/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-10-20 10:16:44 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=1601 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1400 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1461 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wow_coder` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `html_code` longtext COLLATE utf8mb4_unicode_520_ci,
  `css_code` longtext COLLATE utf8mb4_unicode_520_ci,
  `js_code` longtext COLLATE utf8mb4_unicode_520_ci,
  `php_code` longtext COLLATE utf8mb4_unicode_520_ci,
  `param` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` tinyint(1) DEFAULT NULL,
  `mode` tinyint(1) DEFAULT NULL,
  `tag` text COLLATE utf8mb4_unicode_520_ci,
  `php_include` int NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`),
  KEY `id_index` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpie_template` (
  `id` int NOT NULL AUTO_INCREMENT,
  `status` varchar(25) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `opration` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `unique_id` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `opration_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `options` longtext COLLATE utf8mb4_unicode_520_ci,
  `process_log` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `process_lock` int DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `last_update_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20251020_gocleer", "f897e83f50b0c98a4706_20251020101639", "21", "2025-10-20 10:16:44", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-20 10:16:39\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.43\";s:10:\"VersionPHP\";s:6:\"8.2.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:16:\"20251020_gocleer\";s:4:\"Hash\";s:35:\"f897e83f50b0c98a4706_20251020101639\";s:8:\"NameHash\";s:52:\"20251020_gocleer_f897e83f50b0c98a4706_20251020101639\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:62:\"20251020_gocleer_f897e83f50b0c98a4706_20251020101639_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.3\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:64:\"20251020_gocleer_f897e83f50b0c98a4706_20251020101639_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:51:\"/var/www/wpapp_info_usr/data/www/gocleer.wpapp.info\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1157;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:6196;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-20 10:16:39\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.43\";s:10:\"VersionPHP\";s:6:\"8.2.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:16:\"20251020_gocleer\";s:4:\"Hash\";s:35:\"f897e83f50b0c98a4706_20251020101639\";s:8:\"NameHash\";s:52:\"20251020_gocleer_f897e83f50b0c98a4706_20251020101639\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:70:\"20251020_gocleer_f897e83f50b0c98a4706_20251020101639_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:65:\"/var/www/wpapp_info_usr/data/www/gocleer.wpapp.info/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:65:\"20251020_gocleer_f897e83f50b0c98a4706_20251020101639_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:149:\"/var/www/wpapp_info_usr/data/www/gocleer.wpapp.info/wp-content/backups-dup-lite/tmp/20251020_gocleer_f897e83f50b0c98a4706_20251020101639_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:60:\"/var/www/wpapp_info_usr/data/www/gocleer.wpapp.info/wp-admin\";i:1;s:63:\"/var/www/wpapp_info_usr/data/www/gocleer.wpapp.info/wp-includes\";i:2;s:72:\"/var/www/wpapp_info_usr/data/www/gocleer.wpapp.info/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:51:\"/var/www/wpapp_info_usr/data/www/gocleer.wpapp.info\";i:1;s:51:\"/var/www/wpapp_info_usr/data/www/gocleer.wpapp.info\";i:2;s:62:\"/var/www/wpapp_info_usr/data/www/gocleer.wpapp.info/wp-content\";i:3;s:70:\"/var/www/wpapp_info_usr/data/www/gocleer.wpapp.info/wp-content/uploads\";i:4;s:70:\"/var/www/wpapp_info_usr/data/www/gocleer.wpapp.info/wp-content/plugins\";i:5;s:73:\"/var/www/wpapp_info_usr/data/www/gocleer.wpapp.info/wp-content/mu-plugins\";i:6;s:69:\"/var/www/wpapp_info_usr/data/www/gocleer.wpapp.info/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:83:\"/var/www/wpapp_info_usr/data/www/gocleer.wpapp.info/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:12:{i:1760957480;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1760961080;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760961783;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760961785;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760964680;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760966480;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760968280;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761048229;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761133880;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761570000;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761955470;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "http://gocleer.wpapp.info", "on");
INSERT INTO `wp_options` VALUES("3", "home", "http://gocleer.wpapp.info", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "Gocleer", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "A modular platform to help insurers, corporates and city councils to enable customer engagement and promote sustainable mobility", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "admin@gocleer.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "j F Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "H:i", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "j F Y H:i", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%category%/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:104:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:37:\"^broken-link-checker-review/([^/]*)/?\";s:33:\"index.php?user-review=$matches[1]\";s:41:\"^broken-link-checker-activation/([^/]*)/?\";s:44:\"index.php?blc-activate-recipient=$matches[1]\";s:35:\"^broken-link-checker-scan/([^/]*)/?\";s:39:\"index.php?blc-scan-complete=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=1343&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:31:\".+?/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\".+?/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\".+?/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\".+?/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\".+?/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\".+?/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"(.+?)/([^/]+)/embed/?$\";s:63:\"index.php?category_name=$matches[1]&name=$matches[2]&embed=true\";s:26:\"(.+?)/([^/]+)/trackback/?$\";s:57:\"index.php?category_name=$matches[1]&name=$matches[2]&tb=1\";s:46:\"(.+?)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:41:\"(.+?)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:34:\"(.+?)/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&paged=$matches[3]\";s:41:\"(.+?)/([^/]+)/comment-page-([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&cpage=$matches[3]\";s:30:\"(.+?)/([^/]+)(?:/([0-9]+))?/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&page=$matches[3]\";s:20:\".+?/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:30:\".+?/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:50:\".+?/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\".+?/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\".+?/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:26:\".+?/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:33:\"(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:14:\"(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:26:\"(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:33:\"(.+?)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&cpage=$matches[2]\";s:8:\"(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:6:{i:0;s:35:\"autodescription/autodescription.php\";i:1;s:39:\"disable-gutenberg/disable-gutenberg.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:75:\"the-seo-framework-extension-manager/the-seo-framework-extension-manager.php\";i:4;s:37:\"tinymce-advanced/tinymce-advanced.php\";i:5;s:21:\"wp-coder/wp-coder.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "astra", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "astra", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "60421", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "0", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "Europe/London", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "101", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "1343", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "1459", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1775994680", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "60421", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("105", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("106", "sidebars_widgets", "a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:2:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";}s:15:\"footer-widget-1\";a:0:{}s:15:\"footer-widget-2\";a:0:{}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;s:9:\"show_date\";b:0;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.8.3\";s:5:\"files\";a:536:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:26:\"post-content/style-rtl.css\";i:309;s:30:\"post-content/style-rtl.min.css\";i:310;s:22:\"post-content/style.css\";i:311;s:26:\"post-content/style.min.css\";i:312;s:23:\"post-date/style-rtl.css\";i:313;s:27:\"post-date/style-rtl.min.css\";i:314;s:19:\"post-date/style.css\";i:315;s:23:\"post-date/style.min.css\";i:316;s:27:\"post-excerpt/editor-rtl.css\";i:317;s:31:\"post-excerpt/editor-rtl.min.css\";i:318;s:23:\"post-excerpt/editor.css\";i:319;s:27:\"post-excerpt/editor.min.css\";i:320;s:26:\"post-excerpt/style-rtl.css\";i:321;s:30:\"post-excerpt/style-rtl.min.css\";i:322;s:22:\"post-excerpt/style.css\";i:323;s:26:\"post-excerpt/style.min.css\";i:324;s:34:\"post-featured-image/editor-rtl.css\";i:325;s:38:\"post-featured-image/editor-rtl.min.css\";i:326;s:30:\"post-featured-image/editor.css\";i:327;s:34:\"post-featured-image/editor.min.css\";i:328;s:33:\"post-featured-image/style-rtl.css\";i:329;s:37:\"post-featured-image/style-rtl.min.css\";i:330;s:29:\"post-featured-image/style.css\";i:331;s:33:\"post-featured-image/style.min.css\";i:332;s:34:\"post-navigation-link/style-rtl.css\";i:333;s:38:\"post-navigation-link/style-rtl.min.css\";i:334;s:30:\"post-navigation-link/style.css\";i:335;s:34:\"post-navigation-link/style.min.css\";i:336;s:27:\"post-template/style-rtl.css\";i:337;s:31:\"post-template/style-rtl.min.css\";i:338;s:23:\"post-template/style.css\";i:339;s:27:\"post-template/style.min.css\";i:340;s:24:\"post-terms/style-rtl.css\";i:341;s:28:\"post-terms/style-rtl.min.css\";i:342;s:20:\"post-terms/style.css\";i:343;s:24:\"post-terms/style.min.css\";i:344;s:24:\"post-title/style-rtl.css\";i:345;s:28:\"post-title/style-rtl.min.css\";i:346;s:20:\"post-title/style.css\";i:347;s:24:\"post-title/style.min.css\";i:348;s:26:\"preformatted/style-rtl.css\";i:349;s:30:\"preformatted/style-rtl.min.css\";i:350;s:22:\"preformatted/style.css\";i:351;s:26:\"preformatted/style.min.css\";i:352;s:24:\"pullquote/editor-rtl.css\";i:353;s:28:\"pullquote/editor-rtl.min.css\";i:354;s:20:\"pullquote/editor.css\";i:355;s:24:\"pullquote/editor.min.css\";i:356;s:23:\"pullquote/style-rtl.css\";i:357;s:27:\"pullquote/style-rtl.min.css\";i:358;s:19:\"pullquote/style.css\";i:359;s:23:\"pullquote/style.min.css\";i:360;s:23:\"pullquote/theme-rtl.css\";i:361;s:27:\"pullquote/theme-rtl.min.css\";i:362;s:19:\"pullquote/theme.css\";i:363;s:23:\"pullquote/theme.min.css\";i:364;s:39:\"query-pagination-numbers/editor-rtl.css\";i:365;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:366;s:35:\"query-pagination-numbers/editor.css\";i:367;s:39:\"query-pagination-numbers/editor.min.css\";i:368;s:31:\"query-pagination/editor-rtl.css\";i:369;s:35:\"query-pagination/editor-rtl.min.css\";i:370;s:27:\"query-pagination/editor.css\";i:371;s:31:\"query-pagination/editor.min.css\";i:372;s:30:\"query-pagination/style-rtl.css\";i:373;s:34:\"query-pagination/style-rtl.min.css\";i:374;s:26:\"query-pagination/style.css\";i:375;s:30:\"query-pagination/style.min.css\";i:376;s:25:\"query-title/style-rtl.css\";i:377;s:29:\"query-title/style-rtl.min.css\";i:378;s:21:\"query-title/style.css\";i:379;s:25:\"query-title/style.min.css\";i:380;s:25:\"query-total/style-rtl.css\";i:381;s:29:\"query-total/style-rtl.min.css\";i:382;s:21:\"query-total/style.css\";i:383;s:25:\"query-total/style.min.css\";i:384;s:20:\"query/editor-rtl.css\";i:385;s:24:\"query/editor-rtl.min.css\";i:386;s:16:\"query/editor.css\";i:387;s:20:\"query/editor.min.css\";i:388;s:19:\"quote/style-rtl.css\";i:389;s:23:\"quote/style-rtl.min.css\";i:390;s:15:\"quote/style.css\";i:391;s:19:\"quote/style.min.css\";i:392;s:19:\"quote/theme-rtl.css\";i:393;s:23:\"quote/theme-rtl.min.css\";i:394;s:15:\"quote/theme.css\";i:395;s:19:\"quote/theme.min.css\";i:396;s:23:\"read-more/style-rtl.css\";i:397;s:27:\"read-more/style-rtl.min.css\";i:398;s:19:\"read-more/style.css\";i:399;s:23:\"read-more/style.min.css\";i:400;s:18:\"rss/editor-rtl.css\";i:401;s:22:\"rss/editor-rtl.min.css\";i:402;s:14:\"rss/editor.css\";i:403;s:18:\"rss/editor.min.css\";i:404;s:17:\"rss/style-rtl.css\";i:405;s:21:\"rss/style-rtl.min.css\";i:406;s:13:\"rss/style.css\";i:407;s:17:\"rss/style.min.css\";i:408;s:21:\"search/editor-rtl.css\";i:409;s:25:\"search/editor-rtl.min.css\";i:410;s:17:\"search/editor.css\";i:411;s:21:\"search/editor.min.css\";i:412;s:20:\"search/style-rtl.css\";i:413;s:24:\"search/style-rtl.min.css\";i:414;s:16:\"search/style.css\";i:415;s:20:\"search/style.min.css\";i:416;s:20:\"search/theme-rtl.css\";i:417;s:24:\"search/theme-rtl.min.css\";i:418;s:16:\"search/theme.css\";i:419;s:20:\"search/theme.min.css\";i:420;s:24:\"separator/editor-rtl.css\";i:421;s:28:\"separator/editor-rtl.min.css\";i:422;s:20:\"separator/editor.css\";i:423;s:24:\"separator/editor.min.css\";i:424;s:23:\"separator/style-rtl.css\";i:425;s:27:\"separator/style-rtl.min.css\";i:426;s:19:\"separator/style.css\";i:427;s:23:\"separator/style.min.css\";i:428;s:23:\"separator/theme-rtl.css\";i:429;s:27:\"separator/theme-rtl.min.css\";i:430;s:19:\"separator/theme.css\";i:431;s:23:\"separator/theme.min.css\";i:432;s:24:\"shortcode/editor-rtl.css\";i:433;s:28:\"shortcode/editor-rtl.min.css\";i:434;s:20:\"shortcode/editor.css\";i:435;s:24:\"shortcode/editor.min.css\";i:436;s:24:\"site-logo/editor-rtl.css\";i:437;s:28:\"site-logo/editor-rtl.min.css\";i:438;s:20:\"site-logo/editor.css\";i:439;s:24:\"site-logo/editor.min.css\";i:440;s:23:\"site-logo/style-rtl.css\";i:441;s:27:\"site-logo/style-rtl.min.css\";i:442;s:19:\"site-logo/style.css\";i:443;s:23:\"site-logo/style.min.css\";i:444;s:27:\"site-tagline/editor-rtl.css\";i:445;s:31:\"site-tagline/editor-rtl.min.css\";i:446;s:23:\"site-tagline/editor.css\";i:447;s:27:\"site-tagline/editor.min.css\";i:448;s:26:\"site-tagline/style-rtl.css\";i:449;s:30:\"site-tagline/style-rtl.min.css\";i:450;s:22:\"site-tagline/style.css\";i:451;s:26:\"site-tagline/style.min.css\";i:452;s:25:\"site-title/editor-rtl.css\";i:453;s:29:\"site-title/editor-rtl.min.css\";i:454;s:21:\"site-title/editor.css\";i:455;s:25:\"site-title/editor.min.css\";i:456;s:24:\"site-title/style-rtl.css\";i:457;s:28:\"site-title/style-rtl.min.css\";i:458;s:20:\"site-title/style.css\";i:459;s:24:\"site-title/style.min.css\";i:460;s:26:\"social-link/editor-rtl.css\";i:461;s:30:\"social-link/editor-rtl.min.css\";i:462;s:22:\"social-link/editor.css\";i:463;s:26:\"social-link/editor.min.css\";i:464;s:27:\"social-links/editor-rtl.css\";i:465;s:31:\"social-links/editor-rtl.min.css\";i:466;s:23:\"social-links/editor.css\";i:467;s:27:\"social-links/editor.min.css\";i:468;s:26:\"social-links/style-rtl.css\";i:469;s:30:\"social-links/style-rtl.min.css\";i:470;s:22:\"social-links/style.css\";i:471;s:26:\"social-links/style.min.css\";i:472;s:21:\"spacer/editor-rtl.css\";i:473;s:25:\"spacer/editor-rtl.min.css\";i:474;s:17:\"spacer/editor.css\";i:475;s:21:\"spacer/editor.min.css\";i:476;s:20:\"spacer/style-rtl.css\";i:477;s:24:\"spacer/style-rtl.min.css\";i:478;s:16:\"spacer/style.css\";i:479;s:20:\"spacer/style.min.css\";i:480;s:20:\"table/editor-rtl.css\";i:481;s:24:\"table/editor-rtl.min.css\";i:482;s:16:\"table/editor.css\";i:483;s:20:\"table/editor.min.css\";i:484;s:19:\"table/style-rtl.css\";i:485;s:23:\"table/style-rtl.min.css\";i:486;s:15:\"table/style.css\";i:487;s:19:\"table/style.min.css\";i:488;s:19:\"table/theme-rtl.css\";i:489;s:23:\"table/theme-rtl.min.css\";i:490;s:15:\"table/theme.css\";i:491;s:19:\"table/theme.min.css\";i:492;s:24:\"tag-cloud/editor-rtl.css\";i:493;s:28:\"tag-cloud/editor-rtl.min.css\";i:494;s:20:\"tag-cloud/editor.css\";i:495;s:24:\"tag-cloud/editor.min.css\";i:496;s:23:\"tag-cloud/style-rtl.css\";i:497;s:27:\"tag-cloud/style-rtl.min.css\";i:498;s:19:\"tag-cloud/style.css\";i:499;s:23:\"tag-cloud/style.min.css\";i:500;s:28:\"template-part/editor-rtl.css\";i:501;s:32:\"template-part/editor-rtl.min.css\";i:502;s:24:\"template-part/editor.css\";i:503;s:28:\"template-part/editor.min.css\";i:504;s:27:\"template-part/theme-rtl.css\";i:505;s:31:\"template-part/theme-rtl.min.css\";i:506;s:23:\"template-part/theme.css\";i:507;s:27:\"template-part/theme.min.css\";i:508;s:30:\"term-description/style-rtl.css\";i:509;s:34:\"term-description/style-rtl.min.css\";i:510;s:26:\"term-description/style.css\";i:511;s:30:\"term-description/style.min.css\";i:512;s:27:\"text-columns/editor-rtl.css\";i:513;s:31:\"text-columns/editor-rtl.min.css\";i:514;s:23:\"text-columns/editor.css\";i:515;s:27:\"text-columns/editor.min.css\";i:516;s:26:\"text-columns/style-rtl.css\";i:517;s:30:\"text-columns/style-rtl.min.css\";i:518;s:22:\"text-columns/style.css\";i:519;s:26:\"text-columns/style.min.css\";i:520;s:19:\"verse/style-rtl.css\";i:521;s:23:\"verse/style-rtl.min.css\";i:522;s:15:\"verse/style.css\";i:523;s:19:\"verse/style.min.css\";i:524;s:20:\"video/editor-rtl.css\";i:525;s:24:\"video/editor-rtl.min.css\";i:526;s:16:\"video/editor.css\";i:527;s:20:\"video/editor.min.css\";i:528;s:19:\"video/style-rtl.css\";i:529;s:23:\"video/style-rtl.min.css\";i:530;s:15:\"video/style.css\";i:531;s:19:\"video/style.min.css\";i:532;s:19:\"video/theme-rtl.css\";i:533;s:23:\"video/theme-rtl.min.css\";i:534;s:15:\"video/theme.css\";i:535;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("125", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("126", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1760443493;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("127", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"d06a7f052b4e40e68a6a375ce6525c87\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("135", "_site_transient_timeout_browser_2204ee63bef2f351470a66ffe1bb020e", "1761048185", "off");
INSERT INTO `wp_options` VALUES("136", "_site_transient_browser_2204ee63bef2f351470a66ffe1bb020e", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"141.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("137", "_site_transient_timeout_php_check_986ab27a5c44eb5941b7e3b238532f66", "1761048185", "off");
INSERT INTO `wp_options` VALUES("138", "_site_transient_php_check_986ab27a5c44eb5941b7e3b238532f66", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("140", "can_compress_scripts", "0", "on");
INSERT INTO `wp_options` VALUES("153", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("154", "recently_activated", "a:5:{s:43:\"broken-link-checker/broken-link-checker.php\";i:1760593871;s:28:\"auto-upload-images/index.php\";i:1760532235;s:29:\"search-regex/search-regex.php\";i:1760513679;s:47:\"wp-import-export-lite/wp-import-export-lite.php\";i:1760513670;s:41:\"wordpress-importer/wordpress-importer.php\";i:1760512572;}", "off");
INSERT INTO `wp_options` VALUES("160", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("164", "tadv_settings", "a:7:{s:7:\"options\";s:44:\"menubar,advlist,menubar_block,merge_toolbars\";s:7:\"plugins\";s:104:\"anchor,code,insertdatetime,nonbreaking,print,searchreplace,table,visualblocks,visualchars,advlist,wptadv\";s:9:\"toolbar_1\";s:106:\"formatselect,bold,italic,blockquote,bullist,numlist,alignleft,aligncenter,alignright,link,unlink,undo,redo\";s:9:\"toolbar_2\";s:103:\"fontselect,fontsizeselect,outdent,indent,pastetext,removeformat,charmap,wp_more,forecolor,table,wp_help\";s:9:\"toolbar_3\";s:0:\"\";s:9:\"toolbar_4\";s:0:\"\";s:21:\"toolbar_classic_block\";s:123:\"formatselect,bold,italic,blockquote,bullist,numlist,alignleft,aligncenter,alignright,link,forecolor,backcolor,table,wp_help\";}", "auto");
INSERT INTO `wp_options` VALUES("165", "tadv_admin_settings", "a:1:{s:7:\"options\";s:86:\"classic_paragraph_block,table_resize_bars,table_grid,table_tab_navigation,table_advtab\";}", "auto");
INSERT INTO `wp_options` VALUES("166", "tadv_version", "5900", "auto");
INSERT INTO `wp_options` VALUES("167", "tsfem_current_db_versions", "a:1:{s:4:\"core\";s:4:\"2700\";}", "auto");
INSERT INTO `wp_options` VALUES("168", "tsf-extension-manager-active-extensions", "a:3:{s:9:\"incognito\";b:1;s:6:\"origin\";b:1;s:9:\"title-fix\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("170", "the_seo_framework_initial_db_version", "5100", "off");
INSERT INTO `wp_options` VALUES("171", "autodescription-site-settings", "a:127:{s:25:\"advanced_query_protection\";i:1;s:19:\"alter_archive_query\";i:1;s:24:\"alter_archive_query_type\";s:8:\"in_query\";s:23:\"alter_search_query_type\";s:8:\"in_query\";s:18:\"alter_search_query\";i:1;s:16:\"author_noarchive\";i:0;s:15:\"author_nofollow\";i:0;s:14:\"author_noindex\";i:0;s:16:\"auto_description\";i:1;s:28:\"auto_description_html_method\";s:4:\"fast\";s:18:\"baidu_verification\";s:0:\"\";s:17:\"bing_verification\";s:0:\"\";s:13:\"cache_sitemap\";i:1;s:16:\"canonical_scheme\";s:9:\"automatic\";s:14:\"date_noarchive\";i:0;s:13:\"date_nofollow\";i:0;s:12:\"date_noindex\";i:1;s:19:\"disabled_post_types\";a:0:{}s:19:\"disabled_taxonomies\";a:0:{}s:25:\"display_character_counter\";i:1;s:21:\"display_pixel_counter\";i:1;s:23:\"display_seo_bar_metabox\";i:0;s:22:\"display_seo_bar_tables\";i:0;s:16:\"excerpt_the_feed\";i:1;s:15:\"facebook_author\";s:0:\"\";s:18:\"facebook_publisher\";s:0:\"\";s:13:\"facebook_tags\";i:1;s:19:\"google_verification\";s:0:\"\";s:18:\"home_paged_noindex\";i:0;s:19:\"home_title_location\";s:5:\"right\";s:20:\"homepage_description\";s:111:\"Gocleer, el nuevo seguro de coche inteligente y justo que te paga cuando no conduces. Fácil y desde tu móvil.\";s:18:\"homepage_noarchive\";i:0;s:17:\"homepage_nofollow\";i:0;s:16:\"homepage_noindex\";i:0;s:18:\"homepage_canonical\";s:0:\"\";s:17:\"homepage_redirect\";s:0:\"\";s:23:\"homepage_og_description\";s:0:\"\";s:17:\"homepage_og_title\";s:0:\"\";s:24:\"homepage_social_image_id\";i:0;s:25:\"homepage_social_image_url\";s:0:\"\";s:16:\"homepage_tagline\";i:0;s:22:\"homepage_title_tagline\";s:0:\"\";s:14:\"homepage_title\";s:16:\"Home – Gocleer\";s:26:\"homepage_twitter_card_type\";s:0:\"\";s:28:\"homepage_twitter_description\";s:0:\"\";s:22:\"homepage_twitter_title\";s:0:\"\";s:14:\"index_the_feed\";i:0;s:18:\"knowledge_facebook\";s:0:\"\";s:19:\"knowledge_instagram\";s:0:\"\";s:18:\"knowledge_linkedin\";s:0:\"\";s:17:\"knowledge_logo_id\";i:0;s:18:\"knowledge_logo_url\";s:0:\"\";s:14:\"knowledge_logo\";i:1;s:14:\"knowledge_name\";s:0:\"\";s:16:\"knowledge_output\";i:1;s:19:\"knowledge_pinterest\";s:0:\"\";s:20:\"knowledge_soundcloud\";s:0:\"\";s:16:\"knowledge_tumblr\";s:0:\"\";s:17:\"knowledge_twitter\";s:0:\"\";s:14:\"knowledge_type\";s:12:\"organization\";s:17:\"knowledge_youtube\";s:0:\"\";s:19:\"ld_json_breadcrumbs\";i:1;s:15:\"ld_json_enabled\";i:1;s:17:\"ld_json_searchbox\";i:1;s:17:\"max_image_preview\";s:5:\"large\";s:18:\"max_snippet_length\";i:-1;s:17:\"max_video_preview\";i:-1;s:14:\"multi_og_image\";i:0;s:20:\"oembed_remove_author\";i:1;s:14:\"oembed_scripts\";i:1;s:19:\"oembed_use_og_title\";i:0;s:23:\"oembed_use_social_image\";i:1;s:7:\"og_tags\";i:1;s:13:\"paged_noindex\";i:0;s:17:\"pint_verification\";s:0:\"\";s:16:\"post_modify_time\";i:1;s:17:\"post_publish_time\";i:1;s:18:\"prev_next_archives\";i:1;s:19:\"prev_next_frontpage\";i:1;s:15:\"prev_next_posts\";i:1;s:3:\"pta\";a:0:{}s:18:\"robotstxt_block_ai\";i:0;s:19:\"robotstxt_block_seo\";i:0;s:16:\"search_noarchive\";i:0;s:15:\"search_nofollow\";i:0;s:14:\"search_noindex\";i:1;s:20:\"seo_bar_low_contrast\";i:0;s:15:\"seo_bar_symbols\";i:0;s:24:\"set_copyright_directives\";i:1;s:13:\"shortlink_tag\";i:0;s:14:\"site_noarchive\";i:0;s:13:\"site_nofollow\";i:0;s:12:\"site_noindex\";i:0;s:10:\"site_title\";s:7:\"Gocleer\";s:20:\"sitemap_color_accent\";s:6:\"00a0d2\";s:18:\"sitemap_color_main\";s:6:\"222222\";s:22:\"sitemap_cron_prerender\";i:0;s:15:\"sitemap_logo_id\";i:0;s:16:\"sitemap_logo_url\";s:0:\"\";s:12:\"sitemap_logo\";i:1;s:19:\"sitemap_query_limit\";i:250;s:14:\"sitemap_styles\";i:1;s:17:\"sitemaps_modified\";i:1;s:15:\"sitemaps_output\";i:1;s:15:\"sitemaps_robots\";i:1;s:18:\"social_image_fb_id\";i:0;s:19:\"social_image_fb_url\";s:0:\"\";s:26:\"social_title_rem_additions\";i:1;s:15:\"source_the_feed\";i:1;s:11:\"theme_color\";s:0:\"\";s:17:\"timestamps_format\";i:1;s:14:\"title_location\";s:5:\"right\";s:19:\"title_rem_additions\";i:0;s:18:\"title_rem_prefixes\";i:0;s:15:\"title_separator\";s:6:\"hyphen\";s:16:\"title_strip_tags\";i:1;s:12:\"twitter_card\";s:19:\"summary_large_image\";s:15:\"twitter_creator\";s:0:\"\";s:12:\"twitter_site\";s:0:\"\";s:12:\"twitter_tags\";i:1;s:19:\"yandex_verification\";s:0:\"\";s:20:\"noarchive_post_types\";a:0:{}s:19:\"nofollow_post_types\";a:0:{}s:18:\"noindex_post_types\";a:1:{s:10:\"attachment\";i:1;}s:20:\"noarchive_taxonomies\";a:0:{}s:19:\"nofollow_taxonomies\";a:0:{}s:18:\"noindex_taxonomies\";a:1:{s:11:\"post_format\";i:1;}}", "on");
INSERT INTO `wp_options` VALUES("172", "the_seo_framework_upgraded_db_version", "5100", "on");
INSERT INTO `wp_options` VALUES("173", "autodescription-site-cache", "a:3:{s:18:\"persistent_notices\";a:0:{}s:12:\"excluded_ids\";a:2:{s:7:\"archive\";a:0:{}s:6:\"search\";a:0:{}}s:15:\"settings_notice\";s:0:\"\";}", "on");
INSERT INTO `wp_options` VALUES("174", "tsf-extension-manager-settings", "a:6:{s:7:\"api_key\";s:0:\"\";s:16:\"activation_email\";s:0:\"\";s:17:\"_activation_level\";s:4:\"Free\";s:10:\"_activated\";s:9:\"Activated\";s:9:\"_instance\";s:32:\"KF2CQfDiNoJiHisuUwISZ3eKWQWdG566\";s:17:\"_instance_version\";s:3:\"3.0\";}", "auto");
INSERT INTO `wp_options` VALUES("175", "tsfem_i_KF2CQfDiNoJiHisuUwISZ3eKWQWdG566", "28c8aa9c8567faebae24ff7642de5526445fa483576f7fdf48c69298d47428f3", "auto");
INSERT INTO `wp_options` VALUES("176", "tsfem_error_notice_option", "", "off");
INSERT INTO `wp_options` VALUES("177", "tsfem-updater-cache", "a:4:{s:7:\"plugins\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:1:{s:75:\"the-seo-framework-extension-manager/the-seo-framework-extension-manager.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:63:\"theseoframework.com/plugins/the-seo-framework-extension-manager\";s:4:\"slug\";s:35:\"the-seo-framework-extension-manager\";s:6:\"plugin\";s:75:\"the-seo-framework-extension-manager/the-seo-framework-extension-manager.php\";s:11:\"new_version\";s:5:\"2.7.1\";s:3:\"url\";s:28:\"https://theseoframework.com/\";s:7:\"package\";s:49:\"https://dl.theseoframework.com/get/plugin/latest/\";s:5:\"icons\";a:4:{s:3:\"svg\";s:55:\"https://dl.theseoframework.com/get/assets/1.0/icon/svg/\";s:2:\"1x\";s:54:\"https://dl.theseoframework.com/get/assets/1.0/icon/1x/\";s:2:\"2x\";s:54:\"https://dl.theseoframework.com/get/assets/1.0/icon/2x/\";s:7:\"default\";s:54:\"https://dl.theseoframework.com/get/assets/1.0/icon/1x/\";}s:7:\"banners\";a:3:{s:2:\"1x\";s:57:\"https://dl.theseoframework.com/get/assets/1.0/banner/low/\";s:2:\"2x\";s:58:\"https://dl.theseoframework.com/get/assets/1.0/banner/high/\";s:7:\"default\";s:57:\"https://dl.theseoframework.com/get/assets/1.0/banner/low/\";}s:6:\"tested\";s:5:\"6.7.4\";s:12:\"requires_php\";s:5:\"7.4.0\";}}s:20:\"_tsfem_delay_updater\";i:1760956058;}", "off");
INSERT INTO `wp_options` VALUES("184", "current_theme", "Astra", "auto");
INSERT INTO `wp_options` VALUES("185", "theme_mods_generatepress", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:14;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1760593449;s:4:\"data\";a:11:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:6:\"header\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:8:\"footer-5\";a:0:{}s:10:\"footer-bar\";a:0:{}s:7:\"top-bar\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("186", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("189", "generate_dynamic_css_output", "body{background-color:var(--base-2);color:var(--contrast);}a{color:var(--accent);}a{text-decoration:underline;}.entry-title a, .site-branding a, a.button, .wp-block-button__link, .main-navigation a{text-decoration:none;}a:hover, a:focus, a:active{color:var(--contrast);}.wp-block-group__inner-container{max-width:1200px;margin-left:auto;margin-right:auto;}:root{--contrast:#222222;--contrast-2:#575760;--contrast-3:#b2b2be;--base:#f0f0f0;--base-2:#f7f8f9;--base-3:#ffffff;--accent:#1e73be;}:root .has-contrast-color{color:var(--contrast);}:root .has-contrast-background-color{background-color:var(--contrast);}:root .has-contrast-2-color{color:var(--contrast-2);}:root .has-contrast-2-background-color{background-color:var(--contrast-2);}:root .has-contrast-3-color{color:var(--contrast-3);}:root .has-contrast-3-background-color{background-color:var(--contrast-3);}:root .has-base-color{color:var(--base);}:root .has-base-background-color{background-color:var(--base);}:root .has-base-2-color{color:var(--base-2);}:root .has-base-2-background-color{background-color:var(--base-2);}:root .has-base-3-color{color:var(--base-3);}:root .has-base-3-background-color{background-color:var(--base-3);}:root .has-accent-color{color:var(--accent);}:root .has-accent-background-color{background-color:var(--accent);}.top-bar{background-color:#636363;color:#ffffff;}.top-bar a{color:#ffffff;}.top-bar a:hover{color:#303030;}.site-header{background-color:var(--base-3);}.main-title a,.main-title a:hover{color:var(--contrast);}.site-description{color:var(--contrast-2);}.mobile-menu-control-wrapper .menu-toggle,.mobile-menu-control-wrapper .menu-toggle:hover,.mobile-menu-control-wrapper .menu-toggle:focus,.has-inline-mobile-toggle #site-navigation.toggled{background-color:rgba(0, 0, 0, 0.02);}.main-navigation,.main-navigation ul ul{background-color:var(--base-3);}.main-navigation .main-nav ul li a, .main-navigation .menu-toggle, .main-navigation .menu-bar-items{color:var(--contrast);}.main-navigation .main-nav ul li:not([class*=\"current-menu-\"]):hover > a, .main-navigation .main-nav ul li:not([class*=\"current-menu-\"]):focus > a, .main-navigation .main-nav ul li.sfHover:not([class*=\"current-menu-\"]) > a, .main-navigation .menu-bar-item:hover > a, .main-navigation .menu-bar-item.sfHover > a{color:var(--accent);}button.menu-toggle:hover,button.menu-toggle:focus{color:var(--contrast);}.main-navigation .main-nav ul li[class*=\"current-menu-\"] > a{color:var(--accent);}.navigation-search input[type=\"search\"],.navigation-search input[type=\"search\"]:active, .navigation-search input[type=\"search\"]:focus, .main-navigation .main-nav ul li.search-item.active > a, .main-navigation .menu-bar-items .search-item.active > a{color:var(--accent);}.main-navigation ul ul{background-color:var(--base);}.separate-containers .inside-article, .separate-containers .comments-area, .separate-containers .page-header, .one-container .container, .separate-containers .paging-navigation, .inside-page-header{background-color:var(--base-3);}.entry-title a{color:var(--contrast);}.entry-title a:hover{color:var(--contrast-2);}.entry-meta{color:var(--contrast-2);}.sidebar .widget{background-color:var(--base-3);}.footer-widgets{background-color:var(--base-3);}.site-info{background-color:var(--base-3);}input[type=\"text\"],input[type=\"email\"],input[type=\"url\"],input[type=\"password\"],input[type=\"search\"],input[type=\"tel\"],input[type=\"number\"],textarea,select{color:var(--contrast);background-color:var(--base-2);border-color:var(--base);}input[type=\"text\"]:focus,input[type=\"email\"]:focus,input[type=\"url\"]:focus,input[type=\"password\"]:focus,input[type=\"search\"]:focus,input[type=\"tel\"]:focus,input[type=\"number\"]:focus,textarea:focus,select:focus{color:var(--contrast);background-color:var(--base-2);border-color:var(--contrast-3);}button,html input[type=\"button\"],input[type=\"reset\"],input[type=\"submit\"],a.button,a.wp-block-button__link:not(.has-background){color:#ffffff;background-color:#55555e;}button:hover,html input[type=\"button\"]:hover,input[type=\"reset\"]:hover,input[type=\"submit\"]:hover,a.button:hover,button:focus,html input[type=\"button\"]:focus,input[type=\"reset\"]:focus,input[type=\"submit\"]:focus,a.button:focus,a.wp-block-button__link:not(.has-background):active,a.wp-block-button__link:not(.has-background):focus,a.wp-block-button__link:not(.has-background):hover{color:#ffffff;background-color:#3f4047;}a.generate-back-to-top{background-color:rgba( 0,0,0,0.4 );color:#ffffff;}a.generate-back-to-top:hover,a.generate-back-to-top:focus{background-color:rgba( 0,0,0,0.6 );color:#ffffff;}:root{--gp-search-modal-bg-color:var(--base-3);--gp-search-modal-text-color:var(--contrast);--gp-search-modal-overlay-bg-color:rgba(0,0,0,0.2);}@media (max-width:768px){.main-navigation .menu-bar-item:hover > a, .main-navigation .menu-bar-item.sfHover > a{background:none;color:var(--contrast);}}.nav-below-header .main-navigation .inside-navigation.grid-container, .nav-above-header .main-navigation .inside-navigation.grid-container{padding:0px 20px 0px 20px;}.site-main .wp-block-group__inner-container{padding:40px;}.separate-containers .paging-navigation{padding-top:20px;padding-bottom:20px;}.entry-content .alignwide, body:not(.no-sidebar) .entry-content .alignfull{margin-left:-40px;width:calc(100% + 80px);max-width:calc(100% + 80px);}.rtl .menu-item-has-children .dropdown-menu-toggle{padding-left:20px;}.rtl .main-navigation .main-nav ul li.menu-item-has-children > a{padding-right:20px;}@media (max-width:768px){.separate-containers .inside-article, .separate-containers .comments-area, .separate-containers .page-header, .separate-containers .paging-navigation, .one-container .site-content, .inside-page-header{padding:30px;}.site-main .wp-block-group__inner-container{padding:30px;}.inside-top-bar{padding-right:30px;padding-left:30px;}.inside-header{padding-right:30px;padding-left:30px;}.widget-area .widget{padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px;}.footer-widgets-container{padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px;}.inside-site-info{padding-right:30px;padding-left:30px;}.entry-content .alignwide, body:not(.no-sidebar) .entry-content .alignfull{margin-left:-30px;width:calc(100% + 60px);max-width:calc(100% + 60px);}.one-container .site-main .paging-navigation{margin-bottom:20px;}}", "auto");
INSERT INTO `wp_options` VALUES("190", "generate_dynamic_css_cached_version", "3.6.0", "auto");
INSERT INTO `wp_options` VALUES("191", "generate_db_version", "3.6.0", "auto");
INSERT INTO `wp_options` VALUES("304", "wpie_plugin_version", "3.9.30", "auto");
INSERT INTO `wp_options` VALUES("305", "wpie_db_version", "1.0.0", "auto");
INSERT INTO `wp_options` VALUES("306", "wpie_install_date", "1760514044", "auto");
INSERT INTO `wp_options` VALUES("307", "wpie_is_updated_file_security", "1", "auto");
INSERT INTO `wp_options` VALUES("308", "wpie_is_admin_notice_clear", "1", "auto");
INSERT INTO `wp_options` VALUES("309", "wpie_flush_rewrite_rules", "1", "auto");
INSERT INTO `wp_options` VALUES("358", "_site_transient_timeout_browser_e3f8101c41b40572973227d0a64620d0", "1761118697", "off");
INSERT INTO `wp_options` VALUES("359", "_site_transient_browser_e3f8101c41b40572973227d0a64620d0", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"118.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("362", "_site_transient_timeout_browser_d4f10de547cb9cf96c32dc2e2c1a7bd2", "1761118698", "off");
INSERT INTO `wp_options` VALUES("363", "_site_transient_browser_d4f10de547cb9cf96c32dc2e2c1a7bd2", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"92.0.4515.107\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("364", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wp_options` VALUES("454", "nav_menu_options", "a:1:{s:8:\"auto_add\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("513", "_transient_health-check-site-status-result", "{\"good\":17,\"recommended\":6,\"critical\":0}", "on");
INSERT INTO `wp_options` VALUES("694", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/en_GB/wordpress-6.8.3.zip\";s:6:\"locale\";s:5:\"en_GB\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/en_GB/wordpress-6.8.3.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.3\";s:7:\"version\";s:5:\"6.8.3\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1760921766;s:15:\"version_checked\";s:5:\"6.8.3\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("696", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1760955044;s:7:\"checked\";a:3:{s:5:\"astra\";s:7:\"4.11.13\";s:13:\"generatepress\";s:5:\"3.6.0\";s:17:\"twentytwentythree\";s:3:\"1.6\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:3:{s:5:\"astra\";a:6:{s:5:\"theme\";s:5:\"astra\";s:11:\"new_version\";s:7:\"4.11.13\";s:3:\"url\";s:35:\"https://wordpress.org/themes/astra/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/theme/astra.4.11.13.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.3\";}s:13:\"generatepress\";a:6:{s:5:\"theme\";s:13:\"generatepress\";s:11:\"new_version\";s:5:\"3.6.0\";s:3:\"url\";s:43:\"https://wordpress.org/themes/generatepress/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/generatepress.3.6.0.zip\";s:8:\"requires\";s:3:\"6.5\";s:12:\"requires_php\";s:3:\"7.4\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("708", "theme_mods_astra", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:14;}s:18:\"custom_css_post_id\";i:1351;s:11:\"custom_logo\";i:1429;}", "on");
INSERT INTO `wp_options` VALUES("711", "astra-settings", "a:19:{s:18:\"theme-auto-version\";s:7:\"4.11.13\";s:22:\"is_theme_queue_running\";b:0;s:17:\"logo-title-inline\";b:1;s:29:\"display-site-title-responsive\";a:3:{s:7:\"desktop\";i:0;s:6:\"tablet\";i:0;s:6:\"mobile\";i:0;}s:11:\"blog-layout\";s:13:\"blog-layout-4\";s:19:\"blog-post-structure\";a:4:{i:0;s:5:\"image\";i:1;s:8:\"category\";i:2;s:5:\"title\";i:3;s:7:\"excerpt\";}s:23:\"footer-copyright-editor\";s:49:\"Copyright [copyright] [current_year] [site_title]\";s:19:\"site-sidebar-layout\";s:13:\"right-sidebar\";s:23:\"ast-site-content-layout\";s:22:\"normal-width-container\";s:20:\"enable-comments-area\";b:0;s:30:\"single-post-ast-content-layout\";s:22:\"normal-width-container\";s:26:\"single-post-sidebar-layout\";s:13:\"right-sidebar\";s:20:\"enable-related-posts\";b:0;s:27:\"archive-post-sidebar-layout\";s:10:\"no-sidebar\";s:37:\"site-layout-outside-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:25:\"content-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:11:\"theme-color\";s:7:\"#0fa3ae\";s:10:\"link-color\";s:7:\"#0c4e90\";s:12:\"link-h-color\";s:7:\"#066f89\";}", "on");
INSERT INTO `wp_options` VALUES("712", "astra_analytics_installed_time", "1760593449", "off");
INSERT INTO `wp_options` VALUES("735", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1760954259;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:13:{s:37:\"tinymce-advanced/tinymce-advanced.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:30:\"w.org/plugins/tinymce-advanced\";s:4:\"slug\";s:16:\"tinymce-advanced\";s:6:\"plugin\";s:37:\"tinymce-advanced/tinymce-advanced.php\";s:11:\"new_version\";s:5:\"5.9.2\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/tinymce-advanced/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/tinymce-advanced.5.9.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/tinymce-advanced/assets/icon-256x256.png?rev=971511\";s:2:\"1x\";s:68:\"https://ps.w.org/tinymce-advanced/assets/icon-128x128.png?rev=971511\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/tinymce-advanced/assets/banner-1544x500.png?rev=2390186\";s:2:\"1x\";s:71:\"https://ps.w.org/tinymce-advanced/assets/banner-772x250.png?rev=2390186\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";}s:19:\"akismet/akismet.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"5.5\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.5.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";}s:28:\"auto-upload-images/index.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:32:\"w.org/plugins/auto-upload-images\";s:4:\"slug\";s:18:\"auto-upload-images\";s:6:\"plugin\";s:28:\"auto-upload-images/index.php\";s:11:\"new_version\";s:5:\"3.3.2\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/auto-upload-images/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/auto-upload-images.3.3.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/auto-upload-images/assets/icon-256x256.png?rev=1617356\";s:2:\"1x\";s:71:\"https://ps.w.org/auto-upload-images/assets/icon-128x128.jpg?rev=1617356\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/auto-upload-images/assets/banner-1544x500.jpg?rev=1617356\";s:2:\"1x\";s:72:\"https://ps.w.org/auto-upload-images/assets/banner-772x250.jpg?rev=624464\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"2.7\";}s:43:\"broken-link-checker/broken-link-checker.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:33:\"w.org/plugins/broken-link-checker\";s:4:\"slug\";s:19:\"broken-link-checker\";s:6:\"plugin\";s:43:\"broken-link-checker/broken-link-checker.php\";s:11:\"new_version\";s:5:\"2.4.6\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/broken-link-checker/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/broken-link-checker.2.4.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/broken-link-checker/assets/icon-256x256.png?rev=2900468\";s:2:\"1x\";s:72:\"https://ps.w.org/broken-link-checker/assets/icon-128x128.png?rev=2900468\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/broken-link-checker/assets/banner-1544x500.png?rev=2900471\";s:2:\"1x\";s:74:\"https://ps.w.org/broken-link-checker/assets/banner-772x250.png?rev=2900471\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.2\";}s:51:\"custom-permalink-editor/custom-permalink-editor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:37:\"w.org/plugins/custom-permalink-editor\";s:4:\"slug\";s:23:\"custom-permalink-editor\";s:6:\"plugin\";s:51:\"custom-permalink-editor/custom-permalink-editor.php\";s:11:\"new_version\";s:5:\"1.0.4\";s:3:\"url\";s:54:\"https://wordpress.org/plugins/custom-permalink-editor/\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/plugin/custom-permalink-editor.1.0.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/custom-permalink-editor/assets/icon-256x256.png?rev=2624415\";s:2:\"1x\";s:76:\"https://ps.w.org/custom-permalink-editor/assets/icon-128x128.png?rev=2624415\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:79:\"https://ps.w.org/custom-permalink-editor/assets/banner-1544x500.png?rev=2624415\";s:2:\"1x\";s:78:\"https://ps.w.org/custom-permalink-editor/assets/banner-772x250.png?rev=2624415\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";b:0;}s:39:\"disable-gutenberg/disable-gutenberg.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:31:\"w.org/plugins/disable-gutenberg\";s:4:\"slug\";s:17:\"disable-gutenberg\";s:6:\"plugin\";s:39:\"disable-gutenberg/disable-gutenberg.php\";s:11:\"new_version\";s:5:\"3.2.3\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/disable-gutenberg/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/disable-gutenberg.3.2.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/disable-gutenberg/assets/icon-256x256.png?rev=1925990\";s:2:\"1x\";s:70:\"https://ps.w.org/disable-gutenberg/assets/icon-128x128.png?rev=1925990\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.5.14\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.5.14.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}s:29:\"search-regex/search-regex.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:26:\"w.org/plugins/search-regex\";s:4:\"slug\";s:12:\"search-regex\";s:6:\"plugin\";s:29:\"search-regex/search-regex.php\";s:11:\"new_version\";s:5:\"3.1.2\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/search-regex/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/search-regex.3.1.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/search-regex/assets/icon-256x256.jpg?rev=1030025\";s:2:\"1x\";s:65:\"https://ps.w.org/search-regex/assets/icon-128x128.jpg?rev=1030024\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/search-regex/assets/banner-1544x500.jpg?rev=1030023\";s:2:\"1x\";s:67:\"https://ps.w.org/search-regex/assets/banner-772x250.jpg?rev=1030022\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.4\";}s:35:\"autodescription/autodescription.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/autodescription\";s:4:\"slug\";s:15:\"autodescription\";s:6:\"plugin\";s:35:\"autodescription/autodescription.php\";s:11:\"new_version\";s:5:\"5.1.2\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/autodescription/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/autodescription.5.1.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:60:\"https://ps.w.org/autodescription/assets/icon.svg?rev=3000376\";s:3:\"svg\";s:60:\"https://ps.w.org/autodescription/assets/icon.svg?rev=3000376\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/autodescription/assets/banner-1544x500.png?rev=3000376\";s:2:\"1x\";s:70:\"https://ps.w.org/autodescription/assets/banner-772x250.png?rev=3000376\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.0\";}s:41:\"wordpress-importer/wordpress-importer.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:32:\"w.org/plugins/wordpress-importer\";s:4:\"slug\";s:18:\"wordpress-importer\";s:6:\"plugin\";s:41:\"wordpress-importer/wordpress-importer.php\";s:11:\"new_version\";s:5:\"0.9.4\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/wordpress-importer/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/wordpress-importer.0.9.4.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:63:\"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=2791650\";s:3:\"svg\";s:63:\"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=2791650\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-importer/assets/banner-772x250.png?rev=547654\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.2\";}s:21:\"wp-coder/wp-coder.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:22:\"w.org/plugins/wp-coder\";s:4:\"slug\";s:8:\"wp-coder\";s:6:\"plugin\";s:21:\"wp-coder/wp-coder.php\";s:11:\"new_version\";s:3:\"4.4\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/wp-coder/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/plugin/wp-coder.4.4.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:53:\"https://ps.w.org/wp-coder/assets/icon.svg?rev=3359026\";s:3:\"svg\";s:53:\"https://ps.w.org/wp-coder/assets/icon.svg?rev=3359026\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/wp-coder/assets/banner-1544x500.png?rev=3359026\";s:2:\"1x\";s:63:\"https://ps.w.org/wp-coder/assets/banner-772x250.png?rev=3359026\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.4\";}s:47:\"wp-import-export-lite/wp-import-export-lite.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:35:\"w.org/plugins/wp-import-export-lite\";s:4:\"slug\";s:21:\"wp-import-export-lite\";s:6:\"plugin\";s:47:\"wp-import-export-lite/wp-import-export-lite.php\";s:11:\"new_version\";s:6:\"3.9.30\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/wp-import-export-lite/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/wp-import-export-lite.3.9.30.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/wp-import-export-lite/assets/icon-256x256.png?rev=2129449\";s:2:\"1x\";s:74:\"https://ps.w.org/wp-import-export-lite/assets/icon-128x128.png?rev=2129449\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/wp-import-export-lite/assets/banner-1544x500.png?rev=2129449\";s:2:\"1x\";s:76:\"https://ps.w.org/wp-import-export-lite/assets/banner-772x250.png?rev=2129449\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.4\";}s:75:\"the-seo-framework-extension-manager/the-seo-framework-extension-manager.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:63:\"theseoframework.com/plugins/the-seo-framework-extension-manager\";s:4:\"slug\";s:35:\"the-seo-framework-extension-manager\";s:6:\"plugin\";s:75:\"the-seo-framework-extension-manager/the-seo-framework-extension-manager.php\";s:11:\"new_version\";s:5:\"2.7.1\";s:3:\"url\";s:28:\"https://theseoframework.com/\";s:7:\"package\";s:49:\"https://dl.theseoframework.com/get/plugin/latest/\";s:5:\"icons\";a:4:{s:3:\"svg\";s:55:\"https://dl.theseoframework.com/get/assets/1.0/icon/svg/\";s:2:\"1x\";s:54:\"https://dl.theseoframework.com/get/assets/1.0/icon/1x/\";s:2:\"2x\";s:54:\"https://dl.theseoframework.com/get/assets/1.0/icon/2x/\";s:7:\"default\";s:54:\"https://dl.theseoframework.com/get/assets/1.0/icon/1x/\";}s:7:\"banners\";a:3:{s:2:\"1x\";s:57:\"https://dl.theseoframework.com/get/assets/1.0/banner/low/\";s:2:\"2x\";s:58:\"https://dl.theseoframework.com/get/assets/1.0/banner/high/\";s:7:\"default\";s:57:\"https://dl.theseoframework.com/get/assets/1.0/banner/low/\";}s:6:\"tested\";s:5:\"6.7.4\";s:12:\"requires_php\";s:5:\"7.4.0\";}}s:7:\"checked\";a:13:{s:37:\"tinymce-advanced/tinymce-advanced.php\";s:5:\"5.9.2\";s:19:\"akismet/akismet.php\";s:3:\"5.5\";s:28:\"auto-upload-images/index.php\";s:5:\"3.3.2\";s:43:\"broken-link-checker/broken-link-checker.php\";s:5:\"2.4.6\";s:51:\"custom-permalink-editor/custom-permalink-editor.php\";s:5:\"1.0.4\";s:39:\"disable-gutenberg/disable-gutenberg.php\";s:5:\"3.2.3\";s:25:\"duplicator/duplicator.php\";s:6:\"1.5.14\";s:29:\"search-regex/search-regex.php\";s:5:\"3.1.2\";s:35:\"autodescription/autodescription.php\";s:5:\"5.1.2\";s:41:\"wordpress-importer/wordpress-importer.php\";s:5:\"0.9.4\";s:21:\"wp-coder/wp-coder.php\";s:3:\"4.4\";s:47:\"wp-import-export-lite/wp-import-export-lite.php\";s:6:\"3.9.30\";s:75:\"the-seo-framework-extension-manager/the-seo-framework-extension-manager.php\";s:5:\"2.7.1\";}}", "off");
INSERT INTO `wp_options` VALUES("736", "wow_coder_db_version", "4.0", "auto");
INSERT INTO `wp_options` VALUES("779", "disable_gutenberg_options", "a:21:{s:11:\"disable-all\";i:1;s:23:\"user-role_administrator\";s:1:\"1\";s:16:\"user-role_editor\";s:1:\"1\";s:16:\"user-role_author\";s:1:\"1\";s:21:\"user-role_contributor\";s:1:\"1\";s:20:\"user-role_subscriber\";s:1:\"1\";s:14:\"post-type_post\";s:1:\"1\";s:14:\"post-type_page\";s:1:\"1\";s:9:\"templates\";s:0:\"\";s:8:\"post-ids\";s:0:\"\";s:12:\"whitelist-id\";s:4:\"1343\";s:14:\"whitelist-slug\";s:0:\"\";s:15:\"whitelist-title\";s:0:\"\";s:15:\"classic-widgets\";i:1;s:11:\"disable-nag\";i:1;s:9:\"whitelist\";i:1;s:13:\"styles-enable\";i:0;s:9:\"hide-menu\";i:0;s:8:\"hide-gut\";i:0;s:12:\"links-enable\";i:0;s:10:\"acf-enable\";i:0;}", "auto");
INSERT INTO `wp_options` VALUES("859", "site_logo", "1429", "auto");
INSERT INTO `wp_options` VALUES("911", "category_children", "a:1:{i:2;a:10:{i:0;i:3;i:1;i:4;i:2;i:5;i:3;i:6;i:4;i:7;i:5;i:8;i:6;i:9;i:7;i:10;i:8;i:11;i:9;i:12;}}", "auto");
INSERT INTO `wp_options` VALUES("918", "astra_partials_config_cache", "a:2:{s:8:\"settings\";a:1010:{s:46:\"section-header-builder-layout-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[cloned-component-track]\";a:4:{s:7:\"default\";a:12:{s:13:\"header-button\";i:2;s:13:\"footer-button\";i:2;s:11:\"header-html\";i:2;s:11:\"footer-html\";i:2;s:11:\"header-menu\";i:2;s:13:\"header-widget\";i:4;s:13:\"footer-widget\";i:4;s:19:\"header-social-icons\";i:1;s:19:\"footer-social-icons\";i:1;s:14:\"header-divider\";i:0;s:14:\"footer-divider\";i:0;s:13:\"removed-items\";a:0:{}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[builder-header]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[header-desktop-items]\";a:4:{s:7:\"default\";a:4:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:5:{s:10:\"above_left\";a:0:{}s:17:\"above_left_center\";a:0:{}s:12:\"above_center\";a:0:{}s:18:\"above_right_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:5:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:19:\"primary_left_center\";a:0:{}s:14:\"primary_center\";a:0:{}s:20:\"primary_right_center\";a:0:{}s:13:\"primary_right\";a:1:{i:0;s:6:\"menu-1\";}}s:5:\"below\";a:5:{s:10:\"below_left\";a:0:{}s:17:\"below_left_center\";a:0:{}s:12:\"below_center\";a:0:{}s:18:\"below_right_center\";a:0:{}s:11:\"below_right\";a:0:{}}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[header-preset-style]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-desktop-draggable-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[header-mobile-items]\";a:4:{s:7:\"default\";a:4:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:3:{s:10:\"above_left\";a:0:{}s:12:\"above_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:3:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:14:\"primary_center\";a:0:{}s:13:\"primary_right\";a:1:{i:0;s:14:\"mobile-trigger\";}}s:5:\"below\";a:3:{s:10:\"below_left\";a:0:{}s:12:\"below_center\";a:0:{}s:11:\"below_right\";a:0:{}}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-mobile-draggable-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-mobile-popup-items]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[header-transparent-link-heading]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[header-transparant-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[hb-header-main-layout-width]\";a:4:{s:7:\"default\";s:7:\"content\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-header-builder-layout-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:40:\"astra-settings[header-builder-pro-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[button-preset-style]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[theme-button-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[theme-button-bg-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[theme-button-border-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[theme-button-border-group-border-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:56:\"astra-settings[theme-button-border-group-border-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:28:\"astra-settings[button-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[button-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:31:\"astra-settings[button-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[button-bg-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[theme-button-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";i:14;s:5:\"right\";i:28;s:6:\"bottom\";i:14;s:4:\"left\";i:28;}s:6:\"mobile\";a:4:{s:3:\"top\";i:12;s:5:\"right\";i:24;s:6:\"bottom\";i:12;s:4:\"left\";i:24;}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:53:\"astra-settings[theme-button-border-group-border-size]\";a:4:{s:7:\"default\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[button-radius-fields]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:45:\"astra-settings[secondary-button-preset-style]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[secondary-theme-button-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[secondary-theme-button-bg-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[secondary-theme-button-border-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:64:\"astra-settings[secondary-theme-button-border-group-border-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:66:\"astra-settings[secondary-theme-button-border-group-border-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:38:\"astra-settings[secondary-button-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[secondary-button-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[secondary-button-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[secondary-button-bg-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[secondary-theme-button-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:13;s:5:\"right\";i:30;s:6:\"bottom\";i:13;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";i:12;s:5:\"right\";i:28;s:6:\"bottom\";i:12;s:4:\"left\";i:28;}s:6:\"mobile\";a:4:{s:3:\"top\";i:10;s:5:\"right\";i:24;s:6:\"bottom\";i:10;s:4:\"left\";i:24;}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:63:\"astra-settings[secondary-theme-button-border-group-border-size]\";a:4:{s:7:\"default\";a:4:{s:3:\"top\";i:2;s:5:\"right\";i:2;s:6:\"bottom\";i:2;s:4:\"left\";i:2;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[secondary-button-radius-fields]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:34:\"section-secondary-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[site-content-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[narrow-container-max-width]\";a:4:{s:7:\"default\";i:750;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[different-retina-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[ast-header-retina-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:11:\"esc_url_raw\";}s:37:\"astra-settings[different-mobile-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[mobile-header-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:11:\"esc_url_raw\";}s:33:\"astra-settings[use-logo-svg-icon]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:29:\"astra-settings[logo-svg-icon]\";a:4:{s:7:\"default\";a:2:{s:4:\"type\";s:0:\"\";s:5:\"value\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:22:\"sanitize_logo_svg_icon\";}}s:39:\"astra-settings[logo-svg-site-title-gap]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:1:\"5\";s:6:\"tablet\";s:1:\"5\";s:6:\"mobile\";s:1:\"5\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[ast-header-responsive-logo-width]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[display-site-title-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:0;s:6:\"tablet\";i:0;s:6:\"mobile\";i:0;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[display-site-tagline-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:0;s:6:\"tablet\";i:0;s:6:\"mobile\";i:0;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[logo-title-inline]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[site-identity-title-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[header-color-site-title]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-2)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[logo-svg-icon-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[logo-svg-icon-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[logo-svg-icon-hover-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-color-h-site-title]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-color-site-tagline]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[site-icon-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:26:\"astra-settings[blog-width]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[blog-max-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[blog-post-content]\";a:4:{s:7:\"default\";s:7:\"excerpt\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:28:\"astra-settings[blog-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:27:\"astra-settings[blog-layout]\";a:4:{s:7:\"default\";s:13:\"blog-layout-4\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[blog-post-per-page]\";a:4:{s:7:\"default\";i:10;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[archive-post-content-structure-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[blog-post-structure]\";a:4:{s:7:\"default\";a:4:{i:0;s:5:\"image\";i:1;s:8:\"category\";i:2;s:5:\"title\";i:3;s:7:\"excerpt\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[blog-meta-date-type]\";a:4:{s:7:\"default\";s:9:\"published\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[blog-meta-date-format]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[blog-image-ratio-type]\";a:4:{s:7:\"default\";s:10:\"predefined\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[blog-image-ratio-pre-scale]\";a:4:{s:7:\"default\";s:4:\"16/9\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[blog-image-custom-scale-width]\";a:4:{s:7:\"default\";i:16;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:23:\"sanitize_number_n_blank\";}}s:46:\"astra-settings[blog-image-custom-scale-height]\";a:4:{s:7:\"default\";i:9;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[blog-custom-image-scale-description]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[blog-hover-effect]\";a:4:{s:7:\"default\";s:7:\"zoom-in\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:31:\"astra-settings[blog-image-size]\";a:4:{s:7:\"default\";s:5:\"large\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[blog-post-color-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[post-card-featured-overlay]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[post-card-border-radius]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:6;s:5:\"right\";i:6;s:6:\"bottom\";i:6;s:4:\"left\";i:6;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[blog-category-style]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[blog-tag-style]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[blog-post-meta-divider-type]\";a:4:{s:7:\"default\";s:1:\"/\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[blog-meta-category-style]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[blog-meta-tag-style]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:29:\"section-blog-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:25:\"astra-settings[blog-meta]\";a:4:{s:7:\"default\";a:2:{i:0;s:6:\"author\";i:1;s:4:\"date\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[blog-single-width]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[blog-single-max-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[single-content-images-shadow]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[section-blog-single-spacing-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[single-post-outside-spacing]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:42:\"astra-settings[single-post-inside-spacing]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:36:\"section-blog-single-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[site-sidebar-layout]\";a:4:{s:7:\"default\";s:13:\"right-sidebar\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[site-sidebar-style]\";a:4:{s:7:\"default\";s:7:\"unboxed\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[site-sidebar-width]\";a:4:{s:7:\"default\";i:30;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[site-sidebar-width-description]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:0:\"\";}s:35:\"astra-settings[site-sticky-sidebar]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[ast-sidebar-pro-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[ast-site-content-layout]\";a:4:{s:7:\"default\";s:22:\"normal-width-container\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[site-content-style]\";a:4:{s:7:\"default\";s:5:\"boxed\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[surface-colors-title]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[site-layout-outside-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[content-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[ast-site-layout-button-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[global-color-palette]\";a:4:{s:7:\"default\";a:1:{s:7:\"palette\";a:9:{i:0;s:7:\"#046bd2\";i:1;s:7:\"#045cb4\";i:2;s:7:\"#1e293b\";i:3;s:7:\"#334155\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#F0F5FA\";i:6;s:7:\"#111111\";i:7;s:7:\"#D1D5DB\";i:8;s:7:\"#111111\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:20:\"astra-color-palettes\";a:4:{s:7:\"default\";a:3:{s:14:\"currentPalette\";s:9:\"palette_1\";s:8:\"palettes\";a:4:{s:9:\"palette_1\";a:9:{i:0;s:7:\"#046bd2\";i:1;s:7:\"#045cb4\";i:2;s:7:\"#1e293b\";i:3;s:7:\"#334155\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#F0F5FA\";i:6;s:7:\"#111111\";i:7;s:7:\"#D1D5DB\";i:8;s:7:\"#111111\";}s:9:\"palette_2\";a:9:{i:0;s:7:\"#0067FF\";i:1;s:7:\"#005EE9\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#364151\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#E7F6FF\";i:6;s:7:\"#070614\";i:7;s:7:\"#D1DAE5\";i:8;s:7:\"#222222\";}s:9:\"palette_3\";a:9:{i:0;s:7:\"#6528F7\";i:1;s:7:\"#5511F8\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#454F5E\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#F2F0FE\";i:6;s:7:\"#0D0614\";i:7;s:7:\"#D8D8F5\";i:8;s:7:\"#222222\";}s:9:\"palette_4\";a:9:{i:0;s:7:\"#0085FF\";i:1;s:7:\"#0177E3\";i:2;s:7:\"#FFFFFF\";i:3;s:7:\"#E7F6FF\";i:4;s:7:\"#212A37\";i:5;s:7:\"#0F172A\";i:6;s:7:\"#4F5B62\";i:7;s:7:\"#070614\";i:8;s:7:\"#222222\";}}s:7:\"presets\";a:11:{s:3:\"Oak\";a:9:{i:0;s:7:\"#0067FF\";i:1;s:7:\"#005EE9\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#364151\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#E7F6FF\";i:6;s:7:\"#070614\";i:7;s:7:\"#D1DAE5\";i:8;s:7:\"#222222\";}s:5:\"Viola\";a:9:{i:0;s:7:\"#6528F7\";i:1;s:7:\"#5511F8\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#454F5E\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#F2F0FE\";i:6;s:7:\"#0D0614\";i:7;s:7:\"#D8D8F5\";i:8;s:7:\"#222222\";}s:5:\"Cedar\";a:9:{i:0;s:7:\"#DD183B\";i:1;s:7:\"#CC1939\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#3A3A3A\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#FFEDE6\";i:6;s:7:\"#140609\";i:7;s:7:\"#FFD1BF\";i:8;s:7:\"#222222\";}s:6:\"Willow\";a:9:{i:0;s:7:\"#54B435\";i:1;s:7:\"#379237\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#2F3B40\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#EDFBE2\";i:6;s:7:\"#0C1406\";i:7;s:7:\"#D5EAD8\";i:8;s:7:\"#222222\";}s:4:\"Lily\";a:9:{i:0;s:7:\"#DCA54A\";i:1;s:7:\"#D09A40\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#4A4A4A\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#FAF5E5\";i:6;s:7:\"#141004\";i:7;s:7:\"#F0E6C5\";i:8;s:7:\"#222222\";}s:4:\"Rose\";a:9:{i:0;s:7:\"#FB5FAB\";i:1;s:7:\"#EA559D\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#454F5E\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#FCEEF5\";i:6;s:7:\"#140610\";i:7;s:7:\"#FAD8E9\";i:8;s:7:\"#222222\";}s:4:\"Sage\";a:9:{i:0;s:7:\"#1B9C85\";i:1;s:7:\"#178E79\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#454F5E\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#EDF6EE\";i:6;s:7:\"#06140C\";i:7;s:7:\"#D4F3D7\";i:8;s:7:\"#222222\";}s:5:\"Flare\";a:9:{i:0;s:7:\"#FD9800\";i:1;s:7:\"#E98C00\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#454F5E\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#FEF9E1\";i:6;s:7:\"#141006\";i:7;s:7:\"#F9F0C8\";i:8;s:7:\"#222222\";}s:5:\"Maple\";a:9:{i:0;s:7:\"#FF6210\";i:1;s:7:\"#F15808\";i:2;s:7:\"#1C0D0A\";i:3;s:7:\"#353535\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#FEF1E4\";i:6;s:7:\"#140B06\";i:7;s:7:\"#E5D7D1\";i:8;s:7:\"#222222\";}s:5:\"Birch\";a:9:{i:0;s:7:\"#737880\";i:1;s:7:\"#65696F\";i:2;s:7:\"#151616\";i:3;s:7:\"#393C40\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#F6F6F6\";i:6;s:7:\"#232529\";i:7;s:7:\"#F1F0F0\";i:8;s:7:\"#222222\";}s:4:\"Dark\";a:9:{i:0;s:7:\"#0085FF\";i:1;s:7:\"#0177E3\";i:2;s:7:\"#FFFFFF\";i:3;s:7:\"#E7F6FF\";i:4;s:7:\"#212A37\";i:5;s:7:\"#0F172A\";i:6;s:7:\"#4F5B62\";i:7;s:7:\"#070614\";i:8;s:7:\"#222222\";}}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[theme-color-divider-reset]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:27:\"astra-settings[theme-color]\";a:4:{s:7:\"default\";s:7:\"#0fa3ae\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[base-link-colors-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:26:\"astra-settings[link-color]\";a:4:{s:7:\"default\";s:7:\"#0c4e90\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:28:\"astra-settings[link-h-color]\";a:4:{s:7:\"default\";s:7:\"#066f89\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:26:\"astra-settings[text-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-3)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:28:\"astra-settings[border-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-7)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[ast-blog-pro-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[font-size-page-title]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:20;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[font-size-post-meta]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:13;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[font-size-post-tax]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:14;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[ast-body-font-settings-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[ast-body-font-settings]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:32:\"astra-settings[body-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:33:\"astra-settings[body-font-variant]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:21:\"sanitize_font_variant\";}}s:32:\"astra-settings[body-font-weight]\";a:4:{s:7:\"default\";s:3:\"400\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:30:\"astra-settings[font-size-body]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:32:\"astra-settings[body-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:4:\"1.65\";s:16:\"line-height-unit\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[ast-headings-font-settings]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[ast-headings-font-settings-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[headings-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:36:\"astra-settings[headings-font-weight]\";a:4:{s:7:\"default\";s:3:\"600\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:37:\"astra-settings[headings-font-variant]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:21:\"sanitize_font_variant\";}}s:36:\"astra-settings[headings-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[para-margin-bottom]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[underline-content-links]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[ast-heading-h1-typo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[ast-heading-h2-typo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[ast-heading-h3-typo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[ast-heading-h4-typo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[ast-heading-h5-typo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[ast-heading-h6-typo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:28:\"astra-settings[wp-blocks-ui]\";a:4:{s:7:\"default\";s:7:\"comfort\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[wp-blocks-global-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:40:\"astra-settings[wp-blocks-ui-description]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:0:\"\";}s:33:\"comments-section-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[comments-single-section-heading]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[enable-comments-area]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[comments-box-placement]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[comments-box-container-width]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[comment-form-position]\";a:4:{s:7:\"default\";s:5:\"below\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-sub-section-comments-border-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-sub-section-comments-border-width]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-sub-section-comments-border-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:54:\"astra-settings[ast-sub-section-comments-border-radius]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[ast-sub-section-comments-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[ast-sub-section-comments-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";i:2;s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:47:\"astra-settings[ast-sub-section-comments-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:2;s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:30:\"astra-settings[font-family-h1]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:30:\"astra-settings[font-weight-h1]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:28:\"astra-settings[font-size-h1]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:36;s:6:\"tablet\";i:30;s:6:\"mobile\";i:30;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-extras-h1]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:3:\"1.4\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-family-h2]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:30:\"astra-settings[font-weight-h2]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:28:\"astra-settings[font-size-h2]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:30;s:6:\"tablet\";i:25;s:6:\"mobile\";i:25;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-extras-h2]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-family-h3]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:30:\"astra-settings[font-weight-h3]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:28:\"astra-settings[font-size-h3]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:24;s:6:\"tablet\";i:20;s:6:\"mobile\";i:20;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-extras-h3]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-family-h4]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:30:\"astra-settings[font-weight-h4]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:28:\"astra-settings[font-size-h4]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:20;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-extras-h4]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:3:\"1.2\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-family-h5]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:30:\"astra-settings[font-weight-h5]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:28:\"astra-settings[font-size-h5]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-extras-h5]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:3:\"1.2\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-family-h6]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:30:\"astra-settings[font-weight-h6]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:28:\"astra-settings[font-size-h6]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[font-extras-h6]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:4:\"1.25\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[ast-single-post-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:24:\"astra-typography-presets\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[enable-scroll-to-id]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[site-accessibility-toggle]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[site-accessibility-highlight-type]\";a:4:{s:7:\"default\";s:6:\"dotted\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[site-accessibility-highlight-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[site-accessibility-highlight-input-type]\";a:4:{s:7:\"default\";s:7:\"disable\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[site-accessibility-highlight-input-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[astra-pro-section-notice]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[single-post-ast-content-layout]\";a:4:{s:7:\"default\";s:22:\"normal-width-container\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[single-post-content-style]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[single-post-sidebar-layout]\";a:4:{s:7:\"default\";s:13:\"right-sidebar\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[single-post-sidebar-style]\";a:4:{s:7:\"default\";s:5:\"boxed\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[page-single-width]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[page-single-max-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"ast-dynamic-single-post-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[ast-single-post-title]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[ast-dynamic-single-post-layout]\";a:4:{s:7:\"default\";s:8:\"layout-1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-post-banner-width-type]\";a:4:{s:7:\"default\";s:9:\"fullwidth\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-single-post-banner-custom-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[ast-dynamic-single-post-structure]\";a:4:{s:7:\"default\";a:2:{i:0;s:29:\"ast-dynamic-single-post-title\";i:1;s:28:\"ast-dynamic-single-post-meta\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:80:\"astra-settings[ast-dynamic-single-post-article-featured-image-position-layout-1]\";a:4:{s:7:\"default\";s:6:\"behind\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:80:\"astra-settings[ast-dynamic-single-post-article-featured-image-position-layout-2]\";a:4:{s:7:\"default\";s:4:\"none\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:73:\"astra-settings[ast-dynamic-single-post-article-featured-image-width-type]\";a:4:{s:7:\"default\";s:4:\"wide\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:73:\"astra-settings[ast-dynamic-single-post-article-featured-image-ratio-type]\";a:4:{s:7:\"default\";s:10:\"predefined\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:78:\"astra-settings[ast-dynamic-single-post-article-featured-image-ratio-pre-scale]\";a:4:{s:7:\"default\";s:4:\"16/9\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:81:\"astra-settings[ast-dynamic-single-post-article-featured-image-custom-scale-width]\";a:4:{s:7:\"default\";i:16;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:23:\"sanitize_number_n_blank\";}}s:82:\"astra-settings[ast-dynamic-single-post-article-featured-image-custom-scale-height]\";a:4:{s:7:\"default\";i:9;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:23:\"sanitize_number_n_blank\";}}s:87:\"astra-settings[ast-dynamic-single-post-article-featured-image-custom-scale-description]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:67:\"astra-settings[ast-dynamic-single-post-article-featured-image-size]\";a:4:{s:7:\"default\";s:5:\"large\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-single-post-remove-featured-padding]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-single-post-featured-as-background]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-single-post-banner-featured-overlay]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-single-post-taxonomy-clone-tracker]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-single-post-structural-taxonomy]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:65:\"astra-settings[ast-dynamic-single-post-structural-taxonomy-style]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[ast-dynamic-single-post-metadata]\";a:4:{s:7:\"default\";a:2:{i:0;s:6:\"author\";i:1;s:4:\"date\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-single-post-author-prefix-label]\";a:4:{s:7:\"default\";s:3:\"By \";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-dynamic-single-post-author-avatar]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-single-post-author-avatar-size]\";a:4:{s:7:\"default\";i:30;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[ast-dynamic-single-post-meta-date-type]\";a:4:{s:7:\"default\";s:9:\"published\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[ast-dynamic-single-post-date-format]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-single-post-metadata-separator]\";a:4:{s:7:\"default\";s:1:\"/\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[ast-dynamic-single-post-horizontal-alignment]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-single-post-vertical-alignment]\";a:4:{s:7:\"default\";s:6:\"center\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-dynamic-single-post-banner-height]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[ast-dynamic-single-post-elements-gap]\";a:4:{s:7:\"default\";i:15;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-post-banner-background]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"tablet\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"mobile\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-single-post-banner-title-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-post-banner-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-post-banner-link-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-single-post-banner-link-hover-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:69:\"astra-settings[ast-dynamic-single-post-banner-title-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:68:\"astra-settings[ast-dynamic-single-post-banner-text-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-post-text-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:56:\"astra-settings[ast-dynamic-single-post-text-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:54:\"astra-settings[ast-dynamic-single-post-text-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-post-text-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-post-title-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:57:\"astra-settings[ast-dynamic-single-post-title-font-weight]\";a:4:{s:7:\"default\";s:3:\"600\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:55:\"astra-settings[ast-dynamic-single-post-title-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"32\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-post-title-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:68:\"astra-settings[ast-dynamic-single-post-banner-meta-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-post-meta-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:56:\"astra-settings[ast-dynamic-single-post-meta-font-weight]\";a:4:{s:7:\"default\";s:3:\"600\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:54:\"astra-settings[ast-dynamic-single-post-meta-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:13;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-post-meta-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-dynamic-single-post-banner-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:54:\"astra-settings[ast-dynamic-single-post-banner-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:3;s:5:\"right\";i:3;s:6:\"bottom\";i:3;s:4:\"left\";i:3;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:48:\"astra-settings[ast-dynamic-single-post-taxonomy]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[ast-dynamic-single-post-taxonomy-style]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[ast-dynamic-single-post-taxonomy-1]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-post-taxonomy-1-style]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[ast-dynamic-single-post-taxonomy-2]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-post-taxonomy-2-style]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[single-page-ast-content-layout]\";a:4:{s:7:\"default\";s:22:\"normal-width-container\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[single-page-content-style]\";a:4:{s:7:\"default\";s:7:\"unboxed\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[single-page-sidebar-layout]\";a:4:{s:7:\"default\";s:10:\"no-sidebar\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[single-page-sidebar-style]\";a:4:{s:7:\"default\";s:7:\"unboxed\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"ast-dynamic-single-page-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[ast-single-page-title]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[ast-dynamic-single-page-layout]\";a:4:{s:7:\"default\";s:8:\"layout-1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-page-banner-width-type]\";a:4:{s:7:\"default\";s:9:\"fullwidth\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-single-page-banner-custom-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[ast-dynamic-single-page-structure]\";a:4:{s:7:\"default\";a:2:{i:0;s:29:\"ast-dynamic-single-page-image\";i:1;s:29:\"ast-dynamic-single-page-title\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:80:\"astra-settings[ast-dynamic-single-page-article-featured-image-position-layout-1]\";a:4:{s:7:\"default\";s:6:\"behind\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:80:\"astra-settings[ast-dynamic-single-page-article-featured-image-position-layout-2]\";a:4:{s:7:\"default\";s:4:\"none\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:73:\"astra-settings[ast-dynamic-single-page-article-featured-image-width-type]\";a:4:{s:7:\"default\";s:4:\"wide\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:73:\"astra-settings[ast-dynamic-single-page-article-featured-image-ratio-type]\";a:4:{s:7:\"default\";s:10:\"predefined\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:78:\"astra-settings[ast-dynamic-single-page-article-featured-image-ratio-pre-scale]\";a:4:{s:7:\"default\";s:4:\"16/9\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:81:\"astra-settings[ast-dynamic-single-page-article-featured-image-custom-scale-width]\";a:4:{s:7:\"default\";i:16;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:23:\"sanitize_number_n_blank\";}}s:82:\"astra-settings[ast-dynamic-single-page-article-featured-image-custom-scale-height]\";a:4:{s:7:\"default\";i:9;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:23:\"sanitize_number_n_blank\";}}s:87:\"astra-settings[ast-dynamic-single-page-article-featured-image-custom-scale-description]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:67:\"astra-settings[ast-dynamic-single-page-article-featured-image-size]\";a:4:{s:7:\"default\";s:5:\"large\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-single-page-remove-featured-padding]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-single-page-featured-as-background]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-single-page-banner-featured-overlay]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[ast-dynamic-single-page-taxonomy-clone-tracker]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-single-page-structural-taxonomy]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:65:\"astra-settings[ast-dynamic-single-page-structural-taxonomy-style]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[ast-dynamic-single-page-metadata]\";a:4:{s:7:\"default\";a:3:{i:0;s:8:\"comments\";i:1;s:6:\"author\";i:2;s:4:\"date\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-single-page-author-prefix-label]\";a:4:{s:7:\"default\";s:3:\"By \";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-dynamic-single-page-author-avatar]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-single-page-author-avatar-size]\";a:4:{s:7:\"default\";i:30;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[ast-dynamic-single-page-meta-date-type]\";a:4:{s:7:\"default\";s:9:\"published\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[ast-dynamic-single-page-date-format]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-single-page-metadata-separator]\";a:4:{s:7:\"default\";s:1:\"/\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[ast-dynamic-single-page-horizontal-alignment]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-single-page-vertical-alignment]\";a:4:{s:7:\"default\";s:6:\"center\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-dynamic-single-page-banner-height]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[ast-dynamic-single-page-elements-gap]\";a:4:{s:7:\"default\";i:10;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-page-banner-background]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"tablet\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"mobile\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-single-page-banner-title-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-page-banner-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-page-banner-link-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[ast-dynamic-single-page-banner-link-hover-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:69:\"astra-settings[ast-dynamic-single-page-banner-title-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:68:\"astra-settings[ast-dynamic-single-page-banner-text-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-page-text-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:56:\"astra-settings[ast-dynamic-single-page-text-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:54:\"astra-settings[ast-dynamic-single-page-text-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-page-text-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-page-title-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:57:\"astra-settings[ast-dynamic-single-page-title-font-weight]\";a:4:{s:7:\"default\";s:3:\"600\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:55:\"astra-settings[ast-dynamic-single-page-title-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"32\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-single-page-title-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:68:\"astra-settings[ast-dynamic-single-page-banner-meta-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-page-meta-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:56:\"astra-settings[ast-dynamic-single-page-meta-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:54:\"astra-settings[ast-dynamic-single-page-meta-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[ast-dynamic-single-page-meta-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-dynamic-single-page-banner-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:54:\"astra-settings[ast-dynamic-single-page-banner-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:3;s:5:\"right\";i:3;s:6:\"bottom\";i:3;s:4:\"left\";i:3;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:76:\"astra-settings[ast-dynamic-single-page-disable-structure-meta-on-front-page]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:47:\"ast-dynamic-single-page-parent-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[section-single-page-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[section-single-page-padding]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:42:\"astra-settings[section-single-page-margin]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:47:\"astra-settings[archive-post-ast-content-layout]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[archive-post-content-style]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[archive-post-sidebar-layout]\";a:4:{s:7:\"default\";s:10:\"no-sidebar\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[archive-post-sidebar-style]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"ast-dynamic-archive-post-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[ast-archive-post-title]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[ast-dynamic-archive-post-layout]\";a:4:{s:7:\"default\";s:8:\"layout-1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-archive-post-banner-width-type]\";a:4:{s:7:\"default\";s:9:\"fullwidth\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[ast-dynamic-archive-post-banner-custom-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[ast-dynamic-archive-post-structure]\";a:4:{s:7:\"default\";a:2:{i:0;s:30:\"ast-dynamic-archive-post-title\";i:1;s:36:\"ast-dynamic-archive-post-description\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-dynamic-archive-post-custom-title]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:61:\"astra-settings[ast-dynamic-archive-post-custom-title-support]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-archive-post-custom-description]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:67:\"astra-settings[ast-dynamic-archive-post-custom-description-support]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:61:\"astra-settings[ast-dynamic-archive-post-horizontal-alignment]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-archive-post-vertical-alignment]\";a:4:{s:7:\"default\";s:6:\"center\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[ast-dynamic-archive-post-banner-height]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-dynamic-archive-post-elements-gap]\";a:4:{s:7:\"default\";i:10;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-archive-post-banner-image-type]\";a:4:{s:7:\"default\";s:4:\"none\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-archive-post-banner-custom-bg]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"tablet\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"mobile\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[ast-dynamic-archive-post-banner-title-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-archive-post-banner-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-archive-post-banner-link-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:64:\"astra-settings[ast-dynamic-archive-post-banner-link-hover-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:70:\"astra-settings[ast-dynamic-archive-post-banner-title-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:69:\"astra-settings[ast-dynamic-archive-post-banner-text-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-archive-post-text-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:57:\"astra-settings[ast-dynamic-archive-post-text-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:55:\"astra-settings[ast-dynamic-archive-post-text-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[ast-dynamic-archive-post-text-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-archive-post-title-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:58:\"astra-settings[ast-dynamic-archive-post-title-font-weight]\";a:4:{s:7:\"default\";s:3:\"600\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:56:\"astra-settings[ast-dynamic-archive-post-title-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"32\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-dynamic-archive-post-title-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[ast-dynamic-archive-post-banner-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:55:\"astra-settings[ast-dynamic-archive-post-banner-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:3;s:5:\"right\";i:3;s:6:\"bottom\";i:3;s:4:\"left\";i:3;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:55:\"astra-settings[ast-dynamic-archive-post-banner-on-blog]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"section-search-page-title-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[ast-search-page-title]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[section-search-page-title-layout]\";a:4:{s:7:\"default\";s:8:\"layout-1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[section-search-page-title-banner-width-type]\";a:4:{s:7:\"default\";s:9:\"fullwidth\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:61:\"astra-settings[section-search-page-title-banner-custom-width]\";a:4:{s:7:\"default\";i:1200;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[section-search-page-title-structure]\";a:4:{s:7:\"default\";a:2:{i:0;s:31:\"section-search-page-title-title\";i:1;s:36:\"section-search-page-title-breadcrumb\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[section-search-page-title-custom-title]\";a:4:{s:7:\"default\";s:19:\"Search Results for:\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:66:\"astra-settings[section-search-page-title-found-custom-description]\";a:4:{s:7:\"default\";s:44:\"Here are the search results for your search.\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:70:\"astra-settings[section-search-page-title-not-found-custom-description]\";a:4:{s:7:\"default\";s:85:\"Sorry, but we could not find anything related to your search terms. Please try again.\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[section-search-page-title-horizontal-alignment]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[section-search-page-title-vertical-alignment]\";a:4:{s:7:\"default\";s:6:\"center\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[section-search-page-title-banner-height]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[section-search-page-title-elements-gap]\";a:4:{s:7:\"default\";i:10;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[section-search-page-title-banner-image-type]\";a:4:{s:7:\"default\";s:4:\"none\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[section-search-page-title-banner-custom-bg]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"tablet\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"mobile\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[section-search-page-title-banner-title-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[section-search-page-title-banner-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[section-search-page-title-banner-link-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:65:\"astra-settings[section-search-page-title-banner-link-hover-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:71:\"astra-settings[section-search-page-title-banner-title-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:70:\"astra-settings[section-search-page-title-banner-text-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[section-search-page-title-text-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:58:\"astra-settings[section-search-page-title-text-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:56:\"astra-settings[section-search-page-title-text-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[section-search-page-title-text-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[section-search-page-title-title-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:59:\"astra-settings[section-search-page-title-title-font-weight]\";a:4:{s:7:\"default\";s:3:\"600\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:57:\"astra-settings[section-search-page-title-title-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:32;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[section-search-page-title-title-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[section-search-page-title-banner-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:56:\"astra-settings[section-search-page-title-banner-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:3;s:5:\"right\";i:3;s:6:\"bottom\";i:3;s:4:\"left\";i:3;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:41:\"astra-settings[ast-search-content-layout]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[ast-search-content-style]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[ast-search-sidebar-layout]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[ast-search-sidebar-style]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[ast-search-results-style]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[ast-search-results-per-page]\";a:4:{s:7:\"default\";i:10;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[ast-search-live-search]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[ast-search-live-search-post-types]\";a:4:{s:7:\"default\";a:2:{s:4:\"post\";i:1;s:4:\"page\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[related-posts-section-heading]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:38:\"related-posts-section-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[enable-related-posts]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[related-posts-title]\";a:4:{s:7:\"default\";s:13:\"Related Posts\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[releted-posts-title-alignment]\";a:4:{s:7:\"default\";s:4:\"left\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[related-posts-structure]\";a:4:{s:7:\"default\";a:2:{i:0;s:14:\"featured-image\";i:1;s:10:\"title-meta\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[related-metadata-separator]\";a:4:{s:7:\"default\";s:1:\"/\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[related-posts-meta-structure]\";a:4:{s:7:\"default\";a:3:{i:0;s:8:\"comments\";i:1;s:8:\"category\";i:2;s:6:\"author\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[related-posts-image-ratio-type]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[related-posts-image-ratio-pre-scale]\";a:4:{s:7:\"default\";s:4:\"16/9\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[related-posts-image-custom-scale-width]\";a:4:{s:7:\"default\";i:16;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:23:\"sanitize_number_n_blank\";}}s:55:\"astra-settings[related-posts-image-custom-scale-height]\";a:4:{s:7:\"default\";i:9;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:23:\"sanitize_number_n_blank\";}}s:60:\"astra-settings[related-posts-custom-image-scale-description]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[related-posts-image-size]\";a:4:{s:7:\"default\";s:5:\"large\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[related-posts-author-prefix-label]\";a:4:{s:7:\"default\";s:3:\"By \";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[related-posts-author-avatar]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[related-posts-author-avatar-size]\";a:4:{s:7:\"default\";i:30;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[related-posts-meta-date-type]\";a:4:{s:7:\"default\";s:9:\"published\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[related-posts-date-format]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[related-posts-category-style]\";a:4:{s:7:\"default\";s:4:\"none\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[related-posts-tag-style]\";a:4:{s:7:\"default\";s:4:\"none\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[enable-related-posts-excerpt]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[related-posts-excerpt-count]\";a:4:{s:7:\"default\";i:25;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[related-posts-total-count]\";a:4:{s:7:\"default\";i:2;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[related-posts-grid-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[related-posts-query-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[related-posts-based-on]\";a:4:{s:7:\"default\";s:10:\"categories\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[related-posts-order-by]\";a:4:{s:7:\"default\";s:4:\"date\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[related-posts-order]\";a:4:{s:7:\"default\";s:3:\"asc\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[related-posts-box-placement]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[related-posts-outside-location]\";a:4:{s:7:\"default\";s:5:\"above\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[related-posts-container-width]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[related-posts-colors-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[related-posts-section-title-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[related-posts-title-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[related-posts-meta-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[related-posts-content-typography-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[related-posts-text-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-2)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[related-posts-link-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[related-posts-title-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-2)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:46:\"astra-settings[related-posts-background-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:40:\"astra-settings[related-posts-meta-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[related-posts-link-hover-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[related-posts-meta-link-hover-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[related-posts-title-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:47:\"astra-settings[related-posts-title-font-weight]\";a:4:{s:7:\"default\";s:3:\"500\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:45:\"astra-settings[related-posts-title-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"20\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[related-posts-title-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:3:\"1.5\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[related-posts-section-title-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:55:\"astra-settings[related-posts-section-title-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:53:\"astra-settings[related-posts-section-title-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"26\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[related-posts-section-title-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[related-posts-meta-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:46:\"astra-settings[related-posts-meta-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:44:\"astra-settings[related-posts-meta-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[related-posts-meta-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[related-posts-content-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:49:\"astra-settings[related-posts-content-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:47:\"astra-settings[related-posts-content-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[related-posts-content-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-sub-section-related-posts-border-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-sub-section-related-posts-border-width]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[ast-sub-section-related-posts-border-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:59:\"astra-settings[ast-sub-section-related-posts-border-radius]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-sub-section-related-posts-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[ast-sub-section-related-posts-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";d:2.5;s:5:\"right\";d:2.5;s:6:\"bottom\";d:2.5;s:4:\"left\";d:2.5;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:52:\"astra-settings[ast-sub-section-related-posts-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:2;s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:45:\"astra-settings[transparent-header-logo-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[hba-transparent-header-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[transparent-header-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[hbb-transparent-header-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[transparent-header-color-site-title-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:64:\"astra-settings[transparent-header-color-h-site-title-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[transparent-menu-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[transparent-menu-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[transparent-menu-h-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[transparent-submenu-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[transparent-submenu-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[transparent-submenu-h-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:65:\"astra-settings[transparent-content-section-link-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:67:\"astra-settings[transparent-content-section-link-h-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[transparent-header-enable]\";a:4:{s:7:\"default\";i:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[transparent-header-disable-on]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[transparent-header-disable-404-page]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[transparent-header-disable-search-page]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[transparent-header-disable-archive-pages]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[transparent-header-disable-index]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:61:\"astra-settings[transparent-header-disable-latest-posts-index]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[transparent-header-disable-page]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[transparent-header-disable-posts]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[transparent-header-on-devices]\";a:4:{s:7:\"default\";s:4:\"both\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[different-transparent-logo]\";a:4:{s:7:\"default\";i:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[transparent-header-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:11:\"esc_url_raw\";}s:49:\"astra-settings[different-transparent-retina-logo]\";a:4:{s:7:\"default\";i:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[transparent-header-retina-logo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:11:\"esc_url_raw\";}s:45:\"astra-settings[transparent-header-logo-width]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:150;s:6:\"tablet\";i:120;s:6:\"mobile\";i:100;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[transparent-header-main-sep]\";a:4:{s:7:\"default\";i:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[transparent-header-main-sep-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:47:\"astra-settings[divider-sec-transparent-styling]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[transparent-header-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[transparent-header-colors-menu]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[transparent-header-colors-submenu]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"section-transparent-header-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:61:\"astra-settings[transparent-header-social-text-colors-content]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:67:\"astra-settings[transparent-header-social-background-colors-content]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[transparent-header-social-icons-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[transparent-header-social-icons-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[transparent-header-social-icons-bg-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:58:\"astra-settings[transparent-header-social-icons-bg-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[transparent-header-html-colors-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[transparent-header-html-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:50:\"astra-settings[transparent-header-html-link-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:52:\"astra-settings[transparent-header-html-link-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:52:\"astra-settings[transparent-header-search-icon-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:62:\"astra-settings[transparent-header-search-box-background-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:53:\"astra-settings[transparent-header-buttons-text-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:59:\"astra-settings[transparent-header-buttons-background-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[transparent-header-buttons-border-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[transparent-header-button-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:54:\"astra-settings[transparent-header-button-text-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:50:\"astra-settings[transparent-header-button-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:52:\"astra-settings[transparent-header-button-bg-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:54:\"astra-settings[transparent-header-button-border-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[transparent-header-button-border-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[transparent-account-icon-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:51:\"astra-settings[transparent-account-type-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:51:\"astra-settings[transparent-header-toggle-btn-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[transparent-header-toggle-btn-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[transparent-header-toggle-border-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[breadcrumb-position]\";a:4:{s:7:\"default\";s:4:\"none\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[breadcrumb-position-none-notice]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:0:\"\";}s:49:\"astra-settings[breadcrumb-disable-layout-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[breadcrumb-disable-on]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[breadcrumb-disable-home-page]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[breadcrumb-disable-blog-posts-page]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[breadcrumb-disable-search]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[breadcrumb-disable-archive]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[breadcrumb-disable-single-page]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[breadcrumb-disable-single-post]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[breadcrumb-disable-singular]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[breadcrumb-disable-404-page]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[breadcrumb-alignment]\";a:4:{s:7:\"default\";s:4:\"left\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[breadcrumb-spacing]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:45:\"astra-settings[breadcrumb-separator-selector]\";a:4:{s:7:\"default\";s:5:\"\\003E\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[breadcrumb-separator]\";a:4:{s:7:\"default\";s:5:\"\\00bb\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"section-breadcrumb-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[breadcrumb-color-section-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[breadcrumb-bg-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[breadcrumb-active-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[breadcrumb-separator-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[section-breadcrumb-link-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[breadcrumb-text-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[breadcrumb-hover-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[section-breadcrumb-typo]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[breadcrumb-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:38:\"astra-settings[breadcrumb-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:36:\"astra-settings[breadcrumb-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[breadcrumb-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[scroll-to-top-enable]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[scroll-to-top-on-devices]\";a:4:{s:7:\"default\";s:4:\"both\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[scroll-to-top-icon-position]\";a:4:{s:7:\"default\";s:5:\"right\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[scroll-to-top-icon-size]\";a:4:{s:7:\"default\";i:15;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[scroll-on-top-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[scroll-on-top-bg-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[scroll-to-top-icon-radius-fields]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[scroll-to-top-icon-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:43:\"astra-settings[scroll-to-top-icon-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:42:\"astra-settings[scroll-to-top-icon-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:45:\"astra-settings[scroll-to-top-icon-h-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:38:\"section-scroll-to-top-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[enable-scroll-to-top-notice]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:0:\"\";}s:34:\"astra-settings[heading-base-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-2)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:38:\"astra-settings[button-text-typography]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[secondary-button-text-typography]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[font-family-button]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:44:\"astra-settings[secondary-font-family-button]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:34:\"astra-settings[font-weight-button]\";a:4:{s:7:\"default\";s:3:\"500\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:44:\"astra-settings[secondary-font-weight-button]\";a:4:{s:7:\"default\";s:3:\"500\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:32:\"astra-settings[font-size-button]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"16\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[secondary-font-size-button]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:2:\"16\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[font-extras-button]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[secondary-font-extras-button]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"section-footer-builder-layout-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:30:\"astra-settings[builder-footer]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[footer-bg-obj-responsive-description]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:0:\"\";}s:36:\"astra-settings[footer-desktop-items]\";a:4:{s:7:\"default\";a:3:{s:5:\"above\";a:5:{s:7:\"above_1\";a:0:{}s:7:\"above_2\";a:0:{}s:7:\"above_3\";a:0:{}s:7:\"above_4\";a:0:{}s:7:\"above_5\";a:0:{}}s:7:\"primary\";a:5:{s:9:\"primary_1\";a:0:{}s:9:\"primary_2\";a:0:{}s:9:\"primary_3\";a:0:{}s:9:\"primary_4\";a:0:{}s:9:\"primary_5\";a:0:{}}s:5:\"below\";a:5:{s:7:\"below_1\";a:1:{i:0;s:9:\"copyright\";}s:7:\"below_2\";a:0:{}s:7:\"below_3\";a:0:{}s:7:\"below_4\";a:0:{}s:7:\"below_5\";a:0:{}}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[footer-draggable-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-builder-pro-items]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[section-footer-builder-layout-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[section-footer-builder-layout-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:52:\"astra-settings[section-footer-builder-layout-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:45:\"section-above-header-builder-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hba-header-height]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:50;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[hba-header-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:55:\"var( --ast-global-color-primary, --ast-global-color-4 )\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[hba-header-bottom-border-color]\";a:4:{s:7:\"default\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:36:\"astra-settings[hba-header-separator]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-above-header-builder-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-above-header-builder-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:51:\"astra-settings[section-above-header-builder-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:66:\"astra-settings[section-above-header-builder-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"section-below-header-builder-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hbb-header-height]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:60;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[hbb-header-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:7:\"#eeeeee\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[hbb-header-bottom-border-color]\";a:4:{s:7:\"default\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:36:\"astra-settings[hbb-header-separator]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-below-header-builder-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-below-header-builder-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:51:\"astra-settings[section-below-header-builder-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:66:\"astra-settings[section-below-header-builder-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[astra-sidebar-widgets-header-widget-1-margin]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:43:\"astra-settings[header-widget-1-title-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[header-widget-1-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[header-widget-1-link-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-widget-1-link-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[header-widget-1-link-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-widget-1-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-widget-1-content-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:75:\"astra-settings[astra-sidebar-widgets-header-widget-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[astra-sidebar-widgets-header-widget-2-margin]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:43:\"astra-settings[header-widget-2-title-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[header-widget-2-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[header-widget-2-link-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-widget-2-link-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[header-widget-2-link-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-widget-2-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-widget-2-content-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:75:\"astra-settings[astra-sidebar-widgets-header-widget-2-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"section-header-mobile-trigger-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[header-trigger-icon]\";a:4:{s:7:\"default\";s:4:\"menu\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[mobile-header-toggle-btn-style]\";a:4:{s:7:\"default\";s:7:\"minimal\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[mobile-header-menu-label]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[mobile-header-toggle-btn-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:46:\"astra-settings[mobile-header-toggle-icon-size]\";a:4:{s:7:\"default\";i:20;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[mobile-header-toggle-btn-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:52:\"astra-settings[mobile-header-toggle-btn-border-size]\";a:4:{s:7:\"default\";a:4:{s:3:\"top\";i:1;s:5:\"right\";i:1;s:6:\"bottom\";i:1;s:4:\"left\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[mobile-header-toggle-border-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:57:\"astra-settings[mobile-header-toggle-border-radius-fields]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:60:\"astra-settings[section-header-mobile-trigger-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-header-mobile-trigger-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:45:\"astra-settings[mobile-header-label-font-size]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"section-popup-header-builder-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[mobile-header-type]\";a:4:{s:7:\"default\";s:8:\"dropdown\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[off-canvas-move-body]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[off-canvas-move-body-notice]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";s:0:\"\";}s:32:\"astra-settings[off-canvas-slide]\";a:4:{s:7:\"default\";s:5:\"right\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-builder-menu-toggle-target]\";a:4:{s:7:\"default\";s:4:\"icon\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[header-offcanvas-content-alignment]\";a:4:{s:7:\"default\";s:10:\"flex-start\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[off-canvas-background]\";a:4:{s:7:\"default\";a:10:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:23:\"sanitize_background_obj\";}}s:38:\"astra-settings[off-canvas-close-color]\";a:4:{s:7:\"default\";s:7:\"#3a3a3a\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:40:\"astra-settings[off-canvas-inner-spacing]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[off-canvas-padding]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"section-primary-header-builder-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:32:\"astra-settings[hb-header-height]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:80;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[hb-header-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:55:\"var( --ast-global-color-primary, --ast-global-color-4 )\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[hb-header-main-sep-color]\";a:4:{s:7:\"default\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:34:\"astra-settings[hb-header-main-sep]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[section-primary-header-builder-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[section-primary-header-builder-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:53:\"astra-settings[section-primary-header-builder-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:68:\"astra-settings[section-primary-header-builder-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[logo-title-settings-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:30:\"title_tagline-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[header-logo-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[title_tagline-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[title_tagline-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:36:\"astra-settings[font-size-site-title]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:26;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[font-size-site-tagline]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[title_tagline-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"section-hb-button-1-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[header-button1-text]\";a:4:{s:7:\"default\";s:6:\"Button\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-button1-link-option]\";a:4:{s:7:\"default\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:13:\"sanitize_link\";}}s:47:\"astra-settings[header-button1-text-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[header-button1-background-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-button1-text-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[header-button1-text-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-button1-back-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[header-button1-back-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:65:\"astra-settings[header-button1-builder-button-border-colors-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[header-button1-border-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-button1-border-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-button1-border-size]\";a:4:{s:7:\"default\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[header-button1-border-radius-fields]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:46:\"astra-settings[header-button1-text-typography]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-button1-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:42:\"astra-settings[header-button1-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:40:\"astra-settings[header-button1-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-button1-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[section-hb-button-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[section-hb-button-1-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[section-hb-button-1-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:42:\"astra-settings[section-hb-button-1-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:55:\"astra-settings[section-hb-html-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[font-size-section-hb-html-1]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"section-hb-html-1-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:29:\"astra-settings[header-html-1]\";a:4:{s:7:\"default\";s:22:\"Insert HTML text here.\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[header-html-1color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-html-1-link-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[header-html-1link-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-html-1link-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[section-hb-html-1-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[section-hb-html-1-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:55:\"astra-settings[section-hb-html-2-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[font-size-section-hb-html-2]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"section-hb-html-2-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:29:\"astra-settings[header-html-2]\";a:4:{s:7:\"default\";s:22:\"Insert HTML text here.\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[header-html-2color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-html-2-link-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[header-html-2link-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-html-2link-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[section-hb-html-2-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[section-hb-html-2-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:55:\"astra-settings[section-hb-menu-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"section-hb-menu-1-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-menu1-create-menu-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-menu1-menu-hover-animation]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[header-menu1-submenu-heading]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-menu1-submenu-width]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[header-menu1-submenu-container-animation]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[header-menu1-submenu-container-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[header-menu1-submenu-item-b-size]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-menu1-submenu-item-b-color]\";a:4:{s:7:\"default\";s:7:\"#eaeaea\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:47:\"astra-settings[header-menu1-submenu-top-offset]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[header-menu1-submenu-border]\";a:4:{s:7:\"default\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[header-menu1-submenu-b-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:57:\"astra-settings[header-menu1-submenu-border-radius-fields]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:48:\"astra-settings[header-menu1-submenu-item-border]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-menu1-menu-stack-on-mobile]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[section-hb-menu-1-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:40:\"astra-settings[header-menu1-text-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-menu1-background-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-menu1-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-menu1-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[header-menu1-h-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[header-menu1-h-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[header-menu1-a-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[header-menu1-a-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[header-1-font-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[header-menu1-header-menu-typography]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-menu1-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:40:\"astra-settings[header-menu1-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:38:\"astra-settings[header-menu1-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-menu1-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-1-spacing-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-menu1-menu-spacing]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:55:\"astra-settings[section-hb-menu-2-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"section-hb-menu-2-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-menu2-create-menu-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-menu2-menu-hover-animation]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[header-menu2-submenu-heading]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-menu2-submenu-width]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[header-menu2-submenu-container-animation]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[header-menu2-submenu-container-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[header-menu2-submenu-item-b-size]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-menu2-submenu-item-b-color]\";a:4:{s:7:\"default\";s:7:\"#eaeaea\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:47:\"astra-settings[header-menu2-submenu-top-offset]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[header-menu2-submenu-border]\";a:4:{s:7:\"default\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[header-menu2-submenu-b-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:57:\"astra-settings[header-menu2-submenu-border-radius-fields]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:48:\"astra-settings[header-menu2-submenu-item-border]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-menu2-menu-stack-on-mobile]\";a:4:{s:7:\"default\";b:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[section-hb-menu-2-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:40:\"astra-settings[header-menu2-text-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-menu2-background-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-menu2-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-menu2-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[header-menu2-h-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[header-menu2-h-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[header-menu2-a-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[header-menu2-a-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[header-2-font-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[header-menu2-header-menu-typography]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-menu2-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:40:\"astra-settings[header-menu2-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:38:\"astra-settings[header-menu2-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-menu2-font-extras]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-2-spacing-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-menu2-menu-spacing]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:38:\"section-header-search-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-search-icon-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-search-icon-space]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";i:18;s:6:\"mobile\";i:18;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[header-search-width]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:27:\"astra-settings[live-search]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[live-search-post-types]\";a:4:{s:7:\"default\";a:2:{s:4:\"post\";i:1;s:4:\"page\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[live-search-result-count]\";a:4:{s:7:\"default\";i:5;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-header-search-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[section-header-search-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:59:\"astra-settings[section-header-search-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:35:\"astra-settings[header-account-tabs]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[header-account-login-heading]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-account-login-style]\";a:4:{s:7:\"default\";s:4:\"icon\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:67:\"astra-settings[header-account-login-style-extend-text-profile-type]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-account-logged-in-text]\";a:4:{s:7:\"default\";s:10:\"My Account\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-account-login-link]\";a:4:{s:7:\"default\";a:3:{s:3:\"url\";s:0:\"\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:13:\"sanitize_link\";}}s:45:\"astra-settings[header-account-logout-heading]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[header-account-logout-style]\";a:4:{s:7:\"default\";s:4:\"icon\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:68:\"astra-settings[header-account-logout-style-extend-text-profile-type]\";a:4:{s:7:\"default\";s:7:\"default\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-account-logout-preview]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-account-logged-out-text]\";a:4:{s:7:\"default\";s:6:\"Log In\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-account-logout-link]\";a:4:{s:7:\"default\";a:3:{s:3:\"url\";s:38:\"http://gocleer.wpapp.info/wp-login.php\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:13:\"sanitize_link\";}}s:42:\"astra-settings[header-account-image-width]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:2:\"40\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-account-icon-size]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";i:18;s:6:\"mobile\";i:18;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[header-account-icon-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-2)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:50:\"astra-settings[header-account-text-design-options]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-account-type-text-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:46:\"astra-settings[header-account-spacing-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[header-account-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:48:\"astra-settings[font-size-section-header-account]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[section-header-account-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[section-hb-social-icons-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[font-size-section-hb-social-icons-1]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"section-hb-social-icons-1-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-social-1-color-type]\";a:4:{s:7:\"default\";s:6:\"custom\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[header-social-1-brand-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-social-1-brand-label-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[header-social-1-brand-hover-toggle]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[header-social-1-icon-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[header-social-1-label-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[header-social-1-background-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[header-social-1-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[header-social-1-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[header-social-1-label-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-social-1-label-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-social-1-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[header-social-1-bg-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[header-social-icons-1]\";a:4:{s:7:\"default\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:21:\"sanitize_social_icons\";}}s:44:\"astra-settings[header-social-1-label-toggle]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[header-social-1-space]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[header-social-1-bg-space]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[header-social-1-size]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[header-social-1-radius-fields]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:56:\"astra-settings[section-hb-social-icons-1-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[section-hb-social-icons-1-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:43:\"section-header-mobile-menu-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[header-mobile-menu-create-menu-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[header-mobile-menu-submenu-item-border]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[header-mobile-menu-divider-colors-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[header-mobile-menu-submenu-item-b-size]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[header-mobile-menu-submenu-item-b-color]\";a:4:{s:7:\"default\";s:7:\"#eaeaea\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:46:\"astra-settings[header-mobile-menu-link-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[header-mobile-menu-background-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[header-mobile-menu-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:25:\"var(--ast-global-color-3)\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[header-mobile-menu-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[header-mobile-menu-h-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:25:\"var(--ast-global-color-1)\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[header-mobile-menu-h-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:25:\"var(--ast-global-color-5)\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:53:\"astra-settings[header-mobile-menu-a-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:25:\"var(--ast-global-color-1)\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:56:\"astra-settings[header-mobile-menu-a-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:25:\"var(--ast-global-color-5)\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[header-mobile-menu-header-typo-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[header-mobile-menu-header-menu-typography]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[header-mobile-menu-font-family]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";s:19:\"sanitize_text_field\";}s:46:\"astra-settings[header-mobile-menu-font-weight]\";a:4:{s:7:\"default\";s:7:\"inherit\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_font_weight\";}}s:44:\"astra-settings[header-mobile-menu-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[font-extras-header-mobile-menu]\";a:4:{s:7:\"default\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[header-mobile-menu-menu-spacing-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[header-mobile-menu-menu-spacing]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:49:\"astra-settings[section-header-mobile-menu-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:64:\"astra-settings[section-header-mobile-menu-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"section-above-footer-builder-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hba-footer-column]\";a:4:{s:7:\"default\";s:1:\"2\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hba-footer-layout]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[hba-footer-layout-width]\";a:4:{s:7:\"default\";s:7:\"content\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hba-footer-height]\";a:4:{s:7:\"default\";i:60;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[hba-footer-vertical-alignment]\";a:4:{s:7:\"default\";s:10:\"flex-start\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:25:\"astra-settings[hba-stack]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[hba-footer-separator]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[hba-footer-top-border-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:44:\"astra-settings[hba-footer-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:7:\"#eeeeee\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hba-inner-spacing]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-above-footer-builder-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-above-footer-builder-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:51:\"astra-settings[section-above-footer-builder-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:66:\"astra-settings[section-above-footer-builder-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"section-below-footer-builder-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hbb-footer-column]\";a:4:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hbb-footer-layout]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:4:\"full\";s:6:\"tablet\";s:4:\"full\";s:6:\"mobile\";s:4:\"full\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[hbb-footer-layout-width]\";a:4:{s:7:\"default\";s:7:\"content\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hbb-footer-height]\";a:4:{s:7:\"default\";i:60;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[hbb-footer-vertical-alignment]\";a:4:{s:7:\"default\";s:6:\"center\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:25:\"astra-settings[hbb-stack]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[hbb-footer-separator]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[hbb-footer-top-border-color]\";a:4:{s:7:\"default\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:44:\"astra-settings[hbb-footer-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:26:\"var(--ast-global-color-4 )\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:33:\"astra-settings[hbb-inner-spacing]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-below-footer-builder-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:52:\"astra-settings[section-below-footer-builder-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:51:\"astra-settings[section-below-footer-builder-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:66:\"astra-settings[section-below-footer-builder-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:41:\"section-footer-copyright-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[footer-copyright-editor]\";a:4:{s:7:\"default\";s:49:\"Copyright [copyright] [current_year] [site_title]\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[footer-copyright-alignment]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[footer-copyright-color]\";a:4:{s:7:\"default\";s:25:\"var(--ast-global-color-3)\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:55:\"astra-settings[section-footer-copyright-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:47:\"astra-settings[section-footer-copyright-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:50:\"astra-settings[font-size-section-footer-copyright]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:62:\"astra-settings[section-footer-copyright-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:36:\"section-footer-menu-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[footer-create-menu-link]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[footer-menu-layout]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:10:\"horizontal\";s:6:\"tablet\";s:8:\"vertical\";s:6:\"mobile\";s:8:\"vertical\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[footer-menu-alignment]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[footer-menu-link-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[footer-menu-background-colors]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[footer-menu-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[footer-menu-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[footer-menu-h-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[footer-menu-h-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:46:\"astra-settings[footer-menu-a-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[footer-menu-a-bg-color-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-main-menu-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-main-menu-spacing]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"20\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:42:\"astra-settings[section-footer-menu-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:37:\"astra-settings[footer-menu-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:57:\"astra-settings[section-footer-menu-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:63:\"astra-settings[section-fb-social-icons-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:51:\"astra-settings[font-size-section-fb-social-icons-1]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"section-fb-social-icons-1-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[footer-social-1-color-type]\";a:4:{s:7:\"default\";s:6:\"custom\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[footer-social-1-brand-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[footer-social-1-brand-label-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:50:\"astra-settings[footer-social-1-brand-hover-toggle]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[footer-social-1-icon-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[footer-social-1-label-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[footer-social-1-background-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[footer-social-1-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[footer-social-1-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[footer-social-1-label-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[footer-social-1-label-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-social-1-bg-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[footer-social-1-bg-h-color]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[footer-social-icons-1]\";a:4:{s:7:\"default\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:21:\"sanitize_social_icons\";}}s:44:\"astra-settings[footer-social-1-label-toggle]\";a:4:{s:7:\"default\";b:0;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[footer-social-1-space]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-social-1-bg-space]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:36:\"astra-settings[footer-social-1-size]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:45:\"astra-settings[footer-social-1-radius-fields]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:56:\"astra-settings[section-fb-social-icons-1-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[section-fb-social-icons-1-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:41:\"astra-settings[footer-social-1-alignment]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:47:\"section-primary-footer-builder-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:32:\"astra-settings[hb-footer-column]\";a:4:{s:7:\"default\";s:1:\"3\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:32:\"astra-settings[hb-footer-layout]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:7:\"3-equal\";s:6:\"tablet\";s:7:\"3-equal\";s:6:\"mobile\";s:4:\"full\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:38:\"astra-settings[hb-footer-layout-width]\";a:4:{s:7:\"default\";s:7:\"content\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[hb-primary-footer-height]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[hb-footer-vertical-alignment]\";a:4:{s:7:\"default\";s:10:\"flex-start\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:24:\"astra-settings[hb-stack]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[hb-footer-main-sep]\";a:4:{s:7:\"default\";i:1;s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[hb-footer-main-sep-color]\";a:4:{s:7:\"default\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:20:\"sanitize_alpha_color\";}}s:43:\"astra-settings[hb-footer-bg-obj-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:7:\"#f9f9f9\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:32:\"astra-settings[hb-inner-spacing]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[section-primary-footer-builder-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:54:\"astra-settings[section-primary-footer-builder-padding]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:53:\"astra-settings[section-primary-footer-builder-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:68:\"astra-settings[section-primary-footer-builder-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[section-fb-html-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[font-size-section-fb-html-1]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"section-fb-html-1-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:29:\"astra-settings[footer-html-1]\";a:4:{s:7:\"default\";s:22:\"Insert HTML text here.\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[footer-html-1color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-html-1-link-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[footer-html-1link-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[footer-html-1link-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[section-fb-html-1-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[section-fb-html-1-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:39:\"astra-settings[footer-html-1-alignment]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:55:\"astra-settings[section-fb-html-2-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[font-size-section-fb-html-2]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"section-fb-html-2-ast-context-tabs\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:29:\"astra-settings[footer-html-2]\";a:4:{s:7:\"default\";s:22:\"Insert HTML text here.\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:34:\"astra-settings[footer-html-2color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[footer-html-2-link-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:39:\"astra-settings[footer-html-2link-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[footer-html-2link-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[section-fb-html-2-margin-divider]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:40:\"astra-settings[section-fb-html-2-margin]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:39:\"astra-settings[footer-html-2-alignment]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[astra-sidebar-widgets-footer-widget-1-margin]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:41:\"astra-settings[footer-widget-alignment-1]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[footer-widget-1-title-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[footer-widget-1-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[footer-widget-1-link-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[footer-widget-1-link-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[footer-widget-1-link-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[footer-widget-1-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[footer-widget-1-content-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:75:\"astra-settings[astra-sidebar-widgets-footer-widget-1-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[astra-sidebar-widgets-footer-widget-2-margin]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:41:\"astra-settings[footer-widget-alignment-2]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[footer-widget-2-title-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[footer-widget-2-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[footer-widget-2-link-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[footer-widget-2-link-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[footer-widget-2-link-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[footer-widget-2-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[footer-widget-2-content-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:75:\"astra-settings[astra-sidebar-widgets-footer-widget-2-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[astra-sidebar-widgets-footer-widget-3-margin]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:41:\"astra-settings[footer-widget-alignment-3]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[footer-widget-3-title-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[footer-widget-3-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[footer-widget-3-link-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[footer-widget-3-link-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[footer-widget-3-link-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[footer-widget-3-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[footer-widget-3-content-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:75:\"astra-settings[astra-sidebar-widgets-footer-widget-3-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}s:60:\"astra-settings[astra-sidebar-widgets-footer-widget-4-margin]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";a:2:{i:0;s:26:\"Astra_Customizer_Sanitizes\";i:1;s:27:\"sanitize_responsive_spacing\";}}s:41:\"astra-settings[footer-widget-alignment-4]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:43:\"astra-settings[footer-widget-4-title-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:37:\"astra-settings[footer-widget-4-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:48:\"astra-settings[footer-widget-4-link-color-group]\";a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:42:\"astra-settings[footer-widget-4-link-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:44:\"astra-settings[footer-widget-4-link-h-color]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:41:\"astra-settings[footer-widget-4-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:49:\"astra-settings[footer-widget-4-content-font-size]\";a:4:{s:7:\"default\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:11:\"postMessage\";s:17:\"sanitize_callback\";b:0;}s:75:\"astra-settings[astra-sidebar-widgets-footer-widget-4-visibility-responsive]\";a:4:{s:7:\"default\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:4:\"type\";s:6:\"option\";s:9:\"transport\";s:7:\"refresh\";s:17:\"sanitize_callback\";b:0;}}s:8:\"partials\";a:37:{s:41:\"astra-settings[header-mobile-popup-items]\";a:4:{s:8:\"selector\";s:25:\"#ast-mobile-popup-wrapper\";s:15:\"render_callback\";a:2:{i:0;O:20:\"Astra_Builder_Header\":0:{}i:1;s:12:\"mobile_popup\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:1;}s:37:\"astra-settings[different-retina-logo]\";a:4:{s:8:\"selector\";s:14:\".site-branding\";s:15:\"render_callback\";s:35:\"Astra_Builder_Header::site_identity\";s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:38:\"astra-settings[ast-header-retina-logo]\";a:4:{s:8:\"selector\";s:14:\".site-branding\";s:15:\"render_callback\";s:35:\"Astra_Builder_Header::site_identity\";s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:37:\"astra-settings[different-mobile-logo]\";a:4:{s:8:\"selector\";s:14:\".site-branding\";s:15:\"render_callback\";s:35:\"Astra_Builder_Header::site_identity\";s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:33:\"astra-settings[use-logo-svg-icon]\";a:4:{s:8:\"selector\";s:14:\".site-branding\";s:15:\"render_callback\";s:49:\"Astra_Builder_UI_Controller::render_site_identity\";s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:0;}s:29:\"astra-settings[logo-svg-icon]\";a:4:{s:8:\"selector\";s:14:\".site-branding\";s:15:\"render_callback\";s:49:\"Astra_Builder_UI_Controller::render_site_identity\";s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:0;}s:33:\"astra-settings[logo-title-inline]\";a:4:{s:8:\"selector\";s:14:\".site-branding\";s:15:\"render_callback\";s:35:\"Astra_Builder_Header::site_identity\";s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:35:\"astra-settings[related-posts-title]\";a:4:{s:8:\"selector\";s:57:\".ast-related-posts-title-section .ast-related-posts-title\";s:15:\"render_callback\";a:2:{i:0;s:26:\"Astra_Related_Posts_Loader\";i:1;s:26:\"render_related_posts_title\";}s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:39:\"astra-settings[transparent-header-logo]\";a:4:{s:8:\"selector\";s:64:\".ast-replace-site-logo-transparent .site-branding .site-logo-img\";s:15:\"render_callback\";s:0:\"\";s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:35:\"astra-settings[breadcrumb-position]\";a:4:{s:8:\"selector\";s:54:\".ast-breadcrumbs-wrapper .ast-breadcrumbs .trail-items\";s:15:\"render_callback\";s:0:\"\";s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:36:\"astra-settings[footer-desktop-items]\";a:4:{s:8:\"selector\";s:12:\".site-footer\";s:15:\"render_callback\";a:2:{i:0;O:20:\"Astra_Builder_Footer\":0:{}i:1;s:13:\"footer_markup\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:1;}s:35:\"astra-settings[header-trigger-icon]\";a:4:{s:8:\"selector\";s:16:\".ast-button-wrap\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:21:\"render_mobile_trigger\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:46:\"astra-settings[mobile-header-toggle-btn-style]\";a:4:{s:8:\"selector\";s:16:\".ast-button-wrap\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:21:\"render_mobile_trigger\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:40:\"astra-settings[mobile-header-menu-label]\";a:4:{s:8:\"selector\";s:16:\".ast-button-wrap\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:21:\"render_mobile_trigger\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:35:\"astra-settings[header-button1-text]\";a:4:{s:8:\"selector\";s:20:\".ast-header-button-1\";s:15:\"render_callback\";a:2:{i:0;r:8394;i:1;s:8:\"button_1\";}s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:0;}s:42:\"astra-settings[header-button1-link-option]\";a:4:{s:8:\"selector\";s:20:\".ast-header-button-1\";s:15:\"render_callback\";a:2:{i:0;r:8394;i:1;s:8:\"button_1\";}s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:29:\"astra-settings[header-html-1]\";a:4:{s:8:\"selector\";s:18:\".ast-header-html-1\";s:15:\"render_callback\";a:2:{i:0;r:8394;i:1;s:13:\"header_html_1\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:0;}s:29:\"astra-settings[header-html-2]\";a:4:{s:8:\"selector\";s:18:\".ast-header-html-2\";s:15:\"render_callback\";a:2:{i:0;r:8394;i:1;s:13:\"header_html_2\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:0;}s:42:\"astra-settings[header-account-login-style]\";a:4:{s:8:\"selector\";s:19:\".ast-header-account\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:14:\"render_account\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:67:\"astra-settings[header-account-login-style-extend-text-profile-type]\";a:4:{s:8:\"selector\";s:19:\".ast-header-account\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:14:\"render_account\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:45:\"astra-settings[header-account-logged-in-text]\";a:4:{s:8:\"selector\";s:19:\".ast-header-account\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:14:\"render_account\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:41:\"astra-settings[header-account-login-link]\";a:4:{s:8:\"selector\";s:19:\".ast-header-account\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:14:\"render_account\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:43:\"astra-settings[header-account-logout-style]\";a:4:{s:8:\"selector\";s:19:\".ast-header-account\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:14:\"render_account\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:68:\"astra-settings[header-account-logout-style-extend-text-profile-type]\";a:4:{s:8:\"selector\";s:19:\".ast-header-account\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:14:\"render_account\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:45:\"astra-settings[header-account-logout-preview]\";a:4:{s:8:\"selector\";s:19:\".ast-header-account\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:14:\"render_account\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:46:\"astra-settings[header-account-logged-out-text]\";a:4:{s:8:\"selector\";s:19:\".ast-header-account\";s:15:\"render_callback\";a:2:{i:0;s:27:\"Astra_Builder_UI_Controller\";i:1;s:14:\"render_account\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:1;}s:37:\"astra-settings[header-social-icons-1]\";a:4:{s:8:\"selector\";s:25:\".ast-header-social-1-wrap\";s:15:\"render_callback\";a:2:{i:0;r:8394;i:1;s:15:\"header_social_1\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:0;}s:44:\"astra-settings[header-social-1-label-toggle]\";a:4:{s:8:\"selector\";s:25:\".ast-header-social-1-wrap\";s:15:\"render_callback\";a:2:{i:0;r:8394;i:1;s:15:\"header_social_1\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:0;}s:33:\"astra-settings[hba-footer-column]\";a:4:{s:8:\"selector\";s:23:\".site-above-footer-wrap\";s:15:\"render_callback\";a:2:{i:0;r:8448;i:1;s:12:\"above_footer\";}s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:33:\"astra-settings[hbb-footer-column]\";a:4:{s:8:\"selector\";s:23:\".site-below-footer-wrap\";s:15:\"render_callback\";a:2:{i:0;r:8448;i:1;s:12:\"below_footer\";}s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:39:\"astra-settings[footer-copyright-editor]\";a:4:{s:8:\"selector\";s:21:\".ast-footer-copyright\";s:15:\"render_callback\";a:2:{i:0;r:8448;i:1;s:16:\"footer_copyright\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:1;}s:34:\"astra-settings[footer-menu-layout]\";a:4:{s:8:\"selector\";s:59:\".footer-widget-area[data-section=\"section-footer-menu\"] nav\";s:15:\"render_callback\";a:2:{i:0;r:8448;i:1;s:11:\"footer_menu\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:1;}s:37:\"astra-settings[footer-social-icons-1]\";a:4:{s:8:\"selector\";s:25:\".ast-footer-social-1-wrap\";s:15:\"render_callback\";a:2:{i:0;r:8448;i:1;s:15:\"footer_social_1\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:0;}s:44:\"astra-settings[footer-social-1-label-toggle]\";a:4:{s:8:\"selector\";s:25:\".ast-footer-social-1-wrap\";s:15:\"render_callback\";a:2:{i:0;r:8448;i:1;s:15:\"footer_social_1\";}s:18:\"containerInclusive\";b:1;s:15:\"fallbackRefresh\";b:0;}s:32:\"astra-settings[hb-footer-column]\";a:4:{s:8:\"selector\";s:25:\".site-primary-footer-wrap\";s:15:\"render_callback\";a:2:{i:0;r:8448;i:1;s:14:\"primary_footer\";}s:18:\"containerInclusive\";b:0;s:15:\"fallbackRefresh\";b:1;}s:29:\"astra-settings[footer-html-1]\";a:4:{s:8:\"selector\";s:18:\".ast-footer-html-1\";s:15:\"render_callback\";a:2:{i:0;r:8448;i:1;s:13:\"footer_html_1\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:0;}s:29:\"astra-settings[footer-html-2]\";a:4:{s:8:\"selector\";s:18:\".ast-footer-html-2\";s:15:\"render_callback\";a:2:{i:0;r:8448;i:1;s:13:\"footer_html_2\";}s:18:\"containerInclusive\";s:0:\"\";s:15:\"fallbackRefresh\";b:0;}}}", "off");
INSERT INTO `wp_options` VALUES("919", "_transient_is_multi_author", "0", "on");
INSERT INTO `wp_options` VALUES("1573", "_transient_timeout_astra-theme-cron-test-ok", "1760957855", "off");
INSERT INTO `wp_options` VALUES("1574", "_transient_astra-theme-cron-test-ok", "1", "off");
INSERT INTO `wp_options` VALUES("1575", "allowed_astra_notices", "a:1:{i:0;s:18:\"astra-optin-notice\";}", "auto");
INSERT INTO `wp_options` VALUES("1576", "_site_transient_timeout_community-events-18cf6ecb7580b0ea77f325d194d8a706", "1760997456", "off");
INSERT INTO `wp_options` VALUES("1577", "_site_transient_community-events-18cf6ecb7580b0ea77f325d194d8a706", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"46.147.104.0\";}s:6:\"events\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("1578", "_transient_timeout_feed_94d0b45cbbe5640144493b43a9e8f566", "1760997457", "off");
INSERT INTO `wp_options` VALUES("1579", "_transient_feed_94d0b45cbbe5640144493b43a9e8f566", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Blog – WordPress.org English (UK)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://en-gb.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Sep 2024 20:43:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-GB\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.9-alpha-60929\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Blog – WordPress.org English (UK)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://en-gb.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.6.2 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://en-gb.wordpress.org/2024/09/10/wordpress-6-6-2-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://en-gb.wordpress.org/2024/09/10/wordpress-6-6-2-maintenance-release/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Sep 2024 20:43:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1777\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:412:\"WordPress 6.6.2 is now available! This minor release includes&#160;15 bug fixes in Core&#160;and&#160;11 in the Block Editor, addressing issues like unexpected CSS specificity changes in certain themes. For a full summary of the maintenance updates, you can refer to the&#160;Release Candidate announcement. WordPress 6.6.2 is a short-cycle release. The next major release will be version 6.7 planned [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8189:\"\n<h2 class=\"wp-block-heading\">WordPress 6.6.2 is now available!</h2>\n\n\n\n<p>This minor release includes&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;id=!61982&amp;milestone=6.6.2&amp;group=status&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;col=keywords&amp;order=id\">15 bug fixes in Core</a>&nbsp;and&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/61982#comment:5\">11 in the Block Editor</a>, addressing issues like unexpected CSS specificity changes in certain themes. For a full summary of the maintenance updates, you can refer to the&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/04/wordpress-6-6-2-rc1-is-now-available/\">Release Candidate announcement</a>.</p>\n\n\n\n<p>WordPress 6.6.2 is a short-cycle release. The next major release will be <a href=\"https://make.wordpress.org/core/6-7/\">version 6.7</a> planned for 12 November 2024.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can&nbsp;<a href=\"https://wordpress.org/wordpress-6.6.2.zip\">download WordPress 6.6.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information on this release, please&nbsp;<a href=\"https://wordpress.org/support/wordpress-version/version-6-6-2\">visit the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a> and <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a>, with <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> mentoring us.</p>\n\n\n\n<p>WordPress 6.6.2 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/aaronrobertshaw\">Aaron Robertshaw</a>,&nbsp;<a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>,&nbsp;<a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>,&nbsp;<a href=\"https://profiles.wordpress.org/atachibana\">Akira Tachibana</a>,&nbsp;<a href=\"https://profiles.wordpress.org/akshat2802\">Akshat Kakkad</a>,&nbsp;<a href=\"https://profiles.wordpress.org/harlet7\">Alexandru Horeanu</a>,&nbsp;<a href=\"https://profiles.wordpress.org/amitraj2203\">Amit Raj</a>,&nbsp;<a href=\"https://profiles.wordpress.org/andreiglingeanu\">andreiglingeanu</a>,&nbsp;<a href=\"https://profiles.wordpress.org/andrewserong\">Andrew Serong</a>,&nbsp;<a href=\"https://profiles.wordpress.org/the-ank\">Ankur Vishwakarma</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ahortin\">Anthony Hortin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/apmeyer\">apmeyer</a>,&nbsp;<a href=\"https://profiles.wordpress.org/aristath\">Ari Stathopoulos</a>,&nbsp;<a href=\"https://profiles.wordpress.org/rainbowgeek\">Benjamin Denis</a>,&nbsp;<a href=\"https://profiles.wordpress.org/bernhard-reiter\">bernhard-reiter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ironprogrammer\">Brian Alexander</a>,&nbsp;<a href=\"https://profiles.wordpress.org/freibergergarcia\">Bruno Freiberger Garcia</a>,&nbsp;<a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/costdev\">Colin Stewart</a>,&nbsp;<a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dballari\">David Ballarin Prunera</a>,&nbsp;<a href=\"https://profiles.wordpress.org/davidbaumwald\">David Baumwald</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dsas\">Dean Sas</a>,&nbsp;<a href=\"https://profiles.wordpress.org/debarghyabanerjee\">DEBARGHYA BANERJEE</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>,&nbsp;<a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jamesros161\">James Rosado</a>,&nbsp;<a href=\"https://profiles.wordpress.org/madtownlems\">Jason LeMahieu (MadtownLems)</a>,&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jeherve\">Jeremy Herve</a>,&nbsp;<a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/josklever\">Jos Klever</a>,&nbsp;<a href=\"https://profiles.wordpress.org/karan4word\">karan4official</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ryelle\">Kelly Choyce-Dwan</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kowsar89\">Kowsar Hossain</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kracked888\">kracked888</a>,&nbsp;<a href=\"https://profiles.wordpress.org/luisherranz\">luisherranz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/clorith\">Marius L. J.</a>,&nbsp;<a href=\"https://profiles.wordpress.org/marius84\">mariushosting</a>,&nbsp;<a href=\"https://profiles.wordpress.org/markhowellsmead\">Mark Howells-Mead</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mattraines\">mattraines</a>,&nbsp;<a href=\"https://profiles.wordpress.org/michaelwp85\">michaelwp85</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>,&nbsp;<a href=\"https://profiles.wordpress.org/munyagu\">munyagu</a>,&nbsp;<a href=\"https://profiles.wordpress.org/narenin\">Narendra Sishodiya</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ndiego\">Nick Diego</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nithi22\">Nithin John</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nithins53\">Nithin SreeRaj</a>,&nbsp;<a href=\"https://profiles.wordpress.org/alshakero\">Omar Alshaker</a>,&nbsp;<a href=\"https://profiles.wordpress.org/paaljoachim\">Paal Joachim Romdahl</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pamprn\">Pamela Ribeiro</a>,&nbsp;<a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pbiron\">Paul Biron</a>,&nbsp;<a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/presstoke\">presstoke</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ramonopoly\">ramonopoly</a>,&nbsp;<a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>,&nbsp;<a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>,&nbsp;<a href=\"https://profiles.wordpress.org/shailu25\">Shail Mehta</a>,&nbsp;<a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>,&nbsp;<a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a>,&nbsp;<a href=\"https://profiles.wordpress.org/vcanales\">Vicente Canales</a>,&nbsp;<a href=\"https://profiles.wordpress.org/wongjn\">wongjn</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ytfeldrawkcab\">ytfeLdrawkcaB</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac,&nbsp;<a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a>&nbsp;and&nbsp;<a href=\"https://wordpress.slack.com/archives/C07BTF54N68\">#6-7-release-leads</a>&nbsp;channels. Need help? Check out the&nbsp;<a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p>As a reminder, please see&nbsp;<a href=\"https://wordpress.org/https://make.wordpress.org/plugins/2024/09/04/upcoming-security-changes-for-plugin-and-theme-authors-on-wordpress-org/\">this post for the upcoming security changes for plugin and theme authors on WordPress.org</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://en-gb.wordpress.org/2024/09/10/wordpress-6-6-2-maintenance-release/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1777\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.6.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://en-gb.wordpress.org/2024/07/23/wordpress-6-6-1-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://en-gb.wordpress.org/2024/07/23/wordpress-6-6-1-maintenance-release/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Jul 2024 16:10:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1771\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:384:\"WordPress 6.6.1 is now available! This minor release features&#160;7 bug fixes in Core&#160;and&#160;9 bug fixes for the Block Editor. You can review a summary of the maintenance updates in this release by reading the&#160;Release Candidate announcement. WordPress 6.6.1 is a short-cycle release. The next major release will be version 6.7 planned for November 2024. If you [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6032:\"\n<p><strong>WordPress 6.6.1 is now available!</strong></p>\n\n\n\n<p>This minor release features&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;id=!61692&amp;milestone=6.6.1&amp;group=status&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;col=keywords&amp;order=priority\">7 bug fixes in Core</a>&nbsp;and&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/61692#comment:4\">9 bug fixes for the Block Editor</a>. You can review a summary of the maintenance updates in this release by reading the&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/18/wordpress-6-6-1-rc1-is-now-available/\">Release Candidate announcement</a>.</p>\n\n\n\n<p>WordPress 6.6.1 is a short-cycle release. The next major release will be <a href=\"https://make.wordpress.org/core/6-7/\">version 6.7</a> planned for November 2024.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can&nbsp;<a href=\"https://wordpress.org/wordpress-6.6.1.zip\">download WordPress 6.6.1 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information on this release, please&nbsp;<a href=\"https://wordpress.org/support/wordpress-version/version-6-6-1\">visit the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by&nbsp;<a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a>&nbsp;and&nbsp;<a href=\"https://profiles.wordpress.org/ellatrix/\">Ella</a>.</p>\n\n\n\n<p>WordPress 6.6.1 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin%22\">Aaron Jorbin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/aaronrobertshaw\">Aaron Robertshaw</a>,&nbsp;<a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>,&nbsp;<a href=\"https://profiles.wordpress.org/amitraj2203\">Amit Raj</a>,&nbsp;<a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a>,&nbsp;<a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>,&nbsp;<a href=\"https://profiles.wordpress.org/andrewserong\">Andrew Serong</a>,&nbsp;<a href=\"https://profiles.wordpress.org/annezazu\">annezazu</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ambrosiawt\">Art Smith</a>,&nbsp;<a href=\"https://profiles.wordpress.org/bgardner\">Brian Gardner</a>,&nbsp;<a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/cbirdsong\">cbirdsong</a>,&nbsp;<a href=\"https://profiles.wordpress.org/butterflymedia\">Ciprian</a>,&nbsp;<a href=\"https://profiles.wordpress.org/clarktbt\">Clark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/courane01\">Courtney Robertson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a>,&nbsp;<a href=\"https://profiles.wordpress.org/davidbaumwald\">David Baumwald</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ellatrix\">Ella</a>,&nbsp;<a href=\"https://profiles.wordpress.org/annubis\">Eric-Oliver Mächler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/fabiankaegy\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jsnajdr\">Jarda Snajdr</a>,&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/joen\">Joen A.</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a><a>,&nbsp;</a><a href=\"https://profiles.wordpress.org/mciampini\">Marco Ciampini</a>,&nbsp;<a href=\"https://profiles.wordpress.org/santosguillamot\">Mario Santos</a>,&nbsp;<a href=\"https://profiles.wordpress.org/markhowellsmead\">Mark Howells-Mead</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mukesh27%20\">Mukesh Panchal</a>,&nbsp;<a href=\"https://profiles.wordpress.org/neotrope\">neotrope</a>,&nbsp;<a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pbiron\">Paul Biron</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ramonopoly\">ramonopoly</a>,&nbsp;<a href=\"https://profiles.wordpress.org/raquelandefeld\">Raquel</a>,&nbsp;<a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>,&nbsp;<a href=\"https://profiles.wordpress.org/richtabor\">Rich Tabor</a>,&nbsp;<a href=\"https://profiles.wordpress.org/noisysocks\">Robert Anderson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>,&nbsp;<a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sourav08\">Sourav Pahwa</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sunil25393\">SunilPrajapati</a>,&nbsp;<a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a>,&nbsp;<a href=\"https://profiles.wordpress.org/up1512001\">up1512001</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac,&nbsp;<a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a>&nbsp;and&nbsp;<a href=\"https://wordpress.slack.com/archives/C07BTF54N68\">#6-7-release-leads</a>&nbsp;channels. Need help? Check out the&nbsp;<a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://en-gb.wordpress.org/2024/07/23/wordpress-6-6-1-maintenance-release/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1771\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 6.6 “Dorsey”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://en-gb.wordpress.org/2024/07/16/wordpress-6-6-dorsey/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://en-gb.wordpress.org/2024/07/16/wordpress-6-6-dorsey/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Jul 2024 17:07:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1768\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:388:\"Say hello to WordPress 6.6 “Dorsey,” named after the legendary American Big Band leader, Tommy Dorsey. Renowned for his smooth-toned trombone and compositions, Dorsey’s music captivated audiences with its emotional depth and vibrant energy. Let your heart swing, sing, and sway to the deep brass notes of&#160;Dorsey’s Big Band sound&#160;as you explore the new features [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:63148:\"\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/07/Release-Edition-Inline-Image-1.png?resize=1024%2C683&amp;ssl=1\" alt=\"\" class=\"wp-image-17529\" /></figure>\n\n\n\n<p>Say hello to WordPress 6.6 “Dorsey,” named after the legendary American Big Band leader, Tommy Dorsey. Renowned for his smooth-toned trombone and compositions, Dorsey’s music captivated audiences with its emotional depth and vibrant energy.</p>\n\n\n\n<p>Let your heart swing, sing, and sway to the deep brass notes of&nbsp;<a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO2TT3Ge?si=d9872e46371c4ed7\" target=\"_blank\" rel=\"noreferrer noopener\">Dorsey’s Big Band sound</a>&nbsp;as you explore the new features and enhancements of WordPress 6.6.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Hello, 6.6!</h2>\n\n\n\n<p>WordPress 6.6 delivers on the promise of a better web by bringing style, finesse, and a suite of creative possibilities to your site-building experience. This version helps you do more with ease, putting enhanced tools at your fingertips and giving you unprecedented power behind the scenes. You will find more ways to create beautiful, coherent design elements across your site, a new layout for quick page previews in the Site Editor, and the safety of automatic rollbacks for failed plugin auto-updates – among many other highlights.</p>\n\n\n\n<p>In addition to the new features, “Dorsey” continues to deliver the performance and accessibility gains you can expect from every WordPress release. Explore what WordPress 6.6 has to offer and get ready to let its features take your sites to new heights.</p>\n\n\n\n<p><a href=\"https://wordpress.org/wordpress-6.6.zip\" target=\"_blank\" rel=\"noreferrer noopener\">Download WordPress 6.6 “Dorsey”</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s inside</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Add more design options to block themes</h3>\n\n\n\n<p>Create colour or font sets to multiply design combinations across one theme. These sets offer more contained design possibilities, allowing visual variety within the site’s broader styling guidelines.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://lh7-us.googleusercontent.com/docsz/AD_4nXc7Mg7QzTwFiR7NDQLj6p5m4eddq6MtscZYzTh5QeGqB2sLP3T_t2Io2cqA5QuSixyze9ZVWqsDF9ZD7VscWn0TWA6lCG0OgZ4o5Ar_8MgQta8B3vu3VzJQHYREY9NxUb9J8e3BFESmcnbRwg7g6GuFfguU?key=EV-htfbHG-kjLl6r6s-uKA\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Simplify your workflow with a new layout for pages in the Site Editor</h3>\n\n\n\n<p>See all of your pages and a preview of any selected page with the new side-by-side layout in the Site Editor.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://lh7-us.googleusercontent.com/docsz/AD_4nXfdAh-2XaS_6bdw8YcDZMRpkT0O6oWezPzZT3FzKjoWcxhM4ofivJli8eDRs1pO60wJ7F6YjQblSDop_O8MXQKwRlb_-g8CsFPPVb7hY3vEgIBPLb3tDyrvZZhSZL6Zp-ntXQdB2-ixFVoWaY-Empv3hZQ-?key=EV-htfbHG-kjLl6r6s-uKA\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Auto-update your plugins with peace of mind</h3>\n\n\n\n<p>Enjoy the convenience of plugin auto-updates with the safety of rollbacks if anything goes wrong – offering your site a new level of security, enhanced functionality as it becomes available, and almost no time or bandwidth from you to make it happen.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://lh7-us.googleusercontent.com/docsz/AD_4nXc3cOWzosH9yiEDJrkmndXXX4QShj-vVMJJslAlgxCT74ugbYJuRPszdUi2rrCt8fnmZm1fTdJ3DTkKxYh5ImN4b6lvyBI3bsf5nvzWSBtexeldhPGyjYZM4Me1eUzfq9bAzlzlwxVqI5Hf_i9y1NGvKEdc?key=EV-htfbHG-kjLl6r6s-uKA\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Customise content in synced patterns</h3>\n\n\n\n<p>Make content changes in each instance of a synced pattern while maintaining a consistent style across them. Set these overrides for Heading, Paragraph, Button, and Image blocks when placed in a synced pattern.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://lh7-us.googleusercontent.com/docsz/AD_4nXdH_at4lSW3-Slznfn7HTOEp11xKp889JaLIj-JY5zATJbqZhNPM5MIVZzhn7J2gGhqRbkIzjGMhkFzfQFXfLpxoXu2MXDcPMCXaACaucFHph4dMrd8jHCqFckpk0HtJhEI_cWHTRDR0343_Ut06sgNgaOw?key=EV-htfbHG-kjLl6r6s-uKA\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Performance</h3>\n\n\n\n<p>WordPress 6.6 features important updates like removing redundant WP_Theme_JSON calls, disabling autoload for large options, and eliminating unnecessary polyfill dependencies. Other highlights include lazy-loading post embeds, a new&nbsp;<code>data-wp-on-async</code>&nbsp;directive, and templates in the editor that load approximately 35% faster overall.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Accessibility</h3>\n\n\n\n<p>This release includes 58 accessibility fixes and enhancements. These focus on foundational aspects of the WordPress experience, particularly the data views component powering the new site editing experience and areas like the Inserter, which provide a key way of interacting with blocks and patterns.</p>\n\n\n\n<h3 class=\"wp-block-heading\">And much more</h3>\n\n\n\n<p>Visit the&nbsp;<a href=\"https://wordpress.org/download/releases/6-6/\">feature showcase</a>&nbsp;for a full overview of all the new features and enhancements in WordPress 6.6.</p>\n\n\n\n<p><a href=\"https://wordpress.org/download/releases/6-6/\">Check out what’s new</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.6</h2>\n\n\n\n<p>Explore<a href=\"https://learn.wordpress.org/\">&nbsp;Learn WordPress</a>&nbsp;for quick how-to videos,<a href=\"https://learn.wordpress.org/social-learning/\">&nbsp;online workshops</a>, and other free resources to level up your WordPress knowledge and skills.</p>\n\n\n\n<p>The&nbsp;<a href=\"https://make.wordpress.org/core/2024/06/25/wordpress-6-6-field-guide/\">WordPress 6.6 Field Guide</a>&nbsp;contains detailed technical information and&nbsp;<a href=\"https://make.wordpress.org/core/tag/dev-notes-6-6/\">developer notes</a>&nbsp;to help you build with WordPress and get the most out of this release. Don’t forget to subscribe to the&nbsp;<a href=\"https://developer.wordpress.org/news/\">Developer Blog</a>&nbsp;for updates, tutorials, and other helpful WordPress content for developers.</p>\n\n\n\n<p>For information about installation, file changes, fixes, and other updates, read the 6.6 release notes.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.6 release squad</h2>\n\n\n\n<p>Every release comes to you from a dedicated team of enthusiastic contributors who help keep things on track and moving smoothly. The team that has led 6.6 is a cross-functional group of contributors who are always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordinator: <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a></li>\n\n\n\n<li>Core Tech Lead: <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Editor Tech Leads: <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a></li>\n\n\n\n<li>Core Triage Leads: <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a></li>\n\n\n\n<li>Editor Triage Leads: <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>, <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> </li>\n\n\n\n<li>Documentation Leads: <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a>, <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/josepmoran/\">Josep Morán</a></li>\n\n\n\n<li>Marketing &amp; Communications Lead: <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Test Lead: <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a></li>\n\n\n\n<li>Design Lead: <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Performance Lead: <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you, contributors</h2>\n\n\n\n<p>The mission of WordPress is to <a href=\"https://wordpress.org/about/\">democratise publishing</a> and embody the <a href=\"https://opensource.org/osd-annotated\">freedoms that come with open source</a>. A global and diverse community of people collaborating to strengthen the software supports this effort.</p>\n\n\n\n<p>WordPress 6.6 reflects the tireless efforts and passion of more than 630 contributors in at least 51 countries. This release also welcomed over 150 first-time contributors!</p>\n\n\n\n<p>Their collaboration delivered more than 1,900 enhancements and fixes, ensuring a stable release for all – a testament to the power and capability of the WordPress open source community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aatanasov/\">aatanasov</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/abditsori/\">abditsori</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/abhijitrakas/\">Abhijit Rakas</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/abitofmind/\">abitofmind</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kawauso/\">Adam Harley (Kawauso)</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/adeltahri/\">Adel Tahri</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/adrianduffell/\">adrianduffell</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aezazshekh/\">Aezaz Shekh</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ajfleming/\">ajfleming</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/akashdhawade/\">Akash Dhawade</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alesflex/\">alesflex</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cawa-93/\">Alex Kozack</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alexminza/\">alexminza</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/amanias1977/\">amanias1977</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/amirthepiper/\">Amir Abbas</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/amisiewicz/\">amisiewicz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/anamarijapapic/\">Anamarija Papić</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/andr3ribeiro/\">Andre Ribeiro</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a>·&nbsp;<a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/angelasjin/\">Angela Jin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/anilvaza/\">Anil Vaza</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/artpi/\">Artur Piszek</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/asheshmagar/\">Ashesh Magar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/imasikur22/\">Asiqur Rahman</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alisongodar/\">asmittle</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/balub/\">Balu B</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/benlk/\">Ben Keith</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner – Kadence WP</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/benjaminpick/\">Benjamin Pick</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/benjpw/\">benjpw</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bissy/\">bissy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/oldrup/\">Bjarne Oldrup</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/blackbam/\">Blackbam</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/blockify/\">Blockify</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bnewboldbsky/\">bnewboldbsky</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bgoewert/\">Brennan Goewert</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bgosnell/\">Brian Gosnell</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bridgetwillard/\">Bridget Willard</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/freibergergarcia/\">Bruno Freiberger Garcia</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/stringpiggy/\">Candy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/caercam/\">Charlie Merland</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cbringmann/\">Chloe Bringmann</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/colind/\">ColinD</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/colle/\">colle</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/comecaramelos/\">comecaramelos</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cotobago/\">Constantine Vasilyev</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cookiesfordevo/\">CookiesForDevo</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/coreymckrill/\">Corey McKrill</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/craigfrancis/\">Craig Francis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/crazytonyli/\">crazytonyli</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/curdin/\">Curdin Krummenacher</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cyrus11/\">cyrus11</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/daledupreez/\">Dale du Preez</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/colorful%20tones/\">Damon Cook</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dav4/\">dav4</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/davecpage/\">Dave Page</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/diggeddy/\">David</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/davidakennedy/\">David A. Kennedy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dkjensen/\">David Jensen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/davideferre/\">davideferre</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rxnlabs/\">De’Yonté W.</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/deeppatel8950/\">Deep Patel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/deepakvijayan/\">Deepak Vijayan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dhruvang21/\">dhruvang21</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dhruvkb/\">dhruvkb</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/diedeexterkate/\">DiedeExterkate</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/itsjustdj/\">DJ</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/djzone/\">DjZoNe</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/drrxbracho/\">drrxbracho</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/talksina/\">Elena Brescacin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/enej/\">Enej Bajgorić</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/garridinsi/\">Eneko Garrido</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/enodekciw/\">enodekciw</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/enricosorcinelli/\">Enrico Sorcinelli</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/evanltd/\">evanltd</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/iamfarhan09/\">Farhan Ahmed</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/flabernardez/\">Flavia Bernárdez Rodríguez</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/f-j-kaiser/\">Franz Josef Kaiser</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/lunule/\">Gabor Lippert</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/galbaras/\">Gal Baras</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/voldemortensen/\">Garth Mortensen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/blepoxp/\">Glenn Ansley</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hakre/\">hakre</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/haritpanchal/\">Harit Panchal</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/heinperu/\">heinvv</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hinnerk/\">Hinnerk Altenburg</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hitendra-chopda/\">Hitendra Chopda</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/humanify/\">humanify</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/huubl/\">huubl</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/inwerpsel/\">inwerpsel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ivanottinger/\">ivanottinger</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/weijland/\">Jaap Weijland</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jpstevens/\">Jack Stevens</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jaclync/\">jaclync</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jwgoedert/\">James Wesley Goedert</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/xhemals/\">Jamie Speller</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/janboddez/\">Jan Boddez</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jtolleouw/\">Jansen Tolle</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/szopserwis/\">Jarek Mazurczak</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jpolakovic/\">Jaroslav “Dero” Polakovic</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jayanthparthsarathy/\">jayanthparthsarathy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jdekhtiar/\">jdekhtiar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jeryj/\">Jerry Jones</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/amieiro/\">Jesús Amieiro</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/onmauitime/\">Jess</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jhned/\">jhned</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jivedig/\">JiveDig</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/timse201/\">Johannes Jülg</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/johnillo/\">John Espiritu</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bitmachina/\">John Hooks</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jon092/\">jon092</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jaruzek/\">Jonathan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkilä</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/josepmoran/\">Josep Morán</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jossnaz/\">Jossnaz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jules/\">jules</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/justnorris/\">justnorris</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jyolsna/\">Jyolsna J E</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kamran8176/\">kamran8176</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kellenmace/\">Kellen Mace</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kevinwhoffman/\">Kevin Hoffman</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/killua99/\">killua99</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ixkaito/\">Kite</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kmvan/\">kmvan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kovshenin/\">Konstantin Kovshenin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kristenfisher427/\">kristenfisher427</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kyleak/\">kyleak</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mlaetitia/\">Lae</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/lanresmith/\">Lanre Smith</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/lgersman/\">Lars Gersmann</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/oncecoupled/\">Lauren</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/peexy/\">Laurent Naudier</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/leemon/\">leemon</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/leonidasmilossis/\">Leonidas Milosis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/gigitux/\">Luigi</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/lardsax/\">Luis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/interdevel/\">Luis Molina (interdevel)</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/lyonmuller/\">Lyon Müller</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pagelab/\">Márcio Duarte</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mai21/\">Mai</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/makdiahussain/\">Makdia Hussain</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/manojmaharrshi/\">Manoj Maharrshi</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pereirinha/\">Marco Pereirinha</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/marherumr/\">marherumr</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/markjszymanski/\">Mark Szymanski</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mapk/\">Mark Uraine</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mat-lipe/\">Mat Lipe</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/imath/\">Mathieu Viet</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/webdevmattcrom/\">Matt Cromwell</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mattmm/\">Matt Medeiros</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mattormeeple/\">Matt Sherman</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/devsahadat/\">Md Sahadat Husain</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tofajjal02/\">Md Tofajjal Hossen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mdnesarmridha/\">MD.NESAR MRIDHA</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/immeet94/\">Meet Makadia</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/meetmehta1205/\">Meet Mehta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hrkhal/\">Michael James Ilett</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/misulicus/\">Mihai Joldis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mikehend/\">Mike Henderson</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mikeybinns/\">Mikey Binns</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/illuminea/\">Miriam Schwab</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/presents111/\">miya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mkismy/\">mkismy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jucaduca/\">Morais Junior</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/musannifzahir/\">musannifzahir</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/amustaque97/\">Mustaque Ahmed</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/myhro/\">myhro</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mykolashlyakhtun/\">mykolashlyakhtun</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nsinelnikov/\">Mykyta Synelnikov</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/naeemhaque/\">Naeem Haque</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/namithjawahar/\">Namith Jawahar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nateinaction/\">Nate Gay</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nazmul111/\">Nazmul Hosen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nicmare/\">nicmare</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nico23/\">Nico</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/niktat/\">Nicolas Tatarchenko</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nicomollet/\">nicomollet</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a>·&nbsp;<a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nkeller15/\">nkeller15</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ohia/\">Ohia ᚛ᚈᚐᚂᚐᚋᚆ᚜</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/okat/\">okat</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dargus/\">Old account</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/webgarten/\">Oliver Schmid</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/olliejones/\">OllieJones</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/paulwilde/\">Paul Wilde</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/peiche/\">peiche</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pers/\">Per Søderlind</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/perryrylance/\">perryrylance</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mr2p/\">Phi Phan</a>·&nbsp;<a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/wppinar/\">Pinar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pkuliga/\">pkuliga</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/povilasstaskus/\">povilasstaskus</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pranitdugad/\">Pranit Dugad</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/printsachen1/\">printsachen1</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/priyanshii5/\">Priyanshii Vijayvargiya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/prottoysarkar/\">Prottoy Sarkar Argho</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/quietnoise/\">QuietNoise</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rafaelgalani/\">Rafael Galani</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rafaucau/\">Rafał Całka</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/lamarajan/\">Rajan Lama</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ravipatel/\">Ravikumar Patel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ravinderk/\">Ravinder Kumar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/defries/\">Remkus de Vries</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/renishsurani/\">renishsurani</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rockfire/\">Richard Korthuis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/richardevs/\">richardevs</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/littlerchicken/\">Robin Cornett</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rodionov201/\">rodionov201</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kreppar/\">Rodrigo Arias</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rogermedia/\">Roger</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rolfsiebers/\">Rolf Siebers</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ryancurban/\">Ryan Urban</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/s0what/\">s0what</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sagarprajapati/\">Sagar Prajapati</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sahilthakur02/\">sahilthakur02</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/xronn/\">Sam Berry</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/samanthaxmunoz/\">Sam Brockway</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kim88/\">Samuel Rüegger</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sarkarripon/\">Sarkar Ripon</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/smetzdev/\">Sascha Metz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sauliusv/\">Saulius Vikerta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/saxonfletcher/\">Saxon Fletcher</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/scribu/\">scribu</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/script2see/\">script2see</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/flexseth/\">Seth Miller</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sheulyshila/\">sheulyshila</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shital-patel/\">Shital Marakana</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shivapoudel/\">Shiva Poudel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shivashankerbhatta/\">Shiva Shanker Bhatta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shub07/\">Shubham Kumar Bansal</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shuvomohajan/\">Shuvo Mohajan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sirzooro/\">sirzooro</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sjnbham/\">SJNBham</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/spencerfinnell/\">Spencer Finnell</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/stephenbrook/\">Stephen Brook</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/stephenmiracle/\">stephenmiracle</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/stevejonesdev/\">Steve Jones</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/steveblum/\">steveblum</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/strangehill/\">strangehill</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/suascat_wp/\">Suwash</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tahmidulkarim/\">Tahmid ul Karim</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/edent/\">Terence Eden</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/teresagobble/\">Teresa Gobble</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/thijso/\">Thijs</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/thirumani02/\">Thirumani Guhan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tillkruess/\">Till Krüss</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tb1909/\">Tim Brathärig</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/timnicholson/\">Tim Nicholson</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/timotijhof/\">Timo Tijhof</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tomalec/\">Tomek</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tomepajk/\">tomepajk</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tybor/\">tybor</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/vinita29/\">Vinita Tandulkar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ashokrane/\">Vishal Kothari</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/websitegenii/\">websitegenii</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/wesatintellitonic/\">wesatintellitonic</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/whaze/\">whaze</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nestea29950/\">WilliamG</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/wojtekn/\">Wojtek Naruniec</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/yagniksangani/\">Yagnik Sangani</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/yankiara/\">yankiara</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/collet/\">Yann</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/yukinobu/\">Yukinobu Asakawa</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/zackkrida/\">Zack Krida</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/zafarkamal/\">Zafar Kamal</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/zkarj/\">zkarj</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a></p>\n\n\n\n<p>More than&nbsp;<a href=\"https://translate.wordpress.org/stats/\">60 locales have translated 90 percent</a>&nbsp;or more of WordPress 6.6 into their language. Community translators are working hard to ensure more translations are on their way. Thank you to everyone who helps make WordPress available in 200 languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the&nbsp;<a href=\"https://wordpress.org/support/\">support forums</a>&nbsp;by answering questions from WordPress users worldwide.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Get involved</h2>\n\n\n\n<p>Participation in WordPress goes far beyond coding, and learning more and getting involved is easy. Discover the teams that come together to&nbsp;<a href=\"https://make.wordpress.org/\">Make WordPress</a>&nbsp;and use&nbsp;<a href=\"https://make.wordpress.org/contribute/\">this interactive tool</a>&nbsp;to help you decide which is right for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">6.6 haiku</h2>\n\n\n\n<p>Six-point-six is here.<br>Make it all gorgeous; keep it<br>On brand, and relax.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://en-gb.wordpress.org/2024/07/16/wordpress-6-6-dorsey/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1768\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:76:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"WordPress 6.5.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://en-gb.wordpress.org/2024/06/24/wordpress-6-5-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://en-gb.wordpress.org/2024/06/24/wordpress-6-5-5/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Jun 2024 20:00:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1761\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:413:\"WordPress 6.5.5 is now available! This release features three security fixes. Because this is a security release, it is recommended that you update your sites immediately. This minor release also includes three bug fixes in Core. You can&#160;download WordPress 6.5.5 from WordPress.org, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4414:\"\n<h2 class=\"wp-block-heading\">WordPress 6.5.5 is now available!</h2>\n\n\n\n<p>This release features three security fixes. Because this is a security release, <strong>it is recommended that you update your sites immediately. </strong>This minor release also includes <a href=\"https://core.trac.wordpress.org/query?component=!Build%2FTest+Tools&amp;milestone=6.5.5&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;col=component&amp;order=priority\">three bug fixes</a> in Core.</p>\n\n\n\n<p>You can&nbsp;<a href=\"https://wordpress.org/wordpress-6.5.5.zip\">download WordPress 6.5.5 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>WordPress 6.5.5 is a short-cycle release. The next major release will be version 6.6 which is scheduled for 16 July 2024.</p>\n\n\n\n<p>For more information on WordPress 6.5.5, please visit the&nbsp;<a href=\"https://wordpress.org/documentation/wordpress-version/version-6-5-5/\">HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for&nbsp;<a href=\"https://hackerone.com/wordpress?type=team\">responsibly reporting vulnerabilities</a>, and allowing them to be fixed in this release:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A cross-site scripting (XSS) vulnerability affecting the HTML API reported by Dennis Snell of the WordPress Core Team, along with Alex Concha and Grzegorz (Greg) Ziółkowski of the WordPress security team.</li>\n\n\n\n<li>A cross-site scripting (XSS) vulnerability affecting the Template Part block reported independently by Rafie Muhammad of Patchstack and during a third party security audit.</li>\n\n\n\n<li>A path traversal issue affecting sites hosted on Windows reported independently by Rafie M &amp; Edouard L of Patchstack, David Fifield,&nbsp;<a href=\"https://hackerone.com/x89\">x89</a>,&nbsp;<a href=\"https://hackerone.com/apple502j\">apple502j</a>, and&nbsp;<a href=\"https://hackerone.com/mishre\">mishre</a>.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by&nbsp;<a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>.</p>\n\n\n\n<p>WordPress 6.5.5 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance and security fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>,&nbsp;<a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/bernhard-reiter\">bernhard-reiter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/costdev\">Colin Stewart</a>,&nbsp;<a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/grantmkin\">Grant M. Kinney</a>,&nbsp;<a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>,&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>,&nbsp;<a href=\"https://profiles.wordpress.org/matveb\">Matias Ventura</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mcsf\">Miguel Fonseca</a>,&nbsp;<a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/rajinsharwar\">Rajin Sharwar</a>,&nbsp;<a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>,&nbsp;<a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac,&nbsp;<a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a>&nbsp;Slack channel. Need help? Check out the&nbsp;<a href=\"https://make.wordpress.org/core/handbook/tutorials/faq-for-new-contributors/\">Core Contributor Handbook</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://en-gb.wordpress.org/2024/06/24/wordpress-6-5-5/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1761\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.5.4 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://en-gb.wordpress.org/2024/06/05/wordpress-6-5-4-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://en-gb.wordpress.org/2024/06/05/wordpress-6-5-4-maintenance-release/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Jun 2024 16:45:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1757\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:399:\"WordPress 6.5.4 is now available!This minor release features&#160;5 bug fixes in Core. You can review a summary of the maintenance updates in this release by reading the&#160;Release Candidate announcement. WordPress 6.5.4 is a short-cycle release. The next major release will be&#160;version 6.6&#160;planned for July 2024. If you have sites that support automatic background updates, the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4531:\"\n<p><strong>WordPress 6.5.4 is now available!</strong><br>This minor release features&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.5.4&amp;group=status&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;col=keywords&amp;order=priority\">5 bug fixes in Core</a>. You can review a summary of the maintenance updates in this release by reading the&nbsp;<a href=\"https://make.wordpress.org/core/2024/05/30/wordpress-6-5-4-rc1-is-now-available/\">Release Candidate announcement</a>.</p>\n\n\n\n<p>WordPress 6.5.4 is a short-cycle release. The next major release will be&nbsp;<a href=\"https://make.wordpress.org/core/6-6/\">version 6.6</a>&nbsp;planned for July 2024.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can&nbsp;<a href=\"https://wordpress.org/wordpress-6.5.4.zip\">download WordPress 6.5.4 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information on this release, please&nbsp;<a href=\"https://wordpress.org/support/wordpress-version/version-6-5-4\">visit the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by&nbsp;<a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a>,&nbsp;<a href=\"https://profiles.wordpress.org/costdev\">Colin Stewart</a>, and&nbsp;<a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>.</p>\n\n\n\n<p>WordPress 6.5.4 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin%22\">Aaron Jorbin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/adrianduffell\">adrianduffell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/afragen\">Andy Fragen</a>,&nbsp;<a href=\"https://profiles.wordpress.org/beaulebens\">Beau Lebens</a>,&nbsp;<a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernhard Reiter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ironprogrammer\">Brian Alexander</a>,&nbsp;<a href=\"https://profiles.wordpress.org/costdev\">Colin Stewart</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nerrad\">Darren Ethier (nerrad)</a>,&nbsp;<a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>,&nbsp;<a href=\"https://profiles.wordpress.org/lopo\">Enrico Battocchi</a>,&nbsp;<a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>,&nbsp;<a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>,&nbsp;<a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>,&nbsp;<a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kevinwhoffman\">Kevin Hoffman</a>,&nbsp;<a href=\"https://profiles.wordpress.org/louiswol94\">Louis Wolmarans</a>,&nbsp;<a href=\"https://profiles.wordpress.org/hmbashar\">Md Abul Bashar</a>,&nbsp;<a href=\"https://profiles.wordpress.org/illuminea\">Miriam Schwab</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>,&nbsp;<a href=\"https://profiles.wordpress.org/narenin\">Narendra Sishodiya</a>,&nbsp;<a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pooja1210\">Pooja N Muchandikar</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mikachan\">Sarah Norris</a>,&nbsp;<a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>,&nbsp;<a href=\"https://profiles.wordpress.org/smub\">Syed Balkhi</a>,&nbsp;<a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac,&nbsp;<a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a>&nbsp;and&nbsp;<a href=\"https://wordpress.slack.com/archives/C06U06K50Q5\">#6-6-release-leads</a>&nbsp;channels. Need help? Check out the&nbsp;<a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://en-gb.wordpress.org/2024/06/05/wordpress-6-5-4-maintenance-release/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1757\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.5.3 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://en-gb.wordpress.org/2024/05/07/wordpress-6-5-3-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://en-gb.wordpress.org/2024/05/07/wordpress-6-5-3-maintenance-release/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 May 2024 17:52:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1752\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:395:\"WordPress 6.5.3 is now available! This minor release features&#160;12 bug fixes in Core&#160;and&#160;9 bug fixes for the block editor. You can review a summary of the maintenance updates in this release by reading the&#160;Release Candidate announcement. WordPress 6.5.3 is a short-cycle release. The next major release will be&#160;version 6.6&#160;planned for July 2024. If you have [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7608:\"\n<h2 class=\"wp-block-heading\">WordPress 6.5.3 is now available!</h2>\n\n\n\n<p>This minor release features&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.5.3&amp;group=status&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;col=keywords&amp;order=priority\">12 bug fixes in Core</a>&nbsp;and&nbsp;<a href=\"https://github.com/WordPress/gutenberg/pull/61299\">9 bug fixes for the block editor</a>. You can review a summary of the maintenance updates in this release by reading the&nbsp;<a href=\"https://make.wordpress.org/core/2024/05/02/wordpress-6-5-3-rc1-is-now-available/\">Release Candidate announcement</a>.</p>\n\n\n\n<p>WordPress 6.5.3 is a short-cycle release. The next major release will be&nbsp;<a href=\"https://make.wordpress.org/core/6-6/\">version 6.6</a>&nbsp;planned for July 2024.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can&nbsp;<a href=\"https://wordpress.org/wordpress-6.5.3.zip\">download WordPress 6.5.3 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information on this release, please&nbsp;<a href=\"https://wordpress.org/support/wordpress-version/version-6-5-3\">visit the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by&nbsp;<a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>&nbsp;and&nbsp;<a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a>.</p>\n\n\n\n<p>WordPress 6.5.3 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>,&nbsp;<a href=\"https://profiles.wordpress.org/adrianduffell\">adrianduffell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>,&nbsp;<a href=\"https://profiles.wordpress.org/alanfuller\">Alan Fuller</a>,&nbsp;<a href=\"https://profiles.wordpress.org/anlino\">Anders Norén</a>,&nbsp;<a href=\"https://profiles.wordpress.org/oandregal\">André</a>,&nbsp;<a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>,&nbsp;<a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/andrewserong\">Andrew Serong</a>,&nbsp;<a href=\"https://profiles.wordpress.org/afragen\">Andy Fragen</a>,&nbsp;<a href=\"https://profiles.wordpress.org/annezazu\">annezazu</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dextorlobo\">Arun Sharma</a>,&nbsp;<a href=\"https://profiles.wordpress.org/aslamdoctor\">Aslam Doctor</a>,&nbsp;<a href=\"https://profiles.wordpress.org/benlk\">Ben Keith</a>,&nbsp;<a href=\"https://profiles.wordpress.org/britner\">Ben Ritner – Kadence WP</a>,&nbsp;<a href=\"https://profiles.wordpress.org/bernhard-reiter\">bernhard-reiter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ironprogrammer\">Brian Alexander</a>,&nbsp;<a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/costdev\">Colin Stewart</a>,&nbsp;<a href=\"https://profiles.wordpress.org/CookiesForDevo\">CookiesForDevo</a>,&nbsp;<a href=\"https://profiles.wordpress.org/colorful-tones\">Damon Cook</a>,&nbsp;<a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a>,&nbsp;<a href=\"https://profiles.wordpress.org/darerodz\">darerodz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/davecpage\">Dave Page</a>,&nbsp;<a href=\"https://profiles.wordpress.org/davidbaumwald\">David Baumwald</a>,&nbsp;<a href=\"https://profiles.wordpress.org/justlevine\">David Levine</a>,&nbsp;<a href=\"https://profiles.wordpress.org/DrewAPicture\">Drew Jaynes</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ellatrix\">Ella</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kebbet\">Erik</a>,&nbsp;<a href=\"https://profiles.wordpress.org/evanltd\">evanltd</a>,&nbsp;<a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>,&nbsp;<a href=\"https://profiles.wordpress.org/grantmkin\">Grant M. Kinney</a>,&nbsp;<a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>,&nbsp;<a href=\"https://profiles.wordpress.org/isabel_brison\">Isabel Brison</a>,&nbsp;<a href=\"https://profiles.wordpress.org/macmanx\">James Huff</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jason_the_adams\">Jason Adams</a>,&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/JeffPaul\">Jeffrey Paul</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jeherve\">Jeremy Herve</a>,&nbsp;<a href=\"https://profiles.wordpress.org/luminuu\">Jessica Lyschik</a>,&nbsp;<a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jordesign\">jordesign</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jorgefilipecosta\">Jorge Costa</a>,&nbsp;<a href=\"https://profiles.wordpress.org/verygoode\">Joshua Goode</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kevin940726\">Kai Hao</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kevinwhoffman\">Kevin Hoffman</a>,&nbsp;<a href=\"https://profiles.wordpress.org/khokansardar\">Khokan Sardar</a>,&nbsp;<a href=\"https://profiles.wordpress.org/luisherranz\">luisherranz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mmaattiiaass\">Matias Benedetto</a>,&nbsp;<a href=\"https://profiles.wordpress.org/webdevmattcrom\">Matt Cromwell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/devsahadat\">Md Sahadat Husain</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>,&nbsp;<a href=\"https://profiles.wordpress.org/narenin\">Narendra Sishodiya</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ntsekouras\">Nik Tsekouras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ramonopoly\">ramonopoly</a>,&nbsp;<a href=\"https://profiles.wordpress.org/roytanck\">Roy Tanck</a>,&nbsp;<a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mikachan\">Sarah Norris</a>,&nbsp;<a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>,&nbsp;<a href=\"https://profiles.wordpress.org/stevejonesdev\">Steve Jones</a>,&nbsp;<a href=\"https://profiles.wordpress.org/tomjcafferkey\">Tom Cafferkey</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nestea29950\">WilliamG</a>,&nbsp;<a href=\"https://profiles.wordpress.org/yguyon\">Yannis Guyon</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac,&nbsp;<a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a>&nbsp;and&nbsp;<a href=\"https://wordpress.slack.com/archives/C06U06K50Q5\">#6-6-release-leads</a>&nbsp;channels. Need help? Check out the&nbsp;<a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://en-gb.wordpress.org/2024/05/07/wordpress-6-5-3-maintenance-release/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1752\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:82:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"WordPress London Meetup #WPLDN – April 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://en-gb.wordpress.org/2024/04/19/wordpress-london-meetup-wpldn-april-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://en-gb.wordpress.org/2024/04/19/wordpress-london-meetup-wpldn-april-2024/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Apr 2024 09:40:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:6:\"London\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Meetup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:9:\"WP London\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:5:\"wpldn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1748\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:415:\"Join the WordPress London Meetup #WPLDN this month, where we&#8217;re presenting two great speakers, one from Amnesty International and the other from a well-established, fast-paced WordPress agency. Join us for an evening of networking, community, and learning. Register today to save your place, as numbers are limited. &#8212; ✍️ &#8211;&#160;Built with humanityFind out about Amnesty&#8217;s (Web [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Dan Maby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2564:\"\n<p>Join the WordPress London Meetup #WPLDN this month, where we&#8217;re presenting two great speakers, one from Amnesty International and the other from a well-established, fast-paced WordPress agency.</p>\n\n\n\n<p>Join us for an evening of networking, community, and learning. Register today to save your place, as numbers are limited.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://www.meetup.com/london-wordpress/events/300347344/\">Register now</a></div>\n</div>\n\n\n\n<p>&#8212;</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/270d.png\" alt=\"✍\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> &#8211;&nbsp;<strong>Built with humanity</strong><br>Find out about Amnesty&#8217;s (Web Ops at the international secretariat to be specific) journey into WordPress from when we launched our first WordPress site in 2018 to now shipping changes to the 46 + sites that use our open-source theme. Most importantly you can find out how you can get involved and help build humanity!</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f5e3.png\" alt=\"🗣\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> &#8211;&nbsp;<strong>Presented by Austin</strong><br>Austin works at Amnesty International and the Humanity Open Source WordPress theme and a number of website running the theme.</p>\n\n\n\n<p>&#8212;</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/270d.png\" alt=\"✍\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> &#8211;&nbsp;<strong>Byte-sized Impact: A greener future for your WordPress website</strong><br>Details will be released soon.</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f5e3.png\" alt=\"🗣\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> &#8211;&nbsp;<strong>Presented by Louise Towler</strong><br>Louise has been building websites for over fifteen years and enjoys helping businesses and organisations make the most of their online web presence and deliver a return on their investment. She started freelancing from her spare room and now runs Indigo Tree with multiple employees. </p>\n\n\n\n<p>&#8212;</p>\n\n\n\n<p>If you&#8217;re interested in featuring as a speaker at an upcoming event, we&#8217;d love to hear from you at&nbsp;<a href=\"https://wpldn.uk/speak\" target=\"_blank\" rel=\"noreferrer noopener\">https://wpldn.uk/speak</a>. Sessions can be delivered both physically in-person and virtually.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://en-gb.wordpress.org/2024/04/19/wordpress-london-meetup-wpldn-april-2024/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1748\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:76:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 6.5.2 Maintenance and Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://en-gb.wordpress.org/2024/04/10/wordpress-6-5-2-maintenance-and-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://en-gb.wordpress.org/2024/04/10/wordpress-6-5-2-maintenance-and-security-release/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Apr 2024 11:18:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1743\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:338:\"Note: due to an issue with the initial package, WordPress 6.5.1 was not released. 6.5.2 is the first minor release for WordPress 6.5. This security and maintenance release features 2 bug fixes on Core, 12 bug fixes for the Block Editor, and 1 security fix. Because this is a security release, it is recommended that you update [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4681:\"\n<p><strong>Note: due to an issue with the initial package, WordPress 6.5.1 was not released. 6.5.2 is the first minor release for WordPress 6.5.</strong></p>\n\n\n\n<p>This security and maintenance release features <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;id=!60398&amp;milestone=6.5.2&amp;group=status&amp;order=priority\">2 bug fixes on Core</a>, <a href=\"https://github.com/WordPress/gutenberg/pull/60577\">12 bug fixes for the Block Editor</a>, and 1 security fix.</p>\n\n\n\n<p><strong>Because this is a security release, it is recommended that you update your sites immediately.</strong>&nbsp;Backports are also available for other major WordPress releases, 6.1 and later.</p>\n\n\n\n<p>You can&nbsp;<a href=\"https://wordpress.org/wordpress-6.5.2.zip\">download WordPress 6.5.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>WordPress 6.5.2 is a short-cycle release. The next major release will be&nbsp;<a href=\"https://make.wordpress.org/core/6-6/\">version 6.6</a>&nbsp;and is currently planned for 16 July 2024.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for responsibly reporting vulnerabilities, and allowing them to be fixed in this release:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A cross-site scripting (XSS) vulnerability affecting the Avatar block type; reported by <a href=\"https://johnblackbourn.com/\">John Blackbourn</a> of the WordPress security team. Many thanks to <a href=\"https://twitter.com/stealthcopter\">Mat Rollings</a> for assisting with the research.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by&nbsp;<a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>,&nbsp;<a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a>, and&nbsp;<a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>.</p>\n\n\n\n<p>WordPress 6.5.2 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance and security fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>,&nbsp;<a href=\"https://profiles.wordpress.org/andraganescu\">Andrei Draganescu</a>,&nbsp;<a href=\"https://profiles.wordpress.org/artemiosans\">Artemio Morales</a>,&nbsp;<a href=\"https://profiles.wordpress.org/iCaleb\">Caleb Burks</a>,&nbsp;<a href=\"https://profiles.wordpress.org/colind\">colind</a>,&nbsp;<a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>,&nbsp;<a href=\"https://profiles.wordpress.org/fabiankaegy\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>,&nbsp;<a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>,&nbsp;<a href=\"https://profiles.wordpress.org/isabel_brison\">Isabel Brison</a>,&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>,&nbsp;<a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>,&nbsp;<a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>,&nbsp;<a href=\"https://profiles.wordpress.org/thelovekesh\">Lovekesh Kumar</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mmaattiiaass\">Matias Benedetto</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>,&nbsp;<a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sean212\">Sean Fisher</a>,&nbsp;<a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>,&nbsp;<a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac,&nbsp;<a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a>&nbsp;channel. Need help? Check out the&nbsp;<a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://en-gb.wordpress.org/2024/04/10/wordpress-6-5-2-maintenance-and-security-release/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 6.5 “Regina”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://en-gb.wordpress.org/2024/04/02/wordpress-6-5-regina/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://en-gb.wordpress.org/2024/04/02/wordpress-6-5-regina/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 20:15:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1740\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:394:\"Say hello to WordPress 6.5 “Regina,” inspired by the dynamic versatility of renowned jazz violinist Regina Carter. An award-winning artist and storied jazz educator known for transcending genre, Regina’s technical foundations in classical music and deep understanding of jazz have earned her the reputation of boldly going beyond what’s possible with the violin.&#160; Let the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:69532:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/Release-Edition-Inline-Image-1024x683.png\" alt=\"WordPress 6.5 &quot;Regina&quot;\" class=\"wp-image-17178\" /></figure>\n\n\n\n<p>Say hello to WordPress 6.5 “Regina,” inspired by the dynamic versatility of renowned jazz violinist <a href=\"https://en.wikipedia.org/wiki/Regina_Carter\">Regina Carter</a>. An award-winning artist and storied jazz educator known for transcending genre, Regina’s technical foundations in classical music and deep understanding of jazz have earned her the reputation of boldly going beyond what’s possible with the violin.&nbsp;</p>\n\n\n\n<p>Let the stunning twists and subtle turns of <a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO1WEiVo?si=534335c984804713\" data-type=\"link\" data-id=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO1WEiVo?si=534335c984804713\">Regina’s genre-bending sound</a> surprise you as you explore everything 6.5 offers.</p>\n\n\n\n<p>This latest version of WordPress puts more power into the details. It offers new and improved ways to fine-tune and enhance your site-building experience, letting you take control in ways that make it your own. You’ll find new ways to manage your site’s typography, more comprehensive revisions available in more places, and a collection of Site Editor updates paired with impressive performance gains to help you get things done smoother and faster.</p>\n\n\n\n<p>&#8220;Regina&#8221; also marks the introduction of some breakthrough developer tools that will start transforming how you use and extend blocks to craft engaging experiences. The Interactivity API opens up a world of creative front-end possibilities, while the Block Bindings API makes dynamic connections between blocks and data seamless. These, among other developer-focused improvements and updates, are ready to help you evolve how you build with WordPress.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpress.org/download/\">Download WordPress 6.5 &#8220;Regina&#8221;</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s inside 6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Add and manage fonts across your site</h3>\n\n\n\n<p>The new Font Library puts you in control of an essential piece of your site’s design – typography – without coding or extra steps. Effortlessly install, remove, and activate local and Google Fonts across your site for any Block theme. The ability to include custom typography collections gives site creators and publishers more options when it comes to styling content.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/Font-Manager-2-1024x656.png\" alt=\"\" class=\"wp-image-17167\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Get more from your revisions – including revisions for templates and template parts</h3>\n\n\n\n<p>Work through creative projects with a more comprehensive picture of what’s been done – and what you can fall back on. Get details like time stamps, quick summaries, and a paginated list of all revisions. View revisions from the Style Book to see how changes impact every block. Revisions are also now available for templates and template parts.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/Revisions-1-1024x656.png\" alt=\"\" class=\"wp-image-17168\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Play with enhanced background and shadow tools</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Control the size, repeat, and focal point options for background images in Group blocks so you can explore subtle or splashy ways to add visual interest to layouts.&nbsp;</li>\n\n\n\n<li>Set aspect ratios for Cover block images and easily add colour overlays that automatically source colour from your chosen image. </li>\n\n\n\n<li>Add box shadow support to more block types and create layouts with visual depth, or throw a little personality into your design.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/design-tools-1-1024x656.png\" alt=\"\" class=\"wp-image-17169\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Discover new Data Views</h3>\n\n\n\n<p>Every piece of your site comes with a library of information and data – now, you can find what you need quickly and organise it however you like. Data views for pages, templates, patterns, and template parts let you see data in a table or grid view, with the option to toggle fields and make bulk changes.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/Data-Views-1-1024x656.png\" alt=\"\" class=\"wp-image-17165\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Smoother drag-and-drop</h3>\n\n\n\n<p>Feel the difference when you move things around, with helpful visual cues like displaced items in List View or frictionless dragging to anywhere in your workspace – from beginning to end.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/drag-and-drop-1-1024x656.png\" alt=\"\" class=\"wp-image-17170\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Improved link controls</h3>\n\n\n\n<p>Create and manage links easily with a more intuitive link-building experience, like a streamlined UI and a shortcut for copying links.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/link-controls-1-1024x656.png\" alt=\"\" class=\"wp-image-17171\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s fresh for developers in 6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Bring interactions to blocks with the Interactivity API</h3>\n\n\n\n<p>The <a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">Interactivity API</a> offers developers a standardised method for building interactive front-end experiences with blocks. It simplifies the process, with fewer dependencies on external tooling, while maintaining optimal performance. Use it to create memorable user experiences, like fetching search results instantly or letting visitors interact with content in real time.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Connect blocks to custom fields or other dynamic content</h3>\n\n\n\n<p>Link core block attributes to custom fields and use the value of custom fields without creating custom blocks. Powered by the <a href=\"https://make.wordpress.org/core/2024/03/06/new-feature-the-block-bindings-api/\">Block Bindings API</a>, developers can extend this capability further to connect blocks to any dynamic content – even beyond custom fields. If there’s data stored elsewhere, easily point blocks to that new source with only a few lines of code.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Add appearance tools to Classic themes</h3>\n\n\n\n<p>Give designers and creators using Classic themes access to an upgraded design experience. Opt in to support for spacing, border, typography, and colour options, even without using theme.json. Once support is enabled, more tools will be automatically added as they become available.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Explore improvements to the plugin experience</h3>\n\n\n\n<p>There&#8217;s now an <a href=\"https://make.wordpress.org/core/2024/03/05/introducing-plugin-dependencies-in-wordpress-6-5/\">easier way to manage plugin dependencies</a>. Plugin authors can supply a new <code>Requires Plugins</code> header with a comma-separated list of required plugin slugs, presenting users with links to install and activate those plugins first.</p>\n\n\n\n<h3 class=\"wp-block-heading\">From fast to faster: Performance updates</h3>\n\n\n\n<p>This release includes 110+ performance updates, resulting in an impressive increase in speed and efficiency across the Post Editor and Site Editor. Loading is over two times faster than in 6.4, with input processing speed up to five times faster than the previous release.</p>\n\n\n\n<p>&nbsp;Translated sites see up to 25% improvement in load time for this release courtesy of <a href=\"https://make.wordpress.org/core/2024/02/27/i18n-improvements-6-5-performant-translations/\">Performant Translations</a>. Additional performance highlights include <a href=\"https://make.wordpress.org/core/2024/02/23/wordpress-6-5-adds-avif-support/\">AVIF image support</a> and improvements for <a href=\"https://make.wordpress.org/core/2024/02/29/performance-improvements-for-registering-block-variations-with-callbacks/\">registering block variations with callbacks</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">A tradition of inclusion</h3>\n\n\n\n<p>This release includes more than 65 accessibility improvements across the platform, making it more accessible than ever. It contains an important fix that unblocks access to the admin submenus for screen reader users and others who navigate by keyboard. This release also adds fixes to colour contrast in admin focus states, positioning of elements, and cursor focus, among many others, that help improve the WordPress experience for everyone.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.5</h2>\n\n\n\n<p>Check out the new <a href=\"https://wordpress.org/download/releases/6-5/\">WordPress 6.5 page</a> to learn more about the numerous enhancements and features of this release – including short demos of some of the highlighted features.</p>\n\n\n\n<p>Explore <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> for quick how-to videos, <a href=\"https://learn.wordpress.org/social-learning/\">online workshops</a>, and other free resources to level up your WordPress knowledge and skills.</p>\n\n\n\n<p>Check out the <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">WordPress 6.5 Field Guide</a> for detailed technical information and <a href=\"https://make.wordpress.org/core/tag/dev-notes-6-5/\">developer notes</a> to help you build with WordPress and get the most out of this release. Don’t forget to subscribe to the <a href=\"https://developer.wordpress.org/news/\">Developer Blog</a> for developer updates, feature tutorials, and other helpful WordPress content from a developer perspective.</p>\n\n\n\n<p>For more information about installation, file changes, fixes, and other updates, read the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-5/\">6.5 release notes</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.5 release squad</h2>\n\n\n\n<p>Every release has many moving parts with its own triumphs and challenges. It takes a dedicated team of enthusiastic contributors to help keep things on track and moving smoothly. 6.5 is made possible by a cross-functional group of contributors, always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordinators: <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Core Tech Leads: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a></li>\n\n\n\n<li>Editor Tech Leads: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a></li>\n\n\n\n<li>Core Triage Leads: <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a></li>\n\n\n\n<li>Editor Triage Leads: <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a></li>\n\n\n\n<li>Design Leads: <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a>, <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Marketing and Communication Leads: <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a>, <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a></li>\n\n\n\n<li>Documentation Leads: <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>, <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a>, <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a></li>\n\n\n\n<li>Performance Leads: <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Test Leads: <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a>, <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a></li>\n\n\n\n<li>Default Themes Leads: <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you, contributors</h2>\n\n\n\n<p>WordPress believes in democratising publishing and the <a href=\"https://opensource.org/osd-annotated\">freedoms that come with open source</a>. Supporting this idea is a global and diverse community of people collaborating to strengthen the software. </p>\n\n\n\n<p>WordPress 6.5 reflects the countless efforts and passion of around 700 contributors in at least 57 countries. This release also welcomed over 150 first-time contributors!</p>\n\n\n\n<p>Their collaboration delivered more than 2,500 enhancements and fixes, ensuring a stable release for all – a testament to the power and capability of the WordPress open source community.</p>\n\n\n<p class=\"is-style-wporg-props-long alignfull\"><a href=\"https://profiles.wordpress.org/_ck_/\">_ck_</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/abmamun007/\">Abdullah Mamun</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/abletec/\">abletec</a> · <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a> · <a href=\"https://profiles.wordpress.org/adampickering/\">Adam Pickering</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/adrianduffell/\">adrianduffell</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajithrn/\">Ajith R N</a> · <a href=\"https://profiles.wordpress.org/skyakash12/\">Akash Muchandikar</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/ahoereth/\">Alex</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexanderkoledov/\">AlexKole</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/sabreuse/\">Amy Hendrix (sabreuse)</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Nor&#233;n</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/norcross/\">Andrew Norcross</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewleap/\">andrewleap</a> · <a href=\"https://profiles.wordpress.org/andbalashov/\">Andrii Balashov</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/lighthouse79/\">Antonella</a> · <a href=\"https://profiles.wordpress.org/colomet/\">Antonio D.</a> · <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a> · <a href=\"https://profiles.wordpress.org/arena94/\">arena94</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/iamarunchaitanyajami/\">Arun Chaitanya Jami</a> · <a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/iamasadpolash/\">Asad Polash</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/audunmb/\">audunmb</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/axwax/\">axwax</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">B&#233;ryl de La Grandi&#232;re</a> · <a href=\"https://profiles.wordpress.org/bahia0019/\">bahia0019</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barryhughes-1/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/bartkleinreesink/\">bartkleinreesink</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/husobj/\">Ben Huson</a> · <a href=\"https://profiles.wordpress.org/benlk/\">Ben Keith</a> · <a href=\"https://profiles.wordpress.org/blobaugh/\">Ben Lobaugh (blobaugh)</a> · <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner - Kadence WP</a> · <a href=\"https://profiles.wordpress.org/retlehs/\">Ben Word</a> · <a href=\"https://profiles.wordpress.org/benniledl/\">Benedikt Ledl</a> · <a href=\"https://profiles.wordpress.org/benjamingosset/\">Benjamin Gosset</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/benoitfouc/\">benoitfouc</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/billseymour/\">billseymour</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/born2webdesign/\">born2webdesign</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a> · <a href=\"https://profiles.wordpress.org/williamsba1/\">Brad Williams</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/fischfood/\">Brian Fischer</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a> · <a href=\"https://profiles.wordpress.org/ecc/\">camya</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/cfinnberg/\">cfinnberg</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisdavidmiles/\">Chris David Miles</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/itschristiandale/\">Christian Dale</a> · <a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/codepo8/\">codepo8</a> · <a href=\"https://profiles.wordpress.org/cdevroe/\">Colin Devroe</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/cookiesfordevo/\">CookiesForDevo</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cvorko/\">cvorko</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/mzaweb/\">Daniel Dvorkin</a> · <a href=\"https://profiles.wordpress.org/mapumba/\">Daniel K&#228;fer</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/valerogarte/\">Daniel Valero Gonz&#225;lez</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/darssen/\">darssen (a11n)</a> · <a href=\"https://profiles.wordpress.org/davecpage/\">Dave Page</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">David Arenas</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/dglingren/\">David Lingren</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dionysous/\">Dennis Hipp</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a> · <a href=\"https://profiles.wordpress.org/derekspringer/\">Derek Springer</a> · <a href=\"https://profiles.wordpress.org/desrosjbot/\">Desrosj Bot</a> · <a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a> · <a href=\"https://profiles.wordpress.org/dlocc/\">Devin Walker</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/lots0logs/\">Dustin Falgout</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/endymion00/\">Endymion00</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/enwikuna/\">Enwikuna</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/evanltd/\">evanltd</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisalahmed29/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a> · <a href=\"https://profiles.wordpress.org/feastdesignco/\">Feast Design Co.</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/flhz/\">Florent Hernandez</a> · <a href=\"https://profiles.wordpress.org/fgiannar/\">Foteini Giannaropoulou (a11n)</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/francescocarlucci/\">FrancescoCarlucci</a> · <a href=\"https://profiles.wordpress.org/fotodrachen/\">Frank J&#228;ger</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/wazeter/\">Frank Wazeter</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garibiza/\">Garbi&#241;e</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gavande1/\">gavande1</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/gerardreches/\">Gerard Reches</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica-1/\">Giuseppe Mazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hztyfoon/\">Hanzala Taifun</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harsh175/\">Harsh Patel</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman Shamim</a> · <a href=\"https://profiles.wordpress.org/halounsbury/\">Heather Wilkins</a> · <a href=\"https://profiles.wordpress.org/muhme/\">Heiko L&#252;bbe</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hrrarya/\">Hridoy Mozumder</a> · <a href=\"https://profiles.wordpress.org/hrithikd/\">Hrithik Dalal</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/ganon/\">Hugo Chinchilla</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/idad5/\">idad5</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/shaampk1/\">Ihtisham Zahoor</a> · <a href=\"https://profiles.wordpress.org/fnpen/\">Ilya Zolotov</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a> · <a href=\"https://profiles.wordpress.org/macmanx/\">James Huff</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/whiteshadow/\">Janis Elsts</a> · <a href=\"https://profiles.wordpress.org/jsandtro/\">jansan</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a> · <a href=\"https://profiles.wordpress.org/japh/\">Japh</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarednova/\">jarednova</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/coolmann/\">Jason Crouse</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/jbobich/\">jbobich</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/amieiro/\">Jes&#250;s Amieiro</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jghazally/\">jghazally</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/jltallon/\">jltallon</a> · <a href=\"https://profiles.wordpress.org/joanrodas/\">Joan Rodas</a> · <a href=\"https://profiles.wordpress.org/morehawes/\">Joe</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnciacia/\">johnciacia</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jbrinley/\">Jonathan Brinley</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/joppuyo/\">joppuyo</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jorgevilchez/\">Jorge Vilchez</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/joefusco/\">Joseph Fusco</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/jsmoriss/\">JS Morisset</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/tadamarketing/\">Katka</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kevincoleman/\">Kevin Coleman</a> · <a href=\"https://profiles.wordpress.org/kevinwhoffman/\">Kevin Hoffman</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/koen12344/\">Koen Reus</a> · <a href=\"https://profiles.wordpress.org/koesper/\">Koesper</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/kdowns/\">Kylen Downs</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/munizleo/\">Leo Muniz</a> · <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/liammcarthur/\">LiamMcArthur</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/logikal16/\">logikal16</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">lucasbustamante</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lpawlik/\">Lukas Pawlik</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukefiretoss/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/mahnewr/\">mahnewr</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/malae/\">Malae</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manyourisms/\">manyourisms</a> · <a href=\"https://profiles.wordpress.org/marc_j/\">Marc_J</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/markoserb/\">Marko Ivanovic</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mathewemoore/\">mathewemoore</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matiasrecondo77/\">matiasrecondo77</a> · <a href=\"https://profiles.wordpress.org/webdevmattcrom/\">Matt Cromwell</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md Hasanur Rahman Shahin</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/devsahadat/\">Md Sahadat Husain</a> · <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/melcarthus/\">melcarthus</a> · <a href=\"https://profiles.wordpress.org/meta4/\">meta4</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">mevolkan</a> · <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a> · <a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski - Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/illuminea/\">Miriam Schwab</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mnydigital/\">mnydigital</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/seusmaniqbal/\">Muhammad Usman Iqbal</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/nahidkhanseo/\">Nahid Khan</a> · <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/navjotjsingh/\">Navjot Singh</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/nerdpressteam/\">NerdPress</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/sessioncookiemonster/\">Nick Martianov</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nikmeyer/\">nikmeyer</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/nko/\">nK</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/nvwd/\">Nowell VanHoesen</a> · <a href=\"https://profiles.wordpress.org/nwjames/\">nwjames</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/dargus/\">Old account</a> · <a href=\"https://profiles.wordpress.org/olegfuture/\">olegfuture</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pacicio/\">Pacicio</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/partyfrikadelle/\">partyfrikadelle</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/djpaul/\">Paul Wong-Gibbs</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbaylies/\">Peter Baylies</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philipp15b/\">Philipp15b</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pmeenan/\">pmeenan</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja Killekar (Muchandikar)</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/pouicpouic/\">pouicpouic</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">rabmalin</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rashiguptaa/\">Rashi Gupta</a> · <a href=\"https://profiles.wordpress.org/ratneshsonar/\">Ratnesh Sonar</a> · <a href=\"https://profiles.wordpress.org/rawrly/\">rawrly</a> · <a href=\"https://profiles.wordpress.org/rcain/\">rcain</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/pogidude/\">Ryann Micua</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">S&#233; Reed</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">S&#233;bastien SERRE</a> · <a href=\"https://profiles.wordpress.org/soean/\">S&#246;ren W&#252;nsch</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">Sachyya</a> · <a href=\"https://profiles.wordpress.org/sadizaman/\">Sadi Mohammad Zaman</a> · <a href=\"https://profiles.wordpress.org/sadpencil/\">sadpencil</a> · <a href=\"https://profiles.wordpress.org/introvertedbot/\">Sahil</a> · <a href=\"https://profiles.wordpress.org/tohincoderex/\">Saiduzzaman Tohin</a> · <a href=\"https://profiles.wordpress.org/sakibsnaz/\">Sakib MD Nazmush</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/xronn/\">Sam Berry</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/kim88/\">Samuel R&#252;egger</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sacerro/\">Santiago Cerro L&#243;pez</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/hellosatya/\">Satyam Vishwakarma (Satya)</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/saxonfletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayful/\">Sayful Islam</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sgr33n/\">Sergio De Falco</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shahariaazam/\">Shaharia Azam</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shanef/\">ShaneF</a> · <a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a> · <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">Sheri Grey</a> · <a href=\"https://profiles.wordpress.org/shidouhikari/\">shidouhikari</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirajummahdi/\">Sirajum Mahdi</a> · <a href=\"https://profiles.wordpress.org/sjregan/\">sjregan</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Sonia</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/sruthi89/\">sruthi89</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephencronin/\">Stephen Cronin</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenh1988/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevejonesdev/\">Steve Jones</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/svitlana41319/\">Svitlana Sukhoveiko</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> · <a href=\"https://profiles.wordpress.org/nuhel/\">Syed Nuhel</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a> · <a href=\"https://profiles.wordpress.org/buley/\">Taylor</a> · <a href=\"https://profiles.wordpress.org/taylorde/\">Taylor Dewey</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kr&#228;ftner</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/creativeslice/\">Tim Bowen</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timoth&#233;e Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">Tobias B&#228;thge</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn &#8220;Tobi&#8221; Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/hifidesign/\">Tom Finley</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a> · <a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vikram6/\">vikram6</a> · <a href=\"https://profiles.wordpress.org/viliamkopecky/\">viliamkopecky</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/wasiur195/\">Wasiur Rahman</a> · <a href=\"https://profiles.wordpress.org/welaunchio/\">welaunchio</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/nestea29950/\">WilliamG</a> · <a href=\"https://profiles.wordpress.org/maartenbelmans/\">Wombat Plugins</a> · <a href=\"https://profiles.wordpress.org/wpcorner/\">WP Corner</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">wplmillet</a> · <a href=\"https://profiles.wordpress.org/xlthlx/\">xlthlx</a> · <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/mkismy/\">Yuta Amakawa</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/tollmanz/\">Zack Tollman</a> · <a href=\"https://profiles.wordpress.org/zanematthew/\">Zane Matthew</a> · <a href=\"https://profiles.wordpress.org/zebaafiashama/\">Zeba Afia Shama</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<p>Over <a href=\"https://translate.wordpress.org/stats/\">70 locales have translated 90 percent</a> or more of WordPress 6.5 into their language. Community translators are working hard to ensure more translations are on their way. Thank you to everyone who helps make WordPress available in 200 languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the <a href=\"https://wordpress.org/support/\">support forums</a> by answering questions from WordPress users worldwide.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved and contribute</h3>\n\n\n\n<p>Participation in WordPress is not limited to coding. If contributing appeals to you, learning more and getting involved is easy. Discover the teams that come together to <a href=\"https://make.wordpress.org/\">Make WordPress</a>, and use <a href=\"https://make.wordpress.org/contribute/\">this interactive tool</a> to help you decide which is right for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">One more haiku</h2>\n\n\n\n<p>6.5 is here!<br>Play, interact, build better,<br>Stronger and faster.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://en-gb.wordpress.org/2024/04/02/wordpress-6-5-regina/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1740\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:76:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WordPress London Meetup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://en-gb.wordpress.org/2024/02/19/wordpress-london-meetup/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://en-gb.wordpress.org/2024/02/19/wordpress-london-meetup/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Feb 2024 12:19:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:6:\"London\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Meetup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1728\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"The WordPress London Meetup is back! You can find all the details at https://www.meetup.com/london-wordpress/events/298932224/.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:208:\"\n<p>The WordPress London Meetup is back! You can find all the details at <a href=\"https://www.meetup.com/london-wordpress/events/298932224/\">https://www.meetup.com/london-wordpress/events/298932224/</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://en-gb.wordpress.org/2024/02/19/wordpress-london-meetup/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1728\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:38:\"https://en-gb.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"65529235\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 20 Oct 2025 09:57:36 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 15 Apr 2025 17:50:06 GMT\";s:4:\"link\";s:64:\"<https://en-gb.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";i:1760442679;s:21:\"cache_expiration_time\";i:1760997457;s:23:\"__cache_expiration_time\";i:1760997457;}", "off");
INSERT INTO `wp_options` VALUES("1580", "_transient_timeout_feed_mod_94d0b45cbbe5640144493b43a9e8f566", "1760997457", "off");
INSERT INTO `wp_options` VALUES("1581", "_transient_feed_mod_94d0b45cbbe5640144493b43a9e8f566", "1760954257", "off");
INSERT INTO `wp_options` VALUES("1582", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1760997458", "off");
INSERT INTO `wp_options` VALUES("1583", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:112:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: Make No Little Plans\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150274\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://ma.tt/2025/10/make-no-little-plans/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:928:\"<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Make no little plans. They have no magic to stir men’s blood and probably themselves will not be realized. Make big plans; aim high in hope and work, remembering that a noble, logical diagram once recorded will never die, but long after we are gone will be a living thing, asserting itself with ever-growing insistency. Remember that our sons and grandsons are going to do things that would stagger us. Let your watchword be order and your beacon beauty. Think big.</p>\n</blockquote>\n\n\n\n<p>— <a href=\"http://en.wikipedia.org/wiki/Daniel_Burnham\">Daniel Burnham</a>, Chicago architect (1864–1912) (Hat tip: <a href=\"https://intenseminimalism.com/2010/make-no-little-plans/\">Erin</a>, and the <a href=\"https://summit.co/make-no-small-plans\">Summit folks</a>.) (It&#8217;s an old quote but update in your head to include the ladies too.)</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 19 Oct 2025 20:19:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Matt: Albumin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150261\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://ma.tt/2025/10/albumin/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1026:\"<p>Since reading the <a href=\"https://fourhourworkweek.com/\">Four Hour Workweek</a> and <a href=\"https://tim.blog/\">Tim Ferriss</a> I&#8217;ve been a bit of a bio-hacker, always trying weird and new stuff. Today was a new one! I did therapeutic plasma exchange (TPE), also known as plasmapheresis, which supposedly gives you all the <a href=\"https://en.wikipedia.org/wiki/Young_blood_transfusion\">benefits of parabiosis</a> without, you know, needing to be a vampire or <a href=\"https://www.youtube.com/watch?v=hBA0AH-LSbo\">having a blood boy</a>. So with the awesome folks at <a href=\"https://extension.health/\">Extension Health</a> I had my blood filtered and put back in, which took a few hours. My plasma <a href=\"https://x.com/bryan_johnson/status/1845950287032492378\">was not as clear as Bryan Johnson&#8217;s</a>, with 41 years of microplastics and mold and who knows what else in there. The process took a few hours, and afterward I got some chicken on rice from a Halal cart on Broadway so maybe it all evens out.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 19 Oct 2025 00:42:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"Gutenberg Times: Abilities API, Block Accessibility Check, Gutenberg Framework, AI creating Blocks and themes—Weekend Edition 345\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=42268\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:20610:\"<p>Hi there, </p>\n\n\n\n<p>A release party is coming up on <strong>Tuesday, October 21, at 15:00 UTC for WordPress 6.9 Beta 1.</strong> It&#8217;s the first time for this release squad. Good luck! </p>\n\n\n\n<p>Will you start testing WordPress 6.9 next week?  You can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">Beta Tester plugin</a> by <strong>Andy Fragen</strong> and install it on your test site. I am using <a href=\"https://developer.wordpress.com/studio/\">WordPress Studio</a> on my computer for systematic testing and prep work for the <em>Source of Truth</em> post to come out in a few weeks.</p>\n\n\n\n<p>The WordPress Test team already published a few pre-beta calls for testing, you can work through, and they are preparing a comprehensive post for all of WordPress 6.9 testing for next week. </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/test/2025/10/03/help-test-changes-to-template-management/\"><strong>Help test changes to template management</strong></a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/\"><strong>Call for Testing: Ability to Hide Blocks</strong></a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/\"><strong>Call for Testing: Accordion Block</strong></a> </li>\n</ul>\n\n\n\n<p>WordPress 6.9 is a big focus of my work now. As always, I&#8217;ll keep you updated. </p>\n\n\n\n<p>Have a fantastic weekend! </p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n\n<p>PS:  On Monday, October 20th, I will be on the 353rd episode of <a href=\"https://wpbuilds.com/news-archive/\"><strong>This week in WordPress</strong></a> show together with Michelle Frechette, Tim Nash, and the brilliant host Nathan Wrigley. <a href=\"https://wpbuilds.com/live/\">You can join us live! </a><img alt=\"📺\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f4fa.png\" style=\"height: 1em;\" /></p>\n\n\n\n<p>PPS: This week, I celebrated the <a href=\"https://icodeforapurpose.com/five-year-anniversary-of-the-gutenberg-nightly/\">five-year anniversary of Gutenberg Nightly. </a><img alt=\"🎉\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f389.png\" style=\"height: 1em;\" /> </p>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n</section>\n\n\n<div class=\"wp-block-spacer\" style=\"height: 21px;\"></div>\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owner</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</a></li></ol></nav>\n</div></div>\n</section>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>Yesterday, <strong>Matt Mullenweg</strong> talked briefly at <strong>WordCamp Canada</strong>, gave a demo, and then answered questions from the  the audience. The wizards behind the scenes already posted the recording of the session to YouTube. <a href=\"https://www.youtube.com/watch?v=RL-XccK30sY\"><strong>WordCamp Canada 2025—Ma.tt Mullenweg &#8220;Town Hall/AMA&#8221;</strong></a>. If you rather read about the talk on Mullenweg&#8217;s blog, <a href=\"https://ma.tt/2025/10/wordcamp-canada/\">WordCamp Canada Talk</a>. He also added the Q &amp; A transcript as well. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode is <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/\">Gutenberg Changelog #122 – Gutenberg 21.8 and WordPress 6.9</a> with Beth Soderberg of <a href=\"https://bethink.studio/\">Bethink Studio</a></p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><img alt=\"Gutenberg Changelog 122 with Beth Soderberg\" class=\"wp-image-42236\" height=\"193\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-11-at-12.32.48.png?resize=652%2C193&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p class=\"has-small-font-size\"><em>If you are listening via Spotify, please leave a comment. If you listen via other podcast apps, please leave a review. It&#8217;ll help with the distribution.</em></p>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owner</h2>\n\n\n\n<p>In his video <a href=\"https://www.youtube.com/watch?v=iCtjWwWi5sQ\"><strong>AI Builds WordPress Blocks</strong></a> , <strong>Jamie Marsland</strong> introduced <em><a href=\"https://telex.automattic.ai/\">Automattic Telex</a></em> and showed off about ten blocks he and other people built with it, like animated text, a countdown counter, and mermaid diagram and more. Check it out; it&#8217;s not only amazing, it borders on voodoo or magic. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Tammie Lister</strong> continues her October Challenge on the <strong>Blocktober.fun</strong> site. The latest blocks are <a href=\"https://blocktober.fun/flip-card/\">Flip Card</a>, <a href=\"https://blocktober.fun/emoji-voting/\">Emoji Voting</a>, <a href=\"https://blocktober.fun/highlighter/\">Highlighter</a>, <a href=\"https://blocktober.fun/story-generator/\">Story Generator,</a>  <a href=\"https://blocktober.fun/watermark/\">Watermark</a> and <a href=\"https://blocktober.fun/make-the-logo-bigger/\">Make the logo bigger</a>. You not only can try them all out on Telex and remix them with your own ideas. Lister also shares here elaborate prompts you can study and learn how to skill up your AI work. </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-42310\" height=\"460\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-18-at-14.04.11.png?resize=652%2C460&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Troy Chaplin</strong> released <strong><a href=\"https://wordpress.org/plugins/block-accessibility-checks/\">Block Accessibility Check v2.2</a></strong>! It introduces Heading structure validation,  alt-text pattern detection and provides an upgraded URL checks with real TLD validation + dev environment support&#8221;Along with the new release comes a <a href=\"https://blockaccessibilitychecks.com/\">new dedicated website</a> featuring improved docs, feature overviews, and developer API guide&#8221;. Chaplin wrote. The site is focused to assist content creators and developers alike. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Anne Katzeff</strong> shared how she created <a href=\"https://www.askdesign.biz/blog/2025/10/overlapping-columns-with-the-media-text-block/#google_vignette\"><strong>overlapping Columns with the Media &amp; Text Block</strong></a> and little Additional CSS. The step-by-step instructions show you how you can build some dynamic layouts with the core block features. </p>\n\n\n\n<figure class=\"wp-block-image\"><img alt=\"\" src=\"blob:https://gutenbergtimes.com/44a2bf47-9c14-481b-bbe1-29e1c6fe25d0\" /></figure>\n\n\n\n<p><strong>Katzeff</strong> also posted a video of her process on YouTube. <a href=\"https://www.youtube.com/watch?v=kNwkwlwKB4I\"><strong>Overlapping Columns With the Media &amp; Text Block</strong></a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Michael Manuel</strong>, WordPress VIP, posted a four-part series of short video: <a href=\"https://wpvip.com/blog/behind-the-build-modernize-publishing/\"><strong>Behind the Build: How Christianity Today Modernized its Publishing Experience</strong></a> and how the team of <em>WebDevStudios</em> helped transform editorial workflows, infrastructure, and content operations for one of America’s most trusted media brands.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Part 1: <strong>Editorial empowerment &amp; workflow efficiency</strong></li>\n\n\n\n<li>Part 2: <strong>Performance &amp; platform modernization</strong></li>\n\n\n\n<li>Part 3: <strong>Homepage &amp; design system overhaul</strong></li>\n\n\n\n<li>Part 4: <strong>Content migration &amp; CMS modernization</strong></li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Brad Salomons</strong>, 8r4d Consulting, Ltd, created the <a href=\"https://wordpress.org/plugins/panoramic-slider-block/\"><strong>Panoramic Slider Block</strong></a> to scratch an itch. With this block you can post your Pano photos from your phone camera as it provides horizontal sliding controls.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Brad Salomons - screenshot of the Panoramic Slider Block in the editor. \" class=\"wp-image-42308\" height=\"312\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/screenshot-1-1.png?resize=652%2C312&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>On the WordPress Developer Blog, <strong>Nick Diego </strong>published a Snippet on <a href=\"https://developer.wordpress.org/news/snippets/how-to-add-custom-blocks-to-navigation-menus/\"><strong>How to add custom blocks to navigation menus</strong></a>. It shows how to use  the <code>blocks.registerBlockType</code> filter to extend the navigation block’s <code>allowedBlocks</code> array.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Elliott Richmond</strong> demonstrated <a href=\"https://www.youtube.com/watch?v=6sgJNNm5EOU\"><strong>how to create a block theme using Claude Code</strong></a> on YouTube. He built a theme from scratch with Claude Code, providing clear structure and Markdown tips for the AI tool. You&#8217;ll discover how to set up a CLAUDE.md file for AI-assisted theme development and how Claude works with the WordPress Block Theme structure.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The earlier years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p><br /><strong><a href=\"https://x.com/muhsinlk\">Muhammad Muhsin</a> </strong>senior engineer at Fueled gave a talk on <a href=\"https://wordsesh.com/speakers/muhammad-muhsin\">Building a Web App with the Gutenberg Framework at WordSesh</a> earlier this year. <a href=\"https://wordpress.org/gutenberg-framework/\">What is Gutenberg as a Framework?</a> It&#8217;s a way to use the block editor in a JavaScript application outside of WordPress. Muhsin &#8220;built CareerVision.io using Gutenberg outside WordPress—a standalone React framework for block-based apps&#8221;. You can watch the <a href=\"https://www.youtube.com/watch?v=0JXbtZWA3zI\">presentation on YouTube</a> now.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ryan Welcher</strong> was the <a href=\"https://www.youtube.com/watch?v=T7kLXWvywww\"><strong>Pro WordPress Developer Watches AI Build a Custom Block… and is Blown Away!</strong></a> He put <a href=\"https://telex.automattic.ai/\">Automattic&#8217;s Telex</a> to the test,  to build a live audio visualizer block inspired by the classic iTunes music visualizer. The AI writes the React code, handles audio input, and even makes the block respond to live microphone sound, all in about 15 minutes. It’s an impressive look at how Telex could reshape the way developers build custom blocks for WordPress. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>JuanMa Garrido</strong>, developer advocate at Automattic,  livestreamed his ongoing discovery of the <a href=\"https://www.youtube.com/watch?v=m19VM2yIbHU\"><strong>Abilities API</strong></a>.  He explored how to register custom abilities, expose them to AI models, and understand how this fits into WordPress’ broader AI architecture alongside the MCP Adapter and PHP AI API. The recording is now available on YouTube.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<p></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p>Featured Image: Photo by MRFE MRFE on <a href=\"https://www.pexels.com/photo/vibrant-geometric-abstract-3d-blocks-design-34268918/\">Pexels.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Oct 2025 22:14:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: WordCamp Canada Talk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150251\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://ma.tt/2025/10/wordcamp-canada/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:46239:\"<p>Howdy and bonjour! First, thank you so much, merci beaucoup, for having me at your WordCamp. I love the spirit of local communities gathering and helping each other learn and grow together. I wasn&#8217;t actually planning to speak or even do a Q &amp; A; I was just going to attend this WordCamp. But since the organizers have given me a bit of your time, I will try to make the best of it. </p>\n\n\n\n<p>I love Canada. I first came here for <a href=\"https://en.wikipedia.org/wiki/Northern_Voice\">the Northern Voice conference</a> in 2006. Was anyone at that one? I think Dave Winer was actually there. It was a pretty awesome one. What&#8217;s that?</p>\n\n\n\n<p>[Here I think Dave said he wasn’t at that one, but a different conference, but can’t remember.]</p>\n\n\n\n<p>Well, that&#8217;s why we blog. My memory is not that good. [laughs] By the way, I think this week is your anniversary, right? </p>\n\n\n\n<p><strong>Dave Winer:</strong> It was actually a couple of weeks ago—31 years.</p>\n\n\n\n<p><strong>MM: </strong>Oh, wow. Thirty-one years. Round of applause! I think why I thought it was your anniversary is that on my blog’s related posts, it showed a post from 2014 that was congratulating you on your 20th because I think <em>The Register</em> or someone did a nice article. </p>\n\n\n\n<p>So yeah, I&#8217;ve since been back dozens of times, including several summers in Montreal, at the jazz festival there—they also do <a href=\"https://haitienfolie.com/\">Le Festival Haïti en Folie</a>, and <a href=\"https://montreal.hahaha.com/home/\">Just For Laughs</a>—and a few times here in Ottawa, where I&#8217;m on the board of a cybersecurity company called Field Effect. We might even have some Field Effect people here—oh, hi! Thanks for coming. </p>\n\n\n\n<p>Let me give a little update on what I’ve been up to. My life’s mission is to democratize publishing, commerce, and messaging. So I have some projects in each of those areas. In publishing, my main work is WordPress, the core software available to everyone. We host it on <a href=\"http://wordpress.com\">WordPress.com</a> and <a href=\"https://pressable.com/\">Pressable</a>, and allow others to host it with <a href=\"https://wpcloud.com/\">WP Cloud</a>—a cool product—and we use <a href=\"https://jetpack.com/\">Jetpack</a> to bring all the best cloud features to every WordPress, wherever it is running. And, of course, running the main community hubs at <a href=\"http://wordpress.org\">WordPress.org</a>, <a href=\"http://wordpress.tv\">WordPress.tv</a>, WordCamps, <a href=\"http://wordpress.net\">WordPress.net</a>, which probably some of y&#8217;all haven&#8217;t heard of, et cetera, et cetera. </p>\n\n\n\n<p>On the social side of publishing, I have <a href=\"https://tumblr.com/\">Tumblr</a>, which is a microblogging social network, but right now it&#8217;s on a different technical stack. I need to switch it over to WordPress, but it&#8217;s a big lift. It&#8217;s over 500 million blogs, actually, and as a business, it&#8217;s costing so much more to run than it generates in revenue. We&#8217;ve had to prioritize other projects to make it sustainable. It&#8217;s probably my biggest failure or missed opportunity right now, but we&#8217;re still working on it. </p>\n\n\n\n<p>I&#8217;m really excited about the personal publishing side of our products: <a href=\"https://dayoneapp.com\">Day One</a> and <a href=\"https://developer.wordpress.com/studio/\">WordPress.com Studio</a> and <a href=\"https://wordpress.org/playground/\">WordPress Playground</a>. Day One is a fully encrypted, shared, and synchronized blogging and journaling app that runs on every device and on the web. You can also have shared encrypted journals with others. It uses the same encryption as one password. It&#8217;s the first place I go to draft an idea—for example, to write this talk. Its editor is not as good as Gutenberg yet, but it&#8217;s pretty decent at allowing multimodal input—which means you can record voice notes, draw things, etc.—and capturing it all. It&#8217;s mostly replaced Evernote, Simplenote, and even private P2s for me. It has some fun features, like when you make a new entry it records, the location, what music you&#8217;re listening to on Apple Music, how many steps you&#8217;ve taken, the weather. Honestly, some features that would be nice to get into WordPress, at least as a plugin. Right now, I just copy and paste it in the WC admin or the Jetpack app if I want to publish something; that could also be made smoother in the future. </p>\n\n\n\n<p>So WordPress.com Studio is built on an open source project called Playground that we created to allow you to spin up WordPress in a WASM container in about 30 seconds, right inside your browser. Who’s tried Playground or Studio? It&#8217;s kind of wild, right? You know how hard it&#8217;s been to set up servers and databases and everything like that, and so to see a WordPress virtual machine spin up in like 30 seconds just blows my mind. There&#8217;s so much you can do with it. It&#8217;s the most sci-fi thing happening inside of WordPress right now, and we&#8217;ve just barely begun to take advantage of the massive technical and architectural shift it allows. For example, my colleague <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella</a> builds an iOS app called <a href=\"https://wordpress.org/playground/wordpress-for-native-ios-apps/\">Blocknotes</a>. It’s a lot like Simplenote, but it uses a Gutenberg editor, and it&#8217;s entirely a WordPress playground instance—the entire iOS app. </p>\n\n\n\n<p>Part of the evolution of WordPress has been going from a blogging system to a CMS to a full development platform. So what Dave talked about yesterday, and now that you can build entire mobile apps—which, by the way, can run on every platform, cross-platform, and run the same thing on the web—it&#8217;s kind of like a promise from back in the day of Java or other things, React, Native. It&#8217;s now very possible with this WordPress WASM stuff. WASM stands for <a href=\"https://webassembly.org/\">web assembly</a>. </p>\n\n\n\n<p>The main distractions and things holding back WordPress right now are the legal attacks from WP Engine and Silver Lake—I  can&#8217;t comment on that, but stay tuned for some major updates soon. </p>\n\n\n\n<p>I forgot to put this in my post—WooCommerce! On the commerce side, there&#8217;s, of course, WooCommerce, which is very, very exciting. You can think of it like an open-source Shopify, our enablers here in Ottawa. It now processes over $30 billion of GMV (gross merchant volume) per year, and you can customize it to do pretty much anything: subscriptions, digital, physical goods, everything. And of course, it&#8217;s fully open source and built on WordPress. It&#8217;s actually a WordPress plugin, so pretty exciting. WooCommerce is now on about 8% of all websites in the world—WordPress is 40, so it&#8217;s running on about a quarter of all WordPress sites. It&#8217;s been a big part of the growth of WordPress, actually, the past few years. </p>\n\n\n\n<p>In messaging, we have this product called Beeper. Anyone tried out Beeper yet? We got a Beeper super-user here, actually, in Robert. So Beeper basically takes all the different messaging apps—WhatsApp, Telegram, Instagram DMs, LinkedIn DMs, did you ever check those?—and it brings it all into one app, one interface, kind of like a Superhuman for messaging, and gives you cool features across all of them. Now this is obviously a pretty hard technical challenge, because we have to reverse engineer all the different networks for everything. But check it out, it&#8217;s a pretty fun little app. It&#8217;s, free for up to a couple accounts, and paid after that. </p>\n\n\n\n<p>There&#8217;s also an open source component of that as well. We&#8217;re going to make it easier for people to build bridges and connections to different networks, because there&#8217;s a lot that we don&#8217;t support yet that we get demand for, like <a href=\"https://kakaotalk.en.softonic.com/mac\">KakaoTalk</a> in Asia. People also want to do dating apps, which I guess have messaging platforms. So it’d be pretty fun to have everything all in one. </p>\n\n\n\n<p>I&#8217;ve been in the public a lot, doing lots of talks and actually blogging every single day now for 28 days, which will be 29 when we all hit the publish button at the end of this! So I&#8217;ve been blogging a lot. It&#8217;s a lot to keep up with. Actually been going every day since <a href=\"https://us.wordcamp.org/2025/\">WordCamp US</a>, with one missed day in there. I got very, very inspired at WordCamp US. It was a fantastic event. I got to hang out a lot and go to a bunch of sessions, and it inspired me to blog a lot more. If you run Jetpack, there&#8217;s actually a pretty cool feature where the notifications will tell you what kind of streak you&#8217;re on. So whenever I post, I get this nice little notification, like 28 days. And it has little easter eggs when you get certain number of days in a row, which is fun. So I&#8217;m gonna have to add some of this to the post later—I riffed a little bit. We&#8217;ll get the recording. So now that this is all done, we can push the publish button together. </p>\n\n\n\n<p>This is a cool device called a Daylight computer. So cool. It’s from a startup I&#8217;m invested in through <a href=\"https://audrey.co/\">Audrey Capital</a> and Automattic. Think of it like a cross between a Kindle and an iPad. It works in the daylight, hence the name—it doesn&#8217;t emit any blue light. It&#8217;s great for kids. You can order it on <a href=\"http://daylightcomputer.com\">DaylightComputer.com</a>. It runs Android, so it&#8217;s super hackable. You can have apps like Beeper, Day One, WordPress, Jetpack, WooCommerce on it. Very, very neat device. I actually have WP Admin loaded right here; you can see you can scroll like super, super fast. Soon the wifi is going to work—it&#8217;s a wifi-only device. </p>\n\n\n\n<p>Later I&#8217;ll update this post with an mp3 recording enclosed an RSS in honor of Dave Winer, who spoke here, who invented podcasting and RSS. And actually, if you go way back in my RSS feeds, I have some mp3 enclosures from 2004 and 2005, some very funny early podcasts. Also, whenever they post this video to WordPress TV or YouTube, I&#8217;ll share that too, and I&#8217;ll add some links. Thank you. Merci beaucoup! If you want to follow more. Please check out my blog at <a href=\"https://ma.tt\">ma.tt</a>. No WWW, no .com. Just ma.tt. I cross post to ma.tt on Bluesky and Mastodon and on Tumblr, Instagram and Twitter/X at @photomatt. </p>\n\n\n\n<p>And now we&#8217;re going to push the button together. Y&#8217;all ready? Murphy willing, are you ready to publish? think I need to add a category and stuff, but I&#8217;ll do that later.</p>\n\n\n\n<span id=\"more-150251\"></span>\n\n\n\n<p><strong>Q: </strong>Hi, I’m Michelle Frechette, and I drove up from Rochester, New York on Wednesday, so it&#8217;s good to be here. [Applause] I love that our open source extends beyond just publishing websites and words, and that we have, for now several years, the photo directory, which is available to people—and we are closing in on 30,000 published photos, which I think is phenomenal. </p>\n\n\n\n<p><strong>MM: </strong>And all of those are, I think, <a href=\"https://creativecommons.org/public-domain/cc0/\">CC0</a>, Creative Commons Zero-licensed. So it&#8217;s compatible with GPL, embedded in WordPress themes. You can use it on your site. It&#8217;s very cool.</p>\n\n\n\n<p><strong>Q: </strong>Yeah, you don&#8217;t have to give attribution to anybody. You can just use the photos that are there, which I think is good. What are we going to do so that more people know that it exists, besides the 10,000 people who have submitted photos, because I think it&#8217;s still, it&#8217;s it&#8217;s growing. It&#8217;s huge. There&#8217;s a million beautiful there&#8217;s almost 30,000 beautiful photos in there, but I don&#8217;t think enough people know that it exists yet. So how can we get the word out, to get more people to use it?</p>\n\n\n\n<p><strong>MM: </strong>Well, I think first we should ask questions about it at WordCamps. </p>\n\n\n\n<p><strong>Q: </strong>I&#8217;m on it. </p>\n\n\n\n<p><strong>MM: </strong>So check. We&#8217;re actually just kind of on like a Version One of that whole idea. So in my mind, for things that we should do, is 1: I think we need to better integrate finding those photos in the media library, because right now, it&#8217;s kind of like you have to click a few buttons to get to it. 2: I would like, for every single WP admin when you upload a photo, for you to be able to set the licensing to it. And if it is licensed as CC0, we can submit it to the directory. And of course, the directory has some extra rules, right? Some of these rules, I think we might be able to re-examine now. So for example, right now, in the directory, we don&#8217;t allow anything that shows someone&#8217;s face, right? And the reason for this is, even if something&#8217;s CC0-licensed, to have someone&#8217;s face, you need a model release form. There&#8217;s different laws for that in different countries and things like that make sense, right? You wouldn&#8217;t want someone to take your photo at a WordCamp, and now they think it&#8217;s CC0, and you start seeing them running ads for, you know, some sort of new medicine or Viagra or something; it could be very embarrassing. However, when AI creates a face, there&#8217;s no such restrictions there. So something that we could actually start to do, because right now I think we have some anti-AI rules in the photo directory, I think we should probably start to look at evolving that. So, for example, you can take a picture of me right now, change my face with AI to a face that has never existed, and that could be CC0-licensed and anyone in the world could use it. So I think there&#8217;s some possibilities there. </p>\n\n\n\n<p>Because right now, the laws for AI-generated stuff vary from country to country. I think right now in America, it can&#8217;t be copywritten, at least in the same way. At least if it&#8217;s fully created; when a human starts to modify it, it can be. Sometimes I&#8217;m not familiar with the laws here yet, but I&#8217;m sure I&#8217;ll look them up later. So I think that would be a pretty interesting way to open it up right now, because in theory, we should have way more than 30,000 photos. Actually, I have 30,000 photos on my site, which are mostly GPL-licensed. So how can we—yeah, I do need to submit them. Some of them are already in WordPress Core. So remember <a href=\"https://wordpress.org/themes/twentyten/\">the Twenty Ten theme</a>, which has like the little sheep. People really love those sheep. So all those photos I GPL-licensed a long time ago—in my copious free time, yes. </p>\n\n\n\n<p>So I think those are some of the ideas for it. And also think about another project we do that people aren&#8217;t as familiar with, Openverse search. Has anyone used Openverse yet? It&#8217;s pretty cool. So actually, Creative Commons, the nonprofit, used to have a search engine that indexed the entire web and would allow you to find different types of Creative Commons content, including that requires attribution or other things. The foundation actually was shutting this down, and we took it over, and we now run it on WordPress.org We renamed it to Openverse instead of Creative Commons, but they still index the entire web, including audio files, video files, images, all sorts of stuff. So it&#8217;s a very, very cool project. It is embedded in WP Admin a bit, but again, we probably should combine that with a photo search and other things. </p>\n\n\n\n<p>I also think there&#8217;s some opportunities to use AI analysis of all the photos to give a better semantic understanding and a better search that we currently offer, which right now is typically monollingual, I don&#8217;t think it translates well into the, you know, 60-plus languages that WordPress supports, and it&#8217;s manual tagging. So there might be things to do, like a more automated understanding, which, of course, gets better over time. You know, we started to incorporate some of the AI models like Gemini and other things on WordPress.org to make us way more efficient on things like plug-in submissions and some code scanning. I actually think we&#8217;re very much in chapter one of where this is going to be. It can sort of massively [grow]—because WordPress.org relies on volunteers, basically. Some people are sponsored, but most are not. And we&#8217;re over 60,000 plugins now, or 10,000 themes, and actually, the rate of plugin submission, I think, has basically doubled since last year, and the team has gotten it down where before they had a six-month queue, they&#8217;ve got it down to basically under a week. So you know, we can definitely automate more and more and more and be vastly more efficient and support way more developers and more users, way more everything, and probably improve the code quality. So that&#8217;s another thing I&#8217;m pretty excited about. </p>\n\n\n\n<p><strong>Q: </strong>I love it. <a href=\"http://wordpress.org/photos\">WordPress.org/photos</a>, if you want to look at it. </p>\n\n\n\n<p><strong>MM: </strong>Thank you, Michelle! </p>\n\n\n\n<p><strong>Q: </strong>Hey, Matt. Courtney Robertson. Kind of related to Michelle&#8217;s question: This week, I saw <a href=\"https://iconick.io/\">Nick Hamze</a> recounting how when you go to submit a theme, the image that&#8217;s in the preview for the theme, if it is AI-generated that that&#8217;s getting rejected and the nuances Dion dug into—Dion is one of our long time core commiters, core leads, etc, in the project. A hidden gem. If you haven&#8217;t encountered Dion yet, please find Dion and meet him. So Nick is learning the legal ramifications of having an AI-generated image as part of the theme directory, like what we have to do in the theme directory. Because if the image that&#8217;s in the theme is generated by AI, there&#8217;s a lot of legal stuff about, can we do it? Can we not? And we would all like to just be like, “Yeah, whatever. Move on.” But then there&#8217;s some other ramifications. Is that on your radar? I know we&#8217;ve looked at criteria of what could go into the theme repo and some of those deals.  I don&#8217;t know if. I mean, once we get into legal stuff, that&#8217;s maybe beyond you and I.</p>\n\n\n\n<p><strong>MM: </strong>Well, unfortunately, I&#8217;m getting really good at legal stuff. [Laughter] It wasn&#8217;t on my roadmap for the past year or two, but yeah. So this is very much an evolving area, and the laws from country to country do vary a lot. However, there&#8217;s also some common sense things you can apply, and I think that there is a sort of rapidly—we&#8217;re not putting the genie back in the bottle with AI stuff. One,  just the companies; like, OpenAI is just too big to fail now. The entire economy and growth is based on these systems. The infrastructure buildouts, massive data centers, everything. It&#8217;s kind of incredible. Not to mention the usage, like it&#8217;s really transforming translation, code, so much. </p>\n\n\n\n<p>Now, WordPress.org, particularly, because a lot of this is volunteers, those folks aren&#8217;t comfortable making big policy decisions like this that could have ramifications. They already put a lot on the line. I kind of shield everyone from a legal point of view and everything like that, but in theory, people could go after them, and we have had instances where some of these folks can get oppressed by someone who gets something rejected, or banned from the forums for spamming or stuff like that. So we do try to provide some shelter. </p>\n\n\n\n<p>Now, on this issue, in particular, Nick is someone I talk to almost every day. He&#8217;s doing some very, very cool stuff across WordPress and some innovative things with themes. I like that he pushes the boundaries. So for example, right now, the theme directory is fairly conservative in for example, with the intention that we want the demo to look like the theme when you install it, or we don&#8217;t want it to rely on a plugin. And part of the intention there is that for WordPress, we want you to be able to switch between themes really easily. So one of the beauties of it is that you can take your entire blog site, click a button, and you have a brand new design. Now themes, as they start to incorporate more advanced functionality—which is pretty cool—those sorts of things aren&#8217;t allowed. In fact, one of my favorite examples of something that was in the theme directory a long time ago and is not allowed on the current guidelines, that I think we&#8217;ve made an exception, is the Command Line theme. Has anyone seen this? You load it up, it&#8217;s like a blinking terminal, and you interact with it by typing in commands, like “list,” “post,” and you can type “help,” and it gives you all the things. This is so cool! By the way, I don&#8217;t think it complies with, like, any of our standards. [laughter] Like accessibility, it probably breaks some rules there, all sorts of things. </p>\n\n\n\n<p>So I think part of it is, you know, how can we move? And I think Nick even did a post about this, like rules versus guardrails. So I think part of the way we can do this is as a marketplace. Right now, there&#8217;s certain things that we don&#8217;t allow, and in fact, those rules creep up and get bigger every time, right? Because each sub-team comes in and says, “Oh, I need my rules to be requirements.” Actually, accessibility is a great, great example of that. Now, I think what&#8217;s interesting in a marketplace is we can move these things from being rules to being like tags. So for example, if you were a university, you only want to see themes that were WCAG 2.0 or higher compliant—which are by the way, some pretty strict requirements that don&#8217;t apply to many websites, for good reasons, but that was a requirement. You should be able to do that as a search. Or if you want to see themes that are orange, or all these sorts of things: I feel like those should just be tags in the marketplace, and use the rating system as well to open up what we can host, but then give better tools for people to search and choose what they want. </p>\n\n\n\n<p><strong>Q: </strong>Thanks. Just a shout out. Please let Nick know that a lot of us are reading what he&#8217;s putting forward, and I forget his exact website domain. It&#8217;s <a href=\"https://iconick.io/\">Iconick</a>.</p>\n\n\n\n<p><strong>MM: </strong>It&#8217;s spelled in an interesting way. </p>\n\n\n\n<p><strong>Q: </strong>Yeah, it has his name in it. I wonder where he got that idea. [Laughter]</p>\n\n\n\n<p><strong>MM: </strong>Yeah. So it reads as “iconick.” Nick Hamze, H-A-M-Z-E. Google him. He&#8217;s got some really cool themes. He&#8217;s done a lot of cool projects, <a href=\"https://iconick.io/wapuu-slaps/\">a bunch of Wapuus</a>. Actually, I&#8217;m talking to them about how we can upgrade all the Wapuu stuff. By the way, y&#8217;all have some awesome ones at this event. I got the little swag pack with all the stickers and everything. All the sponsors have different ones. You have like, four or five of them. I&#8217;m actually gonna put this sticker on my laptop later, probably that WCF one, so keep an eye out for that.</p>\n\n\n\n<p><strong>Q: </strong>Paul Bearne. I want to talk about <a href=\"https://wordpress.org/plugins/hello-dolly/\">Hello Dolly</a>, the plugin, which shipped with Core.</p>\n\n\n\n<p><strong>MM: </strong>Which, by the way, people tried to get rid of because of copyright issues. Yeah, there&#8217;s actually some interesting things we did to get around that and make it fair use.</p>\n\n\n\n<p><strong>Q: </strong>Should it be removed?</p>\n\n\n\n<p><strong>MM: </strong>You&#8217;re asking the wrong guy.</p>\n\n\n\n<p><strong>Q: </strong>Well, it’s there because nobody wants to ask you to come and remove it.</p>\n\n\n\n<p><strong>MM: </strong>No, they ask me like once a year. [Laughter]</p>\n\n\n\n<p><strong>Q: </strong>If it stays, perhaps we could redo the description to indicate that it&#8217;s historic—it was the first plugin, it was the proof of concept—but please don&#8217;t copy it. It&#8217;s no longer good code.</p>\n\n\n\n<p><strong>MM: </strong>I completely disagree with that. Tell me why it&#8217;s not good code. Because it doesn&#8217;t use classes or object orientation? Why is it bad code?</p>\n\n\n\n<p><strong>Q:</strong> It’s not accessible, it’s not translatable. </p>\n\n\n\n<p><strong>MM: </strong>It is translatable. It actually goes through the translation functions.</p>\n\n\n\n<p><strong>Q:</strong> There’s no translation around the strings. </p>\n\n\n\n<p><strong>MM: </strong>That&#8217;s not true. </p>\n\n\n\n<p><strong>Q: ’</strong>Tis true. [Laughter]</p>\n\n\n\n<p><strong>MM: </strong>Then it was removed because it was one of the first things we did the underscore for. Well, let&#8217;s look it up later today, but it&#8217;s not true that no one&#8217;s ever asked me. It does get asked about once a year. There&#8217;s lots of issues on the bug tracker about it. And if there&#8217;s ways to improve it, like make it translatable, I think that&#8217;s great, and I know people have actually used that before to also just change the lyrics to, like, put different songs in there, different things they want to</p>\n\n\n\n<p>say. </p>\n\n\n\n<p><strong>Q: </strong>When it becomes translatable, the [inaudible] can have more fun with the translation strings.</p>\n\n\n\n<p><strong>MM: </strong>Yeah, but they don&#8217;t have to, right? That&#8217;s the fun thing.</p>\n\n\n\n<p><strong>Q: </strong>Then I look forward to some patches. </p>\n\n\n\n<p><strong>MM: </strong>What I don&#8217;t want to do is, I don&#8217;t want to make it super-complicated. I know we did some things, like we moved it to a sub-directory. It actually just used to be a single file, so there have been some minor upgrades there. But the whole idea is to show how easy it is to use the actions and filter system inside of WordPress. </p>\n\n\n\n<p><strong>Q: </strong>There are no actions or filters in that plugin.</p>\n\n\n\n<p><strong>MM: </strong>Yeah, that&#8217;s how it looks in the WP Admin.</p>\n\n\n\n<p><strong>Q: </strong>There&#8217;s no filter on the string</p>\n\n\n\n<p><strong>MM: </strong>Well. we can add a filter on the string. And maybe it&#8217;s, it&#8217;s actually a filter and not translation, might be actually better, because, like you said, like maybe the pot system is not appropriate for that. Although, why not? Like, I&#8217;m sure you can translate those lyrics to French and other things, they would be meaningful. And also the connection to jazz musicians. It was one of the first famous jazz songs by one of my idols, Louis Armstrong, and you know, since then, we&#8217;ve named every release of WordPress in honor of a jazz musician. So that&#8217;s one of the cool things about WordPress versus other software is it has soul. You know, it&#8217;s true. Code is poetry. You know, we honor musicians and artists. You know, one of the first blocks we did in Gutenberg was actually a poetry block, a prose block. Has anyone used this one? It&#8217;s one of these things people are always like, “we should remove this.” [Laughter] </p>\n\n\n\n<p>Actually, I did it because I took a writing poetry course, and the author, a famous poet, was complaining how, when she posted to WordPress she couldn&#8217;t have the formatting correctly—you know how a lot of poetry will use interesting formatting where the white space has significance? Or spacing that has kind of unusual things? So the behavior of the editor, which takes multiple line breaks and combines into one, and other things, all that was being collapsed. And so I said, “Oh!” I think it&#8217;s called the Prose block, but it&#8217;s basically a block inside Gutenberg that preserves white space, kind of like a “pre” tag, and it&#8217;s used by some of the poets out there. So sometimes we do these really niche features for like, very high-end users. So for example, I think three or four of the living Fields Medalists use WordPress—actually, WordPress.com. </p>\n\n\n\n<p>Does anyone know about the <a href=\"https://www.mathunion.org/imu-awards/fields-medal\">Fields Medal</a>? A couple people. So it&#8217;s a math award. It&#8217;s more prestigious than a Nobel Prize. They give away a Nobel Prize every year. This happens only every four years, and some of the smartest people in the world have it, like <a href=\"https://terrytao.wordpress.com/\">Terence Tao</a>, who is, if you don&#8217;t know about him, look him up. He is probably one of the top five smartest people in the world, amazing, brilliant mathematician—he actually just got defunded, but the <a href=\"https://www.simonsfoundation.org/\">Simons Foundation</a> is now sponsoring all his work, which is very exciting. If you don&#8217;t know Jim Simons, he&#8217;s the founder of <a href=\"https://www.rentec.com/Home.action?index=true\">Renaissance Technologies</a>. Has anyone heard of Renaissance Tech? RenTec? One or two people? Oh, I&#8217;m telling you all sorts of cool stuff now. </p>\n\n\n\n<p>So Renaissance Technologies is the most successful hedge fund ever in history. They show, I think, annualized returns of over 40% over 35 years. It&#8217;s actually physicists and mathematicians that came together. Jim Simons was one of them, he went out of business or bankrupt or something, and was like, “gosh, I need to make some money. Maybe I&#8217;ll check out the stocks and trading thing.” And they started out, and they actually did really well, but then in the 80s, it all crashed. Jiim’s big, big innovation was that he invented algorithmic trading. So he basically said, we have humans making decisions. One, they&#8217;re too slow. And two, we don&#8217;t know why it&#8217;s working. And so there must be some fundamental sort of physics or rules of the trading markets and the business systems. And so RenTec started to gather the most data of anyone in the world. The next hedge fund to do this well was Bridgewater, but basically they started getting data sets, like shipping back to the 1400s, like really obscure things. They go get stuff out of books and develop all this priority training data, use it to map the economy and essentially create these models that the mathematicians would come up with. You can only be an investor in this fund if you work for the company, which is pretty interesting. And of course, everyone there is like a decamillionaire and everything. I forget how many employees—200 or 150 or something. Really, really small. So legendary. And he passed away a few years ago, but his foundation funds a ton of fundamental research and physics and math and so he&#8217;s someone I really look up to and admire. I <a href=\"https://ma.tt/2024/07/jim-simons-rip/\">blogged about him</a> earlier last year. He reminds me a lot of my dad, just the way he looks and talks. My dad passed away in 2016, so I really like watching Jim Simon’s stuff. </p>\n\n\n\n<p>Oh, I forgot to say, the point of the Fields Medalists. The reason the Fields Medalists use WordPress is we support a LaTeX plugin. LaTeX is basically like a markup language for doing advanced math formulas. We&#8217;re actually working on an update to this to be a bit more user-friendly. We added support for it in 2005 because Terence Tao started a free WordPress.com account, and he was complaining about this and embedding these images. I followed his blog, and I was like, “oh, we should make a block for this kind of shortcode.” And this shortcode is actually built into Jetpack, so anyone who runs Jetpack has access to this, and it&#8217;s now a Gutenberg block as well. So we&#8217;re adding diversity. So maybe tell the math department here. It’d be awesome to get some more mathematicians and folks on WordPress.</p>\n\n\n\n<p><strong>Q: </strong>Matt, just want to give you a heads up. We’ve got about five minutes left. </p>\n\n\n\n<p><strong>MM: </strong>All right, rapid fire. Should I do some fast ones? I just need to talk a little less.</p>\n\n\n\n<p><strong>Q: </strong>I&#8217;m Chris, I work for Pantheon. As you obviously know, Pantheon does Drupal stuff. So I know WordPress, but I have been watching, particularly, the evolution of their development work in AI, specifically integration in the Drupal admin, and also how the Drupal CMS is onboarding new users to Drupal, and the <a href=\"https://www.drupal.org/project/experience_builder\">Experience Builder</a> that they&#8217;re building. As we gather here today, probably most WordPressers might not be aware that there&#8217;s actually DrupalCon Europe happening in Vienna right now, and there&#8217;s lots of things that are happening out of that. And there&#8217;s a lot of really interesting and exciting things happening in that Drupal space. I know you&#8217;ve had conversations with Dries, because at least Dries <em>says</em> that you&#8217;ve had conversations.</p>\n\n\n\n<p><strong>MM: </strong>We talk semi-regularly. You know, there&#8217;s only there&#8217;s like a dozen people in the world who, like their whole life, is creating CMSes, Dave&#8217;s actually one of them in the room. We&#8217;re just going to do it the rest of our lives. And Dries is one of them, so I have incredible respect. We actually did a talk together with Mike Little, the co-founder of WordPress. So if you look up Dries, Mullenweg, Mike Little, you&#8217;ll you&#8217;ll find this. It&#8217;s pretty cool talk. Actually, we got to talk about the history and everything. </p>\n\n\n\n<p><strong>Q: </strong>So the question here is: To what degree are you looking at or thinking about the types of developments that are happening in Drupal but other CMSes as well, and what can we, as WordPress, learn from those other ecosystems?</p>\n\n\n\n<p><strong>MM: </strong>Oh, it&#8217;s a great question. I’ve got to look up the user ID. I think I was one of the first couple hudnred people registered on drop.org, which is the predecessor to <a href=\"http://drupal.org\">drupal.org</a>. Dries was actually at that Northern Voice conference in 2006; he has a post about it on his blog with some photos. So yeah, I keep in pretty close contact with a number of the other CMSes. Well, I won&#8217;t say close contact, but usually about once a year we&#8217;ll get together with Anthony from Squarespace, Tobi from Shopify, with Dries, whenever we&#8217;re in the same country, or I&#8217;m over in Europe or Boston. I try to look them up, and I test out things pretty regularly. </p>\n\n\n\n<p>So I haven&#8217;t seen the very, very latest stuff for Drupal. I think I checked out one of the last iterations they did. I love that with companies like Pantheon now doing both WordPress and Drupal, we&#8217;re getting a lot of overlap between the communities. So I would say, please bring this stuff over. I mean, we&#8217;re both PHP, we&#8217;re both GPL. It&#8217;s one of the reasons I&#8217;ve always really supported Drupal, even though we&#8217;re kind of mutually exclusive solutions. I&#8217;m always going to be supportive with other open source projects. So yeah, for those people who overlap, like yourself, please make some suggestions. You know, start a P2  post, or do a blog post about it. We&#8217;ll get it in the newsletter, or maybe even if there&#8217;s something specific that we could bring over code wise, we can start to get that incentive into <a href=\"https://core.trac.wordpress.org/\">Trac</a> and everything. Cool. </p>\n\n\n\n<p>I think Drupal also has a plugin to use Gutenberg, right? Yeah, which is pretty cool. It was one of the reasons we designed Gutenberg to actually be portable to other CMSes, and why we&#8217;ve been putting it under license, dual-licensing it so to be embedded even more places, not just GPL.</p>\n\n\n\n<p><strong>Q: </strong>Forgive the AI translation of my words, but it&#8217;ll help me be concise. But here&#8217;s the question. Really, really simple—no, it’s not. WordPress has always thrived because of its open, community-driven ethos, but as the ecosystem grows, we&#8217;re seeing more like large, profit-driven players who don&#8217;t necessarily share the values. How can individual contributors and agencies like ours actively help protect WordPress and uphold the values and ethics that have sustained it from bad actors and people who might try to exploit the community? And do you see room for something more formal, like a certification for individuals and agencies that define what being a good actor is, to help educate clients and even the market, to help protect in a more proactive way from those sorts of bad actors?</p>\n\n\n\n<p><strong>MM: </strong>Well, that&#8217;s a big question. I&#8217;ll try to answer quickly. So first I will say, I don&#8217;t want to say that there&#8217;s bad actors. I think there might be bad actions sometimes, and just temporarily bad actors who hopefully will be good in the future. You know, every saint has a past, every sinner has a future. I never want to define any company or any person as permanently good or bad. Let&#8217;s talk about actions. </p>\n\n\n\n<p>Second, I think with these actions, we can start to create incentive systems, and it&#8217;s part of what we&#8217;re doing with Five for the Future, which is basically saying, you contribute back—which also implies that you&#8217;re not violating the GPL, or something like that. So we&#8217;ve got the hard stuff, like, if you violate the GPL, you&#8217;re gonna get a letter. Violate the trademark. You know, that was more of a legal thing. But also the gentle stuff, like, how can we encourage good behavior by giving people higher rankings in the directory or in the showcase, for example? </p>\n\n\n\n<p>Then finally, I&#8217;ll just say, vote with your wallet. Each one of you here has the ability to strongly influence these companies. If they&#8217;re commercially motivated, great, let&#8217;s commercially motivate them to do the right thing by giving more business to the good companies and less business to the other companies. This has actually been happening a lot the past year. I think I can say this: There&#8217;s a site called <a href=\"https://wordpressenginetracker.com/\">WordPress Engine Tracker</a> which is currently tracking a number of sites that have left a certain host. It&#8217;s about to cross 100,000 that have switched to others host. And 74,000 have gone offline since September of last year. We actually used to make all this data public. The whole list was on there. They got a court order so the data could be fact-checked by press or other people. There was actually a court order that made us that down. So again, trying to muzzle free speech and transparency. But you know, we&#8217;re allowed to keep that site up, so check it out while you can. </p>\n\n\n\n<p>Do we have time for one more. Is this last one?</p>\n\n\n\n<p><strong>Q: </strong>Okay, I don&#8217;t think this qualifies as rapid fire, but it&#8217;s a softball. First of all, I came to WordPress as an open source advocate. I became a b2 user. That&#8217;s how I got to WordPress. So my all-time favorite WordPress release is 1.5, because it has what I consider a killer feature. It&#8217;s not the one you&#8217;re thinking. It’s pages.</p>\n\n\n\n<p><strong>MM: </strong>1.5 right? Yeah, I remember introducing that. Originally. I had a different CMS I was going to release called ContentPress. Or Multipattern. I wasn&#8217;t sure what to call it, and so I had this whole other CMS. And I was like, man, we should just build this into WordPress, even though it&#8217;s a blogging system. I think having this pages feature put us ahead of Movable Type and others. So yeah, glad we did. I think we introduced themes and that I released him. </p>\n\n\n\n<p><strong>Q: </strong>Yes, themes was the was kind of the obvious big feature for it, but pages is the point at which I would say that WordPress went from blogging engine to CMS. So that&#8217;s my favorite. But what I was going to ask is—</p>\n\n\n\n<p><strong>MM: </strong>So it&#8217;s all been downhill since then? </p>\n\n\n\n<p>[Laughter]</p>\n\n\n\n<p><strong>Q: </strong>No, it was such a pivotal moment that helped with WordPress&#8217;s meteoric adoption rates. And for me, personally, at that time, it allowed me to take a whole bunch of static HTML and bring it into WordPress so I could manage it so much more easily. So my question was: can you tell us a story, or give us some fun facts about that? Softball question, unless it really taxes your memory.</p>\n\n\n\n<p><strong>MM: </strong>Well, luckily I blog. I&#8217;ll say that two of my favorites ever in history are 1.2 and 1.5—which actually came out right after each other, because we skipped a few releases; it was a time when we actually got pretty delayed. So 1.2 introduced the hooks and filter system, which was pretty revolutionary, I think still, as a unique programming paradigm. But before that, to modify WordPress, you&#8217;d actually open up files and change lines. I used to publish these, we called them hacks, and they were. At one point we introduced the hacks file, which made it a little bit better. But then our plugin hook system allowed a separation between the core and the add-ons, but you could go really deep to modify things. Then 1.5 was themes, I believe. So 1.2 was plugins, 1.5 was themes. And then the other big one—I think it was 2 or 2 point something, was when we introduced WYSIWYG for the first time. Which, by the way, was so controversial; people did <em>not</em> want basic WYSIWYG in WordPress, which was funny, like 10 years later, when they&#8217;re like, “Okay, this Gutenberg thing&#8217;s even worse.” I was like, “Ah, I’ve been through <em>this</em> before.” </p>\n\n\n\n<p>So I think that those are kind of the fun stories around there. Again, some of this stuff was pretty slow to be adopted at first. I wasn&#8217;t certain that this should be rolled into WordPress or there should be separate software, but I&#8217;m glad we did. You know, Movable Type was a dominant thing at the time, and their static page functionality wasn&#8217;t very robust. And so the other thing that WordPress did around this time that I thought was pretty awesome is really clean URLs. So where, prior, you know, people would have crufty URLs, like they’d have an ID in the number, or you&#8217;d have for WordPress,—the default’s still there, actually—is like “?p=123,” so creating the mapping system where we map dates, a hierarchy, and these clean slugs to the pages in the back, in the browsing system, essentially, I think was really crucial. And I love that URLs from 20-something years ago still work or redirect to proper things today. So I think that&#8217;s really, really important. Thank you. All right. Last one,</p>\n\n\n\n<p><strong>Q: </strong>Hey, Matt. I&#8217;m Raquel, and I love kitties and surprises. Just some facts. I have a another question around the community. I want to know how do you feel, what are your raw thoughts, on independent WordPress events that are happening in our space now?</p>\n\n\n\n<p><strong>MM: </strong>And do you want to disclose anything there?</p>\n\n\n\n<p><strong>Q: </strong>I mean, I am the one responsible for <a href=\"https://pressconf.events/\">PressConf</a>, so independent WordPress event. So, yeah, how do you feel? I’m just curious as to how we can all get better together, which tends to be my motto.</p>\n\n\n\n<p><strong>MM: </strong>I&#8217;m very much like a “let a thousand flowers bloom” kind of guy. So thank you. I know it&#8217;s a huge labor of love doing something like PressConf. That’s something that’s been very active in WordCamps and other things in the past, and hopefully with WordCamp US going to Phoenix, we’ll have an opportunity to do some work together there. </p>\n\n\n\n<p>So I think that&#8217;s my fundamental, you know, raw thoughts. You know, I do think about, you know, what do we want to encourage in the world as well? So I would just encourage you as an independent organizer. You know, there&#8217;s some beauty there that you don&#8217;t have to follow the rules or guidelines necessarily. And it&#8217;s commercial events. Well, like the tickets cost more than WordCamp and stuff, right? How much is a ticket?</p>\n\n\n\n<p><strong>Q: </strong>Depending on early bird to total, $700 average.</p>\n\n\n\n<p><strong>MM: </strong>And so that’s a bit of a smaller event, right? That&#8217;s part of what people like about it. So the ticket price actually becomes like a little bit of a barrier to entry. It&#8217;s more intimate. You get some really awesome attendees and talks there, as I think about this as well, just like, you know, what do we want to see more of in the world? And, you know, trying to focus time, particularly my time, to those types of things. So that&#8217;s why I came to WordCamp Canada. You know, this is not the biggest WordCamp in the world, but man, this spirit here, and the people and the everything, and like you know, what you’ve all put together, as it’s come together over the past few months, the incredible work of the organizers,the social media team&#8217;s been doing a great job getting some awesome speakers like Jill and Dave and like, I was like, man! That&#8217;s why I was just planning to come and attend. You know, just to check it out, because I was very interested in the content and everything y&#8217;all put together. So again, I guess we&#8217;re out of time. So I just want to say thank you. Thank you. Thank you. I&#8217;m going to run to the restroom, but then I&#8217;ll be right back out in the lobby. I&#8217;m going to take pictures, shake hands, kiss babies. </p>\n\n\n\n<p>[Laughter]</p>\n\n\n\n<p>I can shake the hand of a baby too. It&#8217;s whatever. I’m open-minded. But hey, thank you. I appreciate it.</p>\n\n\n\n<p><strong>Update:</strong> The video is up, it&#8217;s pretty bad I think the audio is pulling from a DJI thing not the microphones, <a href=\"https://www.youtube.com/watch?v=RL-XccK30sY\">but here it is</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Oct 2025 14:24:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: On Money Stuff\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150241\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://ma.tt/2025/10/money-stuff/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1862:\"<p>There are a few writers who I follow religiously, and one is <a href=\"https://www.bloomberg.com/opinion/authors/ARbTQlRLRjE/matthew-s-levine\">Matt Levine of Bloomberg&#8217;s Money Stuff</a>. For business and finance it&#8217;s one of the smartest and funniest things you can read. Yesterday, I think for the first time, <a href=\"https://www.bloomberg.com/opinion/newsletters/2025-10-15/openai-has-a-business-plan\">he mentioned WordPress</a>! In the context of his quote on this <a href=\"https://x.com/FhantomBets/status/1977410624343965999\">great X thread about how the Polymarket insider predicted the Nobel peace prize winner</a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>This trader apparently <em>didn’t </em>have inside information, in the traditional bad sense of like bribing a Nobel committee staffer. Instead, web scraping:</p>\n\n\n\n<p>&#8220;The Nobel site runs on WordPress. Like many WordPress setups, it has an XML sitemap that lists every indexable page, even ones not yet public. If someone were monitoring this sitemap, they could easily notice a new page appear, something like &#8220;http://nobelprize.org/prizes/peace/2025/machado/facts/&#8221;</p>\n</blockquote>\n\n\n\n<p>If you run a WordPress site and want the best advice in the world for how to avoid this sort of thing, I <a href=\"https://wpvip.com/\">highly recommend our enterprise WordPress VIP service</a>! They help run some of the largest and most secure WordPress sites in the world, and could easily help navigate avoiding something like this from happening. WordPress is easy and cheap to run everywhere, <a href=\"https://projects.raspberrypi.org/en/projects/lamp-web-server-with-wordpress\">even on a Raspberry Pi</a>, but you get what you pay for, and any serious organization or mission-critical website should be on VIP.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Oct 2025 04:25:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Matt: The Curse of the Muse\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150237\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://ma.tt/2025/10/muse/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2443:\"<p>Some days, like this morning when I almost missed <a href=\"https://ma.tt/2025/10/in-canada/\">my flight to WordCamp Canada in Ottawa</a>, I’m so overwhelmed with the maelstrom of ideas and sparks of creation that it feels like waves crashing against a dam. There are so many ways I can imagine new software, new products, new ways for the world to be.</p>\n\n\n\n<p>This is a beautiful process, but it&#8217;s also painful! The anguish and agony arise as you attempt to distill the ideas and sparks; the creativity dims, and the beauty and perfection of the original inspiration fade, as I try to translate it into something that can become real and be legible to others. That’s why I have to drop everything when inspiration strikes, because if I try to return to it later, I find the muse has left and I can’t bottle that energy anymore. (There&#8217;s a reason <a href=\"https://meyerweb.com/\">Eric</a>, <a href=\"https://tantek.com/\">Tantek</a>, and I put &#8220;muse&#8221; <a href=\"https://gmpg.org/xfn/background\">into the XFN standard</a>!)</p>\n\n\n\n<p>To the extent I’ve been successful at all in my life, it is because I’m able to contain this tornado and break it down into plans, business models, people, and teams.  <em>I’ve never done anything useful on my own</em>; it’s always been in conversation and partnership with others. </p>\n\n\n\n<p>I&#8217;m grateful to everyone I work with across <a href=\"https://automattic.com/\">Automattic</a>, WordPress, <a href=\"https://audrey.co/\">Audrey</a>, <a href=\"https://tinkertendo.com/\">TinkerTendo</a>, <a href=\"https://keysjazzbistro.com/\">Keys</a>, <a href=\"https://www.theinstitute.com/\">The Institute</a>, <a href=\"https://illuminate.org/\">Illuminate</a>, <a href=\"https://ecoamerica.org/\">EcoAmerica</a>, <a href=\"https://fieldeffect.com/\">Field Effect</a> (in Ottawa!), as well as all my <a href=\"https://www.facebook.com/saxmatt\">friends</a> and <a href=\"https://www.linkedin.com/in/mattm/\">professional connections</a>. They are the ones that help me shape this energy into things that actually have an impact in the world and aren’t just fever dreams.</p>\n\n\n\n<p>This essay itself had <a href=\"https://quoteinvestigator.com/2012/04/28/shorter-letter/\">hundreds more words</a>, but I have to <a href=\"https://www.amazon.com/dp/0060891548?tag=photomatt08-20\">edit</a>, <a href=\"https://www.youtube.com/watch?v=aStHTTPxlis\">delete delete delete</a>, trim things down.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Oct 2025 00:01:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: #189 – Weston Ruter on Unlocking WordPress Performance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=200138\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/podcast/189-weston-ruter-on-unlocking-wordpress-performance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:60131:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case how WordPress Core continues to strive to unlock greater performance.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Weston Ruter. Weston is a longtime WordPress user and contributor. He has been a core committer for 10 years, and he co-led the WordPress 4.9 release. He worked in the WordPress agency space, and has also been sponsored to work on the Core Performance Team. He lives in Portland, which as you will hear, was quite handy for this interview.</p>\n\n\n\n<p>We start the conversation by getting into the big picture, why website speed matters more now than ever, and how WordPress performs out of the box. Weston shares details about measuring true performance. Revealing, for example, that achieving a perfect Lighthouse score isn&#8217;t the end game, and that real user experience metrics like Core Web Vitals and Largest Contentful Paint should shape how developers and site owners think about optimization.</p>\n\n\n\n<p>Throughout the episode, you&#8217;ll learn about the advances made by the WordPress Performance Team, from lazy loading and new image formats, to speculative loading that shaves precious milliseconds off page transitions. Weston explains how many performance improvements are designed to work automatically, democratizing speed, so that even casual WordPress users benefit without needing to be technical experts.</p>\n\n\n\n<p>The conversation also touches on the balance between adding features and avoiding plugin bloat. The hidden impact of browser and device differences, and how large companies, like Google, are working hand in hand with WordPress to raise the bar on speed and usability.</p>\n\n\n\n<p>Weston offers practical tips, deep technical wisdom, and a glimpse of where WordPress performance is heading next, and it&#8217;s sure to inspire you to think differently about how your sites load, how your users engage, and how you can squeeze out every last drop of speed from the platform you love.</p>\n\n\n\n<p>Whether you&#8217;re a developer, designer, site owner, or just someone curious about what keeps the web running smoothly. This episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Weston Ruter.</p>\n\n\n\n<p>I am joined on the podcast by Weston Ruter. Hello.</p>\n\n\n\n<p>[00:03:28] <strong>Weston Ruter:</strong> Thank you for having me.</p>\n\n\n\n<p>[00:03:29] <strong>Nathan Wrigley:</strong> You are very welcome. I&#8217;m quite jealous of Weston because we&#8217;re in Portland, Oregon at WordCamp US. I had to get on a plane, which was no hardship really in the grand scheme of things. Nevertheless, it was a lengthy plane journey. You, on the other hand, had to get on some public transport to get here because you live in Portland. That must be nice</p>\n\n\n\n<p>[00:03:45] <strong>Weston Ruter:</strong> I live about five miles to the east of here, and so I jumped on the bus and I got off and walked to coffee shop and over to the conference center.</p>\n\n\n\n<p>[00:03:53] <strong>Nathan Wrigley:</strong> And twice, two years in a row as well. You&#8217;re very, very lucky.</p>\n\n\n\n<p>[00:03:56] <strong>Weston Ruter:</strong> I was very happy when I found out.</p>\n\n\n\n<p>[00:03:57] <strong>Nathan Wrigley:</strong> Yeah. So Weston&#8217;s here today because of a presentation that he&#8217;s giving at WordCamp US. I will read into the record the title of the presentation that you&#8217;re giving, The Site Speed Frontier with Performance Lab and Beyond. So it&#8217;s all about performance, this episode essentially.</p>\n\n\n\n<p>This is one of those subjects where I feel you have to tell us your credentials so that we understand that what you are saying is true. Because I think there&#8217;s a lot of snake oil, certainly from my point of view, quite a lot of ignorance. I don&#8217;t really understand this topic inside and out. So would you mind, a minute or something like that? Just tell us about you and your history with, well, WordPress, but also performance and so on.</p>\n\n\n\n<p>[00:04:32] <strong>Weston Ruter:</strong> Yeah, sure. I have been a WordPress Core committer for 10 years. And I was in the agency space working at XWP, working on enterprise WordPress sites. And then I joined Google and I was a software engineer working on developer programs engineer, then develop a relations engineer working on the AMP project, which is all about making webpages faster using the AMP framework. And from there I transitioned into working on the Core Performance Team for the past couple years. And we are focused on making WordPress fast for everybody.</p>\n\n\n\n<p>[00:05:15] <strong>Nathan Wrigley:</strong> Okay, great. Thank you so much. So the topic at hand then is going to be about performance. Why are you interested in this? I know obviously there&#8217;s a career in it and what have you. Is this something that you lie awake at night thinking about? Do you obsess about this kind of stuff?</p>\n\n\n\n<p>[00:05:28] <strong>Weston Ruter:</strong> Yeah, it&#8217;s a passion of mine because who likes a slow webpage, right? So it&#8217;s fun to eke every bit of performance out of the loading of something. There&#8217;s a lot of little technical details and things to know and best practices to observe. And so it&#8217;s a fun challenge to be as fast as possible and there&#8217;s always room for improvement.</p>\n\n\n\n<p>[00:05:52] <strong>Nathan Wrigley:</strong> And it kind of feels as if the mantra over many, many years has basically been that, you know, if you can make your website faster, it will be successful. People will visit it, people are getting weary of page load time or what have you. And so maybe we&#8217;ll get into the weeds of all of that.</p>\n\n\n\n<p>How does WordPress, if I was just to go, okay, ignore the hosting that it&#8217;s on. Let&#8217;s just imagine we&#8217;ve got a good host, we&#8217;ll just use that term. If I was to download a vanilla version of WordPress and use the default theme, currently 2025, and do nothing else with it, I&#8217;ve written a few blog posts, maybe that&#8217;s it. How does it do out of the box like that?</p>\n\n\n\n<p>[00:06:25] <strong>Weston Ruter:</strong> Yeah, it turns out my talk is exactly about this, and it uses the 2025 theme as a test case to show how the performance of WordPress fares out of the box. And if you were to load up a site running 2025, the theme and nothing else, and you run it through Lighthouse, the performance testing tool from Google, you&#8217;ll most likely get a 100 score, performance score. And you would think, I&#8217;m done, there&#8217;s nothing else to do. But if you dig into it, just because you get a good score, that doesn&#8217;t mean there&#8217;s still not room for improvement. And there&#8217;s still head room even after 100.</p>\n\n\n\n<p>But yeah, WordPress Core does great out of the box, but there are still many opportunities to make it even faster. And as you had Felix on previously to talk about speculative loading, that&#8217;s one example where the performance is improved yet further. And in the performance lab plugin, which the performance team maintains, we have different performance feature plugins that implement additional optimisations that address different scenarios and use cases that WordPress doesn&#8217;t do well out of the box.</p>\n\n\n\n<p>[00:07:40] <strong>Nathan Wrigley:</strong> It&#8217;s kind of interesting, and I&#8217;ve never heard it framed that way. I&#8217;ve never heard that there was a ceiling above 100. It kind of feels as if that is the ceiling. If you score 100, all bets are off, game over, you&#8217;ve succeeded, hooray, have a party, kind of thing. But no, there&#8217;s still room to be squeezing a little bit out here and there.</p>\n\n\n\n<p>[00:07:57] <strong>Weston Ruter:</strong> Yeah, if you look at a Lighthouse audit, Lighthouse is an example of a lab metric. It simulates a page load for a user, but it&#8217;s not an actual page load for an actual user. It&#8217;s just a simulation. And if you really want to know how your site is actually performing, you need to measure those visits from actual users.</p>\n\n\n\n<p>And if you load up a popular site in Google&#8217;s page speed insights tool, you&#8217;ll see there&#8217;s two different sections on the page. At the top, you&#8217;ll see what users are experiencing, and then at the bottom you&#8217;ll see lab data. And the top is coming from actual site visitors through what&#8217;s called the Chrome User Experience Report. And that tells you how the site is performing in terms of the Core Web Vitals that Google has spearheaded.</p>\n\n\n\n<p>And one of those is called the Largest Contentful Paint or LCP, and that measures the time it takes for the largest element that is most likely going to be the main content of the page to be rendered, from the time you start navigating to the page and that element finishes rendering.</p>\n\n\n\n<p>And a good LCP value is considered from 0 to 2.5 seconds. And so you can have, within 2.5 seconds there&#8217;s a big range in the user experience. So if it&#8217;s just under 2.5 seconds, it&#8217;s considered good, but that doesn&#8217;t mean a 1.5 second page load is actually way better, and a 0.5 second page load is even better yet, and a 0.05 second page load is great, is perfect. That would be the perfection. And that is what we&#8217;re working on.</p>\n\n\n\n<p>[00:09:36] <strong>Nathan Wrigley:</strong> There&#8217;s gradations of it, okay. So within that 100 there may be room to do, aspects of the 100 can be improved. And in this case, by taking the LCP time down.</p>\n\n\n\n<p>We&#8217;re at a conference event. There&#8217;s over a thousand people. There must be designers, developers, SEO people here. There&#8217;s everybody. There&#8217;s the whole gamut of people that use WordPress, probably some people that are new to the whole platform as well. Do you think that performance is something that everybody needs to worry about or are you happy to be one of the few that obsess about it? Is it basically better to leave an expert like yourself to worry about it, or is this something that we can all have a little dabble at and be successful about?</p>\n\n\n\n<p>[00:10:14] <strong>Weston Ruter:</strong> Well, that&#8217;s what we&#8217;re concerned about with the Core Performance Team is making it so that the regular WordPress user doesn&#8217;t have to worry about this, because nobody&#8217;s got time to spend learning like, what is LCP? What is time to first bite? What are these different metrics? And nobody has time to worry about optimising for all these. So WordPress Core should do all this out of the box, and the WordPress ecosystem should implement best practices so that users don&#8217;t have to worry about it.</p>\n\n\n\n<p>[00:10:44] <strong>Nathan Wrigley:</strong> It&#8217;s kind of interesting. I remember, I&#8217;m thinking it was about six years ago, but I don&#8217;t really remember the date. But Google kind of informed everybody that in a period of time, a year&#8217;s time or what have you, these metrics, LCP and, Core Web Vitals basically were going to come in.</p>\n\n\n\n<p>And it felt like everybody in our industry was running around like a headless chicken, trying to understand something that they knew, there was this sword of Damocles moment, this date in the calendar where the SERPs were going to change. It didn&#8217;t feel like a comfortable time. In some senses, it felt like Google was kind of poisoning the water a bit because they were alienating developers who suddenly had to learn this new thing, because they realised their client websites were going to probably tumble in the SERPs.</p>\n\n\n\n<p>And so they had to upskill in this thing that probably they didn&#8217;t want to be involved with. So it was a curious time, but the dust seems to have settled. I don&#8217;t know too much about, you know, whether they were penalties that really were paid by people because they didn&#8217;t have these fabulous Core Web Vital scores. But it definitely put the cat amongst the pigeons for a while anyway.</p>\n\n\n\n<p>[00:11:38] <strong>Weston Ruter:</strong> The factors that go into ranking pages and Google search are, I never knew what they are, so the knowledge I have is that the performance of a page contributes to the ranking in some way. And basically, as I understand it, all things being equal, you have two sites with the same content and same relevance to the user, and one has better performance, then in theory that would rank higher.</p>\n\n\n\n<p>How much value you get in terms of your ranking is debatable or unknown. I don&#8217;t know. But what is important is the user experience and the benefits that you get for your users. And if they have a good experience on your site, then they&#8217;re more likely to come back. More likely to result in a conversion or a purchase, or whatever you&#8217;re looking to get out of your site. So that&#8217;s where I would focus the concerns.</p>\n\n\n\n<p>[00:12:34] <strong>Nathan Wrigley:</strong> If this were the Squarespace or Wix podcast, which of course it isn&#8217;t, it would be much more straightforward to have a conversation about why your site was quick because, you know, it&#8217;s this proprietary platform. There&#8217;s constraints about what you can do on that platform, and they run the whole thing, you know, they&#8217;ve got their arms around everything.</p>\n\n\n\n<p>WordPress, you download it from .org in most cases, and start to pile things on top of it. And very quickly we get the problems developing I guess, you know, the more things that you throw into it, the more plugins and what have you. Would your advice simply be circumspect about what you throw in, or can you, for want of a better phrase, can you concentrate on additional tech to mask over any problems that you have?</p>\n\n\n\n<p>You know, with the best one in the world, if you&#8217;ve got an LMS, it&#8217;s probably going to slow your website down because it&#8217;s doing a lot. If you&#8217;ve got WooCommerce, it&#8217;s probably going to slow yourself, the website, down from the vanilla install with using the 2025 theme that you just mentioned.</p>\n\n\n\n<p>But there&#8217;s this whole marketplace of hosting companies and performance companies who are selling you things that kind of undo the, and I&#8217;m doing air quotes, the damage that you did by putting the plugins in.</p>\n\n\n\n<p>So I don&#8217;t know if you&#8217;ve got anything to say to that. You know, the whole thing about bloating the website, slowing it down, unpicking it with different tech.</p>\n\n\n\n<p>[00:13:49] <strong>Weston Ruter:</strong> Yeah, well, the WordPress ecosystem has a problem with the kitchen sink issue and a plugin that has more features is somehow valued more highly than a plugin that does one thing and does it really well.</p>\n\n\n\n<p>And so in the Performance Lab plugin in our suite of plugins that we feature, we have the goal that a plugin should do one thing and do it really well. And if you don&#8217;t like what the plugin is doing, you deactivate it and switch to another one that is doing that one issue and doing it well.</p>\n\n\n\n<p>But if you have plugins that do so many things, then you&#8217;re really kind of, your hands are tied and it&#8217;s difficult to switch. And maybe that&#8217;s a strategy by some plugins to lock you in to their ecosystem, but it&#8217;s a difficult problem, yeah.</p>\n\n\n\n<p>[00:14:39] <strong>Nathan Wrigley:</strong> And we also have a, you know, we have plugins which are performance plugins. I mean, there&#8217;s dozens of them. I&#8217;m sure we could rattle off, whose job is to fix the problems that you may have created elsewhere in the website. If you&#8217;re in the weeds of it, like you are, you&#8217;ve probably got some vague understanding about it. You understand whether something is snake oil or not, but for the rest of us, that is a Pandora&#8217;s box, and there&#8217;s only chaos in there.</p>\n\n\n\n<p>I don&#8217;t know what will slow my website down. If I download, I&#8217;m going to use LMS again, if I download an LMS platform, I&#8217;m going to hope that the work has been done successfully. But I&#8217;m probably also going to be thinking about, okay, now do I need to talk to my host, get a different hosting environment, get it set up so it&#8217;s perfect for that? Do I need a performance plugin? Caching layers, putting things on the edge.</p>\n\n\n\n<p>And on and on it goes. It makes WordPress a difficult thing for many, many people to use. And so this idea of democratising publishing sort of goes out the window a little bit because it&#8217;s really extraordinarily hard to use.</p>\n\n\n\n<p>[00:15:34] <strong>Weston Ruter:</strong> Yeah. And I think that in addition to democratising publishing, WordPress should also be as part of that democratising performance. And again, making it so that users don&#8217;t have to worry about that.</p>\n\n\n\n<p>And what we&#8217;re doing in Core, we&#8217;re doing exactly that where as one of WordPress&#8217;s core philosophies is decisions, not options, and things should work out of the box.</p>\n\n\n\n<p>But when it comes to the ecosystem, it&#8217;s a open source environment and there&#8217;s no top down control over what a plugin does. So I think there&#8217;s opportunities with projects like the Plugin Check plugin to do more analysis on the performance, in addition to the security and the best practices for being accepted into the directory.</p>\n\n\n\n<p>But if there&#8217;s also a surfacing of performance issues or additional audits that are done on the impact of installing a plugin, that could be really valuable for site owners to get a sense of, this may cause problems if you install it.</p>\n\n\n\n<p>[00:16:37] <strong>Nathan Wrigley:</strong> How long has the Performance Team been a thing? I feel like three years or something like that, but I could be really wrong.</p>\n\n\n\n<p>[00:16:43] <strong>Weston Ruter:</strong> About four years I think.</p>\n\n\n\n<p>[00:16:45] <strong>Nathan Wrigley:</strong> Okay, yeah. And could you just run over the history of that? I was going to say organisation, but let&#8217;s go with team. Could you run us through the history of that team and what you&#8217;ve been able to do?</p>\n\n\n\n<p>Each of the little steps, some of them are quite profound. Some of them feel less profound, but very important. But over those four years, a lot of really incredible work has been done actually. Certainly from my perspective, it does seem that without that team we&#8217;d be in a very, very different place.</p>\n\n\n\n<p>[00:17:15] <strong>Weston Ruter:</strong> I hope that&#8217;s true. I think it is. Yeah, well, it started out focusing on, I think lazy loading of images was one of the first things to land through this team. And with that we also then uncovered that actually lazy loading everything, which while great for reducing the weight of a page, because you&#8217;re not downloading images that aren&#8217;t actually shown. If you lazy load images that are in the initial viewport, that actually hurts the Largest Contentful Paint metric because the browser wastes to start downloading those images until it knows that they&#8217;re in the viewport.</p>\n\n\n\n<p>So out of that came work to not lazy load images that are in the initial view port, and then also moving on to this attribute called fetch priority, which you can have the value of high, for example. So if you add fetch priority high to an image, then the browser&#8217;s going to prioritise loading that first. And so a lot of work was done to add sensible defaults in WordPress Core so that, for example, the featured image of a post gets fetch priority high, so that it gets loaded sooner over images that are not going to be the Largest Contentful Paint, most likely.</p>\n\n\n\n<p>So there&#8217;s that. And then there was also an issue with like emoji in posts where, on every page load there&#8217;s some JavaScript that runs in the head of the page, and it computes whether the browser supports the emoji, like all the emoji. And if the browser doesn&#8217;t support all the emoji, then it loads the Twitter emoji library to render them. And that JavaScript was causing a long task in lower performing browsers, or devices, that was hurting the largest contentful paint as well. So that was fixed as well.</p>\n\n\n\n<p>And then work has been done to add support for new image formats, like AVIF and WebP so that site owners can upload those image formats instead of JPEGs, which take longer to download.</p>\n\n\n\n<p>We talked about speculative loading, and you talked about that with Felix. So that landed in 6.8, which by default will start prefetching the HTML for a page when you mouse down or tap or click, pointer down on a link to give the browser a bit of a headstart. But then the API allows you to be more aggressive about starting that process, just when you hover over the link, for example, and then not just to prefetch the HTML, but to actually render the whole page.</p>\n\n\n\n<p>And so in my talk, which I gave earlier today, I showed the difference between no speculative loading, speculative loading as in WordPress Core right now, the default, and then moderate prefetch. And then lastly, moderate pre-render.</p>\n\n\n\n<p>[00:19:57] <strong>Nathan Wrigley:</strong> Is that done with the plugin? Well, I guess you could do that with code, but there&#8217;s an option to, if you download the plugin, you&#8217;ve got a UI for that as well.</p>\n\n\n\n<p>[00:20:04] <strong>Weston Ruter:</strong> Exactly. There&#8217;s a UI in the plugin that allows you to opt into moderate eagerness, or to use pre-render instead of prefetch. And in the example I showed, let&#8217;s say your time to first bite is a second. Then in the initial example, like on a slow, or on a fast 4G connection, you&#8217;re going to get like 2.27 seconds to load the page. But then with conservative prefetch, that shaves off like 50 milliseconds because the amount of time it takes to mouse down and mouse up is just a little bit of time that it can shave off that&#8217;s just a little bit to the loading of the page.</p>\n\n\n\n<p>But then when you go to moderate prefetch, then the browser can load the page fully in the background. And so then the time to first bite in that case becomes zero because the whole page is already in the browser&#8217;s cache. And that can reduce it to like one second because you totally eliminated the time to first bite.</p>\n\n\n\n<p>And then with the moderate pre rendering, then when you&#8217;re hovered over that link, the browser not only downloads the HTML, but also all the images, builds out the layout, runs the JavaScript. And so then when you click on that link, the page can load instantaneously.</p>\n\n\n\n<p>[00:21:12] <strong>Nathan Wrigley:</strong> So literally instantaneous.</p>\n\n\n\n<p>[00:21:14] <strong>Weston Ruter:</strong> 0.05 seconds.</p>\n\n\n\n<p>[00:21:16] <strong>Nathan Wrigley:</strong> Yeah. It&#8217;s instantaneous. I mean that&#8217;s pretty incredible. All of that is available inside of WordPress, but just to rewind, probably about 50 seconds, the default is not aggressive. The default in WordPress in order to satisfy the kind of 80 20 rule and what have you, the default is to make it so that there has to be some interaction. The mouse has to be invoked. There&#8217;s a click involved.</p>\n\n\n\n<p>That&#8217;s fascinating. So if you really want to get into the weeds of that, you can basically make the next page load almost instantaneously, should you wish to do that.</p>\n\n\n\n<p>One thing that I did get into with, I believe it was Adam Silverstein not that long ago when I had a podcast episode with him. And I don&#8217;t mean to go deeply into this, but there&#8217;s a curious balancing act here, I think with the environment and all of this speculative loading. Because it wouldn&#8217;t be desirable to load, I don&#8217;t know, there&#8217;s 12 navigation links and the mouse happens to go across all of them. And suddenly 12 unnecessary pages were entirely pre-rendered and what have you. So yeah. I don&#8217;t know if you&#8217;ve got any thoughts on that, whether there&#8217;s a balancing act between performance and environmental concerns.</p>\n\n\n\n<p>[00:22:23] <strong>Weston Ruter:</strong> Yeah. By default, speculative loading only operates on pages when you&#8217;re not logged in. And so when you&#8217;re not logged into WordPress, that is most of the time when you&#8217;re going to have a page cache that can serve it from the cache. And so as long as you have page caching in place, then the server isn&#8217;t going to be overly taxed by those requests.</p>\n\n\n\n<p>In the newest version of the Speculative Loading plugin, it has an opt in to speculative loading for logged in users as well. But there&#8217;s a warning that shows up if you don&#8217;t have a persistent object cache active, for example. So, yeah, it&#8217;s important to have good caching in place, good best practices for scaling.</p>\n\n\n\n<p>However, in addition to pre rendering, which the speculative loading plugin enables, there&#8217;s a much older technology for instant page loads that browsers all support, and that is the back forward cache.</p>\n\n\n\n<p>And WordPress sites, by default when you&#8217;re logged out, will benefit from this most of the time. But as soon as you login or if you&#8217;re navigating to like a shopping cart page, or an account page, or checkout page in an e-commerce site. Oftentimes the plugin will invoke this no cash headers function that tells the browser, primarily tells the page cache, hey, don&#8217;t hold onto this response because you don&#8217;t want to cache the shopping cart for one user and then serve it to another user, because then you would be seeing something embarrassing potentially.</p>\n\n\n\n<p>And so that is one of the benefits of sending that header. But it also has the effect of preventing the browser from holding onto that page as well. So if you navigate back and forward from the shopping cart, then you&#8217;ll notice that it doesn&#8217;t load very fast. It loads slow, because the browser has to re-fetch it all from the server, and has to rebuild everything from scratch.</p>\n\n\n\n<p>And so there&#8217;s a effort underway for 6.9 to stop doing that. To allow the browser to hold onto that in memory. And then to address, one of the issues that turned this off to begin with, allowing the browser to store the pages in the cache. Is if you aren&#8217;t logged in, for example, into WordPress. You&#8217;re on some sensitive page maybe putting some API key in or something, and you go to log out, with this back, forward cache, you could hit the back button to go back into the WordPress admin as another person, maybe on a shared computer and look at that page, even though the user had logged out.</p>\n\n\n\n<p>[00:24:50] <strong>Nathan Wrigley:</strong> Yeah, really not good.</p>\n\n\n\n<p>[00:24:51] <strong>Weston Ruter:</strong> Not good. So there&#8217;s a ticket for 6.9 which would solve that problem by invalidating those pages from bfcache so that that privacy concern isn&#8217;t there. And this issue is not just about, well, these back, forward navigations are very common. So the Chrome team found that one in 10 navigations on desktop are these back, forward navigations?</p>\n\n\n\n<p>[00:25:15] <strong>Nathan Wrigley:</strong> A tenth?</p>\n\n\n\n<p>[00:25:16] <strong>Weston Ruter:</strong> Yeah. And on mobile, I think it&#8217;s one in five. So 20% of the time on mobile, you&#8217;re going back and forward using a gesture instead of hitting a link.</p>\n\n\n\n<p>[00:25:25] <strong>Nathan Wrigley:</strong> That maps to my life, but I hadn&#8217;t thought about it.</p>\n\n\n\n<p>[00:25:28] <strong>Weston Ruter:</strong> But the benefit here is not just in that you get a faster page load, but also bfcache, this back, forward cache will preserve the entire state of the page. So in my talk, I showed an example where you, if you have BuddyPress installed, you start typing in an update, a status update, and then you click away to a separate tab, and then if you hit the back button to go back to that initial tab, then you&#8217;ll find without this back, forward cache that your update&#8217;s gone because that input field was constructed with JavaScript. And when you don&#8217;t have back, forward cache, then the entire document object model has to be rebuilt. All the JavaScript has to re-execute. This is also an issue for the block editor. If you navigated away from a page and you didn&#8217;t save a draft, then everything gets lost without this back, forward cache.</p>\n\n\n\n<p>So back, forward cache not only improves performance, giving you the possibility of these instant page loads, but it also preserves that important state on a page that could be lost otherwise.</p>\n\n\n\n<p>[00:26:25] <strong>Nathan Wrigley:</strong> You have a plugin if memory serves, recently in the repo.</p>\n\n\n\n<p>[00:26:30] <strong>Weston Ruter:</strong> Yes. And I got some feedback that it&#8217;s a terrible name, which I agree.</p>\n\n\n\n<p>[00:26:32] <strong>Nathan Wrigley:</strong> What&#8217;s the name? I&#8217;ve forgotten.</p>\n\n\n\n<p>[00:26:33] <strong>Weston Ruter:</strong> It&#8217;s called no cache, bfcache.</p>\n\n\n\n<p>[00:26:36] <strong>Nathan Wrigley:</strong> That was it, yeah.</p>\n\n\n\n<p>[00:26:37] <strong>Weston Ruter:</strong> But if I were to rename it, which I probably will now, it would probably be called Instant Back Forward Navigations or something. It&#8217;s not so short, but.</p>\n\n\n\n<p>[00:26:43] <strong>Nathan Wrigley:</strong> So is the intention to take, are you spearheading that basically? is the intention to roll the learnings from that plugin into Core?</p>\n\n\n\n<p>[00:26:50] <strong>Weston Ruter:</strong> Yeah.</p>\n\n\n\n<p>[00:26:50] <strong>Nathan Wrigley:</strong> And I&#8217;m just going to read this into the record so that everybody understands. You are talking about backwards and forwards by using the buttons, which I guess typically live at the top left of a browser. Those buttons, the arrows that point backwards and forwards.</p>\n\n\n\n<p>[00:27:03] <strong>Weston Ruter:</strong> That&#8217;s right, or the navigation in like the gesture on Android to go back.</p>\n\n\n\n<p>[00:27:07] <strong>Nathan Wrigley:</strong> Yeah, so swipe typically and swipe right. okay. Yeah, that&#8217;s really interesting because I do that all the time. It really hadn&#8217;t occurred to me that was something that could be cached. And if, as you say it&#8217;s 20% on mobile, or 10% on, that&#8217;s a lot of time that you&#8217;re saving.</p>\n\n\n\n<p>Because you do, it&#8217;s a journey, isn&#8217;t it? And sometimes you get to a dead end, and so you just back three times, because you know that you wanted to go back to that product that you saw a minute ago, but you kind of got lost along the way. So that&#8217;s kind of almost like a roadmap item. That&#8217;s 6.9, hopefully. Are there any other things coming in 6.9 that are interesting?</p>\n\n\n\n<p>[00:27:39] <strong>Weston Ruter:</strong> Well, one of the new features in WordPress Core is this Interactivity API.</p>\n\n\n\n<p>[00:27:44] <strong>Nathan Wrigley:</strong> Oh, so nice.</p>\n\n\n\n<p>[00:27:46] <strong>Weston Ruter:</strong> And one of the great things about the Interactivity API is one of its key design principles is server side rendering. So let&#8217;s say you have a navigation block, or you have an image block with a lightbox. All of the HTML and the CSS needed to render those blocks are output on the server. There&#8217;s no need for JavaScript to construct the user interface.</p>\n\n\n\n<p>Nevertheless, there&#8217;s JavaScript needed because there&#8217;s interactivity involved in these interactive blocks. And so with each of these interactive blocks, there&#8217;s a script module that gets added to the page, and it&#8217;s added in the head of the page. And browsers download those script modules with a high priority. And the impact of that is, well, the browser doesn&#8217;t know that these aren&#8217;t important. It could be important, it could not be important.</p>\n\n\n\n<p>But by loading them with a high priority, they compete with loading of more important critical resources like the Largest Contentful Paint image, for example. So by having these modules in the head, then they cause the LCP metric to degrade. And so there&#8217;s a ticket to add fetch priority low to these script tags, which causes the browser to bump them down in priority so that the Largest Contentful Paint image has a chance to load sooner.</p>\n\n\n\n<p>[00:29:04] <strong>Nathan Wrigley:</strong> Yeah. It seems like a game of tennis, this whole thing. For example, the Interactivity API, what a fabulous thing that is, but smuggled into that with something, it sounds unexpected that nobody foresaw that one and okay, need to address that. And here we are, 6.9, that gets addressed.</p>\n\n\n\n<p>[00:29:21] <strong>Weston Ruter:</strong> Yeah, and one of the great things about the Interactivity API as well is that it has really pushed forward the new Script Modules API in WordPress, where what are also called ESM modules or scripts. And these are a new way of writing JavaScript and they are, by default they don&#8217;t block the rendering of the page.</p>\n\n\n\n<p>Whereas if you have a classic script like jQuery in the head of your page, as you start loading the page, the browser has to stop parsing the HTML, it has to fetch the JavaScript, it has to execute the JavaScript, and then because that JavaScript may be doing something like document.write, where it like adds HTML to the page as it&#8217;s executing. Then only after that&#8217;s all finished then the parser can continue and continue laying out the page. So it&#8217;s very bad for performance to have any external, or even inline sometimes, JavaScript in the head.</p>\n\n\n\n<p>And so one way to solve that issue is to slap a defer attribute on that script tag, or an async attribute, and that causes the script to then not block rendering, and it will be executed once the page has finished loading.</p>\n\n\n\n<p>And a nice feature of script modules is that they&#8217;re deferred by default. You can&#8217;t have a blocking script. And so the thinking was, oh, they don&#8217;t block rendering, so we can just put them in the head. But it turns out that they do impact the network, because there&#8217;s other things on the network than just the scripts. And we need to make sure that the critical resources are prioritised, like the LCP image and not just load everything with high priority.</p>\n\n\n\n<p>[00:30:55] <strong>Nathan Wrigley:</strong> It&#8217;s kind of curious because the past of WordPress has been about, you know, you click on links and you generate, I don&#8217;t know a post, a page or something, but you&#8217;ve got this static piece of content, largely. You know, there may be some JavaScript or something, which is doing something fun.</p>\n\n\n\n<p>But the interactivity, API suddenly presents a page which, I don&#8217;t know, you might be stuck on that page for quite a while doing other things. I don&#8217;t know how that leans into the whole performance thing. I don&#8217;t know we could search and filter a bunch of houses or real estate or what have you, and update things. And we are on this one URL but everything&#8217;s getting changed in front of our eyes. So I don&#8217;t know how that whole LCP thing gets bundled into that. It suddenly becomes a much more difficult problem to identify and solve, I guess.</p>\n\n\n\n<p>[00:31:35] <strong>Weston Ruter:</strong> Yeah. So with LCP, it is for that initial page load. So as soon as you interact with the page, then whatever is the largest element then going to be.</p>\n\n\n\n<p>[00:31:47] <strong>Nathan Wrigley:</strong> Oh, that ceases there does it?</p>\n\n\n\n<p>[00:31:48] <strong>Weston Ruter:</strong> Yeah, it stops at that point. However, there are other problems with performance that can arise after that Largest Contentful Paint. So one of the newer Core Web Vital metrics is the Interaction to Next Paint, and that is this INP value. And that is all about how much JavaScript is executing on the page. And JavaScript functions can do a lot of work, so much work that they cause the user interface to appear to halt.</p>\n\n\n\n<p>[00:32:19] <strong>Nathan Wrigley:</strong> Hang.</p>\n\n\n\n<p>[00:32:20] <strong>Weston Ruter:</strong> Yeah, hang. And so that&#8217;s called jank. And it can cause animations to stutter, it can cause a user interface to be sluggish, and you click a button and then nothing happens and then all of a sudden it opens up. And so that&#8217;s an example of a metric that is still very relevant with the Interactivity API. And there&#8217;s been work to establish best practices to make sure that the event handlers for these interactive blocks are using the best practices. Like, it&#8217;s called scheduler.yield, and it allows you to break up a long running task to give the browser a chance to catch its breath so that it doesn&#8217;t cause those long tasks.</p>\n\n\n\n<p>And then another important metric, which continues to matter even after the page is loaded is called the Cumulative Layout Shift or CLS. And that is a very common issue with, where you have ads or something that will just expand as you&#8217;re scrolling down and you lose your place in the page and that hurts your cumulative layout, that CLS score.</p>\n\n\n\n<p>[00:33:19] <strong>Nathan Wrigley:</strong> Yeah. You end up with your finger in entirely the wrong place just as you&#8217;re about to click on things.</p>\n\n\n\n<p>[00:33:23] <strong>Weston Ruter:</strong> That&#8217;s exactly right.</p>\n\n\n\n<p>[00:33:24] <strong>Nathan Wrigley:</strong> Old TechCrunch website. I don&#8217;t know if you&#8217;ve ever came across that one. That was a WordPress one, I believe. And I don&#8217;t know how many times I click entirely the wrong article because it just shifted just at the moment that my finger was descending.</p>\n\n\n\n<p>[00:33:33] <strong>Weston Ruter:</strong> Very aggravating yeah.</p>\n\n\n\n<p>[00:33:34] <strong>Nathan Wrigley:</strong> Yeah, really annoying. We&#8217;re really in the weeds here and what&#8217;s kind of fascinating, obviously you understand it all, I&#8217;m just holding on for dear life here. But it feels as if there&#8217;s a dance between what we&#8217;re expecting the browser to be able to do, and what it actually can do. And I don&#8217;t know if that&#8217;s the case.</p>\n\n\n\n<p>You know, I don&#8217;t know if the fact that I&#8217;ve got a shiny new Mac means that my experience of the web in the future will be better than my 8-year-old Mac over there. That never used to be something that I worried about. It took time to boot that machine, but once it was up and running, that machine was probably just as good at displaying the web as the shiny new one. But now it feels as if that&#8217;s maybe not the case.</p>\n\n\n\n<p>[00:34:13] <strong>Weston Ruter:</strong> It&#8217;s funny you say that because this emoji issue that I described earlier where it was causing this long task as the page was loading, I only discovered that as a problem because I was using a Chromebook as development device.</p>\n\n\n\n<p>[00:34:25] <strong>Nathan Wrigley:</strong> Yeah, notoriously low on specs.</p>\n\n\n\n<p>[00:34:27] <strong>Weston Ruter:</strong> Relatively, that one was even a fast one. But yes, much slower than one of the newer Macs. And so it&#8217;s important to always be testing in an average device, and not always just use the latest and greatest. Because you&#8217;re going to miss performance issues that are probably impacting a lot of users.</p>\n\n\n\n<p>And one of the issues with emojis is, going back to what I described earlier with this long script in the head, now there&#8217;s just an inline script, and even with an inline script, there is still a performance impact where it will stop, because the browser has to stop parsing the page, execute the JavaScript, and then keep going.</p>\n\n\n\n<p>And so I used my new Mac to analyse the performance of that and I didn&#8217;t see a problem. But then I tried the CPU throttling in Chrome Dev Tools where you can emulate low end, low tier device. And in that case, then all of a sudden I saw this 100 millisecond long task pop up, I can&#8217;t remember how long exactly, but it negatively impacted the LCP because it had to spend that time with this underpowered device.</p>\n\n\n\n<p>So, yeah, there&#8217;s many opportunities for optimising things that, if you&#8217;re using devices that people are actually using.</p>\n\n\n\n<p>[00:35:41] <strong>Nathan Wrigley:</strong> I don&#8217;t really know what the expectation is from WordPress over the next decade, but it doesn&#8217;t feel like it&#8217;s going to be limiting itself to websites. It feels like that&#8217;s a portion of it, but Matt Mullenweg often has talked about it being almost like the operating system for the web. Whether or not that will transpire, I don&#8217;t know.</p>\n\n\n\n<p>But certainly for me, a lot of the things that I used to associate with a downloaded app that would run on MacOS or Windows or what have you, I&#8217;m now fully expecting that to be in a browser. And so I expect that the same would be true of our websites. We&#8217;re going to be doing more with them. They&#8217;re going to be requiring more grunt in the background, you know, more interactivity, more filtering, more searching, more database queries. And yeah, I guess WordPress has got to try and keep up with all that.</p>\n\n\n\n<p>[00:36:29] <strong>Weston Ruter:</strong> In improving web performance, it&#8217;s a top down and a bottom up problem. Browsers are working to get faster. They&#8217;re competing with each other, trying to be as fast as possible for all the bragging rights, right? But oftentimes it&#8217;s impossible for the browser to know, even if it&#8217;s as smart as possible, what to prioritise when loading a page.</p>\n\n\n\n<p>So that&#8217;s why when I was working at Google, we were prioritising improving the web at scale through WordPress to implement best practices in how WordPress builds pages so that Chrome doesn&#8217;t have to figure out everything because it&#8217;s impossible for Chrome to figure that out from the top down.</p>\n\n\n\n<p>So if you look at the, over time these Core Vital Metrics, they all consistently are going up and improving, even if a CMS isn&#8217;t necessarily focused on a performance. They all are inching upward. And that&#8217;s because the browser is getting better at performance as well. But when a CMS like WordPress also invests in improving performance, then you can start to see it edging out other CMSs in terms of the relative improvement in performance.</p>\n\n\n\n<p>[00:37:35] <strong>Nathan Wrigley:</strong> Yeah, okay. Let me just parse that. So whether WordPress is at the top or the browser is at the top, you&#8217;ve got this top bottom thing, and it&#8217;s kind of inching in from the top, coming down. Maybe that&#8217;s the browser, and then WordPress at the bottom inching up, if they happily meet in the middle.</p>\n\n\n\n<p>So what you&#8217;re saying is that even if no performance work was done by a Performance Team in WordPress, there would have been in recent years a performance improvement, But the fact that there&#8217;s those two things in symphony with each other means that there&#8217;s a greater performance improvement.</p>\n\n\n\n<p>Given that WordPress, I don&#8217;t know what the number is right now, but the statistic of 43% was always banded around. So it&#8217;s a huge proportion of the internet. Does WordPress have a voice toward Mozilla and Chrome? Does it get to say what the future of browsers might look like? It feels like with that market share, It ought to have a big voice, but I don&#8217;t know if it does.</p>\n\n\n\n<p>[00:38:26] <strong>Weston Ruter:</strong> Well, I remember back when responsive images became a thing, and as I recall that it was WordPress implementing these responsive images that caused browsers to say, okay, we&#8217;re going to implement these now as well. So I think Chrome, I can&#8217;t remember which browser did at first, but it was kind of a catalyst that caused everything to get going.</p>\n\n\n\n<p>And similarly, recently with the speculative loading, it being adopted by WordPress has, I think, caused other browsers to say, okay, we&#8217;re going to implement this as well.</p>\n\n\n\n<p>And yeah, I know that when I was working at Google, and still I&#8217;m in contact with people at Google who work on web standards work, there are initiatives that they&#8217;re working on that they want feedback from WordPress developers to know like, is this going to work for WordPress? And if WordPress can leverage this, and going back and forth between what works for WordPress and what works for browsers and there&#8217;s ongoing conversations, yeah.</p>\n\n\n\n<p>[00:39:25] <strong>Nathan Wrigley:</strong> Yeah, it is kind of interesting. I was talking to somebody from Google, from the Site Kit team, they obviously put up quite a lot of money to be marquee sponsors, if you like. I don&#8217;t know what the word is, you know like a top tier sponsor often at these events. I don&#8217;t know if they&#8217;re sponsoring this one, but there does seem to be some interest from Google.</p>\n\n\n\n<p>I know that Mozilla doesn&#8217;t have the deep pocket, so we&#8217;re not really expecting that. But it&#8217;s nice to hear that, even if it&#8217;s kind of back channels, and it may not be that WordPress gets asked all the time, that there is some sort of symbiosis there. That&#8217;s nice to know.</p>\n\n\n\n<p>[00:39:55] <strong>Weston Ruter:</strong> Well, I remember also seeing recently that Site Kit was voted one of the most trusted WordPress plugins.</p>\n\n\n\n<p>[00:40:01] <strong>Nathan Wrigley:</strong> Yeah, 5 Million plus installs in under five years. And I was kind of surprised by that actually. when I did that interview, I didn&#8217;t realise the numbers were so big. And then after the interview I went out and asked a bunch of random people whether they&#8217;d used it, and a hundred percent of the random selection of 10 people that I asked used it on everything.</p>\n\n\n\n<p>[00:40:20] <strong>Weston Ruter:</strong> Yeah. I use it for sure.</p>\n\n\n\n<p>[00:40:22] <strong>Nathan Wrigley:</strong> Yeah, yeah. It&#8217;s kind of amazing. So just sort of rounding it off a little bit, I&#8217;m guessing that if you were to have your performance hat on, I could be wrong about this. You would be advising people to step away from the classic way of doing things in WordPress with, you know, the classic editor, the classic themes and things. I genuinely don&#8217;t know if there&#8217;s a performance improvement in full site editing, block-based themes, and what have you. Over to you really, it&#8217;s an open ended question.</p>\n\n\n\n<p>[00:40:46] <strong>Weston Ruter:</strong> Yeah, there definitely is a performance benefit to using block themes, and that is because the way that classic themes load, they load progressively where they will print out the head, head tag in the page and then before they render any of the template, they basically locked in the scripts and styles that the page is going to need even though that doesn&#8217;t actually know what&#8217;s going to be in the page for sure. It can make some guesses, but it doesn&#8217;t know for sure.</p>\n\n\n\n<p>And so for classic themes, you&#8217;ll have these massive style sheets that are printed in the head, you&#8217;ll have a whole bunch of scripts that you may or may not use. And as we said before, those scripts may be blocking the rendering and causing all kinds of problems in performance.</p>\n\n\n\n<p>But with block themes, the way that a template is rendered is completely different, where it actually will render all of the blocks in the content first before it goes about rendering the head, the links, the style sheets and the scripts that go in the head of the HTML. And so because of that, a block theme is able to selectively load just the styles and just the scripts that are relevant to the blocks on that specific page. And so the amount of CSS and JavaScript that&#8217;s on a page can be greatly reduced, which greatly improves performance.</p>\n\n\n\n<p>And also, one of the initiatives that we&#8217;ve been working on in the Core Performance Team is related to these responsive images that we were talking about. Where a responsive image, it has all of the different intermediate image sizes that are available. When you upload an image, it&#8217;ll reference all those different image sizes in the source set attribute. And then there&#8217;s the sizes attribute that says which of those intermediate image sizes should be loaded for that image in the page. But because WordPress doesn&#8217;t know classically, in the classic themes, how big an element is going to be, it uses by default the image that is the width of the view port.</p>\n\n\n\n<p>And so on a mobile device, that&#8217;s often fine because images are often the full width of the content. But on a desktop you often have a center column with margins on either side, and maybe the image is going to be in a column or floated to the right. And so oftentimes on desktop, you&#8217;re going to download a much larger image than is relevant to that container on the page.</p>\n\n\n\n<p>And so there&#8217;s a, one of the plugins in Performance Lab is called Enhanced Responsive Images. And what it does is it leverages the block structure in block themes to be able to figure out what the width is for the container of a given image. And then it can craft that sizes attribute to be much more accurate compared to the default sizes attribute. And in my talk, I showed that the performance gains from that enhancement alone are one of the largest that you can have, much more than just using AVIF or a modern image format.</p>\n\n\n\n<p>[00:43:51] <strong>Nathan Wrigley:</strong> Really?</p>\n\n\n\n<p>[00:43:51] <strong>Weston Ruter:</strong> Yeah because, for example, in my test page, I had a jpeg and then I tried it again with an AVIF and the AVIF was 20% smaller, so maybe I could compress it even further. But the Largest Contentful Paint improvement for that was only 2%. But with the Enhanced Responsive Images plugin active, it was able to use a much smaller image size, which is much fewer bites, even as a jpeg compared to the AVIF. And that improved the LCP by I think 45%. So a magnitude and a half higher.</p>\n\n\n\n<p>[00:44:28] <strong>Nathan Wrigley:</strong> It feels like this work is never, ever going to come to an end. There&#8217;s always going to be little things to tweak and squeeze out here, there and everywhere. And there was a really good example just there.</p>\n\n\n\n<p>I think somebody listening to this podcast, if they&#8217;ve got to this point, it&#8217;s kind of really fascinating that most of this stuff would go under the radar for most people.</p>\n\n\n\n<p>I&#8217;m sure almost everything that you&#8217;ve mentioned, for the casual WordPress user, they would never know that that happened. Not many people are going to read the change log or delve into the weeds of what the Performance Team are doing. And yet there it all is, laid out in front of us over the last 40 minutes or so. Yeah, absolutely loads and loads of work. and never ending. You&#8217;ll be here this time next with new things to say.</p>\n\n\n\n<p>[00:45:06] <strong>Weston Ruter:</strong> Hopefully. I don&#8217;t want to work myself out of a job.</p>\n\n\n\n<p>[00:45:07] <strong>Nathan Wrigley:</strong> That&#8217;s absolutely true. Where do you go to find information about this? You know, who are the scholars, or the YouTubers, or the blog post authors? Who are the people that are pushing the boundaries here?</p>\n\n\n\n<p>[00:45:20] <strong>Weston Ruter:</strong> Well, I have recently been loving the WordPress newsletters that go out, like the Repository and Remkus de Vries, his WP, I forget the name.</p>\n\n\n\n<p>[00:45:32] <strong>Nathan Wrigley:</strong> It&#8217;s okay.</p>\n\n\n\n<p>[00:45:33] <strong>Weston Ruter:</strong> It&#8217;s something in, WP in the name. I think, Within WP, but don&#8217;t quote me on that.</p>\n\n\n\n<p>[00:45:36] <strong>Nathan Wrigley:</strong> Oh, it is, Yeah Remkus, Within WP, you&#8217;re right.</p>\n\n\n\n<p>[00:45:39] <strong>Weston Ruter:</strong> Yes. So I subscribe to his performance blog. So Jono Alderson, Jono or Jono?</p>\n\n\n\n<p>[00:45:46] <strong>Nathan Wrigley:</strong> I think Jono. Yeah, we&#8217;ll go with that. And apologies if it&#8217;s not.</p>\n\n\n\n<p>[00:45:49] <strong>Weston Ruter:</strong> Yes. And so all of his posts are brilliant, so yeah. And then, yeah, following just the newsletters, because I don&#8217;t have time to keep up on social media anymore, but I really am thankful for those newsletters because it really saves me a lot of time. It gets me what I need to know.</p>\n\n\n\n<p>[00:46:05] <strong>Nathan Wrigley:</strong> Yeah, I will, link to the ones, the three that you&#8217;ve just mentioned.</p>\n\n\n\n<p>Yeah, that&#8217;s amazing. Thank you. Honestly, it seems a bit trite, but I&#8217;ve been following what the Performance Team have done for the last four years now, from the capacity that I have to understand it, which is pretty low in all honesty. You know, most of what you&#8217;re saying, I can get a purchase on the overarching idea, but as soon as you were to draw back, if you were to show me what you were doing, the code and so on, I would immediately lose my purchase.</p>\n\n\n\n<p>I&#8217;d just like to express how profoundly happy I am that people like you are taking the time to do it. I don&#8217;t know how much thanks you get for stuff like this, but for my part, thank you.</p>\n\n\n\n<p>[00:46:42] <strong>Weston Ruter:</strong> Well, thank you, but no thanks are required because I enjoy doing it, so.</p>\n\n\n\n<p>[00:46:45] <strong>Nathan Wrigley:</strong> Yeah, great. Well thank you. anyway.</p>\n\n\n\n<p>[00:46:46] <strong>Weston Ruter:</strong> I&#8217;ll do it anyway.</p>\n\n\n\n<p>[00:46:47] <strong>Nathan Wrigley:</strong> Yeah, well Weston Ruter thank you so much for chatting to me today. It&#8217;s been a pleasure.</p>\n\n\n\n<p>[00:46:51] <strong>Weston Ruter:</strong> Thank you very much.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://weston.ruter.net/\">Weston Ruter</a>.</p>\n\n\n\n<p>Weston Ruter is a long-time WordPress user and contributor. He has been a core committer for 10 years and he co-led the WordPress 4.9 release. He worked in the WordPress agency space and has also been sponsored to work on the Core Performance Team. He lives in Portland, which, as you will hear, was quite handy for this interview.</p>\n\n\n\n<p>We start the conversation by getting into the big picture: why website speed matters more now than ever, and how WordPress performs out of the box. Weston shares details about measuring true performance, revealing, for example, that achieving a perfect Lighthouse score isn’t the end game, and that real user experience metrics like Core Web Vitals and Largest Contentful Paint (LCP) should shape how developers and site owners think about optimisation.</p>\n\n\n\n<p>Throughout the episode, you’ll learn about the advances made by the WordPress Performance Team, from lazy loading and new image formats, to speculative loading that shaves precious milliseconds off page transitions. Weston explains how many performance improvements are designed to work automatically, democratising speed so even casual WordPress users benefit without needing to be technical experts. The conversation also touches on the balance between adding features and avoiding plugin bloat, the hidden impact of browser and device differences, and how large companies like Google are working hand-in-hand with WordPress to raise the bar on speed and usability.</p>\n\n\n\n<p>Weston offers practical tips, deep technical wisdom, and a glimpse of where WordPress performance is heading next, and it’s sure to inspire you to think differently about how your sites load, how your users engage, and how you can squeeze out every last drop of speed from the platform you love.</p>\n\n\n\n<p>Whether you’re a developer, designer, site owner, or just someone curious about what keeps the web running smoothly, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://us.wordcamp.org/2025/session/the-site-speed-frontier-with-performance-lab-and-beyond/\">The Site Speed Frontier with Performance Lab and Beyond</a> &#8211; Weston&#8217;s presentation at WordCamp US 2025</p>\n\n\n\n<p>A post about the presentation (above) on <a href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/\">Weston&#8217;s own website</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/Accelerated_Mobile_Pages\">Accelerated Mobile Pages (AMP)</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/performance/\">WordPress Core Performance Team</a></p>\n\n\n\n<p><a href=\"https://developer.chrome.com/docs/lighthouse/\">Lighthouse</a></p>\n\n\n\n<p>Podcast &#8211; <a href=\"https://wptavern.com/forums/topic/171-felix-arntz-on-how-speculative-loading-is-speeding-up-your-wordpress-website\">Felix Arntz on How Speculative Loading Is Speeding Up Your WordPress Website</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/performance-lab/\">Performance Lab plugin</a></p>\n\n\n\n<p><a href=\"https://developer.chrome.com/docs/crux\">CrUX</a> &#8211; Chrome User Experience Report</p>\n\n\n\n<p><a href=\"https://web.dev/articles/lcp\">Largest Contentful Paint (LCP)</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/plugin-check/\">Plugin Check (PCP)</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/fetch-priority\">Optimize resource loading with the Fetch Priority API</a></p>\n\n\n\n<p>Podcast &#8211; <a href=\"https://wptavern.com/podcast/178-adam-silverstein-explores-transformative-browser-features-impacting-wordpress-sites\">Adam Silverstein Explores Transformative Browser Features Impacting WordPress Sites</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/bfcache\">Back/forward cache</a></p>\n\n\n\n<p>Weston&#8217;s <a href=\"https://wordpress.org/plugins/nocache-bfcache/\">Instant Back/Forward plugin</a> (mentioned in the podcast with an older name)</p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/block-editor/reference-guides/interactivity-api/\">Interactivity API Reference</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2024/03/04/script-modules-in-6-5/\">Script Modules API</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/inp\">Interaction to Next Paint (INP)</a></p>\n\n\n\n<p><a href=\"https://developer.chrome.com/blog/introducing-scheduler-yield-origin-trial/\">Introducing the scheduler.yield origin trial</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/cls\">Cumulative Layout Shift (CLS)</a></p>\n\n\n\n<p><a href=\"https://sitekit.withgoogle.com/\">Site Kit plugin</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/auto-sizes/\">Enhanced Responsive Images plugin</a></p>\n\n\n\n<p><a href=\"https://withinwp.com/\">Within WordPress</a></p>\n\n\n\n<p><a href=\"https://www.jonoalderson.com/\">Jono Alderson&#8217;s website</a></p>\n\n\n\n<p><a href=\"https://www.therepository.email/\">The Repository</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Oct 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Matt: D’Angelo &amp;amp; Diane\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150230\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://ma.tt/2025/10/dangelo-diane/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1141:\"<p>Just last night I was re-watching <a href=\"https://en.wikipedia.org/wiki/Annie_Hall\">Annie Hall</a> to remember and <a href=\"https://www.newyorker.com/culture/postscript/diane-keatons-shadows-and-light\">honor Diane Keaton</a>, and now <a href=\"https://www.nytimes.com/2025/10/14/arts/music/dangelo-dead.html\">the  news that D&#8217;Angelo had passed</a>. I&#8217;m writing this listening to <a href=\"https://open.spotify.com/album/2lO9yuuIDgBpSJzxTh3ai8\">Voodoo</a>, one of the great albums of all time. That CD in my beater car in Houston was on constant rotation, the richness of the tracks— it&#8217;s an album you have to listen to in its entirety, it takes you on a journey, the way the tracks blend in to each other. Not ideal for the atomized world of songs being stand-alone.</p>\n\n\n\n<p>D&#8217;Angelo was obviously a star, but one amazing thing about his bands is he brought so many people with him, so many amazing jazz musicians, including Roy Hargrove, Robert Glasper (<a href=\"https://khspva.houstonisd.org/\">HSPVA</a>!), Chris Dave (HSPVA!), Kenny Garrett, Pino Palladino, Questlove&#8230; May his memory be a blessing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Oct 2025 03:49:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Open Channels FM: Why Focus Matters When Building a Successful WordPress Plugin Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://openchannels.fm/why-focus-matters-when-building-a-successful-wordpress-plugin-business/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:160:\"Learn the importance of focus in scaling a WordPress plugin, advocating for prioritizing core products over numerous side projects to achieve long-term success.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Oct 2025 11:38:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"Open Channels FM: How Great Storytelling Builds Brand Loyalty and Differentiates Products\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=111053\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://openchannels.fm/how-great-storytelling-builds-brand-loyalty-and-differentiates-products/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:166:\"In this episode, Rae and Adam dig into why storytelling is key for brands to shine in WordPress, sharing tips on connection, differentiation, and authentic messaging.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Oct 2025 08:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Matt: Nanochat &amp;amp; MCP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150223\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/nanochat-mcp/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1156:\"<p>Probably the most interesting thing on the internet today is <a href=\"https://x.com/karpathy/status/1977755427569111362\">Andrej Karpathy&#8217;s nanochat</a>, &#8220;a minimal, from scratch, full-stack training/inference pipeline of a simple ChatGPT clone in a single, dependency-minimal codebase.&#8221; 8,000 lines of beautiful code, <a href=\"https://simonwillison.net/2025/Oct/13/nanochat/\">as Simon Willison notes</a>. If you want to understand how LLMs work, <a href=\"https://github.com/karpathy/nanochat\">study this</a>. Andrej is a code poet.</p>\n\n\n\n<p>In hacking news, Wired has <a href=\"https://www.wired.com/story/satellites-are-leaking-the-worlds-secrets-calls-texts-military-and-corporate-data/\">an amazing article on intercepting geostationary satellite signals</a>.</p>\n\n\n\n<p>On Friday, we turned on something cool: <a href=\"https://wordpress.com/blog/2025/10/07/mcp/\">every WordPress.com site now supports MCP</a>. Right now this is read-only access to your site, because the S in MCP stands for Security, but <a href=\"https://developer.wordpress.com/docs/mcp/prompt-examples/\">you can already start to do some cool stuff with it</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Oct 2025 06:07:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: Last Ball\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150219\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ma.tt/2025/10/last-ball/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:319:\"<p>If you appreciate golf at all, <a href=\"https://www.espn.com/golf/story/_/id/26902640/down-last-ball-how-tiger-avoided-disaster-won-2000-us-open-15\">the story of how Tiger Woods won the U.S. Open at Pebble Beach without knowing he was down to his last golf ball because of arcane rules is pretty interesting</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Oct 2025 06:36:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Gutenberg Times: Gutenberg Changelog #122 – Gutenberg 21.8 and WordPress 6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=42245\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:67394:\"<p>In episode 122 of the GT Changelog podcast, host Birgit Pauli-Haack is joined by Beth Soderberg, CEO of bethink Studio, to discuss the latest updates in Gutenberg 21.8 and WordPress 6.9. The conversation kicks off with reminiscing about past WordCamp experiences and transitions into a deep dive on block themes, evolving design tools, and the challenges of adopting new workflows. Beth shares practical insights from her agency work, highlighting the benefits of section and block styles, synced patterns, and strategies for cleaning up legacy code as Gutenberg advances.</p>\n\n\n\n<p>The episode covers new features like section styles, the highly anticipated accordion block, and improvements to template management, aimed at making theme and site building more flexible for users and developers. They also talk about experimental features such as PHP-only blocks, block bindings, and upcoming blocks like breadcrumbs and table of contents, which promise to streamline site navigation and content organization.</p>\n\n\n\n<p>Birgit and Beth underscore the importance of continuous testing and learning, encouraging listeners—especially those hesitant to adopt block themes—to experiment, seek support, and embrace gradual change. The episode wraps with practical advice, recent security updates, and a look at promising innovations coming to the WordPress ecosystem.</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/#transcript\">Transcript</a></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Editor: <a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo: <a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production: <a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Special Guest: Beth Soderberg</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://bethink.studio/\">Bethink Studio</a></li>\n\n\n\n<li><a href=\"https://profiles.wordpress.org/bethsoderberg/\">WordPress.org Profile + Slack </a></li>\n\n\n\n<li><strong>Talks by Beth Soderberg</strong>\n<ul class=\"wp-block-list\">\n<li><a href=\"https://wordpress.tv/2025/07/25/my-process-for-building-a-custom-wordpress-theme-in-2025/\">My Process for Building a Custom WordPress Theme in 2025</a></li>\n\n\n\n<li><a href=\"https://wordpress.tv/2020/04/16/bill-ericksonellen-bauer-beth-soderberg-case-studies-how-to-prepare-your-theme-for-gutenberg/\">Bill Erickson,Ellen Bauer, Beth Soderberg: Case Studies &#8211; How to Prepare your Theme for Gutenberg</a></li>\n\n\n\n<li><a href=\"https://wordpress.tv/?s=beth%20soderberg&amp;sort=newest\">And more</a></li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Calls for Testing WordPress 6.9 </h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/test/2025/10/03/help-test-changes-to-template-management/\">Template management</a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/\">Ability to Hide Blocks</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/\">Accordion Block</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Community Contributions</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/#blocks-galore-with-telex\">Block Galore</a> by designers and developers using Automattic’s Telex </li>\n\n\n\n<li><a href=\"https://gutenbergtimes.com/block-commenting-fun-with-telex-from-classic-to-block-theme-weekend-edition-341/#building-blocks-with-telex\">Moar Blocks</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s Released</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://wordpress.org/news/2025/09/wordpress-6-8-3-release/\">WordPress 6.8.3</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/\">What’s new in Gutenberg 21.8? (8 October)</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">New Blocks still in the works</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><img alt=\"🟣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://github.com/WordPress/gutenberg/pull/71588\">Time to Read</a> (m) </li>\n\n\n\n<li><img alt=\"🟣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://href.li/?https://github.com/WordPress/gutenberg/pull/64119\">Accordion Block</a> (m) </li>\n\n\n\n<li><img alt=\"🟣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://github.com/WordPress/gutenberg/pull/71793\">Breadcrumbs Block</a> (m)</li>\n\n\n\n<li><img alt=\"🟣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://github.com/WordPress/gutenberg/pull/70720\">Terms Query block</a> (m) </li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/71618\">Dialog Block </a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/71227\">Icon Block</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/71904\">Stretchy Text</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/69789\">Tabs Block</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/42229\">Table of Contents block</a></li>\n</ul>\n\n\n\n<p><img alt=\"🟣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> = already merged into trunk, as experiments. </p>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<ul class=\"wp-block-list\">\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on X (formerly known as Twitter) or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Hello and welcome to our 122nd episode of the Gutenberg Changelog. In today&#8217;s episode, we will talk about Gutenberg 21.8 and WordPress 6.9, what we already know about it. And I&#8217;m your host, Birgit Pauli-Haack, curator at Gutenberg Times, co contributor on the Word Open Source project, and I work as a developer advocate for Automattic. I&#8217;m thrilled that I finally have Beth Soderberg join me on the show. Beth is the CEO of Bethink Studio, a special web design and development agency in Alexandria, Virginia, in the U.S. Beth, welcome to the show. How are you doing?</p>\n\n\n\n<p><em>Beth Soderberg:</em> Thank you. Welcome. Welcome to my morning. I&#8217;m doing great. Good to see you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So I tried to recollect how we actually met or we met over the last few years, and I think it was the first time we met at the WordCamp New York in 2019.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I think that&#8217;s right. Ish. I definitely have eaten tacos late at night at WordCamp New York. Okay, so that tracks.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> And I definitely met you sometime before the pandemic, so I&#8217;m not sure exactly, but that sounds about right. And then I know we had lunch at WordCamp us when it was in San Diego.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Oh, okay. Nice. Oh, right. We had this.</p>\n\n\n\n<p><em>Beth Soderberg: </em>There was.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>There was a group of women kind of coming together.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, yeah, I saw a table of women. And if I see a table of women at a conference like that, I&#8217;m going to sit down at it. And you did exactly the same thing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Nice. So.</p>\n\n\n\n<p><em>Beth Soderberg: </em>But that&#8217;s the first time I saw you after the pandemic, for sure.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah. And in between, I think we did together the WP Blog Talk virtual conference that was organized by Automattic, but there were a lot of community members in there talking about the Gutenberg and the stage of it and all that.</p>\n\n\n\n<p><em>Beth Soderberg: </em>That was when I realized that I don&#8217;t like presenting at virtual conferences in front of audiences that you can&#8217;t see.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, it&#8217;s interesting.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I&#8217;m good with Zoom, because you can get some feedback. But the speaking into the void was. I don&#8217;t know. It could have also been that I wasn&#8217;t speaking to anyone in real life at the time, so it felt extra weird.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah, no. I get it. The pre-recording and then just be there for the live part of it. But we had a great live discussion there.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, I. It was fun. And we actually did the presentation live. I think that could be why later things were recorded, because it was a really weird experience. It was very strange because you knew you were live. You had no idea if even your audio was working, but you just kind of had to keep talking. And, yeah, it&#8217;s the least feedback I&#8217;ve ever had from anything I&#8217;ve ever spoken at. And I think that not even being sure that the technology was working part. Like, even that level of feedback wasn&#8217;t there. It was fun. And hopefully next time I do something like that, it will be recorded in advance.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. But it was a. It was a good place talk because it was kind of together with Ellen Bauer, and you had 15 minutes, Ellen had 15 minutes. And I think Bill Erickson was there as well.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>There were three of us.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And every one of you kind of took a different take on the block themes. Yeah. And that was really interesting to kind of. Well, we started out in 2020 with that. Yeah. Now it&#8217;s five years later, and we finally connected again at WordCamp. Us, because I made it there again.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I know. I was excited to see you. And I think. Yeah, I mean, doing that talk was interesting. I think there&#8217;s still some divergence around how people are building and how people are utilizing the tools. That set of like 15-minute talks was a really good microcosm of that because each one of us had been actively building with all of the new tools and had a slightly bigger, different approach. I still think there&#8217;s some divergence there, but we&#8217;re starting to see some patterns of, like, actual best practices with the new tools, which I think is really exciting. And also it&#8217;s fun to sort of invent on the fly. Like, okay, how should this work as the people who really are using it with clients right away, what is the standard we want to set? What does and doesn&#8217;t work? And I think that was still in a time period where we were learning so much about what you could do, what the restrictions were. I know in a lot of what we&#8217;re going through today, there&#8217;s like little tiny changes that end up being so impactful. Right. Like, my favorite thing I hated from that time period was it could have been a little earlier, I don&#8217;t remember. But originally you couldn&#8217;t set text colors on lists.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Oh, yeah, yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Stuff like that. Where it&#8217;s so small, but when it&#8217;s missing, it&#8217;s a big problem.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So, yeah, I think that a lot of work has been put into having consistent design tools for each block that you can control through the theme JSON file and then make it really a unique experience or unique design for your clients. Yeah, that&#8217;s definitely something there where you don&#8217;t, oh, I can&#8217;t do the fonts. Yeah, well, I guess I need to do a variation of it. So there was a lot of coding done to kind of get around those restrictions. How do you feel about kind of ripping out all this additional around coding now that certain things are in core and that are available? Does that kind of trip you up a bit?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I feel great about it and there&#8217;s not that much I need to rip out. Some of that is because of how I&#8217;ve built things over time. Some of that is because things like the tab block, which I am so excited about, I know it&#8217;s not ready and all that, but I have a few sites where I have random solutions for that, but I&#8217;ve got them compartmentalized. So pulling them out and putting in something new that makes more sense is going to be easy.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Because I know, you know, like, especially something like the tabs, they don&#8217;t appear that often. And the other thing with stuff like that, you can just search the database for the machine name of block to find where you&#8217;re using it. I do that a lot and sometimes I don&#8217;t know. I ripped Jetpack out of a site recently because it was only being used for slideshows in like six blog posts. There was no need for it. And it might have been more than six, but still this is a major publishing website that has thousands of posts. They didn&#8217;t need Jetpack sitting there doing this like a very minor task. And so that&#8217;s one of my tactics for sure. When I&#8217;m going to rip something out. People forget that you can search easily. Not even in the database. You can use the WordPress search. Search.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Right. For the posts. Yes. Yeah, that&#8217;s what I do. Yeah. Kind of. You can kind of put the blog name in there and then see which post uses what block, especially the third party blocks. When you find out, okay, I have now three query blocks and core blocks and why am I doing this to me?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> And I&#8217;ve always been pretty conservative about what I&#8217;ll add.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>So I think that&#8217;s part of why it&#8217;s not super daunting to me. Because if I can make it work with the tools that exist, I will.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I&#8217;m not going to over engineer it just because I could. And that makes it easier to clean up long term.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So I think the last big feature that was introduced to theme development was the section styles. Style variation in one and then the section styles, the smaller things and block styles, now that you can edit them in the global styles. How much do you use about that? Is that something that comes up quite a bit in your work?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I use them a lot. Especially when you&#8217;re dealing with semantics, I want to give people the ability to have something look the way they want it to look, but also be semantically correct. So especially with things like headings. Right. Having tooling that&#8217;s easy for an end user to understand to say this should be an H2, but I would like it to look like an H4 without making it an H4 is a game changer. It improves SEO, it improves accessibility, it keeps everything cleaner. And so that kind of tooling, I think when used strategically can really help. When used randomly, you&#8217;re just going to confuse people. But you know.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, aren&#8217;t we in the business of confusing people?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, sometimes. Right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>All right. Yeah, no, it&#8217;s interesting too. So are you using also side styles variations or just the section styles or block styles?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Heavily using block styles. Okay, not so much the whole site variations yet. Yeah, there hasn&#8217;t. It&#8217;s again, it&#8217;s like you want to use the right tool for the right use case and yeah, normally you don&#8217;t.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Want to change how the site looks.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. There&#8217;s only. You kind of need like a site within a site to make that required. And the only thing like that I&#8217;ve been building lately is a voter guide that&#8217;s like within a site but the voter guide has all the same styling as the rest of the site. Because it&#8217;s supposed to match.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, right. Right. Yeah. Yeah. I&#8217;ve always felt that the style variations are more for theme product developers that want to give more options to modify the theme. For agencies, I didn&#8217;t see that there are a whole lot of use cases for. For them. I might be wrong, but. Yeah, but you&#8217;re kind of confirming a little bit my bias here.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, I. I don&#8217;t know. I look at anything that&#8217;s coming in that&#8217;s new. I look at it in terms of strategic utility and there&#8217;s a bunch of stuff that is super cool but it&#8217;s just not necessary for my clients. Right. Like it&#8217;s not the use case for that but for somebody else that could really help. And I&#8217;ve had a few where you end up building this random micro site within the site because some weird reason why they need it. And like that&#8217;s really what you would use that for. It doesn&#8217;t happen all that often.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So yeah. Do you apply section styles to your patterns? Yeah, so that. And you give them design choices and they don&#8217;t have to spend time with kind of reorganize their design just because they want to have a pair of a pink background or a yellow background or something like that.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. I also, I restrict color palettes, of course, because we don&#8217;t want anything looking like, you know, we&#8217;re in the. We&#8217;re in some sort of sci fi. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: Geocities. </em>I&#8217;m dating myself now.</p>\n\n\n\n<p><em>Beth Soderberg: </em>It&#8217;s okay. I told the checker at the grocery store the other day about how I worked at Blockbuster in high school and how that dated me, but it was a good job because you could I had to walk around to put the movies back. So I also use a lot of synced and partially synced blocks to achieve design consistency. So paired together. Because that I have found is really good for editorial teams where you can give them a style guide. And usually I make a page on the inside of the site that&#8217;s just privately published so that they can see like, okay, we have these patterns to work from. And, you know, this is the human part. You have a discussion about how, yes, you can do all these things, but you should use these things that we&#8217;ve all agreed upon that follow the style guide.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Well, it also makes for production much, much faster when you don&#8217;t have to make those design decisions. They&#8217;re already there and then.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Exactly. And you don&#8217;t have to train people. I mean, the number one thing I see real clients, real site administrators doing weirdly with formatting is inconsistent vertical spacing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Okay. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>The tooling is there to make it consistent, but people don&#8217;t. Even if you train them, they&#8217;re like, wait a minute, do I pick it at the fourth hash? Or like, which setting is it again? And does that look. And like as much as I can look at spacing on anything and know if it&#8217;s wrong, many people cannot.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh, no, no. Yeah. That&#8217;s a skill.</p>\n\n\n\n<p><em>Beth Soderberg: </em>It&#8217;s a skill.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>And many people really. And I found that like syncing those patterns that way and getting. Locking down some of that basic stuff that like, you don&#8217;t want your end user to be thinking about how much space they need below something.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Like that&#8217;s not what they should be ever actively thinking about. So that&#8217;s how I have approached that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Yeah. So far. Yeah. Makes sense. Have you taken a survey of how often your clients actually use the spacer block? Because I found that WordPress.com that&#8217;s one of the top five blocks used, I.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Have not, but now I&#8217;m curious and I. Some of them, I mean you definitely have some, some where it&#8217;s used more than it should be. But I think that we&#8217;ve avoided some of that and some of it is what we&#8217;ve been able to do recently. Right. A few years ago you had to use it if you were going to get any consistency at all across things. But I think sometimes the patterns and the pattern syncing, that type of thing has dramatically reduced the need to use the spacer block, which is great because the speaker, the spacer block is so annoying on mobile.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, that&#8217;s one thing. It&#8217;s also, you cannot rip it out when, when you redesign the site or something like that, it&#8217;s going to be the. In your content.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, yeah. So I mean, I haven&#8217;t seen similar dislike as it sounds of the spacer block, but when you shrink a screen down suddenly you get wildly different vertical spacing on mobile. And for the average person there is not a straightforward way to make it not do that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>You have to know how to write a workaround for yourself to make it work and that&#8217;s not great.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So. Yeah, well, yeah, it&#8217;s good to know. So before we head into our usual sections, is there anything else that you would like to tell people who have not yet done the jump into block themes, why they should do it?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I think, I think that it is, it&#8217;s a scary jump, and I have always been an early adopter of the new tooling, and so I look at something like that and it freaks me out a little bit. And then I&#8217;m like, well, why not? And I just push myself through and I know that I have the liberty of doing that because I&#8217;ve been working independently for almost 10 years. So I am in a lot of ways in control of what is and is not allowed in my environment. I&#8217;ve talked to a few folks who have. They understand how it&#8217;s working and they, they personally buy in, but their employer does not.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Okay. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>And so for those folks, I think building up your skill set with your personal site or a personal project so that you can advocate for different things internally. It&#8217;s very hard to advocate for something that you haven&#8217;t done and that you don&#8217;t have hands-on experience with. But you know, the ability to spin up a little like MVP demo of, hey, this is how this would solve a problem that we have systemically is really how you sort of gain permission in those sorts of environments. There&#8217;s some really good resources out there on learning how to do this. I think that they are much harder to find than they used to be. When I was first learning how to code, it was much easier to find like beginner entry level stuff, to like level yourself up. And now I think fewer people are creating it and I think it&#8217;s harder to find just because of how it&#8217;s labeled. Everything starts to look the same because it&#8217;s all named the same. But I think giving yourself the challenge to &#8211; even if you don&#8217;t understand everything, listening to a podcast like this, listening to a talk that you&#8217;re finding online, having it playing in the background like it does, seep in to how you think about it. And what will happen is that later you&#8217;ll encounter the same subject again and you&#8217;ll be like, oh, wait, that&#8217;s what they were talking about. And that&#8217;s how you start to connect the dots when you&#8217;re learning anything new. And I think the idea that you&#8217;re going to get somebody who has been building themes the classic way, building themes that are heavily reliant on advanced custom fields, something like that, to just magically one day pick up a whole new set of tools with a whole different way of thinking and be completely comfortable from the get is like ludicrous. That&#8217;s not going to happen.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>But, you know, giving yourself the ability to slowly absorb it, because it is a different way of thinking, it&#8217;s a completely different way of thinking about how to structure the theme. And for me, that has been the hardest part to learn. Once I figured it out, it was great. But of course, it&#8217;s always the hardest thing to figure out a new way of thinking. When you say it like that, it&#8217;s so obvious. But I think people really get down on themselves about it. And I think really just paying attention, reaching out to folks, you know, when you have questions, not being shy about it. What I&#8217;ve figured out over the course of the last, I guess we&#8217;re almost at eight years of Gutenberg. Yeah, Gutenberg is a month older than my eldest child. So it&#8217;s very easy for me to keep track of how old it is. But we are in a time period where what I have noticed as an early adopter, when I talk to the other early adopters, everybody is making it up. Everybody is inventing their process, everybody is inventing the “ right way.” We&#8217;re starting to congeal on some common things. But it has been a time of innovation. And so being a little bit afraid to stick your toe in. That is so reasonable. And at the same time, when you think about it that way, it becomes less scary to fail in air quotes. Right. Because ultimately, how many light bulbs did Edison make before one worked? Like, it&#8217;s just, you know, you have to experiment in order to figure out how something works. And I think it is challenging to be mid-career and have to go back to that beginning.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>You know, Yeah, I feel a certain.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Confidence that all of a sudden is going away.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, yeah. So. So I. I just think people need to be a little less hard on themselves, push themselves a little, be okay with failing and talk to people, talk to people. Just keep going, Just keep swimming, as the fish say in Finding Nemo.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. All right, so you&#8217;ve listened here to a very experienced theme developer and yeah, it&#8217;s never going to be easy. You need to start now. What is it, the Chinese proverb to the best time to plant a tree was 20 years ago. The second best time is now. So it&#8217;s kind of exactly for that. Yeah. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Announcements</h3>\n\n\n\n<p>So, okay, so we have a few announcements. Now we&#8217;re going a little bit into the Gutenberg change log message here. We have a few announcements and they&#8217;re all calls for testing because we get new stuff and. And the testing team is really on top of things. Last week a call for testing was made for the new template management features that are coming to Core, which. have you checked it out, Beth, on what&#8217;s going to come with that? We talked about it here two weeks ago with Anne Katzeff and it&#8217;s the tool where you can now have multiple templates with the same slug and of the theme hierarchy and then activate and deactivate the ones that you want to use or not use. So it kind of puts a new layer in there and gets the user a little bit more in control on how the template management actually works and figure that out in there. Because template management is something WordPress users have never done before because it was always a developer designer kind of scope and there was no user interface for it. And now it&#8217;s here and the confusion is there, but it&#8217;s also something that can be learned and can be helped with.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I think it&#8217;s also going to be great for launching changes to live sites where. And you know how to launch code for Gutenberg is a whole other conversation. But the best practice is to keep your live site database as your database of record. Right. And some of what I see with the new template management changes are enabling you to more easily respect that without having weird, momentary blips of your content looking bizarre while you&#8217;re changing something over on a live site. So I think it&#8217;s going to be, again, another adjustment in how we think about how we work. But ultimately we&#8217;ll offer more granular tooling that will allow for the elimination of some of these use cases that haven&#8217;t always ended up being really strange, where you&#8217;re like, yeah, should we put up a maintenance message while we&#8217;re doing this? Because everything is going to look bizarre for the next 20 minutes. That kind of stuff. I think it&#8217;s going to be good.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>It&#8217;s really good. Yeah. Yeah. And the first version is going to be not perfect and probably have some bugs, but that&#8217;s why the call for testing is there. So I leave the link in the show notes for you so you can start testing and share your experience with it and also share what still confuses you or what didn&#8217;t work or where you thought it would work, but it didn&#8217;t. It&#8217;s definitely something &#8211; conversation needs to happen. And if you are not sure what to do, come into the W in the WordPress Slack into the Outreach channel and there are a lot of people there that will help you figure that out. So if you don&#8217;t know if it&#8217;s a bug or you don&#8217;t, you&#8217;re not doing it right. I know that&#8217;s often kind of that with new things. Did I get this right or is it not working? Most people, and I&#8217;m one of them, I default to okay, I&#8217;m not doing this right. What&#8217;s happening? And there are two more console testing. </p>\n\n\n\n<p>One is on the ability to hide blocks, which is kind of the first iteration of a blocks visibility kind of plugin idea that you can hide and show blocks conditionally. Right now it&#8217;s only on and off or hide and show. So you could have a block in the editor, but you hide it on the front end. But because you&#8217;re still working on it or you don&#8217;t want to, you want to put it in there so your editor knows about it, but it&#8217;s not going to be pushed to the show version until a certain date or until a certain sale happens or something like that. The instructions for the call for testing are really good and they also show you with little videos how it&#8217;s supposed to work to kind of offset my am I doing this right or not? Idea. And the other one that I wanted to point out in this podcast is the accordion block calls for testing. That seems to be really settled. Came in 20.5, I think, and had some iterations, especially for those of you who started styling it. You need to double check your references because the name changes in between for the panel and for the items and all that. So call for testing for accordion block and what you can do with it. Have you experimented with the accordion block?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Mm, I&#8217;m really excited about it. This is one of the ones that I&#8217;ve been dreaming of for years. It&#8217;s one of the ones where I had an external plugin where like, the only reason I was using the external plugin was because I needed accordions. The detail block is sort of an approximation, but it&#8217;s not the same semantically speaking. So I&#8217;m excited about this one. This one and Tabs are my two that have been a thorn in my side for years.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, I&#8217;m also. Well, we can talk about the other blocks that are supposedly come or at least been worked on for Core, even if they don&#8217;t make it into 6.9 at a later date. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Community Contributions</h3>\n\n\n\n<p>There&#8217;s this new AI feature out there, it&#8217;s called Telex, which is automatic block building AI. And there are a few designers and developers that have actually done some great experimentations with that. One is Tammy Lister. She has started a challenge, kind of the blocktober, meaning every day in October she will build a new block with Telex. And I&#8217;ll of course share the site in the show notes. She started out with a kind of reaching back into history of computers and started out with an esky Tetris game. And that&#8217;s when my afternoon, uploaded my afternoon was shot because I got addicted to Tetris again. Yeah. Did you do any experimentations with that?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Nope. That one, I mean, I know about it, I know about Tammy&#8217;s blocktober. I&#8217;m paying attention, but I don&#8217;t have time to just play with it right now.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah, I. I feel the same way. It&#8217;s kind of letting other people do that. I. I look at what other people do. Yeah. And there&#8217;s Marco Ivanovich. He&#8217;s a designer at Automattic. He has some animated icon blocks. They were kind of sparkling and all that. And then he also created a post-it note block where you can put post-its on your site with an image and with a background gradient background. So pretty cool to look at. </p>\n\n\n\n<p>And then there was Jeff Paul from Ten Up. He actually also created a game of Pong Hung block that&#8217;s kind of the tennis kind of back and forth where you need to up. It was just handy as an easy, medium and hard. Yeah, that was another afternoon. I tried to figure it out. Yeah. Juan Margarito, he created a mermaid diagram which is actually a markdown diagram. And then you put the. The diagram code in markdown and then it kind of creates a. A diagram with errors back and forth. Yeah, it&#8217;s kind of a flow diagram if you want to. So that was really interesting to see. Yeah. Anyway, so I just. Yeah, check it out. If you want to play around with it. It&#8217;s telex.automattic.com automatic with double T. The second T. Yeah.</p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s Released &#8211; WordPress 6.8.3</h3>\n\n\n\n<p>Okay. So now we come to the heart of the show, which is what&#8217;s released. And before we head into Gutenberg 20.8, I wanted to let everybody know WordPress 6. 8.3 is out. It&#8217;s a security issue. No, it&#8217;s a security release fixing two security issues. And if you haven&#8217;t updated yet, please do we wait. Go and update. The two issues were mentioned in the release post. One was data exposure issues and the other one issue and the other one was a cross scripting vulnerability for the nav menus which has been fixed and you are in a secure environment again. But don&#8217;t forget to update. Yeah. Any thoughts?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Always update. I&#8217;m. I&#8217;m of the. I&#8217;m of the camp. I always update on the security releases right away and then major releases. I always wait and see what happens.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>How long do you wait? How long do you wait?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I usually wait until a point release has come out.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Okay.</p>\n\n\n\n<p><em>Beth Soderberg:</em> That&#8217;s usually the trigger but sometimes it&#8217;s really stable and we&#8217;re like, well there. I guess there&#8217;s no point release and it&#8217;s been three weeks.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I do the same thing with updating like my iPhone. Yeah, I don&#8217;t. I&#8217;m. As much as I am interested in technology, I am also somebody who just recently started using mobile deposit for checks. I&#8217;m skeptical.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, I think that makes that an early above to decide where to early adopt and where to be cautious.</p>\n\n\n\n<p><em>Beth Soderberg:</em> That&#8217;s true. Yeah. My risk tolerance is very high for certain things and very low for other things.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>And if it changes my work environment that I need to retrain my muscle memory. I&#8217;m opposed to any change, but I recently had to change my Mac updated and they fixed a bug. That&#8217;s the problem with bug fixes. Yeah. If you, if you have for years known about a workaround and the muscle memory is in. You hate that bug fix that fixes that once and for all. So kind of. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Anyway, that&#8217;s a whole other conversation. Moving on.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Thank you. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Gutenberg 21.8</h3>\n\n\n\n<p>So Gutenberg 21.8 is the second last before 6.9 beta. There&#8217;s one more coming, that&#8217;s a 21.9, of course, and that&#8217;s coming on October 17th. So we are recording this on October 8th and next week we have the last Gutenberg release before 6.9 beta comes. Which means bug fixes, yes. New features, no. From that point on forward to get into Core. Gutenberg 21.8 had 118 PRs by 47 contributors and five people were first time contributors. Congratulations, you got your merge done. That&#8217;s fantastic. Because I can see that the first one is always a little tricky getting it past the reviewers. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p>For Gutenberg, we start with the enhancements to the block content. Comments. Block comments is a feature that creates a commenting method for each block in your editor so you and others can add comments to your blocks and have an editorial kind of process going. It&#8217;s a a lot of PRs made it into that. But the first one that I wanted to point out is a discussion field with trackbacks and comment status aggregated for the post page Quick Edit. So you know, in the Quick edit, are there commenting places? Quick Edit is not the quick edit in the WP admin. It&#8217;s a quick edit in the design. But that&#8217;s actually not the commenting. The block commenting thing.</p>\n\n\n\n<p><em>Beth Soderberg:</em> Yeah, this is hard to contextualize even looking at the PR, right? Yeah, the PR. I think ultimately it&#8217;s unifying. It&#8217;s again, it&#8217;s one of those things that&#8217;s unifying design across components to make things more consistent no matter where you find them.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So when you have the new design view, what was missing that you were able to manage trackbacks and comments. So it&#8217;s not the feature that I just said. It&#8217;s just getting on par with the previous WP admin kind of thing. Especially for pages. The posts haven&#8217;t been included yet in these new designs, but for pages, definitely. And if there&#8217;s a post experiment in Gutenberg where you can have the post view also in the new design view, as the site editor. And that&#8217;s where this actually comes to pass. So that is kind of labeled wrong in that changelog, but that&#8217;s okay. We can handle that. Do you want to do the next one?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Sure. So displaying a message when there is no related block, which is the most logical thing you could do with commentary that has no source attached to it anymore.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Anymore.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Anymore, anymore. Right. So again, it&#8217;s giving context to something so that your actual conversations make sense. And basically what it&#8217;s doing is just adding a little message that says, hey, your original block was deleted so that somebody reading through it understands and also gives you the ability to&#8230;part of why I like this one is because you&#8217;re going to end up with people who in collaborating with each other are going to remove things. And you want to have a record of the conversation for editorial purposes, but understanding what has happened is a key part of creating that record.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So yeah, definitely you want to have a record of the decision making process for certain things. Yeah. The other one that I wanted to point out is that it now shows the dates of the comments in a more human readable part, like 30 minutes ago or two hours ago or three days ago. So you get a little bit more relation to the timestamps of that. I think there was an option to do this, but I&#8217;m not quite sure that you can switch it on and off. But if not. No, it&#8217;s not. It&#8217;s the first. It&#8217;s the first iteration and there are no options.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I think that&#8217;s coming later.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah, but it&#8217;s. It&#8217;s known that there will be something like that needed.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yep. And then the highlighting of the related block. Again, a lot of these changes are improving context indicators and so, you know, this just gives you a clearer sense of what you&#8217;re connecting to and which thing you&#8217;re actually talking about with the comments.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So I&#8217;m just going to look through. If we missed something new, we can now go right into the block library section and there&#8217;s a ton of PRs that actually work on the accordion blocks. That&#8217;s also in the bug fix sections. But I think the most prominent stuff is more like the term description block with the context support. So that if it&#8217;s in a template or in an archive template that the term description block is more. You can use it in patterns like you can do post title and query title for that. Yeah, the term description block is something that&#8217;s a little bit of a… I have seen people that are quite adamant that they need the block editor in the category description section for editing the description because I wanted to make it more there. Design it a little bit or make it a little bit more versatile. That&#8217;s quite interesting because you also can now create a page with all the features that you want on that for a particular category and then just have a query loop on that category displayed on it. So you get around that need to have the term description be a block editor or something like that.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. I had never thought about that before because theoretically you always could do the latter. Right?</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>But you had to have a certain level of technical skill and knowledge to do that. The idea of adding block support to that description opens up possibilities for folks who are not as technical to make modifications in that presentation of the. The term pages. I don&#8217;t know. I could go either way there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I could also create massive. I can see this going very wrong.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. I think that&#8217;s why nobody touched it for now.</p>\n\n\n\n<p><em>Beth Soderberg: </em>That&#8217;s a new concept to me. But I don&#8217;t know. My gut says no.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So. And then we get a new block. It&#8217;s the time to read block. And now it has been in the Guternberg plugin for ages. Similar to the table of content block. But they were to get it into core. There were always kind of missing things or quirkinesses that weren&#8217;t dealt with. And the time to read had massive accessibility objections because it only had one time that it takes to read a block. Not everybody has that reading skill or is on that level like a lot of people are. English as a second language. They don&#8217;t. They don&#8217;t read so fast or dyslexia is pretty. Yeah. It&#8217;s out there. And they don&#8217;t read that fast. And so it kind of makes them feel bad about not reading in that 15 minutes kind of thing. What they&#8217;re doing now is kind of offering a range option. It says it takes one to five minutes or something like that. And which I feel is kind of even for someone who is fast reading but tired is a good indicator. Yeah. That&#8217;s how long it&#8217;s going to actually take. And then they added also a word count to it.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, I like that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. When there are word count plugins out there. Word count blocks, plugins out there say that 15 times fast. But I think having a core block that actually offers it option is really cool.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I&#8217;m sorry I didn&#8217;t bold that, but I wanted to talk about it.</p>\n\n\n\n<p><em>Beth Soderberg: </em>No, I agree. I think it&#8217;s. It&#8217;s a kinder way to deal with the problem because you&#8217;re giving people enough information to very quickly self assess without shaming them.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So the next one is part of the Data Views section actually. It&#8217;s the data forms package. And there&#8217;s now support for certain form elements validation in the data forms package. So if you use that as a plugin or your settings pages. You now get help from the packages that drive that. I think that&#8217;s a. Yeah, it&#8217;s an enhancement for extensibility, for sure.</p>\n\n\n\n<p><em>Beth Soderberg:</em> In the block editor section, block multi selection, disabling transforms and inspector controls.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. That&#8217;s an interesting one. So when you select multiple blocks, you still get the. Sometimes the options that you can transform them. And for paragraphs, a series of paragraphs. I like it. Because then you have. You can transform them to list views. But if you have a mixture of selected blocks, you don&#8217;t need transforms or inspectors back the controls. You just probably want to move it or move the selection. Yeah. So I think it&#8217;s a good way to not confuse people.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Right. And that&#8217;s a good example of a tiny change from an end user perspective that probably won&#8217;t be noticed, but will reduce friction for people. All right. In global styling, adding a reset button to our background controls panel. Hooray.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Hooray. You don&#8217;t have to unselect stuff. Yeah. Just click on things and you make it all go away. It&#8217;s pretty cool. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> And then making the additional CSS UI less prominent, which is great because the less random CSS everywhere, the better.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yes. And. Well, it&#8217;s. I totally agree with that. And that&#8217;s also the. The justification why they want to put it some. So they&#8217;re going to hide it. Again, it was hidden on the left hand side of the global styles or styles panel. You always could edit it on the right hand side when the styles panel where sooner or later we probably need to decide if we want to use the left hand side or the right hand side for the styles features. But it now is going to be in the ellipse menu in the header of the styles section. So it says add additional CSS as a menu item on top. So. So you are not going to be. Well, it was there and then it wasn&#8217;t there. So where is it kind of thing situation. It ended up in the ellipse menu on top of the screen.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Block bindings. I love block bindings.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. There&#8217;s an experimental feature there.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>To support block attributes from the server side. I haven&#8217;t completely read through it. I&#8217;m not quite sure I understand that. So I would need to go back to the developers and say what&#8217;s the use case and why you&#8217;re doing it kind of thing.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>I think. Did you get something?</p>\n\n\n\n<p><em>Beth Soderberg:</em> I would have to clarify, but my understanding of it is the big thing with block bindings is like which things are supported and which things aren&#8217;t supported and how that is communicated is improved from doing this.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Doing it service sort of the nugget.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Of truth there. But I think anything like that. I know it&#8217;s experimental but making block bindings easier and more accessible for people to use anything that helps. That is a good thing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I think there are two areas where they come from. One is to make block bindings available for more than 14 blocks which has been the case until now. That&#8217;s one thing. But also to increase extensibility and use have not only blocks use the block bindings but also whole features use the block bindings for external things like the remote block plugin by WordPress VIP USO. Yeah. They also use block bindings to identify the data that comes in and put it into the block editor. But I think it&#8217;s hard to bring the server side and the client side together with the same information. And this one will have the server side be the moment of truth. No, the source of truth for block bindings. Yeah, it&#8217;s definitely a late edition. I&#8217;m not sure it&#8217;s going to make it to 6.9. I&#8217;m skeptical though. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. Right. Right. Mode Try adding content roles to navigation blocks is the name of the PR which I think is delightfully named and I. Even the way that this is written is pretty great. I wanted to see how far we can go with just adding content roles to nav link in some menu blocks given the improvements to content only logic we&#8217;ve had. And then it references another pr. The next sentence is I think it&#8217;s working better now. Whoever this contributor is, I love your writing. Tell the machines.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh, that&#8217;s.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Fun times. But I think it&#8217;ll.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Isabelle Bryson. Yeah, she&#8217;s been on the podcast before and she&#8217;s actually worked also on the grid layouts and yeah, she works for Automattic on the team. And the other I think the tri part is okay. We experiment with things. So that&#8217;s when it says try and then there&#8217;s also add is kind of definitely need to fix this or add this feature or fix means fix this bug. Yeah. So they have these prefixes on their PRs and the try thing is. Yeah, let&#8217;s try it out and see what happens. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. But this one, it looks cool. People should check it out. Components. The text area component. Adding a default resize vertical rule just to make things more make sense visually so that you can move stuff around the way you need to.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. And you can control the vertical size of things. That&#8217;s always a good thing. And then the other component PR is actually adding storybook examples for the fields package. So there&#8217;s more documentation there for the plugin developers who want to use it. Also of course, for the core developers who are going to use the Fields.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Package for their work patterns, we have a change to the block inspector adding a content tab for section blocks that displays content only descendant blocks. So similar to the existing styles tab, but for content.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. And it&#8217;s up until now it lists the blocks that can be edited in a section pattern or in a content only block. But that&#8217;s all part of the write mode, and we will see how which part of it actually will come into 6.9. But I think it&#8217;s very helpful for content creators who use a pattern to just see the pieces that you can edit and not be confused with any styling of that, even if it&#8217;s only the section styles. And from the PR before and after, you can see that the little drop water drop that&#8217;s in the block toolbar actually gives you a way to browse through the styles for this particular section. So it&#8217;s not taking anything away, it&#8217;s just kind of making it clear where the things the information is going to be for you. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I think for anyone who might be confused about what we&#8217;re talking about, look at the pr. The screenshots will help you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah. It&#8217;s a little bit. Sometimes it&#8217;s a little bit hard on the podcast to make things come to life on a. In a visual component.</p>\n\n\n\n<p><em>Beth Soderberg: </em>The screenshots make it make sense if you&#8217;re confused by what we just said.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And the PR we&#8217;re talking about is 71714. The next one is an easy one, but it&#8217;s definitely something to talk about for Black Friday and all the WooCommerce stuff. There is now a WordPress gift icon available for content creators and developers. So you can use that. It comes from a WooCommerce team, but they contributed to Core so anybody can use it. </p>\n\n\n\n<h3 class=\"wp-block-heading\">New API</h3>\n\n\n\n<p>The next thing I want to point out was the block API has now the block visibility, control support and the ui. That&#8217;s the part where the underlying architecture for the hide and show of blocks I think it is. And that also is the foundation for when you. Later on we will have the conditional Hide and seek. No hide and show. Yeah. When you want to say okay, I want it for logged in users or not. I want it for people who come from Twitter or not. These kinds of conditionals, they&#8217;re not yet in there. For that you still need the block visibility plugin by Nick Diego. So I think we have one more. No. Yeah, there&#8217;s an accordion block also in write mode. We hide the add button in write mode so you can add an additional accordion block in write mode. But I&#8217;m not quite sure that&#8217;s particularly helpful for a content creator. But time will tell.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, that could go either way.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it&#8217;s a 5050 kind of thing. You do it right for 50 people and the others are going to hate you for that. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Bug Fix</h3>\n\n\n\n<p>And then one bug fix I wanted to point out there is a bug in the pattern override. Some users might have found it is that editing was allowed on non-enabled override blocks which kind of defeated the purpose, but it&#8217;s now fixed. So there&#8217;s another experiment. I don&#8217;t know how that comes about, but the PR definitely has some interesting conversations. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Experiments</h3>\n\n\n\n<p>There is allow registering PHP only blocks. What do you say for that?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I say I think this is gonna be, this is gonna be so much bigger than it sounds.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yes.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Because basically what you&#8217;re doing is you&#8217;re enabling developers to create blocks using only PHP. So you&#8217;re opening up the can of worms about who knows PHP and who knows JavaScript and are we gatekeeping by moving everything to JavaScript and blah blah.</p>\n\n\n\n<p>But then you&#8217;re also changing the structure in a way that might make things less portable between projects. So I don&#8217;t know.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, it&#8217;s definitely an experiment.</p>\n\n\n\n<p><em>Beth Soderberg: </em>That&#8217;s true. I think, you know, and I. One of the things I have noticed, there is a developer on my team that I have been mentoring for years and really started learning WordPress specifically post Gutenberg. And what&#8217;s fascinating about watching her is that she struggles with some of the traditional ways of doing things, but can do them the new way. Right. So for somebody like that this might be terrible, you know, and I. It just becomes a context thing about what you know and how you&#8217;ve been progressing with different skills along the way if you&#8217;ve completely forgotten PHP or you know, various things. So I, I don&#8217;t know, I think this, this one is going to be a much bigger deal than I think.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, I think so too. And there will be restrictions to that and I think the documentation will show that because it actually uses something the server side render component that actually was not considered best practice to use until now and the registration of PHP only blocks will actually use the server render component. So I think there is also something a little bit of a movement in the core contributing ranks about that. And it definitely needs some more. Yeah. Experimenting with it and exploration and. But it&#8217;s in there. One listened and maybe there&#8217;s something that can be pushed to the finish line outside the experiments. All the developers out there who were waiting for something like this go have at it.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Oh. Interesting to see what people do.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, me too. And I added a. The label needs developer documentation and a project manager on the team also removed it because it&#8217;s experimental. So the developers that created it have some leeway in backwards compatibility. And it&#8217;s experimental. It means it&#8217;s not documented. You cannot build on it. You need to be part of the experiment spirit about it to use it and not rely on it. That it&#8217;s going to be working like that for the foreseeable future. So yeah. It&#8217;s also that caveat on it. Just wanted to point it out.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I just saw that that&#8217;s important because you&#8217;re going to have somebody who goes off and builds a whole new thing on it and then in two weeks it&#8217;ll break.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Which. Yeah. Any plugin developer that built plugins for Gutenberg has been doing kind of living through that for multiple years now. Yeah. So. But that&#8217;s 21.8 release with quite a few new features and the final release will be today on October 10th. </p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s in Active Development or Discussed</h3>\n\n\n\n<p>And now we are coming to the section where we talk a little bit about what&#8217;s in development and discuss. And there are new blocks in the works and we know this because Matthias has. Matthias Ventura has published that discussion about new blocks that were previously thought about plug into territory. And now quite a few theme developers think that they are held back with their designs if there are not more additional blocks in core because then now they can style it in their themes and make it available on templates and all that. So Justin Tadlock also did an opinion piece on the Gutenberg Times for it about four weeks ago. I can link it again in the show notes. But we are getting new blocks and the ones that have been merged they&#8217;re not entirely out of experiments yet. Time to read. And we talked about it because it just was merged. We also talked about the accordion block that was merged a while ago and still in experiments. But there are two. Oh, we also talked about the terms query block that has been merged but we haven&#8217;t talked about the breadcrumbs block. And I&#8217;m really excited about that because it felt such a need in the template area that people are getting so confused where am I? And I have a better map and I have breadcrumbs and all that. Yeah, it&#8217;s such a useful tool and I&#8217;m looking forward to get that tested. And yeah, watch out on the test team. They&#8217;re putting some more calls for testing together to get this all in the hands of people who want to help with making it better.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I&#8217;m excited about the breadcrumbs block too. That&#8217;s another one where I&#8217;ve had to do sort of weird things to make things work over time and it&#8217;s going to be nice to not have to do the weird things.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I was using Justin Tadock&#8217;s breadcrumbs block that he developed and he had some thoughts in this VR on how broad or restricted this new. This first version is going to be. And I think we all going to like it because depending on the context you can get additional. The breadcrumbs will change. And I really like that.</p>\n\n\n\n<p><em>Beth Soderberg:</em> Yeah, I&#8217;ve. I&#8217;ve used his plugin too. I forget which one it was. There&#8217;s a few independent plugins for breadcrumbs and my team has run into some weird edge cases of what they will do depending on your content structure. So I think that&#8217;s part of why the scope of the breadcrumbs block being limited at first makes so much sense, because the complexity of what you&#8217;re actually trying to do from a templating level, depending on where you are in a site and how your site is structured can get incredibly complex. I don&#8217;t remember which plugin it was, but we had a site. It may have been the Voter Guide. The Voter Guide within the site that completely killed everything. Like something about the logic of where we were just. And we had to use a different plugin just for that one site to make it work.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I might have even re. Ended up doing something sort of manual instead. I don&#8217;t remember. But those plugins have been incredibly useful, but are also prone to edge case weirdness. Basically generating navigation on the fly. And if you don&#8217;t know where you are within the structure of the site from a structural standpoint, or if someone has made some odd decisions about where they&#8217;re putting things or how their hierarchy works, you&#8217;re going to end up with a really confusing breadcrumb.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah. And sometimes you don&#8217;t have the controls to actually make changes. It&#8217;s just all this black box kind of mystery mute kind of thing again. Yeah, yeah. And I. While we&#8217;re running a little bit out of time or short on time, I just wanted to mention there&#8217;s also a dialogue block in the works. There&#8217;s an icon block in the works. My favorite one is the stretchy text. It sounds so weird, but it actually makes sense. It&#8217;s text that stretches over a certain container and it&#8217;s flexible depending on how the container works. So you could do this for hero sections, all that. And then here&#8217;s your bestest favorite. The tabs block is in the works. And then also my favorite is a table of contents block. Because I have these long posts all the time and I want to do the table of contents block. But it had some weird issues. That&#8217;s why it&#8217;s not in Core yet. And they&#8217;re trying to figure that out how that all can be done. It&#8217;s now attempted to be a dynamic one and allow usage outside of the post or page that is actually referring to. But for instance, in a template, you could put it in a single post template in the sidebar and you will always have a table of content for your posts. So I think that&#8217;s a really good use case for pages, when you have landing pages or tutorial pages or documentation pages that you don&#8217;t have to fiddle with it while you&#8217;re creating the content. And it&#8217;s just there in the template.</p>\n\n\n\n<p><em>Beth Soderberg: </em>This is one where my weird workaround for it. There&#8217;s one of the SEO plugins has a table of contents block built into it. I forget which one offhand, but I&#8217;ve used that before to get this type of functionality.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Because it. Sometimes you really just need it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, absolutely. Yeah. Yeah. </p>\n\n\n\n<p>So that&#8217;s it. That is the Gutenberg changelog 122. Thank you so much for being with me on this, Beth. And it was great to chat with you and talk about block themes and all these good things. Block style stuff. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> Thanks for having me. It was fun.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Dear listeners, as always, the show notes will be published on the <a href=\"http://gutenbergtimes.com/podcast\">gutenbergtimes.com/podcast</a>. This is 122. I already said that. But if you have questions or suggestions or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a> that&#8217;s <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a> and I forgot a question for you, Beth. And that is if people want to get in touch with you, what is a good place to do that?</p>\n\n\n\n<p><em>Beth Soderberg: </em>You can find me in the WordPress slack under my name, Beth Soderberg. And then you can find me at work at our website, which is Bethink.studio or bethinkstudio.com. but you know, it&#8217;s really fun when you can get the non.coms to work with your name.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So. Yes, all right. So I&#8217;ll list of course, all those contact information, more in the show notes.</p>\n\n\n\n<p>And thank you all for listening. Thank you for being here and see you when I&#8217;ll see you back. Well, in two weeks. Goodbye, and have a good time. </p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 12 Oct 2025 10:58:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: In Canada\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150205\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ma.tt/2025/10/in-canada/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:731:\"<p>I&#8217;ve been trying to find time in my calendar to attend more WordCamps as I love meeting <a href=\"https://ma.tt/2025/09/wordpresser/\">WordPressers</a> all over the world. The stars aligned, and I&#8217;ll be swinging by <a href=\"https://canada.wordcamp.org/2025/\">WordCamp Canada</a> next week. They&#8217;ve put together an amazing program, including open web pioneer and inventor Dave Winer, so I&#8217;m looking forward to checking out the sessions. I wish I could go to every WordCamp, like I used to! I&#8217;ve been recording videos and messages for those I can&#8217;t physically attend. Ottawa is also great as the only other commercial board I&#8217;m on is <a href=\"https://fieldeffect.com/\">Field Effect</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Oct 2025 15:35:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: Twitter Hacked\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150193\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://ma.tt/2025/10/twitter-hacked/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:662:\"<p>Sorry everybody, my @photomatt on Twitter has been hacked, I&#8217;m trying to regain account access, but it is not currently in my control. <strong>Update: </strong>Thank you to the fine teams at X/Twitter and <a href=\"https://x.com/nikitabier\">Nikita Bier</a>, my account has been recovered. Just for future reference, I will never promote cryptocurrencies or similar investments. If you see anything from me or WordPress claiming that, be highly skeptical. Invest in open source, public stocks, and great companies like Automattic. <img alt=\"🙂\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f642.png\" style=\"height: 1em;\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Oct 2025 00:34:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"Gutenberg Times: Mega Menus in core, WordPress 6.9 calls for testing, going from Elementor to Site Editor — Weekend Edition 344\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=42168\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:23201:\"<p>Howdy,</p>\n\n\n\n<p>After meeting so many people at WordCamp Gdynia, on the plane and then on the train, I caught a nasty cold and struggled all week. I call this stage mushbrain, and everything becomes much harder, especially reading comprehension suffers. I am over it now, though. It also wasn&#8217;t the first time that I sounded horsey on a podcast episode. </p>\n\n\n\n<p>It&#8217;s the time of year now here in Munich when the days get shorter and the weather is cold, drissly and overcast. A time when snow would brighten the sights, with its whiteness covering partly the darkgray, dark brown background. </p>\n\n\n\n<p>Enjoy again  this weekend edition  and stay healthy. </p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#0-word-press-release-information\">Developing Gutenberg and WordPress</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#help-testing-new-features-for-wordpress-6-9\">Help testing new features for WordPress 6.9</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#what-s-new-in-and-around-playground\">What&#8217;s new in and around Playground</a></li></ol></li></ol></nav>\n</div></div>\n</section>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>Gutenberg 21.8 is now available and release lead <strong>Carlos Bravo</strong> hightlighed in his release post <a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/\"><strong>What’s new in Gutenberg 21.8? (8 October)</strong></a></p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/#block-visibility-support-ui\">Block Visibility Control Support and UI</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/#block-comments-improvements\">Block Comments Improvements</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/#accordion-time-to-read\">Accordion and Time To Read Blocks</a></li>\n</ol>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>This week <strong>Gutenberg Changelog 122</strong> recording, <strong>Beth Soderberg</strong>, lead developer at <a href=\"https://bethink.studio/\">Bethink.studio</a> and I chatted about the release and other WordPress topics around Block themes and on going change. The episode arrive at your favorite podcast app over the weekend. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode is <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/\">Gutenberg Changelog #122 – Gutenberg 21.8 and WordPress 6.9</a> with Beth Soderberg of <a href=\"https://bethink.studio/\">Bethink Studio</a></p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><img alt=\"Gutenberg Changelog 122 with Beth Soderberg\" class=\"wp-image-42236\" height=\"193\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-11-at-12.32.48.png?resize=652%2C193&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p class=\"has-small-font-size\"><em>If you are listening via Spotify, please leave a comment. If you listen via other podcast apps, please leave a review. It&#8217;ll help with the distribution.</em></p>\n</div></div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>It was <strong>JuanMa Garrido</strong>&#8216;s turn to write the monthly roundup post <a href=\"https://developer.wordpress.org/news/2025/10/whats-new-for-developers-october-2025/\"><strong>What’s new for developers? (October 2025)</strong></a> on the WordPress Developer Blog. The 21.6, 21.7, and 21.8 Gutenberg releases add features for developers. The Command Palette now works throughout the admin, the new Terms Query block makes taxonomy layouts easier, and Block Visibility controls allow for conditional display. Notes (that&#8217;s how we call Block Comments now) improve team collaboration, while content-only editing maintains design integrity during client handoffs.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"help-testing-new-features-for-wordpress-6-9\">Help testing new features for WordPress 6.9</h3>\n\n\n\n<p>Release test co-leads <strong>Krupa Nanda</strong> and <strong>Jonathan Bossenger</strong>, published several calls for testing in preparation in WordPress of the 6.9 release. Each of the post has a detailed description of the feature, and instructions on how to test is with specific scenarios. It&#8217;s much easier to follow along with any of the calls for testing, to also learn what&#8217;s new in the next release. </p>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/2025/10/03/help-test-changes-to-template-management/\"><strong>Help test changes to template management</strong></a> is probably the most elaborate call for testing, as template management received a completely new feature, and it needs to be working for many different use cases, and has consquences on existing sites.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/\"><strong>Call for Testing: Ability to Hide Blocks</strong></a> for this feature it&#8217;s the bare minimum of a new feature, that will be in future releases see some refinement and extensiblity. </p>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/\"><strong>Call for Testing: Accordion Block</strong></a> lets you dive into a whole new block, many users asked for an several plugins are already available for. Now it will come to core. </p>\n\n\n\n<p>Your time spent on testing the new features for WordPress 6.9, has a lot of impact, as the bugs found now, make the release the best it can be for millions of other users. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong>Lesley Sim</strong> informed us that <a href=\"https://wordpress.org/plugins/eventkoi-lite/\"><strong>EventKoi Lite</strong></a> is now available from the WordPress Plugin Repository. I mentioned the premium version before, Event Koi is modern, WordPress events calendar. Create single or multi-day events and display month, week, or list views via blocks (or shortcodes).</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Mike McAlister </strong>announced a new product: <strong>OlliePro Extensions</strong> on Bluesky. He mentions: Animations, advanced grid + column controls, keyboard shortcuts, and more. Watch the vidoe <a href=\"https://www.youtube.com/watch?v=qq2DLc43pTk\"><strong>Introducing Ollie Pro Extensions &#8211; Supercharge Your WordPress Block Editor</strong></a></p>\n\n\n\n<p>All controls are seamlessly integrated with the Core editor sitebar sections. <strong>Mark Howells-Mead</strong> <a href=\"https://wordpress.slack.com/archives/C015GUFFC00/p1760046957248569\">commented</a> in the WordPress Slack #outreach channel: &#8221; I’m very impressed with how he’s been able to integrate the little add-ons many of us are integrating to our own projects, but in such a seamless way by extending core controls.&#8221;  McAlister shared an <a href=\"https://gist.github.com/mikemcalister/937664ea19e87d61add7fc9902f10ac9\">example Gist on GitHub</a>.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>David McCan</strong> took a deep dive into the world of Block plugins. In this blog post   <a href=\"https://dynamicwp.co/performance-of-third-party-blocks-and-core-compared/\"><strong>Performance of Third Party Blocks and Core Compared</strong></a> he tries to answer the questions many site builders and owners have: &#8220;Can you add the features Gutenberg is missing yet still be performant like core?&#8221;. McCan tested ten third-party Gutenberg block plugins with WordPress core, specifically focusing on performance.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Matt Medeiros</strong>, WPMinute, took the <em>Mega Menu Designer</em>, also made  by Mike McAlister, out for the spin. He shared his thoughts in the Video <a href=\"https://www.youtube.com/watch?v=7NYskePLDM0#feedback\"><strong>How to Build Mega Menus with WordPress Blocks</strong></a>. He provides a detailed walkthrough calls it &#8220;Perfect for anyone looking to enhance their website&#8217;s navigation experience.&#8221; As reported earlier <a href=\"https://wordpress.org/plugins/ollie-menu-designer/\">the plugin is available for free</a> in the WordPress plugin repository. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<p><strong>Rae Morey</strong>, publisher or The Repository, reported <strong><a href=\"https://www.therepository.email/ollies-menu-designer-flagged-for-core-with-automattic-developers-set-to-help-shepherd-it?utm_source=mailpoet&amp;utm_medium=email&amp;utm_source_platform=mailpoet&amp;utm_campaign=issue-276\">Ollie&#8217;s Menu Designer Flagged for Core, With Automattic Developers Set to Help Shepherd It</a></strong>. Automattic&#8217;s Anne McCarthy says developers are preparing to review Ollie&#8217;s Menu Designer for inclusion in the Gutenberg plugin, marking the start of a collaborative push to bring the plugin&#8217;s features into WordPress. This follows WordPress co-founder Matt Mullenweg&#8217;s suggestion that the menu functionality should be part of core. Details and links in Moery&#8217;s article. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>This episode of <em>Greyd Conversations</em> show, <strong><a href=\"https://www.youtube.com/watch?v=cRM4FjR_UbE\">Switching to FSE from a pagebuilder</a>, </strong>covers the story of <em>Buro Staal</em>, a smal dutch agency, which switched from Elementor to Full site editing cold turkey. Greyd&#8217;s host <strong>Sandra Kurze</strong> and agency owner <strong>Rosanne van Staalduinen</strong> shared why and how her agency switched and the lessons learned along the way. </p>\n\n\n\n<p>The biggest hurdles were limited functionality of navigation block, not able to create Mega Menus, and the need for controls for mobile sites and responsiveness. So they augmented their tech stack with Kadence Blocks and Ollie Pro theme. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p><strong>Ryan Welcher</strong> published another recipe from his Blockdevelopment Cook Book on YouTube.  <strong><a href=\"https://www.youtube.com/watch?v=dJ4gUrxTgjM\">How To Make A Simple Fade In Effect Fast</a></strong>. &#8220;In this recipe, we’re adding a little flair by loading custom JavaScript and CSS for the Cover and Image blocks to create a smooth fade-in effect as they scroll into view. To keep things efficient, we’ll only enqueue these files when the blocks are actually on the page.&#8221; </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<h3 class=\"wp-block-heading\" id=\"what-s-new-in-and-around-playground\">What&#8217;s new in and around Playground</h3>\n\n\n\n<p><strong>Nick Diego</strong> announces that <a href=\"https://wordpress.com/blog/2025/10/08/introducing-blueprints-in-wordpress-studio-1-6-0/\"><strong>WordPress Studio version 1.6.0</strong></a> now supports Blueprints, which are lightweight JSON files that predefine site configurations for quick and consistent setup. Instead of starting with empty sites or using large snapshots, teams can create portable recipes specifying WordPress versions, plugins, and settings. Studio offers three featured blueprints for quick starts, development, and commerce, while users can also upload custom blueprints. The feature integrates into the standard site creation flow and helps streamline workflows for solo developers and teams alike.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://wordpress.github.io/wordpress-playground/\"><strong>Playground documentation</strong></a> now has Ask AI button, to get help finding and understanding feature sets and APIs.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://wordpress.github.io/wordpress-playground/\"><img alt=\"\" class=\"wp-image-42203\" height=\"339\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-09-at-18.50.23.png?resize=652%2C339&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ajit Bohra</strong> of Lubus <a href=\"https://x.com/ajitbohra/status/1975920964266258538\">shared on X</a> &#8220;The Visual BluePrint Builder for Playground is shaping up nicely. All the latest updates are in, and it’s feeling solid. Stable version coming soon, but you can already check it out and start building visually.&#8221; A blueprint builder with blocks, how nice.  You can test it via <a href=\"https://playground.wordpress.net/?blueprint-url=https%3A%2F%2Fraw.githubusercontent.com%2FlubusIN%2Fvisual-blueprint-builder%2Fplayground%2F_playground%2Fblueprint-github.json\">this Playground link</a>. The code is available on <a href=\"https://github.com/lubusIN/visual-blueprint-builder\">GitHub</a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jamie Marsland</strong> also tries to make it easier to create blueprints for Playground sites and open up the WordPress in a browser tool for a broader audience. Details in his post <a href=\"https://www.pootlepress.com/2025/10/introducing-pootle-playground-my-experimental-wordpress-blueprint-builder/\" rel=\"noreferrer noopener\" target=\"_blank\"><strong>Introducing Pootle Playground — My Experimental WordPress Blueprint Builder</strong></a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Adam Zielinski</strong> created an <a href=\"https://playground.wordpress.net/php-playground.html\"><strong>online PHP code editor</strong></a> using Playground. It allows developers to test PHP snippets quickly in their browser. The tool supports WordPress functions, enables switching between PHP and WordPress versions, and allows sharing code configurations through links. Built with WordPress Playground, it runs entirely client-side with network access and popular PHP extensions included. He&#8217;s currently experimenting with adding CLI and file browser capabilities to support composer packages and frameworks like Laravel or Symfony.</p>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n</section>\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p>Featured Image: Free colorful building blocks image by <a href=\"https://www.rawpixel.com/image/5906195/photo-image-public-domain-free-game\">Rawpixel </a></p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Oct 2025 23:35:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Matt: Jeremy Kranz and Sentinel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150173\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/jeremy-kranz/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2487:\"<p>I&#8217;d like to introduce you to <a href=\"https://www.linkedin.com/in/jeremykranz/\">Jeremy Kranz</a>. With his career as an investor at <a href=\"https://www.intelcapital.com/\">Intel Capital</a>, then <a href=\"https://en.wikipedia.org/wiki/GIC_(sovereign_wealth_fund)\">GIC</a>, which is the sovereign wealth fund of Singapore rumored to manage over $700B, to now running his own fund <a href=\"https://www.sentinelglobal.xyz/\">Sentinel Global</a>, he has had a front-row seat to investments in industry changing companies such as ByteDance (which became TikTok), Alibaba, Uber, DoorDash, Zoom, DJI (which changed the drone industry and argubly modern warfare), and many more I&#8217;m probably not even aware of.</p>\n\n\n\n<p>When I first met Jeremy in 2014, I was amazed that a late-stage financial investor could understand Open Source so well, and he immediately grokked what <a href=\"https://automattic.com/\">Automattic</a> was doing in a way that I think has little parallel in the world. (Today, it reminds me of Joseph Jacks at <a href=\"https://oss.capital/\">OSS Capital</a>.) <a href=\"https://www.insightpartners.com/team/deven-parekh/\">Deven Perekh of Insight Partners</a> led Automattic&#8217;s 1.16B valuation Series C round, making us one of only forty &#8220;unicorns&#8221; (private companies valued over a billion dollars) at the time, and one of the reasons they beat out others as the lead of the round was that GIC/Jeremy was a LP of Insight so they could directly co-invest. GIC is so intensely private <a href=\"https://ma.tt/2014/05/new-funding-for-automattic/\">I couldn&#8217;t even mention them in the announcement at the time</a> even though they were the catalyst for the round.  Since then, Jeremy has become a close friend and advisor, and he even took me to <a href=\"https://www.nugs.net/live-download-of-dead-and-company-dos-equis-pavilion-dallas-tx-10-14-2021-mp3-flac-or-online-music-streaming/26749.html\">my first Grateful Dead concert</a>.</p>\n\n\n\n<p>Eleven years later, this is his first podcast! Jeremy shares incredible <a href=\"https://www.investopedia.com/terms/a/alpha.asp\">alpha</a> around China, AI and its adoption in the enterprise, how asset allocation is evolving, and at the end, a beautiful tie together of the Grateful Dead and Open Source.</p>\n\n\n\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Oct 2025 19:30:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Kathy Sierra\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150166\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/kathy-sierra/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:774:\"<p>I was reminded today of the profound marketing influence of <a href=\"https://en.wikipedia.org/wiki/Kathy_Sierra\">Kathy Sierra</a>, who was a pretty prolific blogger and speaker back in the day. I would summarize her thesis as such: <strong>Your best marketing and communication should talk about how you make your users awesome, not how you&#8217;re awesome</strong>. If you&#8217;d like to check out some of her talks, <a href=\"https://href.li/?https://wordpress.tv/2008/10/31/wordcamp-sf-2008-kathy-sierra-kicking-ass-and-creating-passionate-users/\">she spoke at WordCamp in 2008</a>, <a href=\"https://vimeo.com/81625882?fl=pl&amp;fe=ti\">at Business of Software in 2013</a>, and at <a href=\"https://www.youtube.com/watch?v=iBtcGwHPMKM\">Mind the Product in 2015</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Oct 2025 01:22:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"Open Channels FM: Bootstrapping a Successful WordPress Business Through Customer Feedback and Iteration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110936\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"https://openchannels.fm/bootstrapping-a-successful-wordpress-business-through-customer-feedback-and-iteration/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:218:\"In this episode, Mark chats with Aurelio Volle from WPUmbrella about his journey in creating a WordPress management tool, maintaining customer focus, and the importance of community and transparency in business growth.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Oct 2025 10:47:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Battery Scan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150146\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/battery-scan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1067:\"<p>One of the cooler companies I&#8217;ve seen in a while is <a href=\"https://www.lumafield.com/\">LumaField</a>, which does industrial CT scanning, as they describe it.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Industrial X-ray CT (Computed Tomography) works on the same basic principle as medical CT, taking hundreds of X-ray images from different angles to capture the internal and external structure of objects in three dimensions.</p>\n</blockquote>\n\n\n\n<p>In addition to providing amazing graphics of these scans, they also gather some valuable data. <a href=\"https://www.lumafield.com/battery-report\">Their Lumafield Battery Quality Report does a deep dive into lithium ion battery manufacturing</a>, showing the wild differences between different brands. </p>\n\n\n\n<p>I love this stuff, whether you call it QA, evals, testing, or whatever, it reminds me of <a href=\"https://www.principles.com/principles/8b086563-5bb4-4741-8713-c62bd1a0d749/\">Ray Dalio&#8217;s Principle to embrace reality and deal with it</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Oct 2025 06:24:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: #188 – Bud Kraus on Teaching and Using WordPress With Low Vision\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=199897\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wptavern.com/podcast/188-bud-kraus-on-teaching-and-using-wordpress-with-low-vision\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39989:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case teaching and using WordPress with low vision.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Bud Kraus. Bud was diagnosed with mascular degeneration, a condition often associated with old age, when he was 37. Affecting both eyes, this gradually eroded his central vision, making it difficult for him to see straight ahead, recognize faces, drive or read.</p>\n\n\n\n<p>Despite these challenges, Bud&#8217;s peripheral vision remained intact, sparing him the need for a cane or guide dog, and allowing him to continue to navigate daily life. Through perseverance and adaptation, Bud continues to live fully, facing the hurdles of vision loss with resilience and optimism.</p>\n\n\n\n<p>Bud opens up the podcast by talking about his experience living with legal blindness, how his central vision loss has shaped everything from everyday activities to his professional routines. He explains the practical ways he adapts his devices and workflow, including tweaks to operating system settings, using screen zoom functions, and relying on pattern recognition to teach coding, write tutorials, and even host his Seriously, Bud? podcast. His unique perspective sheds light on the often overlooked nuances of accessibility, reminding us that every user interacts with technology differently.</p>\n\n\n\n<p>Bud also chats about the broader impact of accessibility in the WordPress space, from frustrations with hard to navigate interfaces, to the importance of not excluding users who may become your audience or customers. His reflections reveal how living with low vision pushed him beyond mere acceptance, helping him discover new opportunities, hone his teaching skills, and even find humour in daily challenges.</p>\n\n\n\n<p>Bud&#8217;s story serves as a powerful reminder of the importance of designing with empathy, embracing adaptation, and viewing accessibility, not just as a technical requirement, but as a source of creativity and connection. It&#8217;s full of real world tips, personal anecdotes, and a dose of inspiration.</p>\n\n\n\n<p>Whether you&#8217;re a designer, developer, educator, or simply passionate about building a more inclusive web, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Bud Kraus.</p>\n\n\n\n<p>I am joined on the podcast by Bud Kraus. Hello, Bud.</p>\n\n\n\n<p>[00:03:35] <strong>Bud Kraus:</strong> Hello, Nathan. Thanks for having me.</p>\n\n\n\n<p>[00:03:37] <strong>Nathan Wrigley:</strong> Yeah, you&#8217;re very welcome. This is not the first time we&#8217;ve spoken, but it is the first time we&#8217;ve spoken at an event because we&#8217;re both at WordCamp US in Portland, it&#8217;s 2025. We&#8217;re in a corridor, so I&#8217;ve got to say at the very outset, if it ends up being quite noisy, there&#8217;s not a lot we can do about that. But we&#8217;ve done our best. We&#8217;ve found a nice quiet little alcove, and we&#8217;re going to be chatting today to Bud about his experience online. Before we do that, Bud, do you mind just telling us a little bit about yourself? Give us your potted bio, if you like.</p>\n\n\n\n<p>[00:04:01] <strong>Bud Kraus:</strong> Yeah, sure. So I create WordPress content for WordPress businesses, articles, blog posts, tutorials, videos, and I am the host of the podcast called Seriously, Bud?</p>\n\n\n\n<p>[00:04:14] <strong>Nathan Wrigley:</strong> And the talk that you&#8217;re doing at WordCamp US, which I guess you haven&#8217;t yet done, because we&#8217;re on the first day of presentations and it&#8217;s fairly early on. You haven&#8217;t done it, right?</p>\n\n\n\n<p>[00:04:23] <strong>Bud Kraus:</strong> No, I actually, no, I haven&#8217;t done it yet, but I&#8217;ve done this a couple times, so this is not my first time doing this talk.</p>\n\n\n\n<p>[00:04:29] <strong>Nathan Wrigley:</strong> So you know how it&#8217;s going to go. It&#8217;s called using low vision as my tool to help me teach WordPress. Now, that kind of leads us into the subject at hand really. We&#8217;re going to be talking about how it is that your experience of the web may differ from other people.</p>\n\n\n\n<p>Are you willing to just tell us a little bit about your experience in the offline world as well as the online world? What is it that you are dealing with on a day-to-day basis?</p>\n\n\n\n<p>[00:04:50] <strong>Bud Kraus:</strong> Sure. So I have macular degeneration, which is a condition of old age, which I got when I was 37. And it&#8217;s the leading cause of legal blindness in the United States. It&#8217;s a destruction of your central vision.</p>\n\n\n\n<p>I have the condition in both eyes, which means I really have it. And it makes it very hard for me to see straight ahead, recognise faces, reading. I can&#8217;t drive a car, which is okay. So anything that&#8217;s straight ahead.</p>\n\n\n\n<p>Now, my peripheral vision&#8217;s perfectly intact, so that means I don&#8217;t need to have a seeing eye dog or a cane, or I don&#8217;t bump into things because the peripheral vision&#8217;s fine. But the very fine vision that we all use to see straight ahead, like to thread a needle, that&#8217;s what I&#8217;m missing.</p>\n\n\n\n<p>[00:05:30] <strong>Nathan Wrigley:</strong> So are you able to describe what you are seeing in that area. And is it like the central portion of your site?</p>\n\n\n\n<p>[00:05:38] <strong>Bud Kraus:</strong> It is the exact central portion of my sight. So I tend to see elliptically, which means I move my eyes around to get a better picture. Like, when I&#8217;m looking at you right now, I&#8217;m moving my eyes around so I can see better because of the destruction of the centre part of my vision.</p>\n\n\n\n<p>[00:05:52] <strong>Nathan Wrigley:</strong> And does that rule out certain tasks? So for example, you mentioned reading there. Obviously I do not have what you have, and so it&#8217;s a given to me that when I&#8217;m staring as I am doing at the moment at my laptop, my eyes, the bullseye, if you like, of my eyes go straight to the letter looking at. And for me, it&#8217;s hard to imagine deploying my peripheral vision to do that, but can you, for example, do things like reading or is that out of the?</p>\n\n\n\n<p>[00:06:16] <strong>Bud Kraus:</strong> You can&#8217;t, peripheral vision is not a, it&#8217;s not even close to being a perfect substitute for central vision. So the answer is no. You cannot read with peripheral vision. You cannot understand. You can see, but you can&#8217;t understand. And it just makes things difficult.</p>\n\n\n\n<p>[00:06:33] <strong>Nathan Wrigley:</strong> Yeah. So how does that affect your real life? So obviously you mentioned things like being unable to drive a car or things like that. Is there anything else that might give us a frame of reference for just how profound it is?</p>\n\n\n\n<p>[00:06:44] <strong>Bud Kraus:</strong> Well, I like to look at it differently. So I have a different approach to this. So when I first was diagnosed with this when I was 37, I thought, oh, this is the worst thing that could ever happen. And that makes sense, but it is not the worst thing that could ever happen.</p>\n\n\n\n<p>And having lived with this for quite a long time now, I look at this not as a curse, but as a blessing. Because what it&#8217;s done is allow me to have so many different opportunities, experiences, ideas, thoughts, whatever that I would&#8217;ve not otherwise had.</p>\n\n\n\n<p>So that process of going, it&#8217;s the grief process when you start from, you know, this is the most horrible thing in the world, to acceptance. I&#8217;m actually beyond acceptance. It&#8217;s like, I like this. This is okay with me. And do I wish it on other people? No, I don&#8217;t. But like I said, it&#8217;s not the end of the world. There are conditions and diseases that are far worse than this.</p>\n\n\n\n<p>So I do think of, and in fact in my talk that I&#8217;m giving, at the end I talk about why this is a blessing and not a curse. I mean, like for example, you can get as inebriated as you want at parties because you&#8217;re not going to be driving the car home. So there&#8217;s lots of that, okay. Or you don&#8217;t see your friends get older because you can&#8217;t see the detail on their face. When I go in a grocery store, I don&#8217;t see all the junk food, so that&#8217;s good. Is it inconvenient? Yes. Do I have a hard time finding people at a large event like this? Yes. But I manage.</p>\n\n\n\n<p>[00:08:09] <strong>Nathan Wrigley:</strong> So in the wider world, you can obviously deploy your peripheral vision. So we&#8217;re sitting in a, I don&#8217;t know, it&#8217;s maybe this room&#8217;s about 10 meters by 10 meters. There&#8217;s a lot of space. Whereas the thing that we&#8217;re talking about, WordPress, building websites and so on, it&#8217;s usually this constrained little, well, let&#8217;s say rectangle. It could be something that we&#8217;re holding our hands, a mobile phone or a computer, laptop, something like that. How does your situation, how does it get impacted by this then? Are you doing this peripheral vision, glancing left and right and trying to figure out what&#8217;s going on? Or do you have other tools, mechanisms, things that you deploy?</p>\n\n\n\n<p>[00:08:39] <strong>Bud Kraus:</strong> I do, and that&#8217;s what my talk is about. So, for example, I&#8217;ve taught WordPress and I taught coding for a long time. And people say, well, how do you do that if you can&#8217;t see?</p>\n\n\n\n<p>Well, one thing is I&#8217;m always very prepared. So when I go into a class, I can&#8217;t wing it. I just have to know exactly what I&#8217;m going to be doing. And in code there&#8217;s a lot of patterns and I recognise patterns.</p>\n\n\n\n<p>And, yes, I do use Zoom. I use audio. I use touch. Now, touch is not really relevant here, but I&#8217;m able to, with the technology as good as it has become for me, I&#8217;m able to Zoom in and out of the screen and I&#8217;m able to read things out loud. And then I have to do a fair amount of memory. But that&#8217;s okay.</p>\n\n\n\n<p>[00:09:22] <strong>Nathan Wrigley:</strong> So do you have adaptations that you make, let&#8217;s say for example, you go out today and you purchase a new computer, do you have adaptations that you make on an operating system level?</p>\n\n\n\n<p>[00:09:30] <strong>Bud Kraus:</strong> Yeah, I do.</p>\n\n\n\n<p>[00:09:31] <strong>Nathan Wrigley:</strong> Okay. I&#8217;m curious to hear about these because I make no modifications when I purchase, so tell me more.</p>\n\n\n\n<p>[00:09:35] <strong>Bud Kraus:</strong> Yeah, good question. So one of the things I do, and I&#8217;ll be demonstrating, is my resolution is a low resolution, meaning 1024 by 768 would be low today. In the olden days, that would be high. But it makes the screen, it makes it easier for me to see the screen. And then I make all kinds of adjustments to make icons bigger, letters bigger, so that it&#8217;s just works for me. And yeah, I don&#8217;t have a problem with it.</p>\n\n\n\n<p>Now, it does cause me to do things maybe a little slower because it&#8217;s just harder for me to maybe find something. But I think I mentioned that patterns is a very important thing to me. So if I&#8217;m going to a website and they change the UI totally around, that&#8217;s going to be a pain in the neck for me, because then I have to relearn where everything is.</p>\n\n\n\n<p>It&#8217;s sort of like changing the furniture if you were blind, I mean, really blind, which most people aren&#8217;t. So I&#8217;m legally blind but, you know, I&#8217;m not like lights out blind. If you change where things are, then it&#8217;s going to make things very difficult for me, whether it&#8217;s in the real world or in the virtual world. I have to relearn everything.</p>\n\n\n\n<p>[00:10:35] <strong>Nathan Wrigley:</strong> A sort of curious question that&#8217;s just occurred to me. When you buy a new computer, is there a process whereby you have to combat the regular default icon size and default tech size, just for a moment in order to wrangle it into the version of the OS that you need?</p>\n\n\n\n<p>[00:10:50] <strong>Bud Kraus:</strong> You&#8217;re absolutely right. So if you&#8217;re booting up for the first time, it&#8217;s a hole in the whole process, which is at least the last time I did, which is there&#8217;s no audio, there&#8217;s no nothing, and you&#8217;re seeing like little tiny print to, you know, configure the language and the location and the time and all that stuff that you do when you work with a computer for the first time. That is a real problem, yeah.</p>\n\n\n\n<p>[00:11:11] <strong>Nathan Wrigley:</strong> You would imagine that there&#8217;d be some mechanism to invoke that as the first thing that happens?</p>\n\n\n\n<p>[00:11:17] <strong>Bud Kraus:</strong> I think so.</p>\n\n\n\n<p>[00:11:17] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s interesting.</p>\n\n\n\n<p>Okay, so we&#8217;ve talked about the wider world. We&#8217;ve talked about a computer that you may modify. Let&#8217;s get onto the bit which we are all here for, which is WordPress. Are there any adjustments or tools, or this could extend to the browser, so it may be browser tools, what have you, but for the internet, let&#8217;s say, what are the modifications that you are making to make your life possible there?</p>\n\n\n\n<p>[00:11:37] <strong>Bud Kraus:</strong> You know, I don&#8217;t think there&#8217;s anything really any different than anybody else makes. I mean, the biggest thing is I will either zoom in or out of a webpage. And it&#8217;s really funny because, if you&#8217;re using a certain screen size with a certain resolution, things can get very hard to work with. I don&#8217;t think enough companies, like I&#8217;m thinking of even LinkedIn, for example, that I was using today. Sorry to call them out, but it&#8217;s just like their chat areas were just really, I just had to do all kinds of crazy things to actually see the text. And then the text was really small.</p>\n\n\n\n<p>I think because I&#8217;m a stress case, that they don&#8217;t always test down to my level. And I think it&#8217;s, I just accept it. But that&#8217;s the way it is, I guess. But I think that you don&#8217;t want to exclude people from anything really, because they may be your customer. And if I can&#8217;t buy something because it&#8217;s really hard to do, and that is something, I don&#8217;t know if I&#8217;ve ever talked to you about it, but other people, that if I am discouraged from buying something because it&#8217;s just, the UI is just too hard to work with, I&#8217;ll just find an alternative. I will. Or I&#8217;ll ask my wife.</p>\n\n\n\n<p>[00:12:39] <strong>Nathan Wrigley:</strong> I guess you&#8217;re in a curious space as well in that we hear a lot in the accessibility space about things like screen readers and those kind of assistive technologies. I guess you are not deploying those because you have enough sight to not have that as a, something to lean upon.</p>\n\n\n\n<p>[00:12:54] <strong>Bud Kraus:</strong> Yeah, that&#8217;s exactly right. I have not, and don&#8217;t use JAWS or any of those big fancy screen reader technologies. I just use what&#8217;s built into the macOS and I just highlight the text and I press a button and it reads. I think it&#8217;s called voiceover, or it&#8217;s text to speech, or whatever it is. And it&#8217;s in the accessibility part of the settings.</p>\n\n\n\n<p>I don&#8217;t use technology beyond what I need it for. It&#8217;s just overkill. What do I, those are complicated systems to master, so I stay away from that because they don&#8217;t need it.</p>\n\n\n\n<p>[00:13:22] <strong>Nathan Wrigley:</strong> So when you are building websites, is there anything unique about the way that you do that? Is there any sort of, again, a tool that you deploy? Or maybe you are relying on other human beings to sort of cast their eye over it a second time after you&#8217;ve done the work. I don&#8217;t know, just talk us through that whole thing.</p>\n\n\n\n<p>[00:13:37] <strong>Bud Kraus:</strong> Well, I don&#8217;t make websites. No, I have, okay. I&#8217;ve done everything, but I don&#8217;t make websites because I don&#8217;t like to make websites. It&#8217;s not because of my vision. But yes, if I am working, in the past like I have, I would ask people to help me with, particularly with colour because I have a very, I think I have a poor colour palette. And I think that&#8217;s either, it&#8217;s because of me. So I have to ask, does this go good with this?</p>\n\n\n\n<p>It&#8217;s just something that I, either I&#8217;m not good at, or I&#8217;m not interested, or my vision, or whatever it is. So I do have a problem with colour in that regard. But because of the technology and the tools that are built in, it&#8217;s not as difficult as one might think.</p>\n\n\n\n<p>[00:14:15] <strong>Nathan Wrigley:</strong> Interesting. Yeah, okay. We&#8217;ll get into that. But you do make a podcast, and there&#8217;s lots and lots of different spinning wheels that have to done there. You know, you&#8217;ve got to book people onto the show, you&#8217;ve got to have calendars, you&#8217;ve got to have posts and pages and things like that on the website. Is there anything uniquely interesting about, I understand the process of making a website from my perspective, there anything that would be different to my process than would be for yours?</p>\n\n\n\n<p>[00:14:36] <strong>Bud Kraus:</strong> Yes, I think one thing I could think of is like a lot of times I won&#8217;t, let&#8217;s say in WordPress, you can write into the editor, you could write a page or a post right into the Gutenberg, the block editor. I choose not to do that. What I do is use a notepad, or not notepad, what is it for a Mac? I forgot.</p>\n\n\n\n<p>[00:14:53] <strong>Nathan Wrigley:</strong> TextEdit.</p>\n\n\n\n<p>[00:14:54] <strong>Bud Kraus:</strong> Yes, TextEdit. Thanks. I&#8217;ll use that and I&#8217;ll have the font blown up bigger than normal, and I&#8217;ll just edit in there, and then I&#8217;ll just take that and then I&#8217;ll copy that and paste that into WordPress. It&#8217;s just easier for me to do it that way. So I just like it that way. You know, everybody has their own little thing. That&#8217;s my little thing. And I think it&#8217;s because of my vision.</p>\n\n\n\n<p>[00:15:14] <strong>Nathan Wrigley:</strong> And in terms of kind of getting the recording software to work and things like that, how do those UIs function for you?</p>\n\n\n\n<p>[00:15:19] <strong>Bud Kraus:</strong> Yeah, pretty good. The problem I have with learning something new and complicated is that, I think it&#8217;s like everybody, quite frankly, I get confused and try to figure out where&#8217;s what. And like I was using, I use Descript, and it just took me quite a while to figure out, how do I do this? How do I do that? But like anything else, once I learn it, it&#8217;s pretty solid and it gets easier.</p>\n\n\n\n<p>Now I do tend to blow things up to make it bigger. And my wife is always telling me, I can&#8217;t use your computer because stuff is too big. Now, I don&#8217;t think it&#8217;s too big, but she does. And when I look at other people&#8217;s computers, then I realise, no, it&#8217;s bigger than theirs.</p>\n\n\n\n<p>[00:15:53] <strong>Nathan Wrigley:</strong> Okay, so we&#8217;re in the era of Gutenberg. It sounds like you&#8217;ve been using WordPress for a fairly long time, presumably before Gutenberg. What&#8217;s your opinion on whether or not that was a move in the right direction? In other words, is it favorable? Is it more straightforward for you to create a post? I know that you said in the scenario for a podcast, you&#8217;re writing it elsewhere and copying and pasting it in. But with other things like, I don&#8217;t know, laying out content and writing paragraphs and things, do you think it&#8217;s a good experience? Did we go in the right direction there?</p>\n\n\n\n<p>[00:16:18] <strong>Bud Kraus:</strong> That&#8217;s a very hard question for me to answer. I&#8217;ll answer it in a couple of different ways. One, as far as accessibility goes, I&#8217;m no expert in this. I am not an accessibility expert. Am I a stakeholder? We all are. But I can&#8217;t answer it in that regard.</p>\n\n\n\n<p>But from a more technical standpoint, because I write technical articles for Kinsta, Hostinger, others, that I find it to be difficult. I know I was told it&#8217;s not supposed to be easy, so it certainly doesn&#8217;t match the easy. Yeah, and that has nothing to do with my vision. It&#8217;s just, I feel it&#8217;s just complicated, even though I&#8217;ve learned quite a bit of the technical side of this stuff. I&#8217;m not trying to be cute here, but I&#8217;m trying to be cute, and I just can&#8217;t answer that question that&#8217;s going to provide any value so.</p>\n\n\n\n<p>[00:17:06] <strong>Nathan Wrigley:</strong> I was kind of wondering if there was a thing which, if you could click your fingers and make it appear in the Block Editor or the Gutenberg interface, which you would, and I don&#8217;t know that you&#8217;ve got got an answer to that.</p>\n\n\n\n<p>[00:17:15] <strong>Bud Kraus:</strong> I, let me think. No, I don&#8217;t think so. No. And I use Elementor too. So I think from a logic standpoint, Elementor seems to be easier for me. What I just don&#8217;t like is a lot of confusion. Too much information built into a UI is a real problem for me.</p>\n\n\n\n<p>Nathan, the funny thing is I feel like I have a special filter on the world that other people don&#8217;t have. This is another one of these blessings, that gives me the ability to understand what works and what doesn&#8217;t work without having to ask somebody because it&#8217;s just built in.</p>\n\n\n\n<p>Now, the thing about disability or this field in general, which is huge, it&#8217;s very idiosyncratic. So my setup is good for me, but it may not work for somebody else. And it&#8217;s very hard to, as those who keep accessibility in mind, and hopefully it&#8217;s everybody. It&#8217;s a very difficult subject because how do we design our systems, our content so that the greatest number of people can access this information, or whatever, on the largest number of devices. I mean, that&#8217;s what accessibility to me is about.</p>\n\n\n\n<p>[00:18:24] <strong>Nathan Wrigley:</strong> It&#8217;s curious that you said, I think you said at the beginning that your condition is one which will deteriorate over time.</p>\n\n\n\n<p>[00:18:31] <strong>Bud Kraus:</strong> Well, macular degeneration, generally, can get worse over time. But fortunately, for reasons that we don&#8217;t need to get into, since 1992 it&#8217;s been very stable, which I&#8217;m really fortunate because trust me, I don&#8217;t want it to get any worse than this. I don&#8217;t need another, that much of a blessing.</p>\n\n\n\n<p>[00:18:50] <strong>Nathan Wrigley:</strong> Yeah, I was wondering from that, whether or not the accessibility side of WordPress is something that you lean into. Do you attend those kind of, I don&#8217;t know, WP Accessibility Day, those kind of events?</p>\n\n\n\n<p>[00:18:59] <strong>Bud Kraus:</strong> No, it just doesn&#8217;t really interest me. You know, back in like 1999, 2000, I was teaching a course at Pratt Institute in New York called Accessible Web Design. And it was way ahead of its time. And the concepts I was teaching were basically concepts because the browsers and technology just wasn&#8217;t there yet. So you&#8217;d have to say, well, one day, and one day did happen in large measure.</p>\n\n\n\n<p>And then I started realising, I just didn&#8217;t want to like make a career out of teaching this or testing or, you know, I started to meet people in the field and I just said, I don&#8217;t really like this. I mean, just because I&#8217;m, I have a disability doesn&#8217;t mean I have to like the field of accessible design, you know, accessibility.</p>\n\n\n\n<p>[00:19:40] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s interesting. You are wearing a WordCamp Montclair t-shirt, which kind of tells me that not only are you attending this event, WordCamp US, but you&#8217;re also attending other ones as well. Is that a big part of your life? If it is, how accessible are things like this event? Do you come here fully expecting of yourself that you&#8217;ll have a full experience the same way that everybody else does?</p>\n\n\n\n<p>[00:19:59] <strong>Bud Kraus:</strong> Well, I have a good experience, but it is not the same way everybody else does. For example, I can&#8217;t see the screens at all. And when they&#8217;re doing stuff, the slides, I&#8217;m just listening, okay. It&#8217;s sort of like, I watch TV a lot that way too. I hear things. Unless I got really close, I&#8217;m not going to be able to see what&#8217;s on the screen. If I took a picture of something that&#8217;s really important, yeah, that&#8217;ll help.</p>\n\n\n\n<p>But generally speaking, that doesn&#8217;t work for me. And then it could be kind of a, yes, I&#8217;ve gone to many WordCamps, but they&#8217;re all sort of the same in terms of the issues. And I don&#8217;t even think of them as issues anymore. I just think of it as like, we&#8217;re all different. This is the way I&#8217;m different. And talking about this stuff, quite frankly is like talking about being right-handed. Would you do an interview of me being right-handed?</p>\n\n\n\n<p>[00:20:42] <strong>Nathan Wrigley:</strong> Yeah, fascinating. I guess, from my perspective, because I just don&#8217;t, I can&#8217;t prize that open my own life, it&#8217;s really intriguing to sort of try to have some sort of understanding of how it differs from my experience to your experience. And I guess for you it&#8217;s, this is how I live.</p>\n\n\n\n<p>[00:20:58] <strong>Bud Kraus:</strong> Yeah. But Nathan, you know, vision is a spectrum. It&#8217;s a continuum. It isn&#8217;t just everybody looks at things the same way. No. So I don&#8217;t think, alright, I&#8217;m like sort of on one end of the spectrum, I get it, but everybody looks at things differently. And I don&#8217;t mean that figuratively, I mean that literally. So I don&#8217;t think of it anymore much as a handicap, you know, other than the fact that, yeah, that&#8217;s a pain in the neck sometimes. And sometimes you find yourself doing some foolish things.</p>\n\n\n\n<p>And I think the hardest thing for me at these events is that I won&#8217;t know who I&#8217;m talking to until about five minutes after I&#8217;m talking to them, and I figured out by looking at their shape, stuff like that, that I can, oh, I&#8217;m talking to Nathan Wrigley, or your accent, or something like that.</p>\n\n\n\n<p>[00:21:42] <strong>Nathan Wrigley:</strong> Yeah. You&#8217;re obviously quite keen on the sort of education side of things though because you&#8217;re writing tutorials. I&#8217;ll link in the show notes to one that you wrote for Smashing Magazine, which is no mean feat. Getting in there is really rather impressive. So well done for that.</p>\n\n\n\n<p>But you&#8217;re also obviously turning up two events like this. And it sounds from what you said as if this is content that you&#8217;ve done before. So very keen on that, even though it may be talking about, you were describing there, it&#8217;s like talking about whether you&#8217;re right-handed. You&#8217;ve put together this presentation in which you&#8217;re going to share these different bits and pieces about how you make amendments and adjustments to WordPress and the operating system and so on. So do you enjoy the education side of it?</p>\n\n\n\n<p>[00:22:16] <strong>Bud Kraus:</strong> Oh, absolutely. I&#8217;m a teacher at heart. I mean, you know, that&#8217;s what I&#8217;ve been doing for 25 years. And even in the writings that I do, they&#8217;re basically, it&#8217;s a different way of teaching. Now the talk that I&#8217;m giving though here, the funny thing is, as I&#8217;ve said, I&#8217;m sort of like cool to the idea to be honest about it. There are other talks I&#8217;d rather give than this one, but this is the talk that everybody seems to be interested in. And I get that.</p>\n\n\n\n<p>And when you come up with a topic called using low vision is a tool to help me teach WordPress, that&#8217;s a winner because you got two things in there that everybody loves. One, we love disability, and two, we love teaching WordPress. So two weird things got put into one title.</p>\n\n\n\n<p>[00:22:57] <strong>Nathan Wrigley:</strong> It&#8217;s a hit.</p>\n\n\n\n<p>[00:22:58] <strong>Bud Kraus:</strong> It got to be a hit, right.</p>\n\n\n\n<p>[00:22:59] <strong>Nathan Wrigley:</strong> What would be the presentation that you would do?</p>\n\n\n\n<p>[00:23:01] <strong>Bud Kraus:</strong> Ah. The one that I&#8217;m threatening to do instead of this one, because I keep saying, I don&#8217;t wanna do this one, let me do another one. There&#8217;s two.</p>\n\n\n\n<p>One is, burnt out on web design, what your future career could be, which is my story.</p>\n\n\n\n<p>And the other one is, show me the money, how to get sponsors to financially help with your podcast, event, whatever. I like that topic, show me the money.</p>\n\n\n\n<p>[00:23:24] <strong>Nathan Wrigley:</strong> Paraphrasing, just a minute, what are the nuggets? Because I&#8217;m curious about that one.</p>\n\n\n\n<p>[00:23:27] <strong>Bud Kraus:</strong> Oh, come on. You could teach me, okay?</p>\n\n\n\n<p>[00:23:30] <strong>Nathan Wrigley:</strong> What are the nuggets in there though?</p>\n\n\n\n<p>[00:23:32] <strong>Bud Kraus:</strong> Well, in my case with my podcast, I&#8217;ve been sort of lucky in that they came to me and said, we&#8217;d like to sponsor you. Which is a shock because when I started the podcast a year and a half ago, or actually the idea was, it&#8217;s now two years old, I said, I didn&#8217;t care if anybody ever listened, I didn&#8217;t care if anybody ever sponsored. And then of course, over time, I did care.</p>\n\n\n\n<p>But I never thought of my show ever being sponsored. I said, I&#8217;ll just do it. And then I started realising, hey, this takes a lot of time, should get paid for this. And, you know, I feel just, if I have a second or two say how fortunate I am to be a part of all of this because at my advanced age, to be in this community with such smart, brilliant, whatever, people that are friendly. When I talk to people my age who are generally retired or retiring and, their world gets smaller and mine gets bigger.</p>\n\n\n\n<p>[00:24:24] <strong>Nathan Wrigley:</strong> Oh, that&#8217;s interesting.</p>\n\n\n\n<p>[00:24:25] <strong>Bud Kraus:</strong> So I&#8217;m really, really lucky about that.</p>\n\n\n\n<p>[00:24:28] <strong>Nathan Wrigley:</strong> Yeah. I don&#8217;t know what your age is, but I am of a certain age, and I&#8217;m kind of feeling at the moment that there&#8217;s this whole thing which everybody wants to talk about, which is AI. And I&#8217;m kind of feeling as if that train has already, you know, that ship has sailed for me. Can&#8217;t invest all of the time and what have you to learn all of the different bits and pieces. It&#8217;s like there&#8217;s another bus coming. I don&#8217;t know what you think about that.</p>\n\n\n\n<p>[00:24:47] <strong>Bud Kraus:</strong> Well, I&#8217;ll tell you what it is, for me, it&#8217;s been a career extender, because I am now writing at a level for Kinsta, technical articles that I could not otherwise write. And because of my use of, and if you will, mastery of AI, I&#8217;ve been able to code things that I could not do before. So I&#8217;ve always had sort of, for the longest time, because I taught great foundation of HTML, CSS, some JavaScript, whatever. So I know this stuff, okay.</p>\n\n\n\n<p>But to elevate that knowledge, to create stuff now that is much more complicated, sort of like junior development oriented stuff or maybe a little bit beyond that. That is amazing. And it&#8217;s because of AI.</p>\n\n\n\n<p>[00:25:28] <strong>Nathan Wrigley:</strong> That&#8217;s fascinating.</p>\n\n\n\n<p>[00:25:30] <strong>Bud Kraus:</strong> It&#8217;s extending what I can do.</p>\n\n\n\n<p>[00:25:32] <strong>Nathan Wrigley:</strong> Yeah, you feel like you&#8217;ve got a new lease of life there.</p>\n\n\n\n<p>[00:25:34] <strong>Bud Kraus:</strong> Yeah, a bit. So I don&#8217;t have to keep writing the same things over and over about how to create a post. You know, I&#8217;ve done that. I want to be challenged to learn new things, and AI is helping me do that. And we&#8217;re teaching AI, and AI is teaching us. So it&#8217;s really cool.</p>\n\n\n\n<p>[00:25:49] <strong>Nathan Wrigley:</strong> Your presentation, is it today or tomorrow?</p>\n\n\n\n<p>[00:25:51] <strong>Bud Kraus:</strong> Well, it&#8217;s tomorrow.</p>\n\n\n\n<p>[00:25:53] <strong>Nathan Wrigley:</strong> I was going to say, you&#8217;re looking very calm for somebody that has a presentation later today.</p>\n\n\n\n<p>[00:25:56] <strong>Bud Kraus:</strong> Well, you know, I&#8217;ve been around the block. I&#8217;m not going to be nervous. Now what I do have to do is I&#8217;ve got to do some more memorisation. And that&#8217;s what I talked about always being prepared. I just can&#8217;t go in there and read the slides. It&#8217;s not going to happen. So I have to really know what the slides are, what the order is, and what the words are on the screen. I don&#8217;t have to read those words, but I have to know the ideas behind all this.</p>\n\n\n\n<p>[00:26:16] <strong>Nathan Wrigley:</strong> So in some sense, you&#8217;ve memorised it more or less. Oh, that&#8217;s interesting. So you&#8217;ve really applied thought to every, more or less, every sentence that comes out of your mouth.</p>\n\n\n\n<p>[00:26:24] <strong>Bud Kraus:</strong> Basically.</p>\n\n\n\n<p>[00:26:25] <strong>Nathan Wrigley:</strong> But you don&#8217;t get nervous.</p>\n\n\n\n<p>[00:26:26] <strong>Bud Kraus:</strong> We&#8217;re with friends.</p>\n\n\n\n<p>[00:26:28] <strong>Nathan Wrigley:</strong> I would get so nervous.</p>\n\n\n\n<p>[00:26:29] <strong>Bud Kraus:</strong> At least I like to think so.</p>\n\n\n\n<p>[00:26:30] <strong>Nathan Wrigley:</strong> Yeah. No, I agree. Every time I&#8217;ve been to a presentation, even when the person delivering it has been quite nervous, there&#8217;s always been a very positive sentiment in the room.</p>\n\n\n\n<p>[00:26:39] <strong>Bud Kraus:</strong> I&#8217;ll tell you why I don&#8217;t get nervous, I don&#8217;t see their faces.</p>\n\n\n\n<p>[00:26:41] <strong>Nathan Wrigley:</strong> Oh.</p>\n\n\n\n<p>[00:26:42] <strong>Bud Kraus:</strong> So if you don&#8217;t see their faces. There&#8217;s so many advantages of vision impairment. I know it sounds crazy, but if you don&#8217;t see their faces, then you don&#8217;t see their reactions. Now, of course, that&#8217;s a negative too. But then you don&#8217;t get nervous.</p>\n\n\n\n<p>[00:26:55] <strong>Nathan Wrigley:</strong> Absolutely fascinating. Well, I wish you the best of luck with it. It will be out on wordpress.tv at some point. Typically now they come out really soon. These flagship events, they turn them around really quickly.</p>\n\n\n\n<p>[00:27:06] <strong>Bud Kraus:</strong> Well, I don&#8217;t know when this is coming out, but this is going to be live streamed around the world.</p>\n\n\n\n<p>[00:27:09] <strong>Nathan Wrigley:</strong> Is it?</p>\n\n\n\n<p>[00:27:10] <strong>Bud Kraus:</strong> Yeah. So one person can watch.</p>\n\n\n\n<p>[00:27:11] <strong>Nathan Wrigley:</strong> The point being, dear listener, that if you&#8217;ve enjoyed this episode and you want to follow on the talk, the presentation that Bud has given at WordCamp US, by the way, maybe the quickest way to do that is to just Google, either WordCamp US 2025. Or Google, using low vision as my tool to help me teach WordPress. That&#8217;s the other short circuit if you like. You&#8217;ll be able to see exactly what it is that Bud delivered.</p>\n\n\n\n<p>I have no further questions, so unless you&#8217;ve got something to add, I will say thank you very much for chatting to me.</p>\n\n\n\n<p>[00:27:40] <strong>Bud Kraus:</strong> Well, thank you Nathan. And you know I&#8217;m a big fan of what you do and thanks for having me on.</p>\n\n\n\n<p>[00:27:43] <strong>Nathan Wrigley:</strong> Thank you so much.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://seriouslybud.com/\">Bud Kraus</a>.</p>\n\n\n\n<p>Bud was diagnosed with macular degeneration, a condition often associated with old age, when he was 37. Affecting both eyes, this gradually eroded his central vision, making it difficult for him to see straight ahead, recognize faces, drive or read. Despite these challenges, Bud’s peripheral vision remained intact, sparing him the need for a cane or guide dog, and allowing him to continue to navigate daily life. Through perseverance and adaptation, Bud continues to live fully, facing the hurdles of vision loss with resilience and optimism.</p>\n\n\n\n<p>Bud opens up the podcast by talking about his experience living with legal blindness, how his central vision loss has shaped everything from everyday activities to his professional routines. He explains the practical ways he adapts his devices and workflow, including tweaks to operating system settings, using screen zoom functions, and relying on pattern recognition to teach coding, write tutorials, and even host his Seriously, Bud podcast. His unique perspective sheds light on the often-overlooked nuances of accessibility, reminding us that every user interacts with technology differently.</p>\n\n\n\n<p>Bud also chats about the broader impact of accessibility in the WordPress space, from frustrations with hard-to-navigate interfaces to the importance of not excluding users who may become your audience or customers. His reflections reveal how living with low vision pushed him beyond mere acceptance, helping him discover new opportunities, hone his teaching skills, and even find humour in daily challenges.</p>\n\n\n\n<p>Bud’s story serves as a powerful reminder of the importance of designing with empathy, embracing adaptation, and viewing accessibility not just as a technical requirement, but as a source of creativity and connection. It’s full of real-world tips, personal anecdotes, and a dose of inspiration.</p>\n\n\n\n<p>Whether you’re a designer, developer, educator, or simply passionate about building a more inclusive web, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://us.wordcamp.org/2025/session/using-low-vision-as-my-tool-to-help-me-teach-wordpress/\">Using Low Vision As My Tool To Help Me Teach WordPress</a>, Bud&#8217;s presentation at WordCamp US 2025</p>\n\n\n\n<p><a href=\"https://www.freedomscientific.com/products/software/jaws/\">JAWS, Job Access With Speech software</a></p>\n\n\n\n<p><a href=\"https://www.pratt.edu/\">Pratt Institute</a></p>\n\n\n\n<p><a href=\"https://www.descript.com/\">Descript</a></p>\n\n\n\n<p><a href=\"https://www.smashingmagazine.com/2018/05/using-low-vision-teach-wordpress/\">Using Low Vision As My Tool To Help Me Teach WordPress</a>, Bud&#8217;s post on Smashing Magazine</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Oct 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Open Channels FM: From Home Kitchen to International Orders\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110428\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://openchannels.fm/from-home-kitchen-to-international-orders/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:163:\"Using WooCommerce and open source to take kitchen baking into an online cake business, embracing cake in a jar and building a vibrant brand with community support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Oct 2025 12:41:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: Tim &amp;amp; Pablos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150138\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://ma.tt/2025/10/tim-pablos/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:652:\"<p>Two of my favorite humans, <a href=\"https://tim.blog/\">Tim Ferriss</a> and <a href=\"https://pablosspeaks.com/\">Pablos Holman</a>, had a great interview together.</p>\n\n\n\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>Pablos has a <a href=\"https://www.amazon.com/dp/B0F23CLXZP\">great new book out</a>, and <a href=\"https://audrey.co/\">Audrey Capital</a> is a happy LP in his <a href=\"https://deepfuture.tech/\">Deep Future fund</a>. Of my many hacker friends, Pablos is probably the most public.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Oct 2025 13:36:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Open Channels FM: How Decentralized Social Platforms Grew from Identica to Modern-Day Mastodon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110897\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://openchannels.fm/how-decentralized-social-platforms-grew-from-identica-to-modern-day-mastodon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:188:\"Matthias Pfefferle discusses the Fediverse\'s origins and evolution with Evan Prodromou, highlighting decentralized social networks, protocols, privacy, and the future of federated systems.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Oct 2025 11:12:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: Beeper Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150133\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://ma.tt/2025/10/beeper-updates/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:277:\"<p><a href=\"https://blog.beeper.com/2025/10/06/beeper-september/\">Beeper has a fun set of September updates</a>, adding support for Google Voice, LinkedIn now runs on-device, typing indicators for Google Messages and Instagram, full Telegram custom emoji support, and more.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Oct 2025 18:22:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Open Channels FM: Why Linking and Permalinks Are the Backbone of the Open Web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110377\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://openchannels.fm/why-linking-and-permalinks-are-the-backbone-of-the-open-web/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:168:\"Dave Winer talks about the open web\'s basics, emphasizing that linking is crucial for real connection. Platforms limiting links miss out on that vibrant web experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Oct 2025 12:49:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Tammie Lister: September in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://binatethoughts.com/?p=2455\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://binatethoughts.com/september-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5187:\"<p>Another month has turned just like the leaves as autumn settles in. I was lucky enough to get time to focus thanks to sponsors, here is what I did within WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">August reflections</h2>\n\n\n\n<p>It’s worth noting I am aware that August didn’t have a month post, this was due to travelling back from being at WordCamp US. This post is a merged month in many sense as the theme has maintained the same as September saw solidifying of what I was doing.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A new team</h2>\n\n\n\n<p>The Core Program team was <a href=\"https://make.wordpress.org/project/2025/09/15/announcing-the-core-program-team/\">announced</a> and I will be the first team rep. This was a huge part of this month as required setting up and focus. I am beyond excited what this means. </p>\n\n\n\n<p>I am thrilled to say <a href=\"https://www.bigscoots.com/\">BigScoots</a> is sponsoring me to cover some time focusing on the Core Program team and thankful for the opportunity to go to sponsors and highlight where I am needed most.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Focusing on AI and editor</h2>\n\n\n\n<p>Relating to the last section a little, <a href=\"https://greyd.io/\">Greyd</a> are now going to be sponsoring me to focus both on Core AI and also on Core Editor. This combination allows me to focus even more my contributions where they can be effective. </p>\n\n\n\n<p>This split focus will add to <a href=\"https://servmask.com/\">ServMask’s</a> sponsorship of me within Core AI already to give me extra time within that area.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Areas of contribution</h2>\n\n\n\n<p>My split this month was given a new focus thanks to being a team rep for a new <a href=\"https://make.wordpress.org/program/2025/09/12/welcome-to-the-core-program-team/\">team announced</a>, Core Program. Beyond that, top areas were:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>&#8216;Needs design&#8217;</strong>: adding design to Core AI experiments.</li>\n\n\n\n<li><strong>Triage:</strong> focused on 6.9 design issues, unblocking and also giving feedback.</li>\n\n\n\n<li><strong>Program team work</strong>: establishing team and getting goals brewing. Weekly posts <a href=\"https://make.wordpress.org/program/tag/this-week/\">here</a>.</li>\n\n\n\n<li><strong>Core AI:</strong> focusing on roadmaps.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Sharing the journey</h2>\n\n\n\n<p>I got to share a few things this month, I also got to attend LoopConf and speak about AI at the local WP London meetup the night before:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://binatethoughts.com/the-sparkle-paradox-how-ai-signalling-undermines-adoption/\">The sparkle paradox</a>: specifically fuelled the designs I worked on for Experiments.</li>\n\n\n\n<li>Spoke at WPLDN about &#8216;<a href=\"https://www.wpldn.uk/talk/when-the-interface-doesnt-matter-anymore/\">When the Interface doesn’t matter anymore</a>&#8216;.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><br />Upcoming plans for contribution</h2>\n\n\n\n<p>October is already shaping up to be busy with Core Program and the 6.9 release.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Triage: </strong>focus on 6.9, but I don’t want to ignore the <a href=\"https://core.trac.wordpress.org/tickets/ancient\">ancient and inactive</a> trac log. This month triage won’t be my main focus but more about unblocking</li>\n\n\n\n<li><strong>Core AI:</strong> feedback and iterations for experiments and program work on abilities. I would also love to work on the <a href=\"https://github.com/WordPress/ai/discussions/23\">documentation</a> and handbook if time.\n<ul class=\"wp-block-list\">\n<li>I had some awesome fun working on the issues for experiments. <a href=\"https://github.com/WordPress/ai/issues/13#issuecomment-3352028955\">#</a> <a href=\"https://github.com/WordPress/ai/issues/12#issuecomment-3353681251\">#</a> <a href=\"https://github.com/WordPress/ai/issues/11#issuecomment-3352146880\">#</a> <a href=\"https://github.com/WordPress/ai/issues/10#issuecomment-3352689787\">#</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Core Program: </strong>shape goals collaboratively, goals will be posted weekly on #core-program in Slack.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Sponsors this month</h2>\n\n\n\n<div class=\"wp-block-group is-layout-constrained wp-block-group-is-layout-constrained\">\n<p>I now have these sponsors and from this month I am highlighting the areas they are helping me focus on if sponsoring a particular focus. </p>\n\n\n\n<p><a href=\"https://www.bigscoots.com\">BigScoots</a> (Core Program), <a href=\"https://greyd.io\">Greyd</a> (Core AI / Core Editor), <a href=\"https://kinsta.com\">Kinsta</a> (Triage), <a href=\"https://servmask.com\">ServMask</a> (Core AI), <a href=\"https://github.com/aaronjorbin\">Aaron Jorbin</a>, <a href=\"https://github.com/timnashcouk\">Tim Nash</a>, <a href=\"https://github.com/jeffpaul\">Jeffrey Paul</a> and <a href=\"https://github.com/scotrumery\">Scot Rumery</a> (<a href=\"https://rumspeed.com/about/\">Rumspeed</a>). To everyone who sponsored me and helped me secure sponsorship, thank you.</p>\n\n\n\n<p>Want to sponsor me? You can through <a href=\"https://github.com/sponsors/karmatosed\">GitHub</a>.</p>\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Oct 2025 09:06:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"binatethoughts.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Matt: Telegram and Weird Al\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150113\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"https://ma.tt/2025/10/telegram-and-weird-al/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2529:\"<p>I have two interesting interviews to share with you today, the first is <a href=\"https://www.youtube.com/watch?v=qjPH9njnaVU\">Lex Fridman interviewing Pavel Durov</a>, the founder of <a href=\"https://telegram.org/\">Telegram</a>. I started using and advocating for Telegram back in 2015, and <a href=\"https://audrey.co/\">Audrey Capital</a> was part of their aborted fundraise in 2018. As a software craftsperson, I&#8217;ve always had tremendous respect for the team and the rate at which they shipped truly novel design and UI. I&#8217;m amazed by the speed at which they ship major features across multiple platforms. The network also has incredibly resiliency, which they get into on the podcast. As I&#8217;m often in poor connectivity situations in planes or remote locations, Telegram has been one of the networks that works most reliably.</p>\n\n\n\n<p>I&#8217;ve met Pavel only briefly about a decade ago, but have followed his story as he&#8217;s a unique character with an ascetic lifestyle, target of many intelligence agencies, sperm donor father of 100+ children, and many other unique characteristics. I use Telegram like I use X/Twitter, I put things I consider semi-public on it and I think of it like a social network and development platform, and <a href=\"https://ma.tt/2022/08/telegram-channel/\">since 2022 I&#8217;ve cross-posted my blog to a Telegram channel using a Jetpack bot</a>. It&#8217;s probably my favorite community platform. The four hour interview between Lex and Pavel covers a lot of ground, but product builders will probably appreciate most the middle part around the 2-hour mark where they go into their engineering and design philosophies. (BTW I usually watch/listen to these at 2x speed.)</p>\n\n\n\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>If you&#8217;re looking for something a little lighter on a Sunday I recommend this <a href=\"https://www.youtube.com/watch?v=sSu2eMkIyZs\">heart-warming conversation between John Mayer and Weird Al Yankovic</a>.</p>\n\n\n\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>I know this seems like an unusual pairing, but both Pavel and Weird Al are hackers in the sense that they examined the rules of the system and decided to create a new game.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 05 Oct 2025 21:08:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Tammie Lister: Why Gentle Leadership Builds Better Products\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://binatethoughts.com/?p=2447\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://binatethoughts.com/why-gentle-leadership-builds-better-products/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11249:\"<p>We&#8217;ve all seen it. A product launches, a feature ships, a choice gets made. And within hours, the not-so-hot, more grumpy takes arrive. Threads dissecting every misstep. Social media posts stating how they&#8217;d have done x or y better. Statements across the web cataloguing failures. Commentary that positions the critic as the one who would have done it better. This happens even more on Open Source projects, we&#8217;ve all seen it across WordPress.</p>\n\n\n\n<p>This is an increasingly prevalent issue in product circles. Yet, we seldom highlight the human impact of this culture and the more effective alternatives that can truly foster better products and stronger teams. Even more so in open source. It&#8217;s also worth noting that those who can drive change, those called and looked to as product leaders, are often the ones who contribute most to the problem. By inspiring others and adopting more positive practices, we can foster a more collaborative and thriving environment for everyone involved.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The Changing Position of the Role of Product</h2>\n\n\n\n<p>My experience in product is a journey many of us share as we grew alongside the practice. We often had to fight for our place at the table, sometimes moving gently and other times more forcefully to ensure our voices were heard.</p>\n\n\n\n<p>Times have changed, and now the product is at the centre of much of our work. It no longer needs to prove its worth or challenge existing components; instead, it should avoid adopting harmful practices seen in longer traditions, such as design, which have led to dangerous and destructive patterns of critique. It&#8217;s possible to disagree without resorting to tearing others down or stripping away their contributions. In fact, taking a more constructive approach is a sign of greater skill, as many of us have come to learn.</p>\n\n\n\n<p>Throughout my career, I have learned a great deal through trial and error, thanks to the incredible mentors who guided me and the space they provided for me to understand. Their compassion and calmness shaped my understanding of leadership; it&#8217;s not just about being in the spotlight, which was a breath of fresh air for someone like me who thrives behind the scenes.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The Psychology of What We&#8217;re Really Doing</h2>\n\n\n\n<p>When we share our thoughts on products and the teams behind them, we&#8217;re doing more than just providing feedback; we&#8217;re meant to encourage accountability and nurture growth. The impact of our words can ripple far beyond the initial conversation, creating a meaningful dialogue.</p>\n\n\n\n<p>Studies in self-determination theory reveal that environments filled with criticism, rather than constructive support, can lead to loss of motivation. This is especially true over time. In open-source and collaborative spaces, the consequences are even more significant. Unhelpful criticism can generate conflicts and discourage participation, particularly for those from underrepresented backgrounds. Our language truly matters, and it becomes even more powerful when coming from influential voices.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;Leadership is about making others better as a result of your presence and making sure that impact lasts in your absence.&#8221;</p>\n\n\n\n<p><a href=\"https://www.goodreads.com/quotes/785876-leadership-is-about-making-others-better-as-a-result-of\" rel=\"noreferrer noopener\" target=\"_blank\">Sheryl Sandber</a>g</p>\n</blockquote>\n\n\n\n<p>The evidence suggests that public criticism, especially when not accompanied by constructive input, doesn&#8217;t enhance products. Instead, it risks stifling the very voices we should be championing to drive improvement and innovation. Let&#8217;s strive to uplift one another and create positive pathways for making. I know I want to create in a space like that, and I&#8217;m reasonably sure those who often critique the loudest do.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What Leadership Actually Looks Like</h2>\n\n\n\n<p>This isn&#8217;t about being soft or avoiding critical conversations, far from it. But if harsh criticism is all you&#8217;re known for, people eventually stop listening. By taking this approach, you are showing an understanding that great products emerge from empowered teams, not demoralised ones.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;To me, leadership is about encouraging people. It&#8217;s about stimulating them. It&#8217;s about enabling them to achieve what they can achieve — and to do that with a purpose.&#8221;</p>\n\n\n\n<p><a href=\"https://www.washingtonpost.com/business/on-leadership/lagarde-on-leadership-its-about-encouraging-people/2014/07/11/4696f284-06b5-11e4-a0dd-f2b22a257353_story.html\" rel=\"noreferrer noopener\" target=\"_blank\">Christine Lagarde</a></p>\n</blockquote>\n\n\n\n<p>The difference between critique and leadership is simple. Leaders focus on building capability, not broadcasting judgment. They build up whilst also setting on a path for that building. It&#8217;s certainly a harder thing to do, but in the long term, far more rewarding for both the leader and those involved. Being the critic, even if you have been elevated to a lead, eventually casts you as the villain of the piece, and that&#8217;s not good for anyone&#8217;s heart. Most leads got there through being incredible makers in the first place; somewhere along the way, they shifted from making to criticising, from building to broadcasting judgment.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The Alternative: Being Part of the Solution</h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;I raise my own voice—not so that I can shout, but so that those without a voice can be heard.&#8221;</p>\n\n\n\n<p><a href=\"https://www.goodreads.com/quotes/6628892-i-raise-up-my-voice-not-so-that-i-can\" rel=\"noreferrer noopener\" target=\"_blank\">Malala Yousafzai</a></p>\n</blockquote>\n\n\n\n<p>If you see a product or team struggling, you have choices beyond posting about it.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Mentor someone on the team.</strong> Reach out privately. Offer your experience. It is often more impactful to say it privately. Share what you&#8217;ve learned from similar challenges. </li>\n\n\n\n<li><strong>Contribute directly.</strong> If it&#8217;s open source, submit a thoughtful pull request. If it&#8217;s not, offer specific, actionable feedback through proper channels. Build the bridge instead of pointing out it&#8217;s incomplete.</li>\n\n\n\n<li><strong>Support publicly, guide privately.</strong> Public spaces should be for celebrating attempts, acknowledging effort, and showing solidarity. Save detailed feedback for contexts where it can actually be heard and acted upon.</li>\n\n\n\n<li><strong>Balance your critiques with equal praise. </strong>When was the last time you praised a feature? Do that as much as you also critique and balance.</li>\n\n\n\n<li><strong>Build knowledge, not status.</strong> Research shows that when team members feel their psychological needs met, such as autonomy, competence, and relatedness, they&#8217;re far more likely to develop intrinsic motivation and engage meaningfully with their work. Your role as a leader isn&#8217;t to prove you could have done better. It&#8217;s to help others actually do better. </li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">The Myth of &#8220;Necessary Toughness&#8221;</h2>\n\n\n\n<p>There&#8217;s a belief in some communities that toxicity is &#8220;a naturally occurring if not necessary facet of culture.&#8221; This is demonstrably false. Toxic behaviour causes contributors to leave projects and creates barriers to participation, particularly for newcomers and those from underrepresented communities. It causes burnout not just in those receiving but also in those giving. It eats at you.</p>\n\n\n\n<p>Gentle leadership isn&#8217;t weak leadership. It&#8217;s strategic leadership. It&#8217;s essential to understand that the long-term health of products and communities depends on creating environments where people want to contribute their best work, not environments where they&#8217;re afraid to take risks and fail.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Evaluating Your Leadership</h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;You can evaluate the quality of your authority by looking deeply to see if compassion is the foundation of your leadership.&#8221;</p>\n\n\n\n<p><a href=\"https://laidlawscholars.network/posts/see-if-compassion-is-the-foundation-of-your-leadership\" rel=\"noreferrer noopener\" target=\"_blank\">Zen Buddhist monk Thích Nhất Hạnh</a> </p>\n</blockquote>\n\n\n\n<p>This isn&#8217;t just an abstract philosophy. You can apply a practical lens for examining how we show up as leaders. The next time you&#8217;re tempted to post about what&#8217;s wrong with someone else&#8217;s or your own product, ask yourself:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Will this help the team, the product improve, or position me as knowledgeable?</li>\n\n\n\n<li>Who does this harm and who does this serve?</li>\n\n\n\n<li>Could I offer this insight in a way that builds rather than breaks?</li>\n\n\n\n<li>Am I solving a problem or performing expertise?</li>\n</ul>\n\n\n\n<p>The products that endure, the teams that innovate, they don&#8217;t come from cultures of constant public criticism. They come from environments where people feel safe to experiment, supported when they stumble, and mentored toward excellence.</p>\n\n\n\n<p>Your influence as a product leader isn&#8217;t measured by how effectively you can identify flaws; it&#8217;s also about how effectively you can address them. It&#8217;s measured by how many people do better work because you were there.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Building Better, Together</h2>\n\n\n\n<p>Every product you see represents countless hours of human effort, difficult trade-offs, and people doing their best with the information and resources available to them. Before you critique, consider how you might contribute. Before pointing out failures, consider how you can prevent them in the future by teaching, mentoring, and supporting.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;At the end of the day, at the end of the week, at the end of my life, I want to say I contributed more than I criticised.&#8221;</p>\n\n\n\n<p><a href=\"https://www.goodreads.com/work/quotes/62183586-dare-to-lead-brave-work-tough-conversations-whole-hearts\" rel=\"noreferrer noopener\" target=\"_blank\">Brené Brown</a></p>\n</blockquote>\n\n\n\n<p>The industry doesn&#8217;t need more critics. It needs more builders. It requires leaders who understand that gentle doesn&#8217;t mean permissive, and that the strongest teams are built on foundations of trust, growth, and mutual support.</p>\n\n\n\n<p>If I can leave one thought at the end of this, it would be to consider: &#8220;What impact will your leadership have?&#8221; Great products are built by great teams. Great teams are built by leaders who lift others. Choose to be that leader.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 05 Oct 2025 11:03:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"binatethoughts.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Greenwashing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150105\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/greenwashing/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3909:\"<p>Tonight there was a lovely event at <a href=\"https://tinkertendo.com/\">TinkerTendo</a> by Raman Frey and Karin Johnson of <a href=\"https://www.gpdinners.com/\">Good People Dinners</a>, this one honoring <a href=\"https://davidgelles.com/\">David Gelles&#8217;</a> new book, <a href=\"https://www.amazon.com/Dirtbag-Billionaire-Chouinard-Patagonia-Fortune/dp/1668032260?tag=photomatt08-20\">Dirtbag Billionaire: How Yvon Chouinard Built Patagonia, Made a Fortune, and Gave It All Away</a>. I&#8217;m a huge fan of Yvon Chouinard and really enjoyed his book <a href=\"https://www.amazon.com/Let-People-Surfing-Education-Businessman/dp/1594200726/?tag=photomatt08-20\">Let My People Go Surfing</a> which I read back in 2018. It was the first time hosting such a large 60-person dinner in the TinkerTendo warehouse, and thanks to <a href=\"https://copperhome.com/\">this Copper battery-operated induction stovetop</a> and an amazing local chef, <a href=\"https://www.komaaj.com/\">Hanif Sadr</a>, the food turned out amazing.</p>\n\n\n\n<p>I&#8217;ve only started the new book, but I&#8217;m interested to see what&#8217;s happened in the 20 years between Yvon&#8217;s book and David&#8217;s, especially the story of <a href=\"https://www.nytimes.com/2022/09/14/climate/patagonia-climate-philanthropy-chouinard.html\">how Yvon gave away all his equity and control in the company</a> to ensure a focus on his lifelong goal of environmentalism and conservation. Patagonia is one of the better corporate entities fighting for good, but it reminded me of how companies can put on a jacket of doing good while actually being evil underneath.</p>\n\n\n\n<p>Like I talked about the <a href=\"https://ma.tt/2025/09/externalities/\">economic concept of Externalties a few weeks ago</a>, I think it&#8217;s imperative that the WordPress community understands the history of <a href=\"https://en.wikipedia.org/wiki/Greenwashing\">Greenwashing</a>, which the <a href=\"https://www.un.org/en/climatechange/science/climate-issues/greenwashing\">United Nations defines as follows</a>:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Claiming that the company will achieve future environment milestones while not putting sufficient plans in place to do so.</li>\n\n\n\n<li>Being intentionally vague about operations or using vague claims that cannot be specifically proven (like saying they are &#8220;environmentally friendly&#8221; or &#8220;green&#8221;).</li>\n\n\n\n<li>Saying that a product does not contain harmful materials or use harmful practices that they would not use anyway.</li>\n\n\n\n<li>Highlighting one thing the company does well regarding the environment while not doing anything else.</li>\n\n\n\n<li>Promoting products that meet regulatory minimums as if peer products do not.</li>\n</ol>\n\n\n\n<p>In <a href=\"https://wordpress.org/\">WordPress</a> and open source our environmental crisis comes from companies that frack the open source software and brands, which shows up as lack of investment in the code which falls fallow <a href=\"https://tech.eu/2025/07/25/chronic-underfunding-of-open-source-software-poses-strategic-risk-to-europes-digital-sovereignty/\">especially in the security sense</a>, or by attaching themselves to a brand or trademark and tricking people into thinking they&#8217;re associated with the Good Open thing, when they&#8217;re really a parasitic cancer on it.</p>\n\n\n\n<p>This is happening right now in WordPress, so when you see a company hire a good person or sponsor an event that seems on its own a good thing, and probably represents hundreds of thousands of dollars of investment, weigh that against the tens of millions they&#8217;re spending with their other hand to destroy the source of everything they&#8217;ve benefited from, and if they were to win, endanger every open source project. It&#8217;s an open source form of greenwashing, perhaps call it <a href=\"https://en.wikipedia.org/wiki/Openwashing\">openwashing</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 05 Oct 2025 06:44:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"Gutenberg Times: Blocks galore, test template management, Woo product collections, and more—Weekend Edition 343\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=42093\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:20342:\"<p>Howdy, </p>\n\n\n\n<p>And just like that, the last quarter of 2025 has begun. It&#8217;s been an interesting year again, and now we are on the home stretch, heading into a Holiday season. It&#8217;s become my favorite time of the year when Autumn make nature paint trees and bushes in so many colors. After a life near evergreen Everglades of Florida, the middle European changing colors of the fall seems magical.</p>\n\n\n\n<p>Soon it&#8217;s time to plan for 2026. Speaking of which, in case you missed it, WordCamp Asia <a href=\"https://asia.wordcamp.org/2026/call-for-speakers-is-now-open/\">Call for Speakers</a> has been out for a couple of week, and the deadline is quite early: October 31, 2025. If you were thinking about going to WordCamp Asia, what would be a talk you would be interested in seeing in April of 2026? </p>\n\n\n\n<p>Anyway, the present is pretty amazing right now, too. So without further ado, the news. </p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n\n<p>PS: This weekend, on October 3rd, Germany celebrates the <a href=\"https://en.wikipedia.org/wiki/German_Unity_Day\">35th anniversary of the Reunion</a> after the Iron Curtain was lifted. </p>\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/#blocks-galore-with-telex\">Blocks Galore with Telex </a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</a></li></ol></nav>\n</div></div>\n</section>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>.<strong>Jonathan Bossenger</strong>, WordPress 6.9 release co-lead for testing, is asking for your <a href=\"https://make.wordpress.org/test/2025/10/03/help-test-changes-to-template-management/\"><strong>help to test changes to the template management</strong></a>. The new feature is a great enhancement to the way templates are handled in the Site Editor. More eyes are needed to make sure it&#8217;s the best it can be in the short amount of time until the first Beta version is released. The instructions are detailed, and Bossenger added a video to show how the various sections of this test should work.</p>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined is-color-set\" style=\"color: #4c38c1; border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n</section>\n\n\n<div class=\"wp-block-spacer\" style=\"height: 39px;\"></div>\n\n\n\n<p>The security and maintenance release, <a href=\"https://wordpress.org/news/2025/09/wordpress-6-8-3-release/\"><strong>WordPress 6.8.3 </strong></a>is now available. John Blackbourn led the release and shares the details in his release post. Update as soon as you can, as it plugs a few security holes.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Carlos Bravo</strong> issues the <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v21.8.0-rc.1\"><strong>release candidate for Gutenberg 21.8</strong></a> and it&#8217;s available for testing. The final release is scheduled for October 8. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode is <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/\">Gutenberg Changelog #122 – Gutenberg 21.8 and WordPress 6.9</a> with Beth Soderberg of <a href=\"https://bethink.studio/\">Bethink Studio</a></p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><img alt=\"Gutenberg Changelog 122 with Beth Soderberg\" class=\"wp-image-42236\" height=\"193\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-11-at-12.32.48.png?resize=652%2C193&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p class=\"has-small-font-size\"><em>If you are listening via Spotify, please leave a comment. If you listen via other podcast apps, please leave a review. It&#8217;ll help with the distribution.</em></p>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p>In the WordPress VIP blog post and video, <a href=\"https://wpvip.com/case-studies/pew-research-center/\"><strong>Pew Research Center Builds Interactive Content at Scale</strong></a>, the Seth Rubenstein and his team share how they rebuilt their website using WordPress VIP to tackle challenges in a world where people seldom visit original sources. Their old method took weeks of custom coding for interactive content, which delayed publishing. By adopting a block-first strategy in 2022, they cut production time from weeks to minutes, enabling editors and designers to create quizzes and maps on their own. This shift allowed developers to focus on innovation while increasing publishing frequency and lowering costs with evergreen interactive content that engages audiences directly.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his video <a href=\"https://www.youtube.com/watch?v=l7GRSnSd7SM\"><strong>Level up your Product Collections</strong></a>, <strong>Brian Coords</strong> demonstrates the new features in WooCommerce 10.2. He covered carousel layouts, taxonomy filters (Category/Brand/Tag), and an improved Cross-Sells collection for displaying products.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Joanne Courtright</strong> of Groundworx released a new <a href=\"https://wordpress.org/plugins/groundworx-testimonial/\"><strong>Testimonials plugin</strong></a> in the WordPress repository. Get the skinny from her blog post:   <a href=\"https://groundworx.dev/blog/introducing-groundworx-testimonial-modern-testimonials-for-wordpress-block-themes/\">Introducing Groundworx Testimonial: Modern Testimonials for WordPress Block Themes</a>. &#8220;Most testimonial plugins are still stuck in the classic era. This one is designed for developers and site builders who want testimonials that “just work” with Gutenberg, she wrote. It aims to be Gutenberg-native, theme.json aware, and accessibility-first. It includes a dedicated Testimonial post type + flexible blocks.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Justin Tadlock</strong> released the first version of an <strong><a href=\"https://wordpress.org/plugins/x3p0-authors/\">Authors List Block</a></strong> for multi-author sites. &#8220;This is especially useful if you’re coming over from using a classic WordPress theme and need a block that’s similar to the old <code>wp_list_authors()</code> template tag,&#8221; he wrote. The plugin comes with a full array of block design tools. It also sports options to display number of posts, various order filters, and feed links. </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-42113\" height=\"354\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-02-at-16.34.38-2.png?resize=652%2C354&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p><strong>Mike McAlister</strong> released his <a href=\"https://wordpress.org/plugins/ollie-menu-designer/\"><strong>Ollie Menu Designer</strong></a> for free in the WordPress repository. It is a powerful way to build  mobile and dropdown menus in the WordPress block editor—no coding required. For more details, watch <a href=\"https://www.youtube.com/watch?v=w96lghXWhiI\">his announcement video on YouTube. </a></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"blocks-galore-with-telex\">Blocks Galore with Telex </h2>\n\n\n\n<p>In his post, <a href=\"https://www.pootlepress.com/2025/10/if-automattics-telex-builds-this-you-might-not-need-that-page-builder/\"><strong>If Automattic’s Telex Builds This, You Might Not Need That Page Builder</strong></a>, <strong>Jamie Marsland</strong> explores how Automattic&#8217;s Telex AI tool could transform WordPress by enabling users to extend existing core blocks rather than just creating new ones. Currently, Telex generates custom blocks like video effects and timelines, but extending core blocks like paragraphs, tables, or buttons requires complex developer skills. If Telex could extend core blocks and offer a public directory for sharing these extensions, it could replace traditional page builders by unlocking the full potential of WordPress&#8217;s native blocks without adding technical debt or duplication.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Tammie Lister </strong>started her personal <a href=\"https://blocktober.fun/\"><strong>Blocktober</strong></a>, posting a block a day on the newly created site. Every day at noon, she uses Automattic&#8217;s Telex and builds a new block. Spanning the arc of history back to the 1980s, Lister started with an <a href=\"https://blocktober.fun/ascii-tetris/\">ASCII Tetris</a> block. Here goes my Thursday morning&#8230;. </p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"\" class=\"wp-image-42099\" height=\"377\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-02-at-11.22.33.png?resize=652%2C377&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p>In his latest blog post, <strong>Marko Ivanovic</strong> made a set of <strong><a href=\"https://ivanovicmarko.com/2025/09/25/telex-for-designers/\">blocks for designers</a></strong> with the help of Automattic&#8217;s Telex. Earlier he also created <a href=\"https://ivanovicmarko.com/2025/09/20/interactive-icons/\">animated icon blocks</a>. Ivanovic is a designer working for Automattic, and since 2022. His post on <a href=\"https://ivanovicmarko.com/2025/10/01/wordpress-and-design/\"><strong>how he rediscovered WordPress</strong></a> and why any designer should embrace WordPress is worth a read, too. And I love those sticky notes.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://ivanovicmarko.com/2025/09/25/telex-for-designers/\"><img alt=\"\" class=\"wp-image-42101\" height=\"331\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-02-at-11.30.51.png?resize=652%2C331&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>In preparation for the WordPress 6.9 release on December 2,  <strong>Justin Tadlock </strong>published a new tutorial on the WordPress Developer Blog: You  on how to implement <a href=\"https://developer.wordpress.org/news/2025/09/border-radius-size-presets-in-wordpress-6-9/\"><strong>Border radius size presets in WordPress 6.9</strong></a>. &#8220;You define an array of sizes that users can apply to blocks that support border radius. You can also reuse them within your own theme stylesheets and <code>theme.json</code> file.&#8221;, he wrote.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"border radius presets coming to WordPress 6.9 \" class=\"wp-image-42118\" height=\"337\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/border-radius-on-gradient.webp?resize=652%2C337&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p>At WordCamp Gdynia I shared how to <strong><a href=\"https://wordpress.tv/2025/09/30/streamlined-block-theme-development-using-wordpress-playground-and-github-for-no-code-version-contr/\">use WordPress Playground and GitHub for No-Code Version Control of Site Editor Changes</a></strong> The recording of my talk is now on WordPress TV. You will learn how theme developers can leverage WordPress Playground alongside the Create Block Theme plugin to create a seamless, browser-based development environment that integrates directly with GitHub for version control—all without writing a single line of code. <a href=\"https://docs.google.com/presentation/d/1ffMAVMjFxm1Ai7p2JWWwZAK5vQN5ryCbh-VXOqDjRiQ/edit?usp=drive_web&amp;ouid=101776844630674138344\">The slides are available on Google Drive. </a></p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://wordpress.tv/2025/09/30/streamlined-block-theme-development-using-wordpress-playground-and-github-for-no-code-version-contr/\"><img alt=\"\" class=\"wp-image-42115\" height=\"408\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/WCGdynia_-Block-Theme-Development-Playground-CBT-GitHub.jpg?resize=652%2C408&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<div class=\"wp-block-spacer\" style=\"height: 19px;\"></div>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</h2>\n\n\n\n<p>Long-time block developer <strong>Kevin Batdorf</strong> at <em>Extendify</em> just updated his <a href=\"https://github.com/KevinBatdorf/block-starter\"><strong>Block Starter plugin</strong> </a>repo—an &#8220;opinionated starter template for crafting WordPress block plugins,&#8221; as he calls it. It uses Tailwind v4 with output for the editor and frontend, TypeScript and Biome.js for code quality and type safety, and runs Playwright tests on PR using the Playground CLI. It also includes a Plugin Check on commits to main and before a release.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p>Featured Image: &#8220;Building blocks&#8221; by jgbarah is licensed under CC BY-SA 2.0 and found on WordPress.org/openverse.</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 04 Oct 2025 07:41:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Matt: Linkrot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150093\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://ma.tt/2025/10/linkrot/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2861:\"<p>One of the things I hate most on the internet, and part of the reason I started <a href=\"https://wordpress.org/\">WordPress</a>, was to fight linkrot. Ever since 1998, when <a href=\"https://www.w3.org/People/Berners-Lee/\">Tim Berners-Lee</a> wrote &#8220;<a href=\"https://www.w3.org/Provider/Style/URI\">Cool URIs Don&#8217;t Change</a>,&#8221; I&#8217;ve been obsessed with content management and ensuring that links don&#8217;t break. (BTW, TBL, a pioneer of creating the World Wide Web, <a href=\"https://www.newyorker.com/magazine/2025/10/06/tim-berners-lee-invented-the-world-wide-web-now-he-wants-to-save-it\">has a great new profile out in the New Yorker</a>.)</p>\n\n\n\n<p>I learned today from the <a href=\"https://newspack.com/\">Newspack</a> newsletter that the <a href=\"https://www.houstonpress.com/\">Houston Press</a> is now on WordPress. Newspack is a distribution or bundle of WordPress designed for journalism, and it is led by <a href=\"https://kinsey.nyc/\">Kinsey Wilson</a>, who began his career as a night-shift journalist covering cops for a newspaper in Chicago, went on to have top editorial and business positions at The New York Times, NPR, and USA TODAY, and ran WordPress.com for a few years, which gives him a very unique position to help craft WordPress for journalists and publishers.</p>\n\n\n\n<p>The Houston Press is an alt-weekly that wrote the very first profile of me in the world, <a href=\"https://ma.tt/2004/10/press-and-cnet/\">which I blogged about here</a>. There&#8217;s a funny quote in there:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>He recently considered taking a job with a San Francisco search-engine start-up, but ended up turning them down. “They have a ton of money…But it would be 50- or 60- or 70-hour weeks, a lot of work, and I wouldn’t have time” to do WordPress. </p>\n</blockquote>\n\n\n\n<p>That &#8220;search-engine start-up&#8221; was <a href=\"https://www.google.com/\">Google</a>! How the internet might have turned out differently if I had taken that job, as my Mom wanted me to (because they offered free food). I still think Google is one of the most interesting companies in the world, one of the few places I&#8217;d consider working if I weren&#8217;t running <a href=\"https://automattic.com/\">Automattic</a>.</p>\n\n\n\n<p>Back to linkrot, the original link to the profile in that article was <code>http://www.houstonpress.com/issues/2004-10-28/feature2.html</code>, which this morning didn&#8217;t work, but thanks to the Houston Press being on Newspack/WordPress I was able to ping Kinsey and his colleague Jason Lee was able to fix it so it redirects to the new canonical URL for that content in minutes. A little corner of the internet tidied up! I love the <a href=\"https://web.archive.org/\">Wayback Machine</a>, but not needing it is even better.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 04 Oct 2025 00:24:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Matt: Blocktober\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150063\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://ma.tt/2025/10/blocktober/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:406:\"<p>It&#8217;s so exciting to see what the creative minds like <a href=\"https://iconick.io/\">Nick Hamze</a> or <a href=\"https://tammielister.com/\">Tammie Lister</a> are doing with Automattic&#8217;s AI vibe coding tool, <a href=\"https://telex.automattic.ai/\">Telex</a>. Tammie is doing a Blocktober, <a href=\"https://blocktober.fun/\">a block every day this month of October, you should follow along</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Oct 2025 22:15:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: Fight For Open\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150050\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://ma.tt/2025/10/fight-for-open/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2067:\"<p>Sometimes the battle for open source and freedom can take on very prosaic and practical terms, but the wins can benefit everybody. To give an example: In <a href=\"https://www.beeper.com/\">Beeper</a> we need more memory for showing notifications, because we support end-to-end encryption for networks like Signal, but Apple&#8217;s default was to only give 15 megabytes — barely enough to do anything. The previous CEO of Beeper, Eric Migicovsky, started a lobbying effort with the <a href=\"https://digital-markets-act.ec.europa.eu/index_en\">EU’s Digital Markets Act</a> on behalf of the team to give third-party apps the same memory limits that Apple provides for their own apps, which is 50MB instead of 15MB. (And up to 250MB on their higher end devices.)</p>\n\n\n\n<p>Today we’ve gotten a notification that as part of iOS 26 update Apple has shipped to 2.3B devices around the world, our memory limits issue has been addressed globally, for every application developer, and some interoperability requests we had for <a href=\"https://developer.apple.com/documentation/telephonymessagingkit\">SMS/RCS</a> have been addressed for EU users. Kudos and huge thank you to Apple for giving us all new capabilities to build amazing experiences for users on par with what they seek to deliver themselves. If you want to geek out on this, <a href=\"https://blog.beeper.com/2025/10/01/how-beeper-ios-implements-notifications/\">check out the technical deep dive that Beeper just posted</a>.</p>\n\n\n\n<p>BTW, if you haven&#8217;t heard of it yet, <a href=\"https://www.beeper.com/\">Beeper</a> is an Automattic product which aims to democratize messaging, just like WordPress democratized publishing for the world, by allowing you to get all your messages from friends across 11 different networks, like WhatsApp, Instagram, Telegram, Twitter/X, Signal, Discord, in one single inbox. The new version we launched in July does this in a completely secure way that&#8217;s local to your device, so the same encryption, privacy, and security each network provides is maintained.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Oct 2025 20:29:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"WPTavern: #187 – June Liu and David Denedo on Making the Web Accessible: The Mission Behind WP Accessibility Day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=199767\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"https://wptavern.com/podcast/187-june-liu-and-david-denedo-on-making-the-web-accessible-the-mission-behind-wp-accessibility-day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:48317:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress, the people, the events, the plugins, the blocks, the themes, and in this case, making the web accessible, and the mission behind WP Accessibility Day.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have June Liu and David Denedo.</p>\n\n\n\n<p>Both June and David are key members of the WP Accessibility Day organizing team, a global, volunteer driven, event focused on improving accessibility in the WordPress ecosystem.</p>\n\n\n\n<p>June serves as the marketing team co-lead, and works with sponsors, bringing her background in project management to keep the events efforts on track.</p>\n\n\n\n<p>David, a web designer and content creator based in London, contributes to the marketing and post-event teams, with his interest in web accessibility stemming from his personal experience as a visually impaired user.</p>\n\n\n\n<p>WP Accessibility Day has grown significantly in the past few years, uniting a large international group of volunteers, and organizers, to drive awareness and practical change in web accessibility.</p>\n\n\n\n<p>The event is powered by a host of teams, marketing, sponsors, tech and vendor, post-event, translation, speakers, and more, ensuring that everything from live captioning to sign language interpretation is in place.</p>\n\n\n\n<p>We begin by learning about June and David&#8217;s unique paths to accessibility advocacy. One through direct lived experience, and the other through supporting a loved one with cognitive challenges. Their stories highlight why accessibility can&#8217;t be an afterthought, and how events like WP Accessibility Day are raising awareness in this important area.</p>\n\n\n\n<p>We discuss what attendees can expect at this year&#8217;s event happening from the 15th of October, 2025. It&#8217;s free, fully virtual, and runs for 24 hours, making space for a diverse range of speakers and topics.</p>\n\n\n\n<p>Whether you&#8217;re interested in the moral, legal or technical cases for accessibility, there&#8217;s something for you here, including sessions on accessible design, risk management for agencies, legal compliance, and demonstrations of assistive technologies.</p>\n\n\n\n<p>June and David share how the event format, a combination of prerecorded talks and live chat, mixes polished content with real time engagement. Plus how translation and community involvement are key to its growing impact.</p>\n\n\n\n<p>If you want to learn more about how you can make your WordPress sites, and the web in general, more inclusive, or if you&#8217;re motivated by global collaboration or personal stories, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you June Liu and David Denedo.</p>\n\n\n\n<p>I am joined on the podcast by two fabulous guests. I&#8217;ve got June Liu and David Denedo. Hello both. How are you both doing?</p>\n\n\n\n<p>[00:03:58] <strong>June Jiu:</strong> Hi there.</p>\n\n\n\n<p>[00:03:59] <strong>David Denedo:</strong> Hello. I&#8217;m doing all right.</p>\n\n\n\n<p>[00:04:00] <strong>Nathan Wrigley:</strong> Well, it&#8217;s very nice to have you both with us. The intention of today&#8217;s podcast is to draw attention to something which well, I&#8217;m sure many of you will know about. If you don&#8217;t know about it, I certainly hope that by the end of this, not only do you know about it, but you are highly engaged, and hopefully going to attend and all of those kind of things, maybe even contribute some of your time, you never know.</p>\n\n\n\n<p>It&#8217;s called WP Accessibility Day, and we&#8217;re going to get into that in a moment. Before we do that, I just want to get the little bio, the introduction from both of you, one at a time, just telling us who you are, what your interest is in WordPress and accessibility, I guess.</p>\n\n\n\n<p>So we&#8217;ll keep it nice and short and sweet. So I&#8217;ll go to June first. Just let us know who you are, June.</p>\n\n\n\n<p>[00:04:39] <strong>June Jiu:</strong> Thank you, Nathan. I&#8217;m June, I serve on the organising team for WP Accessibility Day as the marketing team co-lead, and I also work on the sponsors team.</p>\n\n\n\n<p>My background is mostly project management, so my forte right now is helping the team coordinate tasks, and keeping the initiatives on track. Yeah, I coordinate between the sponsors and the marketing team to get the sponsor page prepared. So that&#8217;s basically my work with WPAD.</p>\n\n\n\n<p>[00:05:08] <strong>Nathan Wrigley:</strong> Thank you so much. That&#8217;s great. And David, let&#8217;s go to you next. Same question really.</p>\n\n\n\n<p>[00:05:11] <strong>David Denedo:</strong> Hi, I&#8217;m David. I&#8217;m visually impaired, so that&#8217;s why I love accessibility. I work in London as a web designer and a content creator, and I&#8217;m part of the WP Accessibility Day organising team, as part of the post-event people. But I&#8217;m also in the marketing team, just jumping around, and at least trying to put as much as I can into web accessibility.</p>\n\n\n\n<p>Yeah, I got into web accessibility mainly because of some talks I had two years ago from the WP Accessibility Day, and that just encouraged me. And then here we are two years later.</p>\n\n\n\n<p>[00:05:53] <strong>Nathan Wrigley:</strong> Thank you so much. So, WP Accessibility Day, one thing that just jumped out at me straight away from what you were both talking about there, you both talked about, I&#8217;m on the, and then you mentioned a team. That implies that there&#8217;s quite a lot of you in the background.</p>\n\n\n\n<p>So just to give credit where credit&#8217;s due, I think it&#8217;s always important to make sure that we credit not just the two of you, because there&#8217;s probably a lot of people behind this as well. I don&#8217;t want to go down the route of missing anybody out. So I wonder if it&#8217;s possible for us to just mention the kind of teams and things like that. And if there are any people in particular that you&#8217;ve been working with that you do wish to name, caveat emptor, dear listener, I apologise on behalf of everybody on this panel. If we miss anybody&#8217;s name out, sorry about that. But let&#8217;s go for the, how many teams there are and how big an enterprise is this these days?</p>\n\n\n\n<p>[00:06:39] <strong>June Jiu:</strong> I don&#8217;t think I&#8217;ve ever counted how many teams there are, but I&#8217;ll list some of them. And David, add yours if I miss any, please.</p>\n\n\n\n<p>There is a volunteer team that&#8217;s, right now, pivotal. That&#8217;s their work right now in preparing the event. The event is on October 15th, so we&#8217;re just about a month away. So the volunteer team is very active right now in onboarding the volunteers.</p>\n\n\n\n<p>Then we have the tech and vendors. And those are also very active. They work closely with the volunteer team to prepare the day of. So they&#8217;re the ones that prepare the Zoom platform for us. So making sure that it all runs well.</p>\n\n\n\n<p>Then we have website, APAC, post event, translation, sponsors, marketing. What else? I feel like there&#8217;s a few others that I&#8217;m missing. But there is a huge team behind Amber, Bet and Joe, working and making sure that we can make the event as smooth as possible, and take some of the load off of them.</p>\n\n\n\n<p>[00:07:36] <strong>Nathan Wrigley:</strong> The Amber, the Bet and the Joe that you just mentioned, we have got Amber Hinds, Bet Hannon and Joe Dolson. So there&#8217;s three names. Do you have any recollection whether they were the people that kind of kickstarted the event, whenever that was? Because if that was the case, it sounds like it&#8217;s gone gangbusters since then with lots of people joining on, and you two being some examples.</p>\n\n\n\n<p>[00:07:56] <strong>June Jiu:</strong> We do have a pretty big team this year. And yes, you&#8217;re right, the history is that Joe Dolson did start WP Accessibility Day. I don&#8217;t recall all of the specifics, but I think the second year, Bet, I think it might&#8217;ve started with Bet and Joe, and then Amber also came on soon after that.</p>\n\n\n\n<p>But we&#8217;re in our fifth year. It&#8217;s very exciting. I joined last year as an organiser and it was a point in my time where I was returning to work. So finding WPAD was kind of a sweet spot for me to test out my skill sets again, get used to being out in the public, so I have a soft spot for them.</p>\n\n\n\n<p>[00:08:35] <strong>Nathan Wrigley:</strong> Thank you. Okay, so there&#8217;s a few that we&#8217;ve rattled off. David, I don&#8217;t know if you can fill in any gaps that might have been left there. If so, go now.</p>\n\n\n\n<p>[00:08:42] <strong>David Denedo:</strong> Yeah, I think those are the main ones that were involved. And I would say Amber Hinds, when she came on board, she brought in a lot of organisation because, you know, with Joe, Joe understands the technical bits of things, but he&#8217;s not really so organised. So when she came in, that&#8217;s why the team grew exponentially from 2022, I believe when she joined. And then the year after, things just kept spiraling. And then now we have a massive team with lots of volunteers, everybody&#8217;s happy to help.</p>\n\n\n\n<p>The other thing that is quite nice is that there was a nice spread of people who are volunteering. So it&#8217;s not just maybe from one region or one country. We are a very nice spread of people, so that&#8217;s really nice. So from different parts, from Asia, from Africa, from the Americas and all of that, they&#8217;re all wide base.</p>\n\n\n\n<p>[00:09:33] <strong>Nathan Wrigley:</strong> That&#8217;s amazing. Everybody from all over the place. That&#8217;s really lovely.</p>\n\n\n\n<p>David, in your introduction, in your bio, you described that you are kind of eating your own dog food a little bit here in that, I can&#8217;t remember the exact phrasing that you had around your eyes. How did you describe the condition that you have, if that&#8217;s the right word?</p>\n\n\n\n<p>[00:09:50] <strong>David Denedo:</strong> Okay, yeah. So I am visually impaired, so I have very high myopia and high astigmatism. I also struggle to see myself, so that&#8217;s one reason why I got really interested when I sa